/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.XMLOperations;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public class XMLFileAuthentication
extends UserAuthenticationInterface {
    private final Path publicsuper;
    private final Path \u00f6o0000;

    public XMLFileAuthentication(SourceManagerSettings sourceManagerSettings) {
        super(sourceManagerSettings);
        Path path = sourceManagerSettings.getConfigHome();
        this.publicsuper = path.resolve("users.xml");
        this.\u00f6o0000 = path.resolve("groups.xml");
        this.\u00d600000 = path.resolve("permissionsets");
        this.do = path.resolve("propertysets");
        this.\u00f6O0000 = path.resolve("publishingsets");
        this.readPropertyConfig();
        this.readPermissionConfig();
        Path[] pathArray = new Path[]{this.publicsuper, this.\u00f6o0000};
        Path[] pathArray2 = new Path[]{this.\u00d600000};
        this.setupMonitoring("updateSourceConnectorAccessRules", pathArray, pathArray2);
        Path[] pathArray3 = new Path[]{this.do, this.\u00f6O0000};
        this.setupMonitoring("updateSourceConnectorAccessRules", null, pathArray3);
    }

    @Override
    protected void readGroups() {
        this.Objectsuper.clear();
        this.setupDefaultGroups();
        try {
            Document document = FileOperations.getXMLFileContent(this.\u00f4O0000.getLogger(), this.\u00f6o0000);
            String string = XMLOperations.elementNamesToLowerCase(this.\u00f4O0000.getLogger(), document);
            Groups groups = XMLOperations.unmarshalJAXB(string, Groups.class);
            if (groups != null && groups.getGroups() != null) {
                for (Group group : groups.getGroups()) {
                    String string2 = group.getName();
                    if (!string2.equalsIgnoreCase("authenticated") && !string2.equals("public")) {
                        this.Objectsuper.put(group.getName(), group);
                        continue;
                    }
                    if (group.getPermissionSet() != null && this.Objectsuper.get(group.getName()) != null) {
                        ((Group)this.Objectsuper.get(group.getName())).setPermissionSet(group.getPermissionSet());
                    }
                    if (group.getPropertySet() == null || this.Objectsuper.get(group.getName()) == null) continue;
                    ((Group)this.Objectsuper.get(group.getName())).setPropertySet(group.getPropertySet());
                }
            }
        }
        catch (IOException iOException) {
            this.\u00f4O0000.getLogger().log(2048, this.\u00f6o0000, iOException.getLocalizedMessage());
        }
    }

    @Override
    protected void readUsers() {
        this.\u00f600000.clear();
        try {
            Document document = FileOperations.getXMLFileContent(this.\u00f4O0000.getLogger(), this.publicsuper);
            String string = XMLOperations.elementNamesToLowerCase(this.\u00f4O0000.getLogger(), document);
            Users users = XMLOperations.unmarshalJAXB(string, Users.class);
            if (users.users != null) {
                Group group = (Group)this.Objectsuper.get("authenticated");
                if (group != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (Users.User user : users.users) {
                        hashSet.add(user.name);
                    }
                    group.setUsers(hashSet);
                }
                this.\u00f600000.addAll(users.users);
            }
        }
        catch (IOException iOException) {
            this.\u00f4O0000.getLogger().log(2048, this.publicsuper, iOException.getLocalizedMessage());
        }
    }

    @Override
    protected synchronized boolean savePermissionSets() {
        \u00d200000.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = false;
        try {
            HashSet<Path> hashSet = new HashSet<Path>();
            for (PathCached object : FileOperations.listFiles(this.\u00d600000, "*.xml")) {
                hashSet.add(object.getPath());
            }
            for (Map.Entry entry : this.\u00d300000.entrySet()) {
                Path path = this.\u00d600000.resolve((String)entry.getKey() + ".xml");
                try {
                    JAXB.marshal(entry.getValue(), (File)path.toFile());
                    hashSet.remove(path);
                    bl &= true;
                }
                catch (DataBindingException dataBindingException) {
                    this.\u00f4O0000.getLogger().log(2048, path, dataBindingException.getLocalizedMessage());
                }
            }
            for (Path path : hashSet) {
                Files.delete(path);
            }
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.setFileMonitorTasksSuspended(false);
        \u00d200000.unlock();
        return bl;
    }

    @Override
    public boolean duplicateGroup(String string, String string2) {
        boolean bl = false;
        if (this.Objectsuper.containsKey(string) && !this.Objectsuper.containsKey(string2)) {
            Group group = new Group(string2);
            HashSet<String> hashSet = new HashSet<String>(((Group)this.Objectsuper.get(string)).getUsers());
            group.setUsers(hashSet);
            this.Objectsuper.put(string2, group);
            bl = this.saveGroups();
        }
        return bl;
    }

    @Override
    protected synchronized boolean saveGroups() {
        \u00d200000.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = this.saveGroupsToFile(this.\u00f6o0000);
        this.setFileMonitorTasksSuspended(false);
        \u00d200000.unlock();
        return bl;
    }

    @Override
    protected synchronized boolean saveUsers() {
        \u00d200000.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean bl = this.saveUsersToFile(this.publicsuper);
        this.setFileMonitorTasksSuspended(false);
        \u00d200000.unlock();
        return bl;
    }

    public Path getUsersFile() {
        return this.publicsuper;
    }

    public Path getGroupsFile() {
        return this.\u00f6o0000;
    }

    public Path getPermissionSetsDirectory() {
        return this.\u00d600000;
    }

    @Override
    public boolean isUserModificationPossible() {
        return true;
    }
}

