/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.cache;

import com.neptunelabs.fsiserver.framework.cache.BlockCache;
import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheLoad;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.cache.CacheableData;
import com.neptunelabs.fsiserver.framework.helpers.URLEncoderFast;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Obfuscation
public class CacheBrowser
extends HttpServlet {
    private static final long serialVersionUID = -1506027446584153143L;
    private ServletContext servletContext;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletContext = servletConfig.getServletContext();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setDateHeader("Last-Modified", System.currentTimeMillis());
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        Object object = this.servletContext.getAttribute("com.neptunelabs.fsiserver.CacheManager");
        CacheManager cacheManager = object != null ? (CacheManager)object : null;
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            if (httpServletRequest.getParameter("delkey") != null) {
                this.delCacheEntries(cacheManager, httpServletRequest.getParameter("delkey"));
            }
            printWriter.append("<!DOCTYPE html>\n");
            printWriter.append("<head>\n");
            printWriter.append("<title>Cache Brower</title>\n");
            printWriter.append("</head>\n");
            printWriter.append("<body><tt>\n");
            printWriter.append("******************<br/>\n");
            printWriter.append("* Cache Manager: *<br/>\n");
            printWriter.append("******************<br/>\n");
            this.printCacheEntries(printWriter, cacheManager);
            printWriter.append("</tt></body>\n");
            printWriter.append("</html>\n");
            printWriter.flush();
        }
    }

    private void delCacheEntries(CacheManager cacheManager, String string) {
        if (cacheManager != null && string != null) {
            CacheKey cacheKey = CacheKey.getInstance(string);
            cacheManager.touchChangedFile(cacheKey);
        }
    }

    private void printCacheEntries(PrintWriter printWriter, CacheManager cacheManager) {
        if (cacheManager == null) {
            printWriter.append("No CacheManager found, sorry.<br/>\n");
        } else {
            long l;
            CacheLoad cacheLoad;
            CacheLoad cacheLoad2;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Map.Entry<String, SoftReference<CacheableData<?>>> object2 : cacheManager.getL1EntrySet()) {
                treeSet.add(object2.getKey());
            }
            BlockCache blockCache = cacheManager.getBlockCache();
            Set<String> set = blockCache.getKeys();
            TreeSet<String> treeSet2 = new TreeSet<String>(set);
            printWriter.append("<h1>L1</h1>\n").append("\nCurrent Objects L1: ").append(String.valueOf(treeSet.size())).append("<h1>L2</h1>\n").append("\n").append(blockCache.toStatisticsString().replaceAll("\n", "<br/>")).append("<hr/>\n").append("<table border=\"1\">\n").append("<tr>").append("<td>Key</td>").append("<td>L1 Type</td>").append("<td>L2 Type</td>").append("<td>Size</td>").append("</tr>\n");
            URLEncoderFast uRLEncoderFast = new URLEncoderFast("", false);
            for (String string : treeSet) {
                printWriter.append("<tr>\n");
                cacheLoad2 = cacheManager.getL1Load(string);
                cacheLoad = blockCache.loadObject(string);
                printWriter.append("<td><a href=\"?delkey=");
                printWriter.append(uRLEncoderFast.escape(string));
                printWriter.append("\" title=\"Delete Key\">");
                printWriter.append(string);
                printWriter.append("</a></td>");
                printWriter.append("<td>");
                printWriter.append(cacheLoad2.\u00d300000.toString());
                printWriter.append("</td>");
                if (cacheLoad != null) {
                    printWriter.append("<td>");
                    printWriter.append(cacheLoad.o00000.toString());
                    printWriter.append("</td>");
                } else {
                    printWriter.append("<td>");
                    printWriter.append("</td>");
                }
                if (cacheLoad != null) {
                    l = blockCache.getObjectSize(string);
                    printWriter.append("<td>");
                    printWriter.append(Long.toString(l));
                    printWriter.append("</td>");
                } else {
                    printWriter.append("<td>");
                    printWriter.append("</td>");
                }
                printWriter.append("\n");
                printWriter.append("</tr>\n");
            }
            for (String string : treeSet2) {
                cacheLoad2 = cacheManager.getL1Load(string);
                cacheLoad = blockCache.loadObject(string);
                printWriter.append("<tr>\n");
                printWriter.append("<td>");
                printWriter.append(string);
                printWriter.append("</td>");
                printWriter.append("<td>");
                printWriter.append("</td>");
                printWriter.append("<td>");
                printWriter.append(cacheLoad.o00000.toString());
                printWriter.append("</td>");
                l = blockCache.getObjectSize(string);
                printWriter.append("<td>");
                printWriter.append(Long.toString(l));
                printWriter.append("</td>");
                printWriter.append("\n");
                printWriter.append("</tr>\n");
            }
            printWriter.append("</table>\n");
        }
    }
}

