/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import java.io.IOException;

public class TIFFNullDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    private boolean isReadActiveOnly = false;
    private int originalSrcMinX;
    private int originalSrcMinY;
    private int originalSrcWidth;
    private int originalSrcHeight;

    @Override
    public void beginDecoding() {
        int n = 0;
        for (int n2 : this.bitsPerSample) {
            n += n2;
        }
        if ((this.activeSrcMinX != this.srcMinX || this.activeSrcMinY != this.srcMinY || this.activeSrcWidth != this.srcWidth || this.activeSrcHeight != this.srcHeight) && (this.activeSrcMinX - this.srcMinX) * n % 8 == 0) {
            this.isReadActiveOnly = true;
            this.originalSrcMinX = this.srcMinX;
            this.originalSrcMinY = this.srcMinY;
            this.originalSrcWidth = this.srcWidth;
            this.originalSrcHeight = this.srcHeight;
            this.srcMinX = this.activeSrcMinX;
            this.srcMinY = this.activeSrcMinY;
            this.srcWidth = this.activeSrcWidth;
            this.srcHeight = this.activeSrcHeight;
        } else {
            this.isReadActiveOnly = false;
        }
        super.beginDecoding();
    }

    @Override
    public void decode() throws IOException {
        super.decode();
        if (this.isReadActiveOnly) {
            this.srcMinX = this.originalSrcMinX;
            this.srcMinY = this.originalSrcMinY;
            this.srcWidth = this.originalSrcWidth;
            this.srcHeight = this.originalSrcHeight;
            this.isReadActiveOnly = false;
        }
    }

    @Override
    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.isReadActiveOnly) {
            int n4 = (this.activeSrcWidth * n2 + 7) / 8;
            int n5 = (this.originalSrcWidth * n2 + 7) / 8;
            int n6 = n5 - n4;
            this.stream.seek(this.offset + (long)((this.activeSrcMinY - this.originalSrcMinY) * n5) + (long)((this.activeSrcMinX - this.originalSrcMinX) * n2 / 8));
            int n7 = this.activeSrcHeight - 1;
            for (int i = 0; i < this.activeSrcHeight; ++i) {
                this.stream.read(byArray, n, n4);
                n += n3;
                if (i == n7) continue;
                this.stream.skipBytes(n6);
            }
        } else {
            this.stream.seek(this.offset);
            int n8 = (this.srcWidth * n2 + 7) / 8;
            if (n8 == n3) {
                this.stream.read(byArray, n, n8 * this.srcHeight);
            } else {
                for (int i = 0; i < this.srcHeight; ++i) {
                    this.stream.read(byArray, n, n8);
                    n += n3;
                }
            }
        }
        this.decodeSpecial(byArray, n, this.bitsPerSample[0], 1);
    }
}

