/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.opimage.TransposeOpImage;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;

final class MlibTransposeOpImage
extends TransposeOpImage {
    public MlibTransposeOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, int n) {
        super(renderedImage, map, imageLayout, n);
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getTileRect(n, n2).intersection(this.getBounds());
        PlanarImage planarImage = this.getSourceImage(0);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0).intersection(planarImage.getBounds());
        Raster[] rasterArray = new Raster[]{planarImage.getData(rectangle2)};
        this.computeRect(rasterArray, writableRaster, rectangle);
        if (planarImage.overlapsMultipleTiles(rectangle2)) {
            this.recycleTile(rasterArray[0]);
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        int n2 = this.getSampleModel().getNumBands();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
                switch (this.type) {
                    case 0: {
                        Image.FlipX((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 1: {
                        Image.FlipY((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 2: {
                        Image.FlipMainDiag((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 3: {
                        Image.FlipAntiDiag((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 4: {
                        Image.Rotate90((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 5: {
                        Image.Rotate180((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 6: {
                        Image.Rotate270((mediaLibImage)mediaLibImageArray2[0], (mediaLibImage)mediaLibImageArray[0]);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray3 = mediaLibAccessor2.getMediaLibImages();
                switch (this.type) {
                    case 0: {
                        Image.FlipX_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 1: {
                        Image.FlipY_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 2: {
                        Image.FlipMainDiag_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 3: {
                        Image.FlipAntiDiag_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 4: {
                        Image.Rotate90_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 5: {
                        Image.Rotate180_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                        break;
                    }
                    case 6: {
                        Image.Rotate270_Fp((mediaLibImage)mediaLibImageArray3[0], (mediaLibImage)mediaLibImageArray[0]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

