/*!
 * FSI Thumb Bar
 * Build: 19.05.6483
 * 
 * Copyright (c) 2019 NeptuneLabs GmbH - All rights reserved.
 *
 * info@neptunelabs.com
 * www.neptunelabs.com
 * 
 * IMPORTANT NOTE
 * ------------------------------------------------------
 * Usage limited to the terms of the NeptuneLabs Software 
 * END-USER LICENSE AGREEMENT.
 * ------------------------------------------------------
 *
 */

"use strict";
(function(k,d){if(k.fnDoNothing!==d){return}k.fnDoNothing=function(){};if(typeof(console.error)!=="function"){k.console={};k.console.log=k.fnDoNothing;k.console.logCSS=k.fnDoNothing;k.console.warn=k.fnDoNothing;k.console.error=k.fnDoNothing;k.console.dir=k.fnDoNothing;k.console.info=k.fnDoNothing}else{k.console=console;if(typeof(console.timeLog)==="function"){k.console.logCSS=console.log}else{k.console.logCSS=function(e){e=e.replace(/%c/g,"");console.log(e)}}}if(typeof(window.requestAnimationFrame)!=="function"){var b=0;var m=["ms","moz","webkit","o"];for(var l=0;l<m.length&&!window.requestAnimationFrame;++l){window.requestAnimationFrame=window[m[l]+"RequestAnimationFrame"];window.cancelAnimationFrame=window[m[l]+"CancelAnimationFrame"]||window[m[l]+"CancelRequestAnimationFrame"]}if(!window.requestAnimationFrame||!window.cancelAnimationFrame){window.requestAnimationFrame=function(q){var e=new Date().getTime();var i=Math.max(0,16-(e-b));var p=window.setTimeout(function(){q(e+i)},i);b=e+i;return p};window.cancelAnimationFrame=function(e){clearTimeout(e)}}}k.initCustomTag=k.initCustomTags=k.fnDoNothing;k.now=(typeof(Date.now)==="function")?Date.now:function(){return new Date().getTime()};k.osVersion=[0,0,0];var c=navigator.userAgent.toLowerCase();var o,n,f;if(c.search(/iphone|ipad|ipod|android|symbian|mobile|phone|windows ce|opera mini|opera mobi/i)>-1){o=true;if(c.search("android")>-1){k.mobileOS="android";k.isTouch=true;k.noMouse=true;n=c.match(/android (\S*)/);if(n&&n.length>1){n=n[1].split(".");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}else{if(c.indexOf("mac os")!==-1){k.mobileOS="ios";k.isTouch=true;k.noMouse=true;n=c.match(/ os (\S*)/);if(n&&n.length>1){n=n[1].split("_");for(f=0;f<n.length;f++){n[f]=parseInt(n[f])}k.osVersion=[].concat(n)}}}}else{o=false}k.isMobileDevice=o;k.isSmallMobileDevice=(c.search(/iphone|ipod|phone|mobile safari|iemobile|opera mini|opera mobi/i)>-1);k.isInternetExplorer=false;k.isIETouch=false;if(c.search("msie")>-1){k.isInternetExplorer=true;n=c.match(/msie ([^;]*)/);if(n&&n.length>1){k.versionInternetExplorer=parseFloat(n[1])}}else{if(navigator.userAgent.match(/Trident.*rv:(\d+\.)/gi)){k.isInternetExplorer=true;k.versionInternetExplorer=parseFloat(RegExp.$1)}else{k.isInternetExplorer=(typeof(window.onmsgestureend)!=="undefined");if(k.isInternetExplorer){k.versionInternetExplorer=12}}}if(window.navigator.msPointerEnabled){k.isIETouch=(window.navigator.msMaxTouchPoints>1)}if(!k.isTouch){k.isTouch=(window.navigator.maxTouchPoints>1||window.navigator.msMaxTouchPoints>1)}if(c.search("chrome")!==-1&&c.search("edge")===-1){k.isChrome=true}else{if(c.search("safari")!==-1){k.isSafari=true}else{if(c.search("firefox")!==-1){k.isFirefox=true}else{if(c.search("opera")!==-1){k.isOpera=true}}}}if(c.search("mac os")>-1){k.isMac=true}if(typeof(window.pageYOffset)==="number"){k.getDocumentScroll=function(e){return{x:e.pageXOffset,y:e.pageYOffset}}}else{if(document.body&&(document.body.scrollLeft||document.body.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.body.scrollLeft,y:e.document.body.scrollTop}}}else{if(document.documentElement&&(document.documentElement.scrollLeft||document.documentElement.scrollTop)){k.getDocumentScroll=function(e){return{x:e.document.documentElement.scrollLeft,y:e.document.documentElement.scrollTop}}}}}if(typeof(window.devicePixelRatio)!=="undefined"){k.getDevicePixelRatio=function(){return window.devicePixelRatio||1}}else{k.getDevicePixelRatio=function(){return 1}}k.preventDefaultEvent=function(e){if(e.preventDefault){e.preventDefault()}e.returnValue=false;return false};k.getElementDimension=function(e){return{width:e.offsetWidth,height:e.offsetHeight}};k.getViewportSize=function(i){var e;if(!i){i=window}if(k.BrowserSupports.visualViewportAPI()){e={width:i.visualViewport.width,height:i.visualViewport.height}}else{e={width:i.innerWidth,height:i.innerHeight}}return e};k.replaceChild=function(q,s,i){try{var p=s.nextSibling;if(p){q.removeChild(s);q.insertBefore(i,p)}else{q.appendChild(i)}}catch(r){k.console.error(r.message);k.console.log(q);k.console.log(s);k.console.log(i)}};k.removeChild=function(i,q){try{i.removeChild(q)}catch(p){k.console.error(p.message);k.console.log(i);k.console.log(q)}};k.getWindowOffset=function(r){var q=0;var p=0;try{if(r.frameElement){var i=r;while(i.frameElement){var s=i.frameElement;var u=k.getElementPosition(s);q+=u.left;p+=u.top;i=i.parent}}}catch(t){}return{x:q,y:p}};var a=document.createElement("div");try{a.getBoundingClientRect();k.getBoundingClientRect=function(e){return e.getBoundingClientRect()}}catch(h){k.getBoundingClientRect=function(i){try{return i.getBoundingClientRect()}catch(p){return{top:0,left:0,right:0,bottom:0,width:0,height:0}}}}k.getElementClientDim=function(e){var i=k.getBoundingClientRect(e);return{width:(i.right-i.left),height:(i.bottom-i.top)}};k.getElementClientPos=function(e){return k.getBoundingClientRect(e)};k.getElementPosition=function(v){var i=k.getBoundingClientRect(v);var t=v.clientLeft;var B=v.clientTop;var C=0;var x=0;var u=0;var r=0;var D=0;var A=0;try{var q=window.getComputedStyle(v,null);u=parseFloat(q.paddingLeft);r=parseFloat(q.paddingRight);D=parseFloat(q.paddingTop);A=parseFloat(q.paddingBottom);t=parseFloat(q.borderLeftWidth);C=parseFloat(q.borderRightWidth);B=parseFloat(q.borderTopWidth);x=parseFloat(q.borderBottomWidth)}catch(w){}var s=i.left+t+u;var z=i.top+B+D;var p=i.right-C-r;var y=i.bottom-x-A;return{left:s,top:z,right:p,bottom:y}};k.dispatchEvent=function(e){var i;if(k.BrowserSupports.genericEvent()){i=new Event(e)}else{i=document.createEvent("Event");i.initEvent(e,true,true)}if(i){return window.dispatchEvent(i)}else{return false}};k.removeEvent=function(q,i,p,e){if(window.removeEventListener&&q){if(e===d){e=true}q.removeEventListener(i,p,e)}else{if(window.detachEvent&&q){q.detachEvent("on"+i,p)}}};k.addEvent=function(q,i,p,e){if(window.addEventListener&&q){if(e===d){e=true}q.addEventListener(i,p,e)}else{if(window.attachEvent&&q){q.attachEvent("on"+i,p)}}};k.sign=Math.sign||function(i){var e;if(isNaN(i)){e=NaN}else{if(i===0){e=0}else{e=(i<0)?-1:1}}return e};k.trim=function(e){if(!e||typeof(e)!=="string"||e.length<1){return e}return e.replace(/(^\s+)|(\s+$)/g,"")};var j=k.escapeRegEx=function(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")};k.addClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};k.addClass(p,q);e.setAttribute("class",p.className)};k.removeClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={removeAttribute:k.fnDoNothing,className:i};k.removeClass(p,q);if(p.className!==""){e.setAttribute("class",p.className)}else{e.removeAttribute("class")}};k.hasClassSVG=function(e,q){var i=e.getAttribute("class");if(i===null){i=""}var p={className:i};return k.hasClass(p,q)};k.addClass=function(i,r){if(!i||typeof(i.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var q=j(r);var p=new RegExp("(^|\\s+)"+q+"(\\s+|$)");var s=k.trim(i.className);var e=s.match(p);if(!e){if(s.length>0){s+=" "+r}else{s+=r}i.className=s}};k.removeClass=function(e,r){if(!e||typeof(e.className)!=="string"){return}if(typeof(r)!=="string"){return}r=k.trim(r);if(r.length<1){return}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");var q=k.trim(e.className.replace(i," "));if(q.length>0){e.className=q}else{e.removeAttribute("class")}};k.hasClass=function(e,r){if(typeof(r)!=="string"){return false}r=k.trim(r);if(r.length<1){return false}var q=e.className;if(typeof(q)!=="string"||q.length<1){return false}r=r.replace(/\s+/," ");var p=j(r);var i=new RegExp("(^|\\s+)"+p+"(\\s+|$)","g");return(q.match(i)!=null)};k.getFSIServerImageDim=function(e,r,p,t,i,q){var u={width:e,height:r};var s={width:p,height:t};k.calcFSIServerImageDim(u,s,i,q);return s};k.calcFSIServerImageDim=function(e,i,q,r){if(typeof(q)!=="object"){q={left:0,top:0,width:1,height:1}}else{q.left=q.left<0?0:q.left>1?1:q.left;q.top=q.top<0?0:q.top>1?1:q.top;q.width=q.width<0?1-q.left:q.width+q.left>1?1-q.left:q.width;q.height=q.height<0?1-q.top:q.height+q.top>1?1-q.top:q.height}i.width=i.width<=0||i.width===d?-1:i.width;i.height=i.height<=0||i.height===d?-1:i.height;var u={};if(i.width!==-1&&i.height!==-1){u.x=i.width/(e.width*q.width);u.y=i.height/(e.height*q.height)}else{if(i.height===-1){u.x=u.y=i.width/(e.width*q.width)}else{u.x=u.y=i.height/(e.height*q.height)}}if(i.width===-1||i.height===-1){var t=Math.min(u.x,u.y);if(i.width===-1){i.width=Math.round(e.width*q.width*t)}else{if(i.height===-1){i.height=Math.round(e.height*q.height*t)}}u.x=t;u.y=t}if(r&&Math.abs(u.x-u.y)>1e-7){if(u.x>u.y){var p=i.height*e.width*q.width/(e.height*q.height);u.x=p/e.width;i.width=Math.round(p)}else{var s=i.width*e.height*q.height/(e.width*q.width);u.y=s/e.height;i.height=Math.round(s)}}i.width=i.width===0?1:i.width;i.height=i.height===0?1:i.height;return u};k.BrowserSupports={};k.BrowserSupports[false]=function(){return false};k.BrowserSupports[true]=function(){return true};k.BrowserSupports.localStorage=function(){var i=false;try{if(typeof(window.localStorage)!=="undefined"&&typeof(localStorage.setItem)==="function"){i=true}}catch(p){}k.BrowserSupports.localStorage=k.BrowserSupports[i];return i};k.BrowserSupports.visualViewportAPI=function(){var i=false;try{if(typeof(window.visualViewport)!=="undefined"){i=true}}catch(p){}k.BrowserSupports.visualViewportAPI=k.BrowserSupports[i];return i};k.BrowserSupports.genericEvent=function(){var i=false;try{if(typeof(window.Event)==="function"){i=true}}catch(p){}k.BrowserSupports.genericEvent=k.BrowserSupports[i];return i};k.BrowserSupports.customElementRegistry=function(){var i=false;try{if(typeof(window.customElements)==="object"&&typeof(window.customElements.define)==="function"){i=true}}catch(p){}k.BrowserSupports.customElementRegistry=k.BrowserSupports[i];return i};k.BrowserSupports.registerElement=function(){var i=false;try{if(typeof(document.registerElement)==="function"){i=true}}catch(p){}k.BrowserSupports.registerElement=k.BrowserSupports[i];return i};k.BrowserSupports.canvas=function(){var q=false;try{var p=document.createElement("canvas");var i=p.getContext("2d");if(i&&i.clearRect!==d){q=true}}catch(r){}k.BrowserSupports.canvas=k.BrowserSupports[q];return q};k.BrowserSupports.cssTouchAction=function(){var p=false;try{if(k.isTouch){if(typeof(window.getComputedStyle)==="function"){var i=window.getComputedStyle(document.body);p=(typeof(i.touchAction)==="string")}}}catch(q){}k.BrowserSupports.cssTouchAction=k.BrowserSupports[p];return p};var g=Boolean(k.isMobileDevice||k.isIETouch||k.isTouch||(k.isMac&&k.isSafari));k.BrowserSupports.documentZoom=k.BrowserSupports[g]}(window.$FSI=window.$FSI||{}));(function($FSI,undefined){if($FSI.Utils!==undefined){return}$FSI.Utils=function(){var self=this;var addedCSSBlocks={};var rgxThousandSeperator=/(\d+)(\d{3})/;var regexPlusToSpace=/\+/g;var regExServerRenderer=/([?&])(renderer|profile)=([^&]*)/i;var regExServerFormat1=/(&)?format=[^&]*/ig;var regExServerFormat2=/\?&/;var documentScaleMethod;var __getMediaMinScreenWidthCount=0;var __getMediaMinScreenWidthLoopCount=0;var __LastGetMediaMinScreenWidthResult;var __LastGetMediaMinScreenWidth;var __getDocumentScaleReferenceWidth;var strCSSTransformStyleName;var iLoaderCSSSkin;var iLoaderJavascript;this.oLanguageMap=undefined;this.API={};var topWindow;var strFSIViewerURL;try{if(typeof(top.window.alert)==="function"){topWindow=top.window}else{topWindow=window}}catch(e){$FSI.console.warn("FSI: top.window is not accessible. This is likely due to cross domain security restrictions. Viewer functionality might be limited.");topWindow=window}var oMatchMedia=topWindow.matchMedia||topWindow.msMatchMedia;this.getTopWindow=function(){return topWindow};var callbackFunctionID=0;this.getNewCallbackFunctionID=function(){return callbackFunctionID++};var nViewerInstanceID=0;this.getViewerInstanceID=function(){return ++nViewerInstanceID};var oSupportedEvents={};$FSI.isEventSupported=function(eventName){if(oSupportedEvents[eventName]!==undefined){return oSupportedEvents[eventName]}var el=document.createElement("div");var eventNameOn="on"+eventName;var isSupported=(eventNameOn in el);if(!isSupported){el.setAttribute(eventNameOn,"return;");isSupported=typeof el[eventNameOn]==="function"}el=null;oSupportedEvents[eventName]=isSupported;return isSupported};this.getSVGNameSpaceURL=function(){return"http://www.w3.org/2000/svg"};var nSVGID=0;this.getSVGID=function(){return"$FSI.SVGID_"+nSVGID++};var oClassDefCreated={};this.ClassDef=function(instance,strClassName,oOptions){var version=oOptions.strVersion;var build=oOptions.strBuild;var self=this;this.instance=instance;this.strClassName=strClassName;this.strConfigSection=oOptions.strConfigSection;this.version=version;this.build=build;if(oOptions.bNoAPI!==true){instance.getAPIData=function(){return self.oAPI}}this.traceConfigValue=function(strParam){var parameters=(typeof(instance.getParameters)==="function")?instance.getParameters():undefined;var tmpCfg=new $FSI.Config(null,null,{strSection:self.strConfigSection});return tmpCfg.traceConfigValue(strParam,parameters)};instance.traceConfigValue=this.traceConfigValue;this.printAPI=function(){if(!self.oAPI){return}var line="------------------------------";line+=line+line;line="\r\n"+line+"\r\n";var toArray=function(obj){var ret=[];if(obj){for(var o in obj){if(obj.hasOwnProperty(o)){var itm=obj[o];if(typeof(itm)!=="object"){itm={val:itm}}itm.nam=o;ret.push(itm)}}}return ret};var outputData=function(obj,strTitle,strReturn,bArgs,objCompare){var i,strResult,strType,itm;var nNotAvailable=0;var args="";if(!obj){return}var ar=toArray(obj);if(ar.length>0){if(fnGroup){fnGroupCollapsed(strTitle.replace(/^API /,""))}else{$FSI.console.log("\r\n"+strTitle+" of "+strVersionString+line)}for(i=0;i<ar.length;i++){if(bArgs){if(ar[i].a===undefined){ar[i].a="void"}args="%c( "+ar[i].a+" )"}else{args="%c"}strResult=(ar[i].r===undefined)?"%c":"%c"+strReturn+ar[i].r;strType=(ar[i].t===undefined)?"":" ("+ar[i].t+")";itm=ar[i].nam+args+strResult+strType;if(objCompare&&objCompare[ar[i].nam]===undefined){nNotAvailable++;itm+=" [x]"}$FSI.console.logCSS(itm,"color:#00a;","color:green;")}if(nNotAvailable>0){$FSI.console.logCSS("%c\r\n\r\nPLEASE NOTE: items marked with [x] are not available with the current configuration options","color:#c50")}if(fnGroup!==undefined){console.groupEnd()}}};var fnGroup,fnGroupCollapsed;if(!$FSI.isInternetExplorer&&typeof(console.group)==="function"){fnGroup=console.group;if(typeof(console.groupCollapsed)==="function"){fnGroupCollapsed=console.groupCollapsed}else{console.groupCollapsed=fnGroup}}if(fnGroup!==undefined){fnGroup("API of "+strVersionString)}outputData(self.oAPI.oMethods,"API Methods"," // RETURNS: ",true);outputData(self.oAPI.oProperties,"API Properties","","");outputData(self.oAPI.oCallbacks,"API Listeners"," // RETURN: ",true);var oActiveButtons=(typeof(self.oAPI.getActiveMenuButtons)==="function")?self.oAPI.getActiveMenuButtons():undefined;outputData(self.oAPI.oMenuCommands,"Button IDs","",false,oActiveButtons);if(fnGroup!==undefined){console.groupEnd()}};instance.printAPI=this.printAPI;this.testAPIListenersStart=function(){if(!instance.addListener||instance._TestAPIListeners){return}var strInstance=instance.getInstanceName();instance._TestAPIListeners={};for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance._TestAPIListeners[listenerName]={};instance._TestAPIListeners[listenerName].listenerName=listenerName;instance._TestAPIListeners[listenerName].fn=function(){$FSI.console.log(strInstance+" called listener ["+this.listenerName+"]",arguments)};instance.addListener(listenerName,instance._TestAPIListeners[listenerName].fn,instance._TestAPIListeners[listenerName])}}};this.testAPIListenersStop=function(){if(!instance.removeListener||!instance._TestAPIListeners){return}for(var listenerName in self.oAPI.oCallbacks){if(self.oAPI.oCallbacks.hasOwnProperty(listenerName)){instance.removeListener(listenerName,instance._TestAPIListeners[listenerName].fn)}}instance._TestAPIListeners=undefined;delete instance._TestAPIListeners};if(oOptions.bHasListeners){instance.testAPIListenersStart=this.testAPIListenersStart;instance.testAPIListenersStop=this.testAPIListenersStop}var strVersionString=strClassName+" "+version+" build "+build;var getVersion=function(){return strVersionString};var getBuild=function(){return build};instance.getVersion=getVersion;instance.getBuild=getBuild;if(!oClassDefCreated[strClassName]){oClassDefCreated[strClassName]=true;if(instance.getBuild()!==$FSI.getBuild()){$FSI.console.error("FSI version mismatch: "+getVersion()+" and "+$FSI.getVersion())}}};new self.ClassDef($FSI,"FSI Core",{strVersion:"2019",strBuild:"19.05.6483",bNoAPI:true});this.mergeObjects=function(o1,o2){for(var o in o2){if(o2.hasOwnProperty(o)){o1[o]=o2[o]}}return o1};this.cloneArray=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}return ar.concat([])};this.cloneArrayRecursive=function(ar){if(typeof(ar)==="undefined"||ar.length===undefined||ar.length===0){return[]}var ret=ar.concat([]);for(var i=0;i<ar.length;i++){ar[i]=self.cloneValue(ar[i])}return ret};this.cloneValue=function(val){var ret;switch(typeof(val)){case"object":if(val!=null&&typeof(val.cloneNode)==="function"){ret=val}else{if(val!=null&&typeof(val.push)==="function"){ret=self.cloneArrayRecursive(val)}else{ret=self.cloneObject(val)}}break;default:ret=val}return ret};this.cloneObject=function(obj){if(typeof(obj)!=="object"){return{}}if(obj==null){return null}var ret={};if(typeof(obj)==="object"&&typeof(obj.push)==="function"){ret=self.cloneArrayRecursive(obj)}else{for(var o in obj){ret[o]=self.cloneValue(obj[o])}}return ret};this.cloneParameters=function(parameters){return self.cloneObject(parameters)};var regExEffects=/((\?)|&)effects=([^&]*)/ig;var regExPadEffect=/[=,]+Pad\([^)]*/ig;this.expandSourceDimensionForPadEffect=function(o,w,h){var dimOrg;if(typeof(o)!=="object"||typeof(o.src)!=="string"){return}var res=o.src.match(regExEffects);if(res&&typeof(res)==="object"&&typeof(res[0])==="string"){o.bHasEffects=true;res[0]=decodeURIComponent(res[0]);if(res[0].match(regExPadEffect)){o.bHasPadEffect=true;var rectWidth=(o.rectWidth!==undefined)?o.rectWidth:1;var rectHeight=(o.rectHeight!==undefined)?o.rectHeight:1;if(rectWidth>0&&rectHeight>0){var sourceWidth=rectWidth*o.sourceWidth;var sourceHeight=rectHeight*o.sourceHeight;if(sourceWidth/w>sourceHeight/h){dimOrg=sourceHeight/sourceWidth*w;o.sourceHeight=Math.round(h/dimOrg*sourceHeight)/rectHeight}else{dimOrg=sourceWidth/sourceHeight*h;o.sourceWidth=Math.round(w/dimOrg*sourceWidth)/rectWidth}}}}};var documentDomain=document.location.hostname;var regCors=new RegExp("//"+documentDomain+"[:/]");this.isCrossDomain=function(url){if(!url||url.indexOf("http")!==0){return false}return url.match(regCors)==null};this.loadImageCors=function(img,url){if(self.isCrossDomain(url)){img.crossOrigin="";img.src=url}else{img.src=url}};var oBoolTable={"0":false,"false":false,"1":true,"true":true};$FSI.makeBool=function(value,def){var ret;var t=typeof(value);if(t==="boolean"){ret=value}else{if(t==="string"){value=value.toLowerCase()}ret=oBoolTable[value];if(ret===undefined){ret=def}}return ret};this.getBoolTable=function(val){return oBoolTable[val]};var oCustomEventListenerClasses={};var oCustomEventListenerInstances={};var oCustomEventListeners={};var nCustomEventListeners=0;var nCustomEventListenerID=0;var nCustomEventFunctionID=0;var nCustomEventElementID=0;this.customEventClassExists=function(nam){return(oCustomEventListenerClasses[nam]!==undefined)};this.getCustomEventListenerInstance=function(myEvent){return new oCustomEventListenerClasses[myEvent]()};this.registerCustomEvent=function(nam,fnClass){if(oCustomEventListenerClasses[nam]){return false}oCustomEventListenerClasses[nam]=fnClass};this.getNewEventElementID=function(){return nCustomEventElementID++};this.getNewEventFunctionID=function(){return nCustomEventFunctionID++};$FSI.addCustomEvent=function(myObj,myEvent,myFunc){var obj,listenerID;var listener=oCustomEventListenerInstances[myEvent];if(!listener){if(typeof(oCustomEventListenerClasses[myEvent])==="undefined"){$FSI.console.error("$FSI.oCustomEventListenerClass for '"+myEvent+"' is missing.");return false}listener=oCustomEventListenerInstances[myEvent]=new oCustomEventListenerClasses[myEvent]()}obj=listener.addListener(myObj,myFunc);if(obj!==undefined){listenerID=obj.nCustomEventListenerID=nCustomEventListenerID++;oCustomEventListeners[obj.nCustomEventListenerID]=obj;nCustomEventListeners++}else{$FSI.console.error("Failed to add custom event listener: "+myEvent)}return listenerID};$FSI.removeCustomEvent=function(myObj,myEvent,myFunc){var listener=oCustomEventListenerInstances[myEvent];if(!listener){return false}var obj=listener.removeListener(myObj,myFunc);if(obj&&oCustomEventListeners[obj.nCustomEventListenerID]!==undefined){delete oCustomEventListeners[obj.nCustomEventListenerID];nCustomEventListeners--}else{$FSI.console.error("Failed to remove custom event listener")}};$FSI.setCustomEventListenerProperty=function(listenerID,nam,val){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.setListenerProps.call(obj.instanceListener,obj.uniqueID,nam,val)};$FSI.enableCustomEventListener=function(listenerID,bEnable){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.enableListener.call(obj.instanceListener,obj.uniqueID,bEnable)};$FSI.pauseCustomEventListener=function(listenerID,bPause){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.pauseListener.call(obj.instanceListener,obj.uniqueID,bPause)};$FSI.triggerCustomEvent=function(listenerID){var obj=oCustomEventListeners[listenerID];if(!obj||!obj.instanceListener){return}obj.instanceListener.triggerEvent.call(obj.instanceListener,obj.uniqueID)};var createJavascriptLoader=function(){if(!iLoaderJavascript){if(typeof($FSI.LoaderJavascript)!=="function"){$FSI.console.error("Class $FSI.LoaderJavascript missing.");return false}iLoaderJavascript=new $FSI.LoaderJavascript()}return true};$FSI.loadJavascript=function(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough){if(!createJavascriptLoader()){return false}return iLoaderJavascript.load(strScriptPath,idInstance,argScope,fnOnLoad,oPassThrough)};$FSI.releaseLoadJavascript=function(strScriptPath,idInstance){if(!createJavascriptLoader()){return false}return iLoaderJavascript.release(strScriptPath,idInstance)};this.loadSkinCSS=function(skinName,scope,fnReady,nPriority,arDependencies){if(typeof(iLoaderCSSSkin)!=="object"){if(typeof($FSI.LoaderCSSSkin)!=="function"){$FSI.console.error("Class $FSI.LoaderCSSSkin missing.");fnReady.call(scope,false);return}iLoaderCSSSkin=new $FSI.LoaderCSSSkin()}return iLoaderCSSSkin.load(skinName,scope,fnReady,nPriority,arDependencies)};this.rgbaHexToDecimal=function(str){var ret={};if(typeof(str)!=="string"){str=""}str=str.toLowerCase();str=str.replace(/[^0-9-a-f]/g,"F");if(str.length>8){str=str.substr(0,8)}else{var def="FFFFFFFF";str+=def.substr(0,8-str.length)}ret.hex=str;ret.redHex=str.substr(0,2);ret.greenHex=str.substr(2,2);ret.blueHex=str.substr(4,2);ret.alphaHex=str.substr(6,2);ret.red=parseInt(ret.redHex,16);ret.green=parseInt(ret.greenHex,16);ret.blue=parseInt(ret.blueHex,16);ret.alpha=parseInt(ret.alphaHex,16)/255;ret.strRGBA=ret.red+","+ret.green+","+ret.blue+","+ret.alpha;return ret};this.setStyleAttr=function(el,strStyle){
/*@cc_on
			 @if (@_jscript_version < 9)
			 el.style.setAttribute('cssText', strStyle);
			 @else @*/
el.setAttribute("style",strStyle);
/*@end
			 @*/
};this.changeRendererInURL=function(url,strRenderer){url=url.replace(regExServerRenderer,"$1renderer="+strRenderer);return url};this.removeFormatInURL=function(url){url=url.replace(regExServerFormat1,"");url=url.replace(regExServerFormat2,"?");return url};this.urlDecode=function(str){if(!str){return str}var ret=str.replace(regexPlusToSpace," ");try{ret=decodeURIComponent(ret)}catch(e){$FSI.console.error("Malformed URI: "+ret)}return ret};this.getCSSTransformStyleName=function(){if(strCSSTransformStyleName!==undefined){return strCSSTransformStyleName}var ret="transform";var ar=["transform","webkitTransform","msTransform","MozTransform","OTransform"];var div=document.createElement("DIV");for(var i=0;i<ar.length;i++){div.style[ar[i]]="translate( 0 , 0)";if(div.style[ar[i]]!=="translate( 0 , 0)"){ret=ar[i];break}}div=null;strCSSTransformStyleName=ret;return ret};var oViewerClassCSSRules={};var oInsertedCSS;this.addViewerClassCSSRule=function(strClass,strRule){if(typeof(strClass)!=="string"||strClass.length<1){return}if(typeof(strRule)!=="string"||strRule.length<1){return}var res=oViewerClassCSSRules[strClass];if(res===strRule){return}addCSSRule(strClass,strRule,0);oViewerClassCSSRules[strClass]=strRule};this.dumpCSS=function(){console.log("Viewer Class CSS");console.log(oViewerClassCSSRules);console.log("CSS blocks");console.log(addedCSSBlocks);console.log("CSS in FSI.CORE");console.dir(oInsertedCSS.sheet.rules)};this.cssClassExists=function(cssID){return(typeof(addedCSSBlocks[cssID])!=="undefined")};this.addCSSClass=function(cssID,strCode){if(self.cssClassExists(cssID)){return false}var node=addCSSNode(cssID);if(node){try{node.innerHTML=strCode;addedCSSBlocks[cssID]=node}catch(e){$FSI.console.error("FSI: addCSSClass failed")}}};var addCSSNode=function(cssID){var node=null;try{node=document.createElement("style");node.setAttribute("data-generated-by","FSI");node.setAttribute("data-generated-for",cssID);node.setAttribute("data-fsi-priority","0");node.appendChild(document.createTextNode(""));if(document.head.firstChild){document.head.insertBefore(node,document.head.firstChild)}else{document.head.appendChild(node)}}catch(e){$FSI.console.error("FSI: FAILED to create style node for "+cssID);$FSI.console.error(e.message)}return node};this.deleteInstanceCSSRules=function(iInstance){var ar=iInstance._arCSSLayoutSelectors;if(ar!==undefined&&ar.length>0){for(var i=0;i<ar.length;i++){deleteCSSRule(ar[i])}iInstance._arCSSLayoutSelectors=[]}};this.addInstanceCSSRule=function(iInstance,strSelector,strRule){if(iInstance._arCSSLayoutSelectors===undefined){iInstance._arCSSLayoutSelectors=[]}iInstance._arCSSLayoutSelectors.push(strSelector);addCSSRule(strSelector,strRule,0)};var addCSSRule=function(selector,rules,index){if(oInsertedCSS===undefined){oInsertedCSS=addCSSNode("FSI.Core")}if(oInsertedCSS!==undefined){try{if(oInsertedCSS&&oInsertedCSS.sheet){if("insertRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.insertRule(selector+"{"+rules+"}",index)}else{if("addRule" in oInsertedCSS.sheet){oInsertedCSS.sheet.addRule(selector,rules,index)}}}}catch(e){$FSI.console.error("FSI: FAILED to add css rule for "+selector);$FSI.console.error(e.message)}}};var deleteCSSRule=function(selector){var ret=false;var i;if(oInsertedCSS!==undefined){try{var arDelete=[];var ar=oInsertedCSS.sheet.cssRules;for(i=0;i<ar.length;i++){var rule=ar[i];if(rule.selectorText===selector){arDelete.push(i)}}if(arDelete.length>0){for(i=arDelete.length-1;i>-1;i--){oInsertedCSS.sheet.deleteRule(arDelete[i])}ret=true}}catch(e){console.error(e.message);ret=false}}return ret};this.attributes2parameters=function(node){var ret={};if(!node||typeof(node.attributes)!=="object"){return ret}var attr;var attrs=node.attributes;for(var i=0;i<attrs.length;i++){attr=attrs[i];ret[attr.name]=attr.value}return ret};this.getElementMargins=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.marginLeft);ret.top=parseFloat(style.marginTop);ret.right=parseFloat(style.marginRight);ret.bottom=parseFloat(style.marginBottom)}catch(e){}return ret};this.getElementBorders=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.borderLeftWidth);ret.top=parseFloat(style.borderTopWidth);ret.right=parseFloat(style.borderRightWidth);ret.bottom=parseFloat(style.borderBottomWidth)}catch(e){}return ret};this.getElementPaddings=function(element){var ret={left:0,top:0,right:0,bottom:0};try{var style=window.getComputedStyle(element,null);ret.left=parseFloat(style.paddingLeft);ret.top=parseFloat(style.paddingTop);ret.right=parseFloat(style.paddingRight);ret.bottom=parseFloat(style.paddingBottom)}catch(e){}return ret};var getScriptTagByFileName=function(strScriptName){var tag,strSelector;if(typeof(document.querySelector)==="function"){strSelector="script[src$='"+strScriptName+"']";tag=document.querySelector(strSelector);if(!tag){strSelector="script[src*='"+strScriptName+"']";tag=document.querySelector(strSelector)}}if(!tag){var tmp=$FSI.escapeRegEx(strScriptName);var regEx=new RegExp("(^|/)"+tmp+"(\\s*|\\?.*)$");var scripts=document.getElementsByTagName("script");for(var i=0;i<scripts.length;i++){var src=scripts[i].src;if(src.match(regEx)){tag=scripts[i];break}}}return tag};this.getScriptPath=function(strScriptName,depth){var src;depth++;var ret="";var tag=getScriptTagByFileName(strScriptName);if(tag){src=tag.src.split("/");src.splice(src.length-depth,depth);ret=src.join("/")}return ret};this.guessFSIViewerLocation=function(strScriptName,depth){if(strFSIViewerURL!==undefined){return strFSIViewerURL}var ret=self.getScriptPath(strScriptName,depth);if(ret){strFSIViewerURL=ret}return ret};var bHTTPS=(document.location.protocol==="https:");this.isHTTPS=function(){return bHTTPS};$FSI.getViewerLocation=function(){return strFSIViewerURL};this.getNumberSeperators=function(iConfig){var lngEng={english:1,japanese:1,chinese_simplified:1,chinese_traditional:1};var lng;if(!iConfig||!iConfig.cfg||typeof(iConfig.cfg.language)!=="string"){lng="english"}else{lng=iConfig.cfg.language.toLowerCase()}return(lngEng[lng])?{thousand:",",decimal:"."}:{thousand:".",decimal:","}};this.makeNiceNumber=function(val,dec,oNumberSep){if(!oNumberSep){oNumberSep={thousand:",",decimal:"."}}if(dec===undefined){dec=0}val=val.toFixed(dec);val=""+val;val=val.split(".");var ret=val[0];while(rgxThousandSeperator.test(ret)){ret=ret.replace(rgxThousandSeperator,"$1"+oNumberSep.thousand+"$2")}if(dec>0){ret+=oNumberSep.decimal+val[1]}return ret};this.makeNiceFileSize=function(n,oNumberSep){var u="byte";if(n>1024){n/=1024;u="KB"}if(n>1024){n/=1024;u="MB"}if(n>1024){n/=1024;u="GB"}if(n>1024){n/=1024;u="TB"}if(u!=="byte"){n=self.makeNiceNumber(Math.round(100*n)/100,2,oNumberSep)}else{n=self.makeNiceNumber(n,0,oNumberSep)}return n+" "+u};this.getCSSColor=function(val){if(typeof(val)==="string"&&val.length>0){val=$FSI.trim(val);if(val.match(/^[0-9,a-f]{3}$/i)||val.match(/^[0-9,a-f]{6}$/i)){val="#"+val.toUpperCase()}}return val};var getMediaMinScreenWidth=function(nam,unit){var init=topWindow.document.documentElement.clientWidth;if(__LastGetMediaMinScreenWidth===topWindow.document.documentElement.clientWidth){return __LastGetMediaMinScreenWidthResult}__LastGetMediaMinScreenWidth=topWindow.document.documentElement.clientWidth;__getMediaMinScreenWidthCount++;var step=10;var pre="("+nam+":";var suf=unit+")";while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=5;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}init-=step;step=1;while(oMatchMedia.call(window,pre+(init+=step)+suf)["matches"]){__getMediaMinScreenWidthLoopCount++}__LastGetMediaMinScreenWidthResult=__getDocumentScaleReferenceWidth=init-step;return __LastGetMediaMinScreenWidthResult};this.getDocumentScaleMethod=function(){return documentScaleMethod};this.getDocumentScaleNone=function(){return 1};this.getDocumentScaleInit=function(){self.getDocumentScale=self.getDocumentScaleNone;if($FSI.BrowserSupports.visualViewportAPI()){documentScaleMethod="visualViewport API";self.getDocumentScale=function(){return topWindow.visualViewport.scale};return self.getDocumentScale()}if(topWindow.innerWidth===undefined){documentScaleMethod="none";return self.getDocumentScale()}if($FSI.isInternetExplorer&&$FSI.isMobileDevice){documentScaleMethod="window.outerWidth / window.innerWidth windows mobile";self.getDocumentScale=function(){if(screen.width!==topWindow.outerWidth){return(topWindow.outerWidth-192)/topWindow.innerWidth}return(topWindow.outerWidth-83)/topWindow.innerWidth};return self.getDocumentScale()}if(window.orientation!==undefined){if(!window.outerWidth){documentScaleMethod="screen.width / window.innerWidth iOS";self.getDocumentScale=function(){__getDocumentScaleReferenceWidth=(window.orientation%180===0)?screen.width:screen.height;return __getDocumentScaleReferenceWidth/window.innerWidth};return self.getDocumentScale()}documentScaleMethod="window.outerWidth / window.innerWidth";self.getDocumentScale=function(){return window.outerWidth/window.innerWidth};return self.getDocumentScale()}if(oMatchMedia&&topWindow.document.documentElement.clientWidth>0){var w=getMediaMinScreenWidth("min-width","px");if(!isNaN(w)){documentScaleMethod="CSS Media Query";self.getDocumentScale=function(){var res=getMediaMinScreenWidth("min-width","px")/topWindow.innerWidth;if(isNaN(res)){res=1}return res};return self.getDocumentScale()}}documentScaleMethod="fallback";self.getDocumentScale=function(){return topWindow.outerWidth/topWindow.innerWidth};return self.getDocumentScale()};self.getDocumentScale=self.getDocumentScaleInit;self.getDocumentScaleWithPixelRatio=function(){return self.getDocumentScale()*$FSI.getDevicePixelRatio()};self.getImageDimFitInto=function(wSrc,hSrc,wMax,hMax,oCroppedImage,bNoLimitToSourceDim){var ret={};var wSrcOrg=wSrc;var hSrcOrg=hSrc;if(!bNoLimitToSourceDim){wMax=Math.min(wSrc,wMax);hMax=Math.min(hSrc,hMax)}var bCropped=oCroppedImage&&oCroppedImage.isCropped();if(bCropped){oCroppedImage.setSourceDimension(wSrc,hSrc);var rc=oCroppedImage.getPixelRangeRect();wSrc=rc.right;hSrc=rc.bottom}if(wSrc/wMax>hSrc/hMax){ret.width=wMax;ret.height=Math.round(hSrc/wSrc*wMax)}else{ret.height=hMax;ret.width=Math.round(wSrc/hSrc*hMax)}if(bCropped){ret.widthUncropped=Math.round(ret.width*wSrcOrg/wSrc);ret.heightUncropped=Math.round(ret.height*hSrcOrg/hSrc)}else{ret.widthUncropped=ret.width;ret.heightUncropped=ret.height}return ret};self.extendRectToFill=function(rc,srcWidth,srcHeight,targetWidth,targetHeight,bAllowInvalidRect,bAllowMove){var amount;var wCur=rc.width()*srcWidth;var hCur=rc.height()*srcHeight;var dim=self.fitImageIntoSpace(wCur,hCur,targetWidth,targetHeight,true,true);if(dim.width/targetWidth<dim.height/targetHeight){amount=(targetWidth/dim.width-1)*rc.width();rc.left=rc.left-amount/2;rc.right=rc.right+amount/2;if(bAllowMove){if(rc.right>1){rc.offsetRect(-(rc.right-1),0)}else{if(rc.left<0){rc.offsetRect(-rc.left,0)}}}}else{amount=(targetHeight/dim.height-1)*rc.height();rc.top=rc.top-amount/2;rc.bottom=rc.bottom+amount/2;if(bAllowMove){if(rc.bottom>1){rc.offsetRect(0,-(rc.bottom-1))}else{if(rc.top<0){rc.offsetRect(0,-rc.top)}}}}if(!bAllowInvalidRect){rc.limitToImageRect()}};this.fitImageIntoSpace=function(wSrc,hSrc,wTarget,hTarget,bDoNotLimitToSrcDim,bFloats){if(!bDoNotLimitToSrcDim){wTarget=Math.min(wTarget,wSrc);hTarget=Math.min(hTarget,hSrc)}var ret={};if(wTarget/wSrc<hTarget/hSrc){ret.dim="width";if(bDoNotLimitToSrcDim){ret.width=wTarget}else{ret.width=Math.min(wTarget,wSrc)}ret.height=ret.width*hSrc/wSrc}else{ret.dim="height";if(bDoNotLimitToSrcDim){ret.height=Math.min(hTarget,hSrc)}else{ret.height=hTarget}ret.width=ret.height*wSrc/hSrc}if(!bFloats){ret.width=Math.round(ret.width);ret.height=Math.round(ret.height)}return ret};this.getParameterValueFromURL=function(url,nam){var ret=undefined;if(typeof(url)==="string"&&typeof(nam)==="string"&&nam.length>0&&url.length>0){nam=$FSI.escapeRegEx(nam);var reg=new RegExp("(\\?|&)"+nam+"=([^&]*)");var match=url.match(reg);if(match&&match[2]){ret=decodeURIComponent(match[2])}}return ret}};if(!$FSI.utils){$FSI.utils=new $FSI.Utils()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CustomTags!==b){return}a.CustomTags=function(){var g={};var e=false;var f=(a.BrowserSupports.registerElement()||a.BrowserSupports.customElementRegistry());var d=this.initCustomTags=function(){if(f){return false}for(var h in g){if(g.hasOwnProperty(h)){c(h)}}return true};var c=this.initCustomTag=function(l){if(f){return false}var k=g[l];if(!k){return false}var h=document.getElementsByTagName(l);if(h.length>0){k.replaceTagInit()}if(h&&h.length>0){for(var j=0;j<h.length;j++){k.replaceTag(h[j],k)}}return true};this.get=function(h){return g[h]};this.register=function(i,h){if(g[i]===b){g[i]=new a.CustomTag(i,h);if(!e){e=true;if(!f){a.addEvent(window,"DOMContentLoaded",d)}}a.customTags.initCustomTag(i)}return g[i]}};a.CustomTag=function(f,c){var q=this;var h;this.opts=c;var p=function(){a.utils.addViewerClassCSSRule(f,c.viewerCSS);if(a.BrowserSupports.customElementRegistry()){j()}else{if(a.BrowserSupports.registerElement()){l()}}};var e=function(s,t){var r=s.getAttribute(t);if(typeof(r)==="string"&&r.length>0){if(!r.match(/[^0-9\s]/)){r+="px"}s.style[t]=r}};var k=function(r){e(r,"width");e(r,"height")};var i=function(u){var r=a.utils.attributes2parameters(u);if(c.parameterAliases){var v=c.parameterAliases;for(var t in v){if(v.hasOwnProperty(t)){var s=v[t];if(r[t]!==b&&r[s]===b){r[s]=r[t]}}}}if(r.src!==b&&r.imagesrc===b){r.imagesrc=r.src}return r};var j=function(){window.customElements.define(f,n)};var g=this.onCreated=function(){c.constructorClass.prototype.constructor.call(this,this,{autoInit:false})};var o=this.onAttached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}m(this)};var m=function(r){k(r);r.init(r,i(r),b,true);if(typeof(r.start)==="function"){r.start()}};var d=this.onDetached=function(){if(a.FullScreen&&a.FullScreen.bChanging){return}if(typeof(this.destroyOnDetach)==="function"){this.destroyOnDetach()}};var l=function(){var r=Object.create(HTMLDivElement.prototype);r.createdCallback=g;r.attachedCallback=o;r.detachedCallback=d;document.registerElement(f,{prototype:r})};this.replaceTag=function(s,r){if(!s||(typeof(s.getInitDone)==="function"&&s.getInitDone())){return}if(r.opts.bConfigTag!==true){c.constructorClass.prototype.constructor.call(s,s,{autoInit:false});m(s)}else{c.constructorClass.prototype.constructor.call(s);s.init(s,i(s),false,true)}};this.replaceTagInit=function(){if(h){return}h=true;a.utils.addViewerClassCSSRule(f,c.viewerCSS)};var n;if(window.Reflect){n=function(){var r=window.Reflect.construct(HTMLElement,[],this.constructor);g.apply(r);return r};n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=o;n.prototype.disconnectedCallback=d}p()};if(!a.customTags){a.customTags=new a.CustomTags();a.initCustomTags=a.customTags.initCustomTags;a.initCustomTag=a.customTags.initCustomTag}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Debugger!==b){return}a.EmptyDebugger=function(){this.log=this.error=this.warn=this.dir=this.group=this.groupCollapsed=this.groupEnd=this.info=this.setPrefix=this.logCSS=function(){};this.on=false};a.Debugger=function(){var c=this;var f="FSI";this.on=true;var e=a.console;var d=0;var h=function(j,i){if(d<1){i=Array.prototype.slice.call(i);i.unshift(f)}e[j].apply(e,i)};var g=function(i,j){if(typeof(e[i])=="function"){c[i]=function(){h(i,arguments)}}else{c[i]=j}};g("log",a.fnDoNothing);g("logCSS",this.log);g("warn",this.log);g("error",this.log);g("info",this.log);if(typeof(e.dir)=="function"){this.dir=e.dir}else{this.dir=this.log}if(!a.isInternetExplorer&&typeof(e.group)=="function"){this.group=function(i){d++;e.group.call(e,f+i)}}else{this.group=this.log}if(!a.isInternetExplorer&&typeof(e.groupCollapsed)=="function"){this.groupCollapsed=function(i){d++;e.groupCollapsed.call(e,f+i)}}else{this.groupCollapsed=this.group}if(typeof(e.groupEnd)=="function"){this.groupEnd=function(){d--;e.groupEnd.apply(e,arguments)}}else{this.groupEnd=a.fnDoNothing}this.setPrefix=function(i){f=i+"> "}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Config!==b){return}a.Config=function(al,x,f){if(typeof(f)!=="object"){f={}}if(!x||typeof(x)!=="object"){x={}}var n=this;this.parameters=(al&&typeof(al)==="object")?al:{};this.XMLSerializer=(window.XMLSerializer)?new window.XMLSerializer():b;this.plugins={};this.arPlugins=[];this.arUnrecognizedConfigNodes=[];this.arConditions=[];var Z=false;var O={};var B=0;var r;var ad={};var H=n.debug=new a.EmptyDebugger();var D=false;var y={};var aq=false;var T={stickynotes:"bookmarks"};var g;var Y=false;var t;var L;var ag;var c;var m;var v="token";var w;var p;var K={};var aj=/(\\?|&)tpl=/i;var af=/\.json\s*$/i;var d=/\.xml\s*$/i;if(a.isInternetExplorer&&a.versionInternetExplorer<10){p=function(at){var ar;if(!a.utils.isCrossDomain(at)){aq=false;ar=new XMLHttpRequest()}else{aq=true;ar=new XDomainRequest()}return ar}}else{if(typeof(XMLHttpRequest)!=="undefined"){p=function(){return new XMLHttpRequest()}}}this.cfgAliasNames={imagesrc:"fpxsrc",imagesources:"fpxsources",imageheight:"fpxheight",imagewidth:"fpxwidth",imageservertemplate:"fpxservertemplate",profile:"fpxservertemplate",format:"imageformat",renderer:"fpxservertemplate",imagerenderer:"fpxservertemplate",imageinfotemplate:"fpxinfotemplate",imageservertype:"fpxservertype",imagetilepaddingx:"fpxtilepaddingx",imagetilepaddingy:"fpxtilepaddingy",imagetilewidth:"fpxtilewidth",imagetileheight:"fpxtileheight",imagetilesx:"fpxtilesx",imagetilesy:"fpxtilesy",imageserver:"fpxserver",imagepath:"fpxpath",imagetransparency:"fpxtransparency"};this.cfg=this.cfgDefaults={defaultcfg:"_default",fsibase:"config/",fpxservertemplate:"jpeg",listtemplate:"image_list"};this.init=function(av){n.reset();t=(typeof(f.strSection)==="string")?f.strSection:"";L=t.toLowerCase();if(typeof(f.strTraceParam)==="string"){var at=f.strTraceParam.toLowerCase();c={};c[at]=true;if(at.indexOf("_")>0&&at.indexOf("pages")===0){at=at.split("_");at.shift();at=at.join("_");c[at]=true}var au=n.getParameterAlias(at);if(au){c[au]=true}}else{c=false}if(av){if(n.parameters){n.parameters=a.utils.mergeObjects(n.parameters,av)}else{n.parameters=av}}ak(n.parameters);n.getQueryParameters();n.cloneParameters(n.cfgDefaults,n.cfg);n.cloneParameters(n.queryParameters,n.cfg);delete n.cfg.effects;n.elevateToHTTPS();e();n.locationFSIViewer="";if(n.queryParameters.fsiviewerlocation!==b){n.locationFSIViewer=n.queryParameters.fsiviewerlocation}else{H.log("FSI Viewer location guessed based on script location: "+a.getViewerLocation());n.locationFSIViewer=(a.getViewerLocation()||"")}if(n.locationFSIViewer.charAt(n.locationFSIViewer.length-1)!=="/"){n.locationFSIViewer+="/"}var ar=n.cfg.defaultcfg;if(typeof(ar)==="string"&&ar.length>0){n.nextConfigURL=n.getReloadPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.defaultcfg))}else{n.nextConfigURL=b}n.checkDebug(false)};var ak=this.makeObjectPropertiesLowerCase=function(ar){for(var at in ar){if(ar.hasOwnProperty(at)){var au=at.toLowerCase();if(at!==au){if(ar[au]===b){ar[au]=ar[at]}delete ar[at]}}}};this.getClassParameters=function(){return ag};this.setAccessToken=function(ar){w=ar};this.getParameterAlias=function(au){var ar;if(n.cfgAliasNames[au]){ar=n.cfgAliasNames[au]}else{for(var at in n.cfgAliasNames){if(n.cfgAliasNames.hasOwnProperty(at)){if(n.cfgAliasNames[at]===au){ar=at;break}}}}return ar};var e=function(){Z=n.makeBool(n.cfg.usenc,false);if(n.cfg.usencquery!==b&&n.cfg.usencquery.length>0){D=n.cfg.usencquery;Z=true;n.queryToObject("?"+D,y)}};this.stopPendingRequests=function(){for(var at in O){if(O.hasOwnProperty(at)){var ar=O[at];if(ar){ar.FSIaborted=true;if(ar.abort){ar.abort()}}}}};this.destroy=function(){n.stopPendingRequests()};this.reset=function(){K={};ag={};n.parameters={};H=n.debug=new a.EmptyDebugger();n.stopPendingRequests();r=Math.random();n.nIncludedConfigs=0;n.completedConfigs={};n.plugins={};n.cfg={};n.queryParameters=b;n.arUnrecognizedConfigNodes=[];am=0;n.arConditions=[];ad={}};this.getQueryParameters=function(){if(n.queryParameters!==b){return}n.queryParameters={};n.cloneParameters(n.parameters,n.queryParameters)};this.makeBool=function(av,ar){if(typeof(ar)!=="boolean"){ar=false}var at=ar;switch(typeof(av)){case"string":var au=a.makeBool(av);if(au!==b){at=au}break;case"number":at=Boolean(av);break;case"boolean":at=av;break}return at};this.parsePositionParameter=function(at){if(typeof(at)!=="string"||at.length<3){return b}at=at.split(",");if(at.length<3){return b}for(var ar=0;ar<3;ar++){at[ar]=parseFloat(at[ar]);if(isNaN(at[ar])){at[ar]=0}}return{x:at[0],y:at[1],z:at[2]}};this.logLoadFileFailed=function(ar){if(!H.on){return}if(ar&&ar.status!==b){var au="HTTP "+ar.status;if(ar&&ar.statusText){au+=", "+ar.statusText}var at=(ar._url)?ar._url:"";H.error("Failed to load "+at+" ("+au+")")}else{H.error("Failed loading a file");if(ar&&ar._url){H.error(ar._url)}}};this.getAttributeValue=function(at,ar){if(!at){return}return at.getAttribute(ar)};this.getImageDownloadOriginalURL=function(at){var ar=n.serverBase.replace(/\/server$/,"");return ar+"/service/file/"+at};this.getImageURL=function(au,ar){var at;if(au===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="image"}if(w){ar[v]=w}ar.source=au;for(at in ad){if(ad.hasOwnProperty(at)){if(ad[at]!==b&&ar[at]===b){ar[at]=ad[at]}}}for(at in ab){if(ar[at]){if(ab[at]!==at){if(!ar[ab[at]]){ar[ab[at]]=ar[at]}ar[at]=null}}}if(ar.renderer===b){ar.renderer="jpeg"}return n.requestBase+"?"+n.objectToQuery(ar)};this.getRectFromInitialView=function(au){var at=n.viewStringToArray(au);return new a.Rect(at[2],at[3],at[4],at[5])};this.getImageRectParamFromRect=function(ar){var at=ar.duplicateRect();at.right=at.width();at.bottom=at.height();return at.toString()};this.getImageURLAsInViewer=function(ax,aA,aF,av,aw,aG,ar,az){az=az||{};var aH={};if(!ar||typeof(ar)!=="object"){ar={}}if(typeof(aG)!=="string"){aG=n.cfg.initialview}var aC,aE;var aB={width:aA,height:aF};var aD={width:aA,height:aF};if(aG){aE=n.getRectFromInitialView(aG)}if(az.bDoNotModifyQuery!==true){delete ar.width;delete ar.height;delete ar.rect}var au=new a.CroppedImage();au.setSourceDimension(aA,aF);au.setCropFromConfig(n.cfg);if(az.cropToFill){au=au.getCropToFill(av,aw,az.cropToFill,true)}var ay;aH.iCrop=au;if(au.isCropped()){ay=aC=au.getFloatRect();aH.rcSource=au.getImageRect()}else{aH.rcSource=new a.Rect(0,0,aA,aF)}if(aE&&!aE.isDefaultImageRect()&&az.expandViewStringToFit!==false){var aI,aJ;if(ay){aI=ay.width();aJ=ay.height()}else{aI=aJ=1}a.utils.extendRectToFill(aE,aI*aA,aJ*aF,av,aw,false,true)}if(ay){if(aE){aC=aC.getPartialRect(aE)}}else{aC=aE}if(aC&&!aC.isDefaultImageRect()){aD.width=aA*aC.width();aD.height=aF*aC.height();aB.width=Math.round(aD.width);aB.height=Math.round(aD.height);if(ar.rect===b){ar.rect=n.getImageRectParamFromRect(aC)}}aH.rc=aC;var at=a.utils.fitImageIntoSpace(aD.width,aD.height,av,aw);if(ar.width===b&&ar.height===b){ar[at.dim]=at[at.dim]}aH.dimFit=at;aH.srcArea=aB;aH.srcAreaFloat=aD;aH.url=n.getImageURL(ax,ar);return aH};this.getImageInfoURL=function(at,ar){if(at===b){return""}if(ar===b){ar={}}if(ar.type===b){ar.type="info"}if(ar.tpl===b){if(n.cfg.fpxinfotemplate!==b){ar.tpl=n.cfg.fpxinfotemplate}else{ar.tpl="info.json"}}if(n.cfg.headers&&n.cfg.headers.length>0){ar.headers=n.cfg.headers}if(!ar.tpl.match(/.json$/)){ar.tpl+=".json"}ar.source=at;if(w){ar[v]=w}return n.requestBase+"?"+n.objectToQuery(ar)};this.queryToObject=function(aw,au){if(au===b){au={}}var av,ay,ax,ar,at;av=aw.indexOf("?");if(av!==-1){at=aw.slice(av+1)}else{at=""}av=at.indexOf("#");if(av!==-1){at=at.substring(0,av)}at=at.split("&");for(av=0;av<at.length;av++){ay=at[av].split("=");ax=a.utils.urlDecode(ay[0]).toLowerCase();if(ax.length>0){ar=a.utils.urlDecode(ay[1]);au[ax]=ar}}return au};this.parseSceneSets=function(ar,aw){var aD={};if(aw===b){aw=true}var aI=[];var aG=0;var aE=0;var au;var ay,ax,av,aC,aA,aH;var az,aB,aF;var at=n.cfg.scenesets;if(ar>1&&at!==b&&typeof(at)==="string"){aB=at.split(";");for(ay=0;ay<aB.length;ay++){aF=[];az=aB[ay].split(",");aE=0;for(ax=0;ax<az.length;ax++){aH=az[ax].split("-");aC=aA=0;if(aH.length===1){aC=parseInt(aH[0])}else{aC=parseInt(aH[0]);if(isNaN(aC)){aC=1}au=false;if(aH[1].charAt(0)===">"){aH[1]=aH[1].substr(1);if(!isNaN(parseInt(aH[1]))){au=true}}aA=parseInt(aH[1]);if(isNaN(aA)){aA=ar}if(aC>0&&aA>0&&aC<=ar&&aA<=ar){if(au===true||aC!==aA){if(au!==true){if(aA<aC){for(av=aC;av>=aA;av--){aF[aE]=av;aE++}}else{for(av=aC;av<=aA;av++){aF[aE]=av;aE++}}}else{for(av=aC;av<=ar;av++){aF[aE]=av;aE++}for(av=1;av<=aA;av++){aF[aE]=av;aE++}}}}}if(aC>0&&aC<=ar&&(aA===0||aA===aC)){aF[aE]=aC;aE++}}if(aE>0){aI[aG]={};aI[aG].arScenes=[];aI[aG].arScenes=aI[aG].arScenes.concat(aF);aG++}}}if(aG===0){aD.bDefault=true;if(aw){aI[0]={};aI[0].arScenes=[];for(ay=0;ay<ar;ay++){aI[0][ay]=ay}}}aD.nSceneSets=aG;aD.bHasMultipleSets=(aD.nSceneSets>1);aD.arSets=aI;aD.nCurrent=1;return aD};this.objectToQuery=function(au){var at=[];var aw,av;if(Z&&D!==false){for(aw in y){if(y.hasOwnProperty(aw)){au[aw]=y[aw]}}}for(aw in au){if(au.hasOwnProperty(aw)){av=au[aw];if(av!==null&&av!==b){av=encodeURIComponent(av);at.push(encodeURIComponent(aw)+"="+av)}}}return at.join("&")};this.loadImageInfo=function(av,ar,au){var at=n.getImageInfoURL(av);n.loadFile(at,ar,b,au)};this.loadFile=function(aw,av,au,aA,az,at,ax){if(!aw||aw.length<0){if(av){setTimeout(function(){av(null,"",aA)},0)}return}if(az===b){az="GET"}if(at===b){at=null}else{if(typeof(at)==="object"){at=n.objectToQuery(at)}}if(au===b){au="application/json"}var ay=p(aw);if(au&&ay.overrideMimeType){ay.overrideMimeType(au)}ay._url=aw;var ar=B;O[B]=ay;B++;if(aq){ay.onerror=function(){delete O[ar];if(av===b||this.FSIaborted){return}n.logLoadFileFailed(this)};ay.onload=function(){delete O[ar];if(av===b||this.FSIaborted){return}var aB=this.responseText;switch(this.contentType){case"application/xml":case"text/xml":try{var aC=new ActiveXObject("Microsoft.XMLDOM");aC.async=false;aC.loadXML(aB);aB=this.responseXML=aC}catch(aD){H.log("Failed parsing XML using Microsoft.XMLDOM");H.log(aw)}break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aD){H.error("Failed parsing JSON from URL: "+aw+" ("+aD.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}else{ay.onreadystatechange=function(){var aB;if(ay.readyState!==4){return}delete O[ar];if(this.FSIaborted||typeof(av)!=="function"){return}if(this.status>299){n.logLoadFileFailed(this)}switch(au){case"application/xml":case"text/xml":aB=this.responseXML;break;case"application/json":aB={};try{aB=JSON.parse(this.responseText)}catch(aC){H.error("Failed parsing JSON from URL: "+aw+" ("+aC.message+")")}break;default:aB=this.responseText}av(this,aB,aA)}}ay.open(az,aw,true);if(ax&&w){ay.setRequestHeader("data-token",w)}if(at){ay.setRequestHeader("Content-type","application/x-www-form-urlencoded");ay.send(at)}else{ay.send()}return ay};this.loadConfigs=function(){ag=(t.length>0)?{}:false;g=true;n.loadNextConfig(true)};this.loadNextConfig=function(at){if(n.nextConfigURL===b){X();return}var au={};if(f.bPreventCaching||n.makeBool(n.cfg.debug)||(!at&&!n.makeBool(n.cfg.configcaching,true)&&n.makeBool(n.cfg.enableconfigcachingparameter))){n.addNoCacheParams(au)}n.finishRequestParams(au);var ar=n.addURLParameters(n.nextConfigURL,au);H.log("Loading config file: "+ar);n.loadFile(ar,E,"application/xml")};this.setDebugger=function(ar){H=n.debug=ar};this.checkDebug=function(au){if(f.bNoDebug){return}var at;var ar;if(n.parameters.debug!==b){ar=n.makeBool(n.parameters.debug)}else{ar=n.makeBool(n.cfg.debug)}if(ar){if(!H||!H.on){H=n.debug=new a.Debugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}else{if(!H||H.on===true){H=n.debug=new a.EmptyDebugger();if(x.onDebuggerChange){at=x.onDebuggerChange(H,au)}}}return at};var E=function(ar){var au=ar.responseXML;m=n.nextConfigURL;n.parseConfig(au);m=b;n.elevateToHTTPS();if(n.checkDebug(true)===true){return}e();if(g&&f.bCaptureDefaultCfg){g=false;n.cfgFromDefaultConfig=a.utils.cloneValue(n.cfg)}var at;if(n.cfg.includeconfig!==b&&n.nIncludedConfigs<10){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.includeconfig));n.nIncludedConfigs++;n.cfg["_includeconfig("+n.nIncludedConfigs+")"]=n.cfg.includeconfig;n.cfg.includeconfig=b}else{if(n.cfg.cfg!==b){at=n.getFSIPath(n.locationFSIViewer,n.expandFSIPath(n.cfg.cfg))}}if(at!==b&&!n.completedConfigs[at]){n.completedConfigs[at]=true;n.nextConfigURL=at;n.loadNextConfig()}else{n.evaluateQuery(n.queryParameters,n.cfg);X()}};this.evaluateXML=function(ar){m="XML Object";n.parseConfig(ar);m=b;n.elevateToHTTPS();e();n.evaluateQuery(n.queryParameters,n.cfg);X()};this.elevateToHTTPS=function(){if(!a.utils.isHTTPS()){return}if(!n.makeBool(n.cfg.autoelevatetohttps,true)){return}i("fpxbase");i("fpxserver")};var i=function(ar){if(n.cfg[ar]!==b&&n.cfg[ar].length>0&&n.cfg[ar].indexOf("http://")===0){n.cfg[ar]="https"+n.cfg[ar].substr(4)}};this.evaluateQuery=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){n.setConfigParamByValue(ar,au.toLowerCase(),at[au])}}};this.parseConfig=function(at,au){var aD="";var ax;var az=false;if(at&&typeof(at)==="object"){if(au===b){au=at.firstChild}if(au&&au.nodeName==="xml"){au=au.nextSibling}var aC=au.childNodes;for(var ay=0;ay<aC.length;ay++){var aw=aC[ay];if(aw.nodeType!==1){continue}var aA;if(aw._myTagName!==b){aA=aw._myTagName}else{aA=aw.nodeName.toLowerCase()}aD=aA;var av=aw.childNodes;az=false;switch(aA){case"licence":break;case"if":n.arConditions.push(aw);break;case"plugins":for(ax=0;ax<av.length;ax++){n.parsePluginNode(av[ax])}break;case L:az=true;case"info":case"options":aD=b;case"fpx":case"image":case"video":case"virtualspace":case"camera":case"include":for(ax=0;ax<av.length;ax++){var aB=av[ax];if(aB.nodeType!==1){continue}if(aB.tagName==="if"){aB._myTagName=aA;n.arConditions.push(aB)}else{var ar=n.getValueFromXMLNode(aB,aD);if(aD===b&&ag){if(az){n.setConfigParam(ag,ar,null,true);n.setConfigParam(n.cfg,ar,aB)}else{if(ag[ar.name]===b){n.setConfigParam(n.cfg,ar,aB)}}}else{n.setConfigParam(n.cfg,ar,aB)}}}break;default:n.arUnrecognizedConfigNodes.push(aw)}}}};this.getData=function(){var ar={};ar.cfg={};for(var at in n.cfg){if(n.cfg.hasOwnProperty(at)){ar.cfg[at]=n.cfg[at]}}return ar};this.setData=function(ar){if(!ar||!ar.cfg){return}n.cfg={};this.setCfgValues(ar.cfg)};this.setCfgValues=function(at){for(var au in at){if(at.hasOwnProperty(au)){var ar=au.toLowerCase();if(n.cfgAliasNames[ar]){ar=n.cfgAliasNames[ar]}if(K.nItems){if(K.bPositive){if(!K.params[ar]){continue}}else{if(K.params[ar]){continue}}}n.cfg[ar]=at[au]}}W()};this.getImagesNodeList=function(au){var ar=[];if(au===b){au=n.getUnrecognizedConfigNode("images")}if(au){var av=au.firstChild;while(av){if(av.nodeType===1){var at={};at.attributes={};N(av,at.attributes);at.cfg={};n.parseConfigFragment(av,at.cfg);ar.push(at)}av=av.nextSibling}}return ar};this.removeUnrecognizedConfigNodes=function(){n.arUnrecognizedConfigNodes=[]};this.setUnrecognizedConfigNode=function(aw,au){var ar;aw=aw.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var av=n.arUnrecognizedConfigNodes[at];if(av&&av.nodeName.toLowerCase()===aw){ar=av;break}}if(!ar){if(au!==null){n.arUnrecognizedConfigNodes.push(au)}}else{if(au===null){n.arUnrecognizedConfigNodes.slice(at,1)}else{n.arUnrecognizedConfigNodes[at]=au}}return ar};this.getUnrecognizedConfigNode=function(av){var ar;av=av.toLowerCase();for(var at=n.arUnrecognizedConfigNodes.length-1;at>-1;at--){var au=n.arUnrecognizedConfigNodes[at];if(au&&au.nodeName.toLowerCase()===av){ar=au;break}}return ar};this.parseConfigFragment=function(at,az,ay){var aD="";if(at&&typeof(at)==="object"&&az!==b){if(ay===b){ay=[]}var aC=at.childNodes;for(var ax=0;ax<aC.length;ax++){var av=aC[ax];if(av.nodeType!==1){continue}var aA=av.nodeName.toLowerCase();aD=aA;var au=av.childNodes;switch(aA){case"info":case"options":aD=b;case"fpx":case"image":case"include":for(var aw=0;aw<au.length;aw++){var aB=au[aw];if(aB.nodeType!==1){continue}var ar=n.getValueFromXMLNode(aB,aD);n.setConfigParam(az,ar,aB)}break;default:ay.push(av)}}}};this.findXMLNode=function(at,ar){if(at===b||at.nodeType===b){return b}while(at){if(at.nodeName.toLowerCase()===ar){break}if(at.firstChild){at=at.firstChild}else{if(at.nextSibling){at=at.nextSibling}else{at=at.parentNode.nextSibling}}}return at};this.getValueFromXMLNode=function(au,ar){if(!au||au.nodeType!==1){return}var at={};var av=(ar)?ar:"";at.name=av+au.nodeName.toLowerCase();var aw=au.getAttribute("value");if(aw){at.value=aw;return at}at.value=n.XMLChildNodesToString(au);at.node=au;return at};this.getXMLNodeAttribute=function(av,au,ar){if(!av||av.nodeType!==1||!av.getAttribute){return ar}var at=av.getAttribute(au);if(at===b||at==null){at=ar}return at};this.XMLChildNodesToString=function(au,at){var ar="";if(!au||!au.firstChild){return ar}if(au.childNodes.length===1&&au.firstChild.nodeType===3){ar=au.firstChild.nodeValue}else{ar=au.innerHTML}if(at!==b){ar=ar.replace(/[\x00-\x1f]/g,at)}return ar};this.hasPlugin=function(ar){return(n.plugins&&n.plugins[ar]!==b)};this.getPluginParameter=function(ay,at,ar,ax,az){ay=ay.toLowerCase();at=at.toLowerCase();if(n.plugins[ay]===b){H.error("CANNOT GET PLUGIN PARAMETER, because plugin is not defined: "+ay+"."+at);return ar}var aw;var av=ay+"_"+at;if(az&&n.cfg[av]===b){av=at}if(n.cfg[av]!==b){aw=n.cfg[av]}else{if(ag&&ag[at]!==b&&L==="pages"){aw=ag[at]}else{var au=n.plugins[ay].parameters;if(au!==b&&au[at]!==b){aw=au[at]}}}if(aw===b){aw=ar}if(ax){aw=n.makeBool(aw,ar)}return aw};var R=this.getAllPluginParameters=function(at){at=at.toLowerCase();var au=a.utils.cloneObject(n.plugins[at].parameters);var aw=at+"_";var ar=aw.length;for(var ax in n.cfg){if(n.cfg.hasOwnProperty(ax)){if(ax.toLowerCase().indexOf(aw)===0){var av=ax.substr(ar);au[av]=n.cfg[ax]}}}return au};this.getIntParameterMinMax=function(at,au,ar,av){return Math.min(av,Math.max(ar,n.getIntParameter(at,au)))};this.getIntParameter=function(at,au){var ar=parseInt(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};this.getStringParameter=function(at,au){var ar=n.cfg[at.toLowerCase()];if(ar===b){ar=au}return ar};this.getFloatParameter=function(at,au){var ar=parseFloat(n.cfg[at.toLowerCase()]);if(isNaN(ar)){ar=au}return ar};var N=function(ax,at){if(!ax||!ax.attributes||!ax.attributes.length||!at){return false}var au=ax.attributes;for(var aw=0;aw<au.length;aw++){var ar=au[aw];var av=ar.nodeName.toLowerCase();at[av]=ar.value}return true};this.parsePluginNode=function(au){if(au.nodeType!==1){return}var aw={};N(au,aw);var av=au.childNodes;for(var ar=0;ar<av.length;ar++){var ax=av[ar];if(ax.nodeType!==1){continue}var at=n.getValueFromXMLNode(ax);if(at.value!==b){aw[at.name]=at.value;if(at.node!==b){aw[at.name+".node"]=at.node}}}this.addPluginFromString(aw.src,aw)};this.clone=function(){var ar=new a.Config(al,x,f);ar.init();ar.setParameterFilter(K);ar.serverBase=n.serverBase;ar.requestBase=n.requestBase;ar.cfg=a.utils.cloneObject(n.cfg);ar.plugins=a.utils.cloneObject(n.plugins);ar.arPlugins=a.utils.cloneArray(ar.arPlugins);ar.arUnrecognizedConfigNodes=a.utils.cloneArray(n.arUnrecognizedConfigNodes);ar.arUnrecognizedConfigNodesWithoutDefault=a.utils.cloneArray(n.arUnrecognizedConfigNodesWithoutDefault);ar.setImageQueryParameters(ad);ar.arConditions=a.utils.cloneArray(n.arConditions);ar.hasImageParameterConditions=n.hasImageParameterConditions;return ar};this.setImageQueryParameters=function(ar){ad=a.utils.cloneObject(ar)};this.getImageQueryParameters=function(){return a.utils.cloneObject(ad)};this.addPluginsFromString=function(au){if(typeof(au)!=="string"||au.length<1){return}var ar=au.split(",");for(var at=0;at<ar.length;at++){var av=a.trim(ar[at]);n.addPluginFromString(av)}};this.addPluginFromString=function(av,aw){if(typeof(av)!=="string"||av.length<1){H.error("PLUGIN without src parameter:");return}av=av.toLowerCase();if(T[av]!==b){av=T[av]}if(aw===b){aw={}}var at=n.plugins[av]={};at.name=av;if(aw.src===b){aw.src=av}at.parameters=aw;if(c){for(var ax in c){if(c.hasOwnProperty(ax)){if(ax.indexOf(av+"_")===0){var au=av+"_";var ar=ax.substr(au.length);if(typeof(at.parameters[ar])!=="undefined"){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log(at.parameters[ar]);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}else{if(ax===av){n.iTraceParameterDebug.group(m);n.iTraceParameterDebug.log('<Plugin src="'+av+'">');n.iTraceParameterDebug.log("(enabled)");n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}}};this.setConfigParamByValue=function(at,au,ar){n.setConfigParam(at,{name:au.toLowerCase(),value:ar})};var V=function(at){if(at.nodeType!==1){return"<unknown>"}var ar=n.XMLSerializer.serializeToString(at.cloneNode(false));ar=ar.replace(/\/>$/gi,">");return ar};this.setParameterFilter=function(at,ar){if(at===b){if(K.nItems){K={}}return}if(typeof(at)==="string"){K=n.getParameterFilterFromString(at,ar)}else{if(typeof(at)==="object"){K=a.utils.cloneObject(at)}}};this.getParameterFilterFromString=function(ay,at){var av={bPositive:at,nItems:0,params:{}};var az=av.params;var au=ay.split(",");for(var ax=0;ax<au.length;ax++){var aw=a.trim(au[ax]).toLowerCase();if(aw.length>0){az[aw]=true;av.nItems++}}return av};this.getParameterFilter=function(){return a.utils.cloneObject(K)};this.setConfigParam=function(av,ar,aw,ax){var az=ar.name;var aB=ar.value;if(!az){return}if(c){for(var aA in c){if(aA===az&&!ax){if(typeof(aw)==="object"&&typeof(aw.tagName)==="string"){var ay;if(m){ay=m}var au=aw.parentNode;var at=[];while(au){if(au.tagName==="if"){ay="Matched Condition"}at.unshift(V(au));au=au.parentNode}at.shift();at.shift();n.iTraceParameterDebug.group(ay);n.iTraceParameterDebug.log(at.join(" "));n.iTraceParameterDebug.log(aw);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}else{n.iTraceParameterDebug.group("By Parameter/Attribute:");n.iTraceParameterDebug.log(aB);n.iTraceParameterDebug.log("");n.iTraceParameterDebug.groupEnd()}}}}if(n.cfgAliasNames[az]!==b){az=n.cfgAliasNames[az]}if(K.nItems){if(K.bPositive){if(!K.params[az]){return}}else{if(K.params[az]){return}}}if(av[az]!==b&&(typeof(aB)==="string"&&a.utils.getBoolTable(aB.toLowerCase())===false)&&a.utils.getBoolTable(av[az])===b){delete av[az]}else{switch(az){case"effects":case"righteffects":case"lefteffects":case"tileeffects":case"sceneeffects":case"naveffects":case"thumbeffects":aB=a.trim(aB);n.appendImageEffect(av,az,aB);break;case"plugins":n.addPluginsFromString(aB);break;case"fpxpath":av[az]=aB;av.fpxsrc=encodeURIComponent(aB);break;default:av[az]=aB;if(ar.node!==b){av[az+".node"]=ar.node}}}};this.appendImageEffect=function(au,at,ar){if(typeof(ar)!=="string"){return}if(ar.match(/^ClearEffects\(\)*/i)){ar=ar.replace(/^ClearEffects\(\)\s*[,]?\s*/i,"");au[at]=b}if(ar.length>0){if(au[at]!==b&&au[at].length>0){au[at]+=","+ar;au[at]=au[at].replace(/,,/g,",")}else{au[at]=ar}}};var l={};l["="]=function(at,ar){return(at.toLowerCase()===ar.toLowerCase())};l["=="]=function(at,ar){return(at===ar)};l["!="]=function(at,ar){return(at.toLowerCase()!==ar.toLowerCase())};l["!=="]=function(at,ar){return(at!==ar)};l["<"]=function(at,ar){return(at<ar)};l["<="]=function(at,ar){return(at<=ar)};l[">"]=function(at,ar){return(at>ar)};l[">="]=function(at,ar){return(at>=ar)};l.match=function(at,ar){var au=false;var aw="g";if(ar.charAt(0)==="/"&&ar.lastIndexOf("/")>0){var av=ar.split("/");av.shift();aw=av.pop();ar=av.join("/")}try{var ax=new RegExp(ar,aw);au=(at.match(ax)!==null)}catch(ay){H.error("Invalid regex in condition: "+ar)}return au};l.notmatch=function(at,ar){return !l.match(at,ar)};var s={lessthan:"<",lt:"<",lessthanequal:"<=",lte:"<=",greaterthan:">",gt:">",greaterthanequal:">=",gte:">=",eq:"=",not:"!="};var u=function(at,au){if(n.cfgAliasNames[au]){au=n.cfgAliasNames[au]}var ar=n.cfg[au];if(ar===b){ar=""}if(!n.hasImageParameterConditions){n.hasImageParameterConditions=(ab[au]!==b)}return G(at,au,ar)};var M=function(av,aw){var ar=false;var au;var at=av.getAttribute("value");switch(aw){case"@mobile":at=n.makeBool(at,true);au=a.isMobileDevice;break;case"@devicepixelratio":au=a.getDevicePixelRatio();break;case"@navigatoruseragent":au=navigator.userAgent;break;case"@navigatorlanguage":au=navigator.language;break;case"@navigatorplatform":au=navigator.platform;break}if(au!==b){if(typeof(at)!=="string"){at=""+at}if(typeof(au)!=="string"){au=""+au}ar=G(av,aw,au,at)}return ar};var G=function(av,au,ax,aw){var az;var at=av.getAttribute("operator");if(typeof(at)!=="string"){at="="}at=at.toLowerCase();if(s[at]){at=s[at]}if(l[at]===b){at="="}if(aw===b){aw=av.getAttribute("value")}if(aw===null){aw=""}var ar=l[at];if(at.match(/[<,>]+/)){var aA=function(aB){aB=parseFloat(aB);if(isNaN(aB)){az=false}return aB};ax=aA(ax);aw=aA(aw)}else{ax=decodeURIComponent(ax)}if(az===b){az=ar(ax,aw)}if(H.on){H.log("Evaluating condition: "+au+": "+ax+" "+at+" "+aw+" => "+az)}if(az===true){if(av._myTagName!==b){var ay={};ay.nodeType=1;ay.tagName=av._myTagName;ay.childNodes=[av];av=ay}n.parseConfig(av,av)}return az};var ab={fpxsrc:"source",headers:"headers",croprect:"rect",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",referencewidth:"referencewidth",referenceheight:"referenceheight",pixelrange:"pixelrange",imagedpi:"dpi"};var ac={headers:"headers",fpxservertemplate:"renderer",quality:"quality",effects:"effects",imageformat:"format",imagecolorspace:"colorspace",imageencoding:"encoding",imagemaxcolors:"maxcolors",imagebackgroundcolor:"backgroundcolor",imageditherer:"ditherer",imagequantizer:"quantizer",imagedpi:"dpi",overlays:"overlays"};var aa;var U=function(){if(aa===b){aa={};for(var ar in ab){aa[ab[ar]]=ar}}return aa};var q=function(aw,av,au){if(au===b){au=""}var ay=au+"left";if(aw[ay]===b){return}var ax=au+"top";var at=au+"right";var ar=au+"bottom";if(av==="pixelrange"){aw[at]=aw[at]-aw[ay];aw[ar]=aw[ar]-aw[ax]}aw[av]=aw[ay]+","+aw[ax]+","+aw[at]+","+aw[ar];if(aw[ay]){delete aw[ay]}if(aw[ax]){delete aw[ax]}if(aw[at]){delete aw[at]}if(aw[ar]){delete aw[ar]}};var ao=this.mapImageParametersToViewer=function(ar){q(ar,"rect");q(ar,"pixelrange","pixel");U();ai(ar,U())};var an=this.mapImageParametersToServer=function(ar){ai(ar,ab)};var ai=function(at,ar){for(var au in at){if(at.hasOwnProperty(au)){if(ar[au]&&au!==ar[au]){at[ar[au]]=at[au];delete at[au]}}}};this.reWriteImageURLByConditions=function(ay){if(n.arConditions.length<1){return ay}if(typeof(ay)!=="string"||ay.length<1){return ay}var au=ay.indexOf("?");if(au===-1){return ay}var at=n.clone();var aw={};n.parseQuery(ay,aw);ao(aw);n.evaluateQuery(aw,at.cfg);var ar=at.evaluateConditions();if(!ar){return ay}var ax;for(ax in aw){if(aw.hasOwnProperty(ax)){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}}for(ax in ac){if(at.cfg[ax]!==b){aw[ax]=decodeURIComponent(at.cfg[ax])}}an(aw);var av=ay.substr(0,au);return av+"?"+n.objectToQuery(aw)};var o=this.applyConditions=function(){if(n.arConditions.length<1){return}if(n.cfgBeforeConditions===b){n.cfgBeforeConditions=a.utils.cloneObject(n.cfg)}n.cfg=n.cfgBeforeConditions;return h()};var am=0;var h=this.evaluateConditions=function(){if(n.arConditions.length<1){return false}var at=false;for(var au=am;au<n.arConditions.length;au++){var av=n.arConditions[au];if(av.fsiConfigEvaluated){continue}am++;var aw=av.getAttribute("parameter");if(typeof(aw)==="string"){aw=aw.toLowerCase();var ar;if(aw.charAt(0)==="@"){ar=M(av,aw)}else{ar=u(av,aw)}if(!at&&ar){at=ar}}}return at};var W=function(){o();n.serverProfile=n.cfg.fpxservertemplate;n.serverProfileDoublePage=n.cfg.fpxservertemplatedoublepage;if(n.serverProfileDoublePage===b){n.serverProfileDoublePage="doublepage"}n.serverBase=n.cfg.fpxserver;if(n.serverBase===b){H.warn("PLEASE NOTE: Parameter 'imageserver' undefined, deriving server location from viewer location ("+n.locationFSIViewer+")");var at;at=n.locationFSIViewer.indexOf("/users/");if(at!==-1){n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}else{at=n.locationFSIViewer.indexOf("/viewer/");n.serverBase=n.locationFSIViewer.substring(0,at)+"/server"}H.log("Derived server location is: ["+n.serverBase+"]")}n.requestBase=n.serverBase;ad={};var ar=n.cfg;for(var au in ac){if(ar[au]!==b){ad[au]=ar[au]}}if(ad.fpxsrc!==b){ad.fpxsrc=decodeURIComponent(ad.fpxsrc)}ar=n.cfg.effects;if(ar!==b){n.cfg.effectsUnFiltered=ar;n.cfg.effects=ar=k(ar)}if(ar!==b){ad.effects=ar}ar=n.cfg.lefteffects;if(ar!==b){ad.lefteffects=ar}ar=n.cfg.righteffects;if(ar!==b){ad.righteffects=ar}};this.getAreaEffects=function(){return"BLUR,DISTORT,EMBOSS,FLIP,GLOW,GRADIENTMAP,LINEARGRADIENT,PAD,PIXELIZE,SHARPEN"};this.setEffectsFilterArea=function(){n.setEffectsFilter(n.getAreaEffects())};this.setEffectsFilter=function(aw){if(typeof(aw)!=="string"||aw.length<1){Y=false;return}aw=a.trim(aw);var au=aw.split(",");for(var av=0;av<au.length;av++){au[av]=a.escapeRegEx(au[av])}var at="(^|[=,]+)("+au.join("|")+")\\([^)]*\\)";Y=new RegExp(at,"ig")};var k=this.removeFilteredEffects=function(ar){if(Y===false||typeof(ar)!=="string"){return ar}ar=ar.replace(Y,"");ar=ar.replace(/^[,\s]*/g,"");ar=a.trim(ar);return ar};var j=function(){for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){var au=at.toLowerCase();var ar=n.makeBool(n.cfg[au],true);if(!ar){n.plugins[at]=b}}}};var X=function(){n.elevateToHTTPS();j();W();n.dumpConfig();if(x.onConfigsReady){x.onConfigsReady()}};this.dumpConfig=function(au){if(!au){au=H}if(au.on){if(n.cfg.fpxsrc!==b){n.cfg["fpxsrc (decoded)"]=decodeURIComponent(n.cfg.fpxsrc)}au.info("Evaluated Configuration:",Q(n.cfg));if(n.queryParameters){au.info("Parameters:",Q(n.queryParameters))}if(ag){au.info("Class <"+t+"> Configuration:",Q(ag))}var at=n.getPluginsAndParameters();var ar=at.data;if(at.count===0){ar="No active plugins."}au.info("Plugin Configuration:",Q(ar))}};var Q=function(au){var ar="--- none ---";if(typeof(au)!=="object"){return ar}for(var at in au){if(au.hasOwnProperty(at)){ar=au;break}}return ar};this.getPluginsAndParameters=function(){var ar={};var au=0;for(var at in n.plugins){if(n.plugins.hasOwnProperty(at)){if(n.hasPlugin(at)){ar[at]=R(at);au++}}}return{count:au,data:ar}};var J=this.addQueryParameterToURL=function(av,ar,au){var at=av.lastIndexOf("?");if(at===-1){av+="?"}else{if(at!==av.length-1){av+="&"}}return av+encodeURIComponent(ar)+"="+encodeURIComponent(au)};var ap=n.finishURL=function(ar){if(w){ar=J(ar,v,w)}if(!Z||ar===b){return ar}var at;if(D===false){at="cache=0&cachernd="+r;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+="&"+at}}else{at=D;if(ar.indexOf("?")===-1){ar+="?"+at}else{ar+=at}}return ar};this.addURLParameters=function(au,av){if(!au||!av){return au}var at=[];for(var aw in av){if(av.hasOwnProperty(aw)){at.push(encodeURIComponent(aw)+"="+encodeURIComponent(av[aw]))}}if(at.length>0){if(au.indexOf("?")===-1){au+="?"}else{au+="&"}au+=at.join("&")}return au};this.finishRequestParams=function(at){if(Z){if(D===false){at.cache=0;at.cachernd=r}else{for(var ar in y){if(y.hasOwnProperty(ar)){at[ar]=y[ar]}}}}};this.addNoCacheParams=function(ar){ar.cache=0;ar.cachernd=r};this.parseQuery=function(at,ar){if(typeof(ar)!=="object"||typeof(at)!=="string"||at.length<1){return}n.queryToObject(at,ar);if(ar.ignorequeryparameters!==b){delete ar.ignorequeryparameters}if(ar.enableconfigcachingparameter!==b){delete ar.enableconfigcachingparameter}};this.cloneParameters=function(ar,at){if(!ar||!at||typeof(ar)!=="object"||typeof(at)!=="object"){H.error("Cloning object failed: "+ar+" / "+at)}for(var au in ar){if(ar.hasOwnProperty(au)){at[au]=ar[au]}}};this.getFSIPath=function(ar,at){if(typeof(at)!=="string"){at=""}if(at.indexOf("//")!==-1){return at}if(n.cfg.fsibase!==b){at=n.cfg.fsibase+at}return n.getReloadPath(ar,at)};this.expandFSIPath=function(at){if(typeof(at)!=="string"){return at}var ar=a.utils.urlDecode(at);if(ar.indexOf("?")!==-1||ar.indexOf(".xml")===(ar.length-4)){return at}return at+".xml"};this.getReloadPath=function(av,ax){var at,ay,ar,aw;if(av===b){av=n.locationFSIViewer}if(typeof(ax)!=="string"){ax=""}var au="/";if(ax.indexOf("//")!==-1){return ax}at=av;aw=at.lastIndexOf("?");if(aw===-1){aw=at.length}ay=at.lastIndexOf("\\",aw);ar=at.lastIndexOf("/",aw);ay=Math.max(ay,ar);if(ay===-1){ay=at.length-1}at=at.slice(0,ay);if(at.length>0&&ax.indexOf(au)!==0){at+=au}return at+ax};var C=function(ar){var at;if(!ar){return}if(ar.childNodes.length>0){at=ar.innerHTML}else{at=ar.getAttribute("value")}return at};var I=function(au,aw){var at,ar;var av=0;while(au){if(au.nodeType===1&&au.nodeName.toLowerCase()===aw){ar=au;break}at=au.firstChild;if(!at){at=au.nextSibling}else{av++}if(!at&&av>0&&au.parentNode){at=au.parentNode.nextSibling;av--}au=at}return ar};var S=function(aO,at){var ay;var aK;if(at===b){at=0}var aL={};var aJ=aL.arImages=[];var aC=aL.arConfigs=[];var aM=aL.arNodes=[];var aw=aL.arImageLists=[];var aB="";var aP="";var aI;var ax;var aH={};if(at===0&&(n.cfg.imagelistparameterfilterpositive||n.cfg.imagelistparameterfilternegative)){n.getParameterFilter();n.cloneParameters(K,aH);if(n.cfg.imagelistparameterfilterpositive){n.setParameterFilter(n.cfg.imagelistparameterfilterpositive,true)}else{if(n.cfg.imagelistparameterfilternegative){n.setParameterFilter(n.cfg.imagelistparameterfilternegative,false)}}}var aG=function(ar){aJ.push(ar);aM.push(aO);if(at===0){aC.push(aI);aw.push(ax)}};var aF;if(!aO){return aL}var aU;aU=n.getAttributeValue(aO,"prefix");if(typeof(aU)==="string"){aB=aU}aU=n.getAttributeValue(aO,"suffix");if(typeof(aU)==="string"){aP=aU}var av=n.getAttributeValue(aO,"from");var aE=n.getAttributeValue(aO,"to");var aT,au;if(typeof(av)==="string"&&typeof(aE)==="string"){aT=parseInt(av);au=parseInt(aE);if(!isNaN(aT)&&!isNaN(au)&&aT<=au&&(au-aT)<512){}else{aT=au=b}}if(aT!==b){ax=aI=b;var aS;var aN=av.length;var aR=aE.length;if(aN===aR){aS=aN}for(var aQ=aT;aQ<=au;aQ++){aK=""+aQ;if(aS){while(aK.length<aS){aK="0"+aK}}if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}}else{aO=I(aO,"image");var az;if(!aO){return aL}while(aO){az=true;if(aO.nodeType===1&&aO.nodeName.toLowerCase()==="image"){ax=aI=b;if(at===0){aI=n.clone();aI.getImageQueryParameters();aI.arUnrecognizedConfigNodes=[];aI.parseConfig(aO,aO);aI.setCfgValues({});aI.checkDebug();if(aI.debug&&aI.debug.on){aI.debug.group("Sub Config #"+aJ.length+" from image list:");aI.dumpConfig();aI.debug.groupEnd()}aI.serverBase=n.serverBase;aI.requestBase=n.requestBase;ax=aI.getImageList(at+1);if(ax&&ax.arImages.length>0){az=false;var aD=aI.parseSceneSets(ax.arImages.length,true);var aV=n.viewStringToArray(aI.cfg.initialview);var aA=aD.arSets[aV[0]-1][aV[1]-1];if(aA===b){aA=0}aG(ax.arImages[aA])}}if(az){ax=aI=b;aF=I(aO,"path");aK=C(aF);if(!aK){aK=a.utils.urlDecode(n.getAttributeValue(aO,"src"))}if(!aK){aK=a.utils.urlDecode(n.getAttributeValue(aO,"file"))}if(aK!==b){if(ae===false){aG(aB+aK+aP)}else{ay=aB+aK+aP;if(ae(ay)){aG(ay)}}}if(aL.width===b){aF=I(aO,"width");aF=C(aF);if(aF!==b){aL.width=parseInt(aF)}aF=I(aO,"height");aF=C(aF);if(aF!==b){aL.height=parseInt(aF)}}}}aO=aO.nextSibling}}if(aH){n.setParameterFilter(aH)}return aL};this.getImageList=function(au){var aA,ay,av;A();if(!n.makeBool(n.cfg.ignoreimagelists)){if(n.cfg&&n.cfg.fpxsources!==b){var az=n.cfg.fpxsources;if(typeof(az)==="string"||(typeof(az)==="object")&&typeof(az.push)==="function"){aA={};aA.oXML=null;if(typeof(az)==="string"){if(ae===false){aA.arImages=az.split(",");for(ay=0;ay<aA.arImages.length;ay++){aA.arImages[ay]=a.utils.urlDecode(aA.arImages[ay])}}else{var ax=az.split(",");aA.arImages=[];for(ay=0;ay<ax.length;ay++){av=a.utils.urlDecode(ax[ay]);if(ae(av)){aA.arImages.push(av)}}}}else{aA.arImages=az}}}if(!aA&&n.arUnrecognizedConfigNodes&&n.arUnrecognizedConfigNodes.length>0){var aB=n.arUnrecognizedConfigNodes;for(ay=0;ay<aB.length;ay++){var aw=aB[ay];if(typeof(aw.nodeName)==="string"){var at=aw.nodeName.toLowerCase();if(at==="images"||at==="images3d"){if(H.on){H.log("Reading image list from XML node: <"+aw.nodeName+">")}aA=S(aw,au);aA.oXML=aw;break}}}}}if(!aA&&n.cfg&&n.cfg.fpxsrc!==b){aA={};aA.oXML=null;if(ae===false){aA.arImages=[a.utils.urlDecode(n.cfg.fpxsrc)]}else{av=a.utils.urlDecode(n.cfg.fpxsrc);if(ae()){aA.arImages=[av]}}}return aA};this.fillViewString=function(aw){if(typeof(aw)!=="string"){aw=""}var au=[1,1,0,0,1,1,0];var at=aw.split(",");if(at.length===2){return aw+",0,0,1,1,0"}if(at.length===6){return aw+",0"}if(at.length===7){return aw}for(var av=at.length;av<7;av++){at.push(au[av])}return at.join(",")};this.viewStringToArray=function(au){var av=function(ay,ax){var ar=parseFloat(ay);if(isNaN(ar)){ar=ax}return ar};var aw=function(ay,ax){var ar=parseInt(ay);if(isNaN(ar)){ar=ax}return ar};au=n.fillViewString(au);var at=au.split(",");at[0]=aw(at[0],1);at[1]=aw(at[1],1);at[2]=av(at[2],0);at[3]=av(at[3],0);at[4]=av(at[4],1);at[5]=av(at[5],1);at[6]=av(at[6],0);return at};this.getServerBase=function(){return n.serverBase};this.loadImageList=function(aw,ax,az,ay){if(!n.serverBase||!aw){ax([],b,ay);return false}A();var av=n.serverBase+"?type=list";if(!aw.match(aj)){var au=n.cfg.listtemplate;if(au&&au.length>0&&!au.match(af)&&!au.match(d)){au+=".json"}av+="&tpl="+au}if(n.cfg.headers&&n.cfg.headers.length>0&&y.headers===b){av+="&headers="+n.cfg.headers}if(typeof(n.cfg.imagelistlimit)==="string"&&n.cfg.imagelistlimit.length>0){av+="&limit="+encodeURIComponent(n.cfg.imagelistlimit)}if(n.cfg.imagelistsort!==b){H.log("Sorting image list by: "+n.cfg.imagelistsort);av+="&sort="+n.cfg.imagelistsort}if(typeof(n.cfg.imagelistsortorder)==="string"){var at=n.cfg.imagelistsortorder.toLowerCase();if(at==="asc"||at==="desc"){H.log("Image list sort order: "+at);av+="&sortorder="+at}}av+="&source="+encodeURIComponent(aw);if(az!==b){av+=az}av=ap(av);var ar=n.loadFile(av,function(aA,aE){if(typeof(aE)==="object"&&typeof(aE.images)==="object"){aE.images.pop();var aF="";if(aE&&aE.imagesattributes&&aE.imagesattributes.dir){aF=aE.imagesattributes.dir}var aB,aD;if(ae===false){aB=new Array(aE.images.length);for(aD=0;aD<aE.images.length;aD++){aB[aD]=aF+aE.images[aD].src}}else{aB=[];for(aD=aE.images.length-1;aD>-1;aD--){var aC=aF+aE.images[aD].src;if(ah(aC)){aB.push(aC)}else{aE.images.splice(aD,1)}}aB.reverse()}ax(aB,aE,ay)}else{ax([],aE,ay)}},"application/json",ay);return ar};var ah=function(at){if(typeof(at)!=="string"){return 1}var ar=1;if(P!==b){if(!at.match(P)){ar=0}}if(ar===1&&z!==b){if(at.match(z)){ar=0}}return ar};var ae=true;var P,z;var F=function(aw){var au;var ay=n.cfg[aw.toLowerCase()];if(!ay||typeof(ay)!=="string"||ay.length<1){return}var ar=/\/([^/]*)$/;try{var av=ay.match(ar);if(av&&av.length>1){var at=av[1];ay=ay.replace(ar,"");ay=ay.replace(/^\//,"")}au=new RegExp(ay,at)}catch(ax){H.error("Invalid Regular Expression "+ay+" in parameter "+aw);H.error(ax.message);au=b}return au};var A=function(){P=F("ListFilterPositive");z=F("ListFilterNegative");if(P===b&&z===b){ae=false}else{ae=ah}};this.traceConfigValue=function(ar,av){if(typeof(ar)!=="string"){return false}ar=a.trim(ar);if(ar.length<1){return false}var at=ar.toLowerCase();if(at.indexOf(".")!==-1){at=at.split(".").join("")}if(at.indexOf("/")!==-1){at=at.split("/").join("")}if(at.indexOf(" ")!==-1){at=at.split(" ").join("")}var au=new a.Debugger();au.setPrefix("");au.group('Tracing parameter "'+ar+'"');var aw=function(){var ax=ar;var aC=n.getParameterAlias(at);if(typeof(aC)==="string"){ax+=" (alias: "+aC+")";if(typeof(n.cfgAliasNames[at])==="string"){at=n.cfgAliasNames[at]}}var ay=n.cfg[at];var aB=true;if(at.indexOf("_")!==-1){var aA=at.split("_");var az=aA.shift();var aD=aA.join("_");if(n.hasPlugin(az)){ay=n.getPluginParameter(az,aD)}}else{if(n.hasPlugin(at)){aB=false;ay="is enabled."}}if(ay===b){aB=false;ay="is undefined (default value applies)"}if(aB){ay='= "'+ay+'"'}au.group("RESULT:");au.log(ax+" "+ay);au.groupEnd();au.groupEnd()};x={onConfigsReady:aw};f.strTraceParam=at;f.bNoDebug=true;n.iTraceParameterDebug=au;n.init(av);n.loadConfigs();return""};this.loadLanguageFile=function(ar,aD,aw,au){var ax=arguments;var ay,aB;if(typeof(aD)!=="string"||n.makeBool(aD,true)===false){return aw.call(n,{},"")}var aC=function(aE){try{a.utils.oLanguageMap=JSON.parse(aE.responseText)}catch(aF){a.utils.oLanguageMap={"default":"english"}}n.loadLanguageFile.apply(this,ax)};var az=function(aE,aH){ar.urlLanguageCurrentLoaded=ay;var aG=ar.oLanguageData={};if(aH){var aF=n.findXMLNode(aH,"data");if(aF){aF=n.findXMLNode(aF,"tip")}while(aF){if(aF.nodeType===1){var aI=aF.getAttribute("id");aG[aI]=n.XMLChildNodesToString(aF)}aF=aF.nextSibling}}aw.call(n,ar.oLanguageData,aB)};if(aD.toLowerCase()==="auto"){if(!a.utils.oLanguageMap){n.loadFile(a.getViewerLocation()+"/languages/mapping.json",aC,"application/json");return}if(a.utils.oLanguageMap._current!==b){aD=a.utils.oLanguageMap._current}else{aD=a.utils.oLanguageMap["default"];var av=navigator.language;if(typeof(av)==="string"){av=av.toLowerCase()}if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}else{if(av.indexOf("-")!==-1){av=av.split("-")[0];if(a.utils.oLanguageMap[av]!==b){aD=a.utils.oLanguageMap[av]}}}}if(aD===b){return aw.call(n,{},"")}if(au){au.log('Automatically choosing language "'+aD+'" from navigator.language "'+navigator.language+'"')}a.utils.oLanguageMap._current=aD}var aA=aD+".xml";var at=a.getViewerLocation()+"/languages/"+aA;if(at!==ar.urlLanguageCurrentLoaded){aB=aD;ay=at;if(au){au.log("Loading language file: "+at)}n.loadFile(at,az,"application/xml")}else{aw.call(n,ar.oLanguageData,aB)}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Rect!==b){return}a.Rect=function(d,f,g,c){var e=this;e.left=(isNaN(d))?0:d;e.top=(isNaN(f))?0:f;e.right=(isNaN(g))?0:g;e.bottom=(isNaN(c))?0:c;this.width=function(){var h=e.right-e.left;return Math.abs(h)};this.height=function(){var h=e.bottom-e.top;return Math.abs(h)};this.offsetRect=function(i,h){e.left+=i;e.right+=i;e.top+=h;e.bottom+=h};this.inflateRect=function(j,i){var h=j/2;var k=i/2;e.left-=h;e.top-=k;e.right+=h;e.bottom+=k};this.normalizeRect=function(){var h;if(e.left>e.right){h=e.left;e.left=e.right;e.right=h}if(e.top>e.bottom){h=e.top;e.top=e.bottom;e.bottom=h}};this.setRect=function(i,j,k,h){e.left=i;e.top=j;e.right=k;e.bottom=h};this.setFromArray=function(h){e.left=h[0];e.top=h[1];e.right=h[2];e.bottom=h[3]};this.scaleRect=function(h){if(h===1){return}e.left*=h;e.top*=h;e.right*=h;e.bottom*=h};this.scaleRectXY=function(i,h){e.left*=i;e.top*=h;e.right*=i;e.bottom*=h};this.scaleRectInt=function(h){if(h===1){return}e.left=Math.round(e.left*h);e.top=Math.round(e.top*h);e.right=Math.round(e.right*h);e.bottom=Math.round(e.bottom*h)};this.getPartialRect=function(j){var i=e.duplicateRect();if(!j.isDefaultImageRect()){var h=i.width();var k=i.height();i.offsetRect(j.left*h,j.top*k);i.right=i.left+h*j.width();i.bottom=i.top+k*j.height()}return i};this.isDefaultImageRect=function(){return(e.left===0&&e.top===0&&e.right===1&&e.bottom===1)};this.limitToImageRect=function(){e.left=Math.max(0,Math.min(1,e.left));e.right=Math.max(0,Math.min(1,e.right));e.top=Math.max(0,Math.min(1,e.top));e.bottom=Math.max(0,Math.min(1,e.bottom))};this.interSectRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.max(e.left,l.left);var h=Math.max(e.top,l.top);var i=Math.min(e.right,l.right);var j=Math.min(e.bottom,l.bottom);e.setRect(k,h,i,j)};this.interSectRectValidate=function(h){e.interSectRect(h);if(e.right<e.left){e.left=e.right=0}if(e.bottom<e.top){e.top=e.bottom=0}};this.isInsideRect=function(h){return(e.left>=h.left&&e.top>=h.top&&e.right<=h.right&&e.bottom<=h.bottom)};this.isRectInsideMe=function(h){return(e.left<=h.left&&e.top<=h.top&&e.right>=h.right&&e.bottom>=h.bottom)};this.getBoundingRect=function(l){e.normalizeRect();l.normalizeRect();var k=Math.min(e.left,l.left);var h=Math.min(e.top,l.top);var i=Math.max(e.right,l.right);var j=Math.max(e.bottom,l.bottom);return new a.Rect(k,h,i,j)};this.equalRect=function(h){return(e.left===h.left&&e.top===h.top&&e.right===h.right&&e.bottom===h.bottom)};this.copyRect=function(h){e.setRect(h.left,h.top,h.right,h.bottom)};this.duplicateRect=function(){return new a.Rect(e.left,e.top,e.right,e.bottom)};this.join=function(h){this.left=Math.min(this.left,h.left);this.top=Math.min(this.top,h.top);this.right=Math.max(this.right,h.right);this.bottom=Math.max(this.bottom,h.bottom)};this.round=function(h){var i=function(k,j){k*=j;k=(k>=0)?Math.floor(k+0.5):Math.ceil(k-0.5);return k/j};if(isNaN(h)){h=1000000}e.left=i(e.left,h);e.top=i(e.top,h);e.right=i(e.right,h);e.bottom=i(e.bottom,h)};this.flipHorz=function(){var h=e.left;e.left=e.right;e.right=h};this.flipVert=function(){var h=e.top;e.top=e.bottom;e.bottom=h};this.setFromString=function(j){if(typeof(j)!=="string"){return}j=decodeURIComponent(j);j=j.replace(/[^0-9,.]/g,"");j=j.split(",");if(j.length>3){for(var h=0;h<j.length;h++){j[h]=parseFloat(j[h])}e.setFromArray(j)}};this.toString=function(){return e.left+","+e.top+","+e.right+","+e.bottom};this.getRange=function(){var h={};h.left=e.left;h.top=e.top;h.width=e.width();h.height=e.height();return h}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.CroppedImage!==b){return}a.CroppedImage=function(){var p=this;var e=new a.Rect(0,0,0,0);var n,d;var i=new a.Rect();var h=new a.Rect(0,0,1,1);var c={width:0,height:0};var k=false;var o=function(t,s){if(typeof(t)!="string"){return s}var q=t.split(",");var r=q.length;while(q.length<4){q.push(s[r]);r++}return q};this.setCropFromConfig=function(q){if(q.cropvalues!==b){p.setCropValuesParam(q.cropvalues)}else{if(q.croprect!==b){p.setCropRectParam(q.croprect)}}};this.setCropRectParam=function(r){var q=o(r,["0","0","1","1"]);p.setCropRect(q[0],q[1],q[2],q[3])};var g=function(s,r){var q;if(isNaN(s)){q=r}else{q=Math.max(0,Math.min(1,s))}return q};var j=function(r,q){return Math.round(r*q)};this.setCropRect=function(s,u,v,q){n={l:s,t:u,r:v,b:q};d=b;s=g(s,0);u=g(u,0);v=g(v,1);q=g(q,1);h.setRect(s,u,1-v,1-q);s=j(s,c.width);u=j(u,c.height);v=c.width-j(v,c.width);q=c.height-j(q,c.height);f(s,u,v,q)};var f=function(s,u,v,q){v=Math.min(c.width-s,v);q=Math.min(c.height-u,q);e.setRect(s,u,v,q);k=(s!==0||u!==0||v!==0||q!==0);i.setRect(s,u,c.width-v,c.height-q)};this.setCropValuesParam=function(r){var q=o(r,["0","0","0","0"]);p.setCropValues(q[0],q[1],q[2],q[3])};var m=function(s,q){var r={};if(s.indexOf("%")!==-1){s=Math.max(0,Math.min(100,parseFloat(s)));r.floatVal=s/100;r.pxVal=Math.round(s*q/100)}else{if(s.indexOf("px")!==-1){s=parseInt(s);r.pxVal=Math.max(0,Math.min(q,s));r.floatVal=r.pxVal/q}else{r.floatVal=Math.max(0,Math.min(1,parseFloat(s)));r.pxVal=Math.round(r.floatVal*q)}}return r};this.setCropValues=function(s,u,v,q){d={l:s,t:u,r:v,b:q};n=b;s=m(s,c.width);v=m(v,c.width);u=m(u,c.height);q=m(q,c.height);h.setRect(s.floatVal,u.floatVal,v.floatVal,q.floatVal);f(s.pxVal,u.pxVal,v.pxVal,q.pxVal)};this.setSourceDimension=function(q,r){c.width=q;c.height=r;l()};this.getSourceDimension=function(){return{width:c.width,height:c.height}};this.isCropped=function(){return k};this.getImageRect=function(){return i.duplicateRect()};this.flipCropHorz=function(){var r=function(t){var s=t.l;t.l=t.r;t.r=s};var q=function(t){var s=t.l;t.l=1-t.r;t.r=1-s};if(n){q(n)}if(d){r(d)}l()};this.getFloatValues=function(){return h.duplicateRect()};this.getFloatRect=function(){var q=h.duplicateRect();q.right=1-q.right;q.bottom=1-q.bottom;return q};this.getCropMargins=function(){return e.duplicateRect()};var l=function(){if(n!==b){p.setCropRect(n.l,n.t,n.r,n.b)}else{if(d!==b){p.setCropValues(d.l,d.t,d.r,d.b)}else{f(0,0,0,0);h.setRect(0,0,0,0)}}};this.getOffsettedPixelRangeRect=function(q,v,r,t){var u=i.width();var s=i.height();q=Math.max(0,Math.min(u,q));v=Math.max(0,Math.min(s,v));r=Math.max(0,Math.min(u-q,r));t=Math.max(0,Math.min(s-v,t));q+=i.left;v+=i.top;return new a.Rect(q,v,r,t)};this.getPixelRangeRect=function(r,u,z,v,B,s){var q,A;if(r===b&&u===b){r=i.width();u=i.height();A=1}else{if(r!==b){A=i.width()/r;if(u===b){u=i.height()/A}}else{A=i.height()/u;if(r===b){r=i.width()/A}}}if(z===b){z=v=0;B=r;s=u}if(!k){q=new a.Rect(z,v,B,s);q._refWidth=r;q._refHeight=u}else{r*=A;u*=A;var t=new a.Rect(z,v,B,s);t.scaleRect(A);q=p.getOffsettedPixelRangeRect(t.left,t.top,t.right,t.bottom);q.scaleRectInt(1/A);r+=e.left+e.right;u+=e.top+e.bottom;r/=A;u/=A;q._refWidth=Math.round(r);q._refHeight=Math.round(u);q.right=Math.min(q._refWidth-q.left,q.right);q.bottom=Math.min(q._refHeight-q.top,q.bottom)}return q};this.getPixelRangeParameters=function(A,u,q,z,r,t){var s;var v=p.getPixelRangeRect(A,u,q,z,r,t);if(v.left===0&&v.top===0&&v.width()===v._refWidth&&v.height()===v._refHeight){s="&width="+v._refWidth}else{s="&pixelRange="+v.left+","+v.top+","+v.right+","+v.bottom+"&referenceWidth="+v._refWidth+"&referenceHeight="+v._refHeight}return s};this.getPixelRangeParametersByCalculatedResult=function(r){var q;if(r.left===0&&r.top===0&&r.width()===r._refWidth&&r.height()===r._refHeight){q="&width="+r._refWidth}else{q="&pixelRange="+r.left+","+r.top+","+r.right+","+r.bottom+"&referenceWidth="+r._refWidth+"&referenceHeight="+r._refHeight}return q};this.getCropToFill=function(u,s,y,B){var C=new a.CroppedImage();var D,v;if(typeof(y)!=="string"||y.length!==2){y="cc"}else{y=y.toLowerCase()}var t=0;var r=new a.Rect();var A;var z=p.isCropped();var q,E;var x,F;if(z){x=(1-h.left-h.right);F=(1-h.top-h.bottom);q=Math.round(x*c.width);E=Math.round(F*c.height)}else{q=c.width;E=c.height}u=Math.min(u,q);s=Math.min(s,E);if(u/q<s/E){v=s;D=Math.round(q/E*s);t=D-u;switch(y.charAt(1)){case"l":r.setRect(0,0,D-t,v);break;case"r":r.setRect(t,0,D,v);break;case"v":A=Math.random()*t;r.setRect(A,0,A+u,v);break;default:r.setRect(t/2,0,D-t/2,v)}}else{D=u;v=Math.round(E/q*u);t=v-s;switch(y.charAt(0)){case"t":r.setRect(0,0,D,v-t);break;case"b":r.setRect(0,t,D,v);break;case"v":A=Math.random()*t;r.setRect(0,A,D,A+s);break;default:r.setRect(0,t/2,D,v-t/2)}}r.scaleRectXY(1/D,1/v);if(p.isCropped()){D/=x;v/=F;if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v);r.scaleRectXY(x,F);r.offsetRect(h.left,h.top)}else{if(B){D=Math.min(D,c.width);v=Math.min(v,c.height)}C.setSourceDimension(D,v)}C.widthUncropped=D;C.heightUncropped=v;C.setCropRect(r.left,r.top,r.right,r.bottom);return C}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.CustomEventListener!==b){return}a.utils.CustomEventListener=function(i){var k=this;var c=[];var f={};var g={};var h=0;k._strClassName="$FSI.CustomEventListener";var j=function(){};this.destroy=function(){for(var l=0;l<c.length;l++){var m=c[l];e(m.element,m.fn)}c=[];f={};g={};k.onDestroy()};this.fireEvent=function(l,m){if(!l||!l.enabled){return false}if(typeof(m)!="object"){m={}}if(l.paused){m.FSI_paused=true}m.FSI_custom_event=true;m.FSI_type=i;m.FSI_target=l.element;return l.fn.call(l.element,m)};this.fireEvents=function(m){if(typeof(m)!="object"){m={}}m.FSI_custom_event=true;m.FSI_type=i;for(var n=0;n<c.length;n++){var l=c[n];if(l.enabled){if(l.paused){m.FSI_paused=true}else{if(m.FSI_paused){delete m.FSI_paused}}m.FSI_target=l.element;l.fn.call(l.element,m)}}};this.addListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for addListener");return}if(p.__FSI===b){p.__FSI={}}if(p.__FSI.eventElementID===b){p.__FSI.eventElementListenerCount=1;p.__FSI.eventElementID=a.utils.getNewEventElementID()}else{p.__FSI.eventElementListenerCount++}if(o.__FSIEventFunctionID===b){o.__FSIEventFunctionListenerCount=1;o.__FSIEventFunctionID=a.utils.getNewEventFunctionID()}else{o.__FSIEventFunctionListenerCount++}var m=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(f[m]===b){var l=f[m]={};l.nFunction=0;l.oFunctions={}}if(f[m].oFunctions[n]===b){f[m].nFunction++;f[m].oFunctions[n]=[]}else{a.console.warn(k._strClassName+": There is already a listener for this exact element and function");a.console.log(p);a.console.log(o)}var q={};q.element=p;q.elementID=m;q.fn=o;q.fnID=n;q.instanceListener=k;q.enabled=true;q.paused=false;q.uniqueID=h++;f[m].oFunctions[n].push(q);c.push(q);g[q.uniqueID]=q;k._onListenerAdd(q);k._onListenerCountChange(c.length);return q};this.setListenerProps=function(o,m,n){var l=g[o];if(!l){return false}if(l.props===b){l.props={}}l.props[m]=n;return true};this.enableListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.enabled===m){return}l.enabled=m};this.pauseListener=function(n,m){var l=g[n];if(!l||typeof(l)!=="object"||l.paused===m){return}l.paused=m};var e=this.removeListener=function(p,o){if(typeof(p)!="object"||typeof(o)!="function"){a.console.error(k._strClassName+": Invalid parameters for removeListener");return}if(typeof(p.__FSI)!=="object"||p.__FSI.eventElementID===b||o.__FSIEventFunctionID===b){if(o.__FSIEventFunctionID===b){a.console.error(k._strClassName+": Function not registered for listener in removeListener")}else{a.console.error(k._strClassName+": Element not registered for listener in removeListener")}return}var l=p.__FSI.eventElementID;var n=o.__FSIEventFunctionID;if(!f[l]){a.console.error(k._strClassName+": No registered listener for this element in removeListener");return}var m=f[l].oFunctions[n];if(m===b||typeof(m.pop)!="function"){a.console.error(k._strClassName+": No registered listener for this function in removeListener");return}var q=m.pop();q.fn.__FSIEventFunctionListenerCount--;q.element.__FSI.eventElementListenerCount--;if(q.element.__FSI.eventElementListenerCount===0){delete q.element.__FSI.eventElementListenerCount;delete q.element.__FSI.eventElementID}if(q.fn.__FSIEventFunctionListenerCount===0){delete q.fn.__FSIEventFunctionListenerCount;delete q.fn.__FSIEventFunctionID}if(m.length===0){delete f[l].oFunctions[n];f[l].nFunction--;if(f[l].nFunction===0){delete f[l]}}delete g[q.uniqueID];d();k._onListenerRemove(q);k._onListenerCountChange(c.length);return q};this.getEventListenerByID=function(l){return g[l]};this.getListenerObjectByID=function(l){return g[l]};this.getListenersArray=function(){return c};this.getListenerCount=function(){return c.length};var d=function(){c=[];for(var m in f){if(f.hasOwnProperty(m)){var o=f[m].oFunctions;for(var n in o){if(o.hasOwnProperty(n)){var l=o[n];c=c.concat(l)}}}}};this.dump=function(){a.console.dir(f);a.console.dir(c)};this._onListenerCountChange=function(l){};this._onListenerAdd=function(m,l){};this._onListenerRemove=function(m,l){};this.triggerEvent=function(l){};this.triggerEvents=function(){};this.setListenerProps=function(n,l,m){};this.onDestroy=function(){};j()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIDocumentZoomChange")){return}a.utils.registerCustomEvent("FSIDocumentZoomChange",function(){var o=this;var c=false;var g;var h;var l=0;var f=false;var e;var n;a.utils.CustomEventListener.prototype.constructor.call(o,"FSIDocumentZoomChange");o._strClassName="$FSI.CustomEventListenerDocumentZoom";var j=function(){if(c){return}c=true;g=a.utils.getDocumentScaleWithPixelRatio();if(a.BrowserSupports.visualViewportAPI()){n=m;a.addEvent(window.visualViewport,"resize",n);h=setInterval(n,250)}else{n=d;e=0;h=setInterval(n,50)}a.addEvent(window,"orientationchange",n)};var i=function(){if(!c){return}c=false;if(a.BrowserSupports.visualViewportAPI()){a.removeEvent(window.visualViewport,"resize",n)}a.removeEvent(window,"orientationchange",n);clearInterval(h);h=b};this.onDestroy=function(){i()};this._onListenerCountChange=function(p){var q=(p>0);if(q!==c){if(q){j()}else{i()}}};var m=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){g=q;k(q);p=true}else{p=false}return p};var d=function(){var p;var q=a.utils.getDocumentScaleWithPixelRatio();if(g!==q){if(!f){e=0;clearInterval(h);h=setInterval(n,50)}l=0;g=q;k(q);p=true}else{p=false;if(e<3){l++;if(l===20){e=1;clearInterval(h);h=setInterval(n,150)}else{if(l===40){e=2;clearInterval(h);h=setInterval(n,300)}else{if(l===50){e=3;clearInterval(h);h=setInterval(n,600)}}}}}return p};this.triggerEvent=function(r){var p=o.getEventListenerByID(r);if(!p){return}var q={};q.FSI_scale=a.utils.getDocumentScale();q.FSI_scale_with_pixel_ratio=a.utils.getDocumentScaleWithPixelRatio();o.fireEvent(p,q)};this.triggerEvents=function(){k(a.utils.getDocumentScaleWithPixelRatio())};var k=function(q){var p={};p.FSI_scale=a.utils.getDocumentScale();p.FSI_scale_with_pixel_ratio=q;o.fireEvents(p)}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIElementDimension")){return}a.utils.registerCustomEvent("FSIElementDimension",function(){var o=this;var k=25;var e;var d=0;var f={};f[0]=25;f[25]=50;f[50]=100;f[75]=250;var l=76;var g;var j=typeof(ResizeObserver)==="function";a.utils.CustomEventListener.prototype.constructor.call(o,"FSIElementDimension");o._strClassName="$FSI.CustomEventListenerElementDimension";this._onListenerCountChange=function(p){if(j){return}if(p<1){clearInterval(e);e=b}else{if(e===b){e=setInterval(n,f[0])}}};var c=function(r,q){for(var p=0;p<r.length;p++){i(r[p])}};var i=function(q){var p=o.getEventListenerByID(q.target.__FSI.idListener);if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){m(p,false);if(p.tresholdEnd>0){if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}if(p.skiptreshold){p.treshold=p.tresholdEnd;p.skiptreshold=false;m(p,true)}else{p.timeoutTreshold=setTimeout(function(){p.treshold=p.tresholdEnd;p.timeoutTreshold=b;m(p,true)},p.tresholdEnd)}}}};this._onListenerRemove=function(p){if(g){g.unobserve(p.element)}if(p.timeoutTreshold!==b){clearTimeout(p.timeoutTreshold)}};this._onListenerAdd=function(p){p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;if(j){if(!g){g=new ResizeObserver(c)}p.element.__FSI.idListener=p.uniqueID;g.observe(p.element)}};this.setListenerProps=function(s,q,r){if(typeof(q)!="string"){return false}var p=o.getListenerObjectByID(s);if(!p){return false}switch(q){case"treshold":if(r&&r>0){p.tresholdEnd=r}break;case"skiptreshold":p.skiptreshold=r;h(15);break;case"fireTresholdEventOnly":p.fireTresholdEventOnly=r;break}};var n=function(){var r=o.getListenersArray();var v=false;var q=false;for(var u=0;u<r.length;u++){var p=r[u];if(p.__elementWidth!==p.element.offsetWidth||p.__elementHeight!==p.element.offsetHeight){v=true;if(p.tresholdEnd){p.treshold=k}m(p,false)}else{if(p.treshold>0){p.treshold+=k;if(p.skiptreshold){q=true;p.treshold=p.tresholdEnd}if(p.treshold>=p.tresholdEnd){p.skiptreshold=false;m(p,true);p.treshold=0}}}}if(!q){if(v){d=0;h(f[0])}else{if(d<l){d++;var s=f[d];if(s!==b){h(s)}}}}};var h=function(p){if(p===k||e===b){return}k=p;clearInterval(e);e=setInterval(n,k)};var m=function(p,r){var q={};if(r){q.FSI_after_treshold=p.treshold}q.FSI_target=p.element;q.FSI_dimension_old={width:p.__elementWidth,height:p.__elementHeight};p.__elementWidth=p.element.offsetWidth;p.__elementHeight=p.element.offsetHeight;q.FSI_dimension={width:p.__elementWidth,height:p.__elementHeight};if(r||!p.fireTresholdEventOnly){o.fireEvent(p,q)}};this.triggerEvent=function(q){var p=o.getEventListenerByID(q);if(!p){return}if(p.tresholdEnd){p.treshold=1}m(p)};this.triggerEvents=function(){var p=o.getListenersArray();for(var q=0;q<p.length;q++){if(p[q].tresholdEnd){p[q].treshold=1}m(p[q])}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.customEventClassExists("FSIViewport")){return}a.utils.registerCustomEvent("FSIViewport",function(){var k=this;var d=false;var h=new a.Rect(0,0,0,0);var i=new a.Rect(0,0,0,0);var l=new a.Rect(0,0,0,0);var H=new a.Rect(0,0,0,0);var t={left:0,top:0};var T;var B;var C="";var o=b;var y;var q=10;var F;var s=0;var u;var E;var S=0;var c=100;var n=1;var z=1;var N=32;var w;var p;var G=a.BrowserSupports.visualViewportAPI();try{p=window.frameElement}catch(P){}a.utils.CustomEventListener.prototype.constructor.call(k,"FSIViewport");k._strClassName="$FSI.CustomEventListenerViewport";this.onDestroy=function(){m()};var M=function(){if(d){return}d=true;g(a.addEvent);F=a.addCustomEvent(k,"FSIDocumentZoomChange",I);n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio()};var m=function(){if(!d){return}d=false;g(a.removeEvent);a.removeCustomEvent(k,"FSIDocumentZoomChange",I);F=b;if(o){clearInterval(o);o=b}r();s=0;if(w!==b){clearTimeout(w);w=b}};var g=function(U){var e=window;U(e.document,"scroll",j,false);U(e,"resize",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&p){U(e,"touchmove",Q,false)}}while(e.frameElement){e=e.parent.window;if(e){U(e.document,"scroll",j,false);if(G){U(e.visualViewport,"resize",j,false);U(e.visualViewport,"scroll",j,false)}else{if(a.isTouch&&!a.isIETouch&&e.frameElement){U(e,"touchmove",Q,false)}}U(e,"resize",j,false)}}U(window,"orientationchange",j,false)};this.setListenerProps=function(W,U,V){if(typeof(U)!="string"){return false}var e=k.getListenerObjectByID(W);if(!e){return false}switch(U){case"treshold":if(e.tresholdEnd!==b){s--;e.tresholdEnd=b}if(V&&V>0){s++;e.tresholdEnd=V}break;case"fireTresholdEventOnly":e.fireTresholdEventOnly=V;break}};this._onListenerRemove=function(e){if(e.tresholdEnd!==b){s--}};this._onListenerCountChange=function(e){var U=(e>0);if(U!==d){if(U){M()}else{m()}}};var I=function(e){n=e.FSI_scale;z=e.FSI_scale_with_pixel_ratio;j()};var j=function(){if(w!==b){return}w=setTimeout(K,N);K()};var K=function(){if(w!==b){clearTimeout(w);w=b}var e=false;var U=L();if(C!==U){C=U;e=true;f()}return e};var J=function(){n=a.utils.getDocumentScale();z=n*a.getDevicePixelRatio();L()};this.triggerEvent=function(V){var e=k.getEventListenerByID(V);if(!e){return}J();var U=O();k.fireEvent(e,U)};this.triggerEvents=function(){J();f()};var f=this.fireEvents=function(){var U=O();var V=k.getListenersArray();for(var W=0;W<V.length;W++){var e=V[W];if(!e.fireTresholdEventOnly){k.fireEvent(e,U)}}A()};var O=function(){var e={};e.FSI_scale=a.utils.getDocumentScale();e.FSI_scale_with_pixel_ratio=e.FSI_scale*a.getDevicePixelRatio();e.FSI_viewport_rect=i;e.FSI_scroll=t;e.FSI_client_rect_body_top=T;e.FSI_viewport_size_top=B;return e};this.getVisibleRect=function(){L();return H};this.getScrollRect=function(){return T};var R=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);var e=window.visualViewport;H.setRect(e.pageLeft,e.pageTop,e.pageLeft+e.width,e.pageTop+e.height);if(p){t.left=-window.pageXOffset;t.top=-window.pageYOffset}else{t.left=T.left;t.top=T.top}i.left=e.offsetLeft;i.top=e.offsetTop;i.right=i.left+e.width;i.bottom=i.top+e.height;return e.scale+"_"+e.offsetLeft+","+e.offsetTop+","+e.width+","+e.height+" "+B.width+" x "+B.height+" "+e.pageTop+"x"+e.pageLeft};var x=function(){B=a.getViewportSize(a.utils.getTopWindow());T=a.getBoundingClientRect(a.utils.getTopWindow().document.documentElement);h.left=a.utils.getTopWindow().pageXOffset;h.top=a.utils.getTopWindow().pageYOffset;h.right=h.left+B.width;h.bottom=h.top+B.height;if(p){var e=a.getViewportSize(window);var U=a.getWindowOffset(window);i.left=0;i.top=0;i.right=i.left+e.width;i.bottom=i.top+e.height;t.left=-window.pageXOffset;t.top=-window.pageYOffset;l.copyRect(i);l.left=-U.x+h.left+T.left;l.top=-U.y+h.top+T.top;l.right=l.left+B.width;l.bottom=l.top+B.height;i.interSectRectValidate(l);var V=a.getBoundingClientRect(window.document.body);H.copyRect(i);H.offsetRect(U.x+V.left,U.y+V.top)}else{t.left=T.left;t.top=T.top;H.copyRect(h);i.copyRect(h);i.offsetRect(T.left,T.top)}return n+"_"+H.toString()+" "+B.width+" x "+B.height};var L=(G)?R:x;var Q=function(){y=q;if(o!==b){return}o=setInterval(v,100)};var v=function(){if(!K()){y--}else{y=q}if(y<1){clearInterval(o);o=b}};var r=function(){if(E!==b){clearInterval(E);E=b;u=b}};var A=function(){r();if(s>0){E=setInterval(D,c)}};var D=function(){var W,e;S+=c;if(u===b){S=c;u=[];var V=k.getListenersArray();for(W=0;W<V.length;W++){e=V[W];if(e.tresholdEnd>0){u.push(e)}}}var U;for(W=u.length-1;W>-1;W--){e=u[W];if(e.tresholdEnd<=S){if(k.getEventListenerByID(e.uniqueID)!==b){if(U===b){U=O();U.FSI_after_treshold=true}k.fireEvent(e,U)}u.splice(W,1)}}if(u.length===0){r()}}})}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Easing!==b){return}a.Easing={easeLinear:function(f,g,e,h){return h*(f/g)+e},easeInQuad:function(f,g,e,h){return h*(f/=g)*f+e},easeOutQuad:function(f,g,e,h){return -h*(f/=g)*(f-2)+e},easeInOutQuad:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f+e}return -h/2*((--f)*(f-2)-1)+e},easeInCubic:function(f,g,e,h){return h*(f/=g)*f*f+e},easeOutCubic:function(f,g,e,h){return h*((f=f/g-1)*f*f+1)+e},easeInOutCubic:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f+e}return h/2*((f-=2)*f*f+2)+e},easeInQuart:function(f,g,e,h){return h*(f/=g)*f*f*f+e},easeOutQuart:function(f,g,e,h){return -h*((f=f/g-1)*f*f*f-1)+e},easeInOutQuart:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f+e}return -h/2*((f-=2)*f*f*f-2)+e},easeInQuint:function(f,g,e,h){return h*(f/=g)*f*f*f*f+e},easeOutQuint:function(f,g,e,h){return h*((f=f/g-1)*f*f*f*f+1)+e},easeInOutQuint:function(f,g,e,h){if((f/=g/2)<1){return h/2*f*f*f*f*f+e}return h/2*((f-=2)*f*f*f*f+2)+e},easeInSine:function(f,g,e,h){return -h*Math.cos(f/g*(Math.PI/2))+h+e},easeOutSine:function(f,g,e,h){return h*Math.sin(f/g*(Math.PI/2))+e},easeInOutSine:function(f,g,e,h){return -h/2*(Math.cos(Math.PI*f/g)-1)+e},easeInExpo:function(f,g,e,h){return(f===0)?e:h*Math.pow(2,10*(f/g-1))+e},easeOutExpo:function(f,g,e,h){return(f===g)?e+h:h*(-Math.pow(2,-10*f/g)+1)+e},easeInOutExpo:function(f,g,e,h){if(f===0){return e}if(f===g){return e+h}if((f/=g/2)<1){return h/2*Math.pow(2,10*(f-1))+e}return h/2*(-Math.pow(2,-10*--f)+2)+e},easeInCirc:function(f,g,e,h){return -h*(Math.sqrt(1-(f/=g)*f)-1)+e},easeOutCirc:function(f,g,e,h){return h*Math.sqrt(1-(f=f/g-1)*f)+e},easeInOutCirc:function(f,g,e,h){if((f/=g/2)<1){return -h/2*(Math.sqrt(1-f*f)-1)+e}return h/2*(Math.sqrt(1-(f-=2)*f)+1)+e},easeInElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return -(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e},easeOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j)===1){return e+k}if(!i){i=j*0.3}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}return f*Math.pow(2,-10*g)*Math.sin((g*j-h)*(2*Math.PI)/i)+k+e},easeInOutElastic:function(g,j,e,k){if(k===0){return e}var h=1.70158;var i=0;var f=k;if(g===0){return e}if((g/=j/2)===2){return e+k}if(!i){i=j*(0.3*1.5)}if(f<Math.abs(k)){f=k;h=i/4}else{h=i/(2*Math.PI)*Math.asin(k/f)}if(g<1){return -0.5*(f*Math.pow(2,10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i))+e}return f*Math.pow(2,-10*(g-=1))*Math.sin((g*j-h)*(2*Math.PI)/i)*0.5+k+e},easeInBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*(f/=h)*f*((g+1)*f-g)+e},easeOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}return i*((f=f/h-1)*f*((g+1)*f+g)+1)+e},easeInOutBack:function(f,h,e,i,g){if(g===b){g=1.70158}if((f/=h/2)<1){return i/2*(f*f*(((g*=(1.525))+1)*f-g))+e}return i/2*((f-=2)*f*(((g*=(1.525))+1)*f+g)+2)+e},easeOutBounce:function(f,g,e,h){if((f/=g)<(1/2.75)){return h*(7.5625*f*f)+e}else{if(f<(2/2.75)){return h*(7.5625*(f-=(1.5/2.75))*f+0.75)+e}else{if(f<(2.5/2.75)){return h*(7.5625*(f-=(2.25/2.75))*f+0.9375)+e}else{return h*(7.5625*(f-=(2.625/2.75))*f+0.984375)+e}}}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.TouchHandler!==b){return}a.TouchHandler=function(m,aX,al,e,aN){var aE=this;var aL=false;var ak=true;var o=false;var aT=false;var aK=false;var aB,E,j,ad;var aC,Y,aI;var h=false;var ae;var r;var a0={};var aq=[];var ac=0;var I=window;var aV;var s;var aU;var d;var aZ=[];var aR={x:0,y:0};var v={x:0,y:0};var ar=40;var n={};n.enabled=false;n.factor=5;n.fEndDiff=1;var ay={};ay.enabled=false;ay.minFrames=14;ay.factorAmount=23;ay.factorAmountQuad=0;ay.factorFrames=2.6;ay.offsetFrames=5;var ab;var az;var aH,w;var F;var at={};var X;var aM=false;var z=false;var am={};am.name="none";var N;var W;var aO;var f=false;var Z={};if(!aX||typeof(aX)!="object"){aX={}}var an=function(){var a6;if(aL){aE.destroy()}aU=A;s=b;if(a.utils.getTopWindow()!==window){s=a.utils.getTopWindow();try{var a5=a.getWindowOffset(window);if(a5.x!==b&&a5.y!==b){aU=ap}}catch(a4){aU=A;s=b}}else{s=b}F=aX.oPassTrough;aW(aX.panDirectionAllowed,true);if(aX.getPageCoords){r=aF}else{r=M}if(aX.afterTouch){for(a6 in aX.afterTouch){if(aX.afterTouch.hasOwnProperty(a6)){ay[a6]=aX.afterTouch[a6]}}}if(ay.minDelta===b){ay.minDelta=15}if(aX.nClickRadius){ab=aX.nClickRadius}else{ab=10}if(ay.fnStartStopAfterTouch&&typeof(ay.fnStartStopAfterTouch)!="function"){ay.fnStartStopAfterTouch=b}if(ay.fnStartStopAfterTouch){ay.useAnimationFrame=b}if(typeof(ay.modifyTarget)!="function"){ay.modifyTarget=b}if(typeof(ay.fnGetAfterTouchEnabled)=="function"){az=ay.fnGetAfterTouchEnabled}else{az=b}if(aX.smoothing){for(a6 in aX.smoothing){if(aX.smoothing.hasOwnProperty(a6)){n[a6]=aX.smoothing[a6]}}}if(aX.detectClick===true){X=true}if(aX.preventSelection!==false){aX.preventSelection=true}if(!m){return}if(typeof(m.join)!="function"){m=[m]}if(typeof(al)!="function"){al=A}if(typeof(e)!="function"){e=A}if(typeof(aN)!="function"){aN=A}if(typeof(aX.onPinchChange)=="function"){N=aX.onPinchChange}else{N=b}aM=aX.detectGestures;aZ=[];ax(true,aM);for(var a3=0;a3<m.length;a3++){var a2=m[a3];if(a2&&typeof(a2.nodeName)!="undefined"){a6={};a6.element=a2;aZ.push(a6);ao(a2,R);if(a.isTouch){try{if(a2.style!==b){if(a.BrowserSupports.cssTouchAction()){if(at.cssTouchAction!==b){q(a2,at.cssTouchAction)}}}}catch(a4){}}}}if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.addEvent(window,"touchforcechange",aD,false)}};this.setFnDown=function(a2){al=a2};this.setFnUp=function(a2){aN=a2};this.setFnMove=function(a2){e=a2};var aW=this.setAllowedPanDirection=function(a3,a2){if(typeof(a3)=="string"){if(a3==="pan-x"||a3==="pan-y"||a3==="pan-x pan-y"){aV=a3+" "}else{aV=""}}else{aV=""}if(!a2){at.nCheck=b;ah(at.captureScroll,at.capturePinch)}};this.enable=function(a2){if(ak===a2){return}if(!a2){Q();ah(false,false)}else{ah(at.captureScrollUser,at.capturePinchUser)}ak=a2};this.getEnabled=function(){return ak};this.cancel=function(){P();ag();aJ();Q()};var aJ=function(){if(n.enabled){i()}B()};this.cancelAfterTouch=function(){B()};this.getInitialDownEvent=function(){return W};var Q=function(){if(!o){return}aJ();o=false;W=b;z=false;if(ac===0){aP()}};var aP=function(){f=false;c()};this.destroy=function(){if(a.mobileOS==="ios"&&a.isEventSupported("touchforcechange")){a.removeEvent(window,"touchforcechange",aD,false)}if(aO){clearTimeout(aO)}aE.cancel();var a2;for(var a3=0;a3<aZ.length;a3++){var a4=aZ[a3];a2=a4.element;x(a2,R)}at={}};var q=function(a2,a3){if(!a.BrowserSupports.cssTouchAction()||!a2||!a2.style){return}a2.style.touchAction=a2.style.msTouchAction=a3};var T=function(a2){if(a2.preventDefault){a2.preventDefault()}};var l=function(a2){T(a2);return false};var ao=function(a3,a2){a.addEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{a.addEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.addEvent(a3,"touchstart",a2);a.addEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.addEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.addEvent(a3,"MSPointerDown",a2)}a.addEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.addEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var x=function(a3,a2){a.removeEvent(a3,"dragstart",l);if(aX.bMouseOnly){if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{a.removeEvent(a3,"mousedown",a2)}return}if(a.isEventSupported("touchstart")&&!a.isInternetExplorer){a.removeEvent(a3,"touchstart",a2);a.removeEvent(a3,"mousedown",a2)}else{if(a.isEventSupported("pointerdown")){a.removeEvent(a3,"pointerdown",a2)}else{if(a.isEventSupported("MSPointerDown")){a.removeEvent(a3,"MSPointerDown",a2)}a.removeEvent(a3,"mousedown",a2)}}if(a.isEventSupported("MSHoldVisual")){a.removeEvent(a3,"MSHoldVisual",a.preventDefaultEvent)}};var A=function(){return true};var aQ=function(a2){if(aK){V(a2,a2.pointerId)}else{var a3=a2.changedTouches;for(var a4=0;a4<a3.length;a4++){V(a3[a4],a3[a4].identifier)}}};var V=function(a2,a4){if(a4===b||a0[a4]!==b){if(aX.debug){if(a4===b){a.console.error("doRegisterPointer: no pointerId")}if(a0[a4]!==b){a.console.error("doRegisterPointer: pointerId already registered: "+a4)}}return}ac++;var a3=a0[a4]={};a3.identifier=a4;r(a3,a2);aq.push(a3)};var aj=function(a2){var a4=false;if(aK){a4=K(a2.pointerId)}else{var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){a4=K(a3[a5].identifier)}}}if(a4){aq=new Array(ac);var a7=0;for(var a6 in a0){if(a0.hasOwnProperty(a6)){aq[a7++]=a0[a6]}}}};var K=function(a2){if(a2===b||a0[a2]===b){if(aX.debug){if(a2===b){a.console.error("doUnregisterPointer: no pointerId")}if(a0[a2]===b){a.console.error("doUnregisterPointer: pointerId not registered: "+a2)}}return false}delete a0[a2];ac--;return true};var H=function(){ac=0;a0={};aq=[]};var M=function(a3,a2){a3.x=a2.clientX;a3.y=a2.clientY};var aF=function(a3,a2){a3.x=a2.pageX;a3.y=a2.pageY};var u=function(a2){var a3=a2.changedTouches;if(a3){for(var a5=0;a5<a3.length;a5++){var a4=a0[a3[a5].identifier];if(a4){r(a4,a3[a5])}}}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y}};var aw=function(a2){var a3=a0[a2.pointerId];if(a3){r(a3,a2)}if(aq.length>0){aR.x=aq[0].x;aR.y=aq[0].y;aU(a2,aR)}};var U=function(a2){r(aR,a2);aU(a2,aR)};this.getMousePositionFromMouseEvent=function(a2){U(a2);return aR};this.getMousePositionPage=function(a3){var a2={};aF(a2,a3);aU(a3,a2);return a2};this.getMousePositionClient=function(a3){var a2={};M(a2,a3);aU(a3,a2);return a2};var t=function(a2,a3){if(window!==a2.view){var a4=a.getWindowOffset(window);a3.x-=a4.x;a3.y-=a4.y}};var ap=function(a2){try{t(a2);aU=t}catch(a3){aU=A}};var aA=function(a2){if(!ak){return}var a4=ac;if(z&&a4===0){z=false}var a5=a2.type;if(o||am.started){if(a5!==aB){if(am.started){P();ag()}else{a2._FSI_Canceled=true;a1(a2,true)}}}aB=a5;d=false;var a3=true;switch(a5){case"touchstart":aT=true;aK=false;ae=u;j="touchmove";E="touchend";ad="touchcancel";aH=false;break;case"MSPointerDown":ae=aw;aT=true;aK=true;j="MSPointerDown";E="MSPointerUp";ad="MSPointerCancel";aH=false;d=true;break;case"pointerdown":ae=aw;aT=true;aK=true;j="pointermove";E="pointerup";ad="pointercancel";aH=true;d=true;break;default:if(ac>0){H()}aT=false;aK=false;aH=(aX.preventSelection);a3=false;ae=U;j="mousemove";E="mouseup";ad=b;d=true}if(aT&&a3){aQ(a2)}ae(a2);if(ac>1){Z.bClick=false}w=false;if(a3&&ai(a2)){if(a4===0){B();D()}return false}return true};this.isPointerDown=function(){return f};this.getPointerCount=function(){return ac};var R=function(a2){if(aX.bMouseOnly&&a2.type==="pointerdown"&&a2.pointerType!=="mouse"){return true}if(!aA(a2)){return}if(o||a2.which>1){return}g(a2)};this.getCurrentPos=function(){return v};var g=function(a2){aJ();if(o){return}ay.evtMove=b;if(n.enabled){v={x:aR.x,y:aR.y}}else{v=aR}Z.x=aR.x;Z.y=aR.y;var a3=W;W=a2;if(!al.call(I,a2,v,F)){W=a3;return false}o=f=true;if(X&&!z){Z.bClick=true;Z.clickRadiusX=Z.clickRadiusY=0}else{Z.bClick=false}D();if(ay.enabled){ay.x=ay.y=0;ay.lastX=aR.x;ay.lastY=aR.y;if(ay.nInterval){clearInterval(ay.nInterval)}ay.nInterval=setInterval(aa,30)}return true};var c=function(){if(h&&Y!==b){var a2={passive:false,capture:false};var a4=(s===b)?a2:b;h=false;a.removeEvent(window,Y,af,a4);a.removeEvent(window,aC,a1,a4);if(d&&s){try{a.removeEvent(s,Y,af,a2);a.removeEvent(s,aC,a1,a2)}catch(a3){}}if(aI!==b){a.removeEvent(window,aI,au,a4)}Y=aC=aI=b}};var aD=function(){};var D=function(){if(h){c()}h=true;var a2={passive:false,capture:false};var a4=(s===b)?a2:b;Y=j;aC=E;aI=ad;a.addEvent(window,Y,af,a4);a.addEvent(window,aC,a1,a4);if(d&&s){try{a.addEvent(s,Y,af,a2);a.addEvent(s,aC,a1,a2)}catch(a3){}}if(ad!==b){a.addEvent(window,aI,au,a4)}};var af=function(a2){ae(a2);a2.FSI_start_x=Z.x;a2.FSI_start_y=Z.y;if(ay.enabled&&ay.evtMove===b){ay.evtMove=a2}if(o){if(Z.bClick){Z.clickRadiusX=Math.max(Z.clickRadiusX,Math.abs(aR.x-Z.x));if(Z.clickRadiusX>ab){Z.bClick=false}else{Z.clickRadiusY=Math.max(Z.clickRadiusY,Math.abs(aR.y-Z.y));if(Z.clickRadiusY>ab){Z.bClick=false}}}if(n.enabled){n.evt=a2;aY()}else{e.call(I,a2,v,F)}}else{if(am.started){if(am.nType===1){av(a2)}}}if(w&&!a2.FSI_allowEventDefault){T(a2)}};var av=function(a2){var a3=k();if(!N){return}a2._FSI_PinchDeltaStart=am.nPinchDistance-am.pinchDistanceStart;a2._FSI_PinchDeltaRelative=am.nPinchDistance-am.pinchDistanceLast;a2._FSI_PinchScale=Math.max(ar,am.pinchDistanceLast)/am.pinchDistanceStartMaxed;am.pinchDistanceLast=am.nPinchDistance;a2._FSI_PinchDistance=a3;N.call(I,a2,aR,F)};var au=function(a2){if(aT){aj(a2);if(ac<1){if(o){a2._FSI_Canceled=true;a1(a2,true);return}else{Q();return}}}ae(a2);ai(a2)};var a1=function(a3,a4){var a2=Z.bClick;Z.bClick=false;if(a4){a3._FSI_Canceled=true}if(aT){aj(a3)}if(ac===0){aP()}ae(a3);if(!a4&&ai(a3)){return}aJ();if(!a4){if(!o||ac>0){return}}a3.FSI_start_x=Z.x;a3.FSI_start_y=Z.y;var a5=false;if(!a4&&ay.enabled){if(az===b||az()){a5=S(a3)}}if(a5){Q();y(a3)}else{if(X){a3._FSI_Click=a2}aN.call(I,a3,v,F);if(a3.type==="touchend"){aO=setTimeout(p,1)}Q()}T(a3)};var p=function(){Q();H();aO=b};var G=function(){return aq};var aY=function(){if(n.animationFrame!==b){return}aS()};var i=function(){if(n.animationFrame===b){return}cancelAnimationFrame(n.animationFrame);n.animationFrame=b};var aS=function(){var a2=Math.abs(v.x-aR.x)+Math.abs(v.y-aR.y);if(a2>n.fEndDiff){v.x+=(aR.x-v.x)/n.factor;v.y+=(aR.y-v.y)/n.factor;n.animationFrame=requestAnimationFrame(aS)}else{v.x=aR.x;v.y=aR.y;n.animationFrame=b}e.call(I,n.evt,v,F)};var S=function(a2){var a3;if(!ay.enabled){return false}if(ay.running){B()}ay.pos=0;var a5=(a2.touches!==b)?1.8:1;if(ay.factorAmountQuad){a3=(ay.x>0)?1:-1;ay.x=ay.x+a3*ay.x*ay.x/ay.factorAmountQuad;a3=(ay.y>0)?1:-1;ay.y=ay.y+a3*ay.y*ay.y/ay.factorAmountQuad}var a7=a5*ay.factorAmount;ay.startX=v.x;ay.startY=v.y;var a6={};a6.x=ay.startX+a7*ay.x;a6.y=ay.startY+a7*ay.y;if(ay.roundTargetPos){a6.x=Math.round(a6.x);a6.y=Math.round(a6.y)}if(ay.modifyTarget){a6=ay.modifyTarget.call(I,a6,F);if(a6===false){return false}}ay.amountX=a6.x-ay.startX;ay.amountY=a6.y-ay.startY;ay.amountXABS=Math.abs(ay.amountX);ay.amountYABS=Math.abs(ay.amountY);var a4=(ay.amountXABS>ay.minDelta||ay.amountYABS>ay.minDelta);if(a4){a7=ay.factorFrames/100;ay.frames=ay.offsetFrames+Math.round(a7*ay.amountXABS+a7*ay.amountYABS)}else{if(typeof(aX.onAfterTouchCancel)=="function"){aX.onAfterTouchCancel.call(I,a2,v,F)}}return a4};this.isAfterTouchRunning=function(){return ay.running};var y=function(a2){if(typeof(aX.onAfterTouchStart)=="function"){aX.onAfterTouchStart.call(I,a2,v,F)}ay.running=true;ay.evtUp=a2;if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,true,ay.evtMove,F)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}else{ay.intervalRun=setInterval(J,16)}}return true};var aG=function(a3,a2,a5,a4){return a5*((a3=a3/a4-1)*a3*a3+1)+a2};var J=this.runAfterTouch=function(){var a2=false;ay.pos++;v.x=aG(ay.pos,ay.startX,ay.amountX,ay.frames);v.y=aG(ay.pos,ay.startY,ay.amountY,ay.frames);e.call(I,ay.evtMove,v,F);if(ay.pos===ay.frames){B(true)}else{if(ay.useAnimationFrame){ay.animationFrameRun=requestAnimationFrame(J)}a2=true}return a2};this.enableAfterTouch=function(a2){if(ay.enabled===a2){return}if(!a2){B()}ay.enabled=a2};var B=function(a2){if(!ay.running){return}if(ay.fnStartStopAfterTouch){ay.fnStartStopAfterTouch.call(I,false,ay.evtMove,F)}else{if(ay.useAnimationFrame){if(ay.animationFrameRun){cancelAnimationFrame(ay.animationFrameRun)}}else{if(ay.intervalRun){clearInterval(ay.intervalRun);ay.intervalRun=b}}}if(typeof(aX.onAfterTouchEnd)=="function"){aX.onAfterTouchEnd.call(I,ay.evtMove,F)}ay.evtMove=b;ay.running=false;ay.evtUp._FSI_Canceled=(a2!==true);ay.evtUp._FSI_fromAfterTouch=true;aN.call(I,ay.evtUp,v,F)};var aa=function(){ay.x=(2*ay.x+aR.x-ay.lastX)/5;ay.y=(2*ay.y+aR.y-ay.lastY)/5;ay.lastX=aR.x;ay.lastY=aR.y};var ax=this.setCapture=function(a2,a4){var a3=ah(a2,a4);if(a3){at.captureScrollUser=a2;at.capturePinchUser=a4}return a3};var ah=function(a2,a4){var a3=0;if(a2){a3+=2}if(a4){a3+=4}if(a3===at.nCheck){return}at.nCheck=a3;at.captureScroll=a2;at.capturePinch=a4;if(a.BrowserSupports.cssTouchAction()){O(a2,a4)}return true};var O=function(){if(aX.bMouseOnly){return}var a4;switch(at.nCheck){case 0:a4="auto";break;case 2:a4=aV+"pinch-zoom";break;case 4:a4="pan-x pan-y";break;default:a4=(aV.length>0)?aV:"none"}at.cssTouchAction=a4;for(var a3=0;a3<m.length;a3++){var a2=m[a3];q(a2,at.cssTouchAction)}};var k=function(){if(aq.length<1){return 0}var a3=Math.abs(aq[1].x-aq[0].x);var a2=Math.abs(aq[1].y-aq[0].y);return am.nPinchDistance=Math.sqrt(a3*a3+a2*a2)};var ai=function(a2){w=false;if(!ak){return}var a3=aq.length;if(!aM){w=(a3===1&&at.captureScroll);return}if(am.pointerCount!==a3){P(a2);if(a3>1){ag();am.nPointers=a3;switch(a3){case 2:am.started=true;am.name="pinch";am.nType=1;if(typeof(aX.onPinchStart)=="function"){L(a2);am.nPinchDistance=0;am.nPinchDistance=k();am.pinchDistanceStart=am.pinchDistanceLast=am.nPinchDistance;am.pinchDistanceStartMaxed=Math.max(ar,am.pinchDistanceStart);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchStart.call(I,a2,aR,F)}break;default:am.started=true;am.name="unknown";am.nType=-1}if(am.started){z=true;if(o){aJ();o=false;a2._FSI_Canceled=true;aN.call(I,a2,v,F)}if(typeof(aX.onGestureStart)=="function"){L(a2);aX.onGestureStart.call(I,a2,aR,F)}}}else{if(a3<1){ag()}}am.pointerCount=a3;w=false;if(a3===1){if(at.captureScroll){w=true}}else{if(at.capturePinch&&am.nType===1){w=true}}}return am.started};var ag=function(){if(!am.timeoutRestartDown){return}clearTimeout(am.timeoutRestartDown);am.timeoutRestartDown=b};var C=function(){if(ac!==1){return}g(W);ag()};var L=function(a2){a2._FSI_Gesture=am.name;a2._FSI_GestureType=am.nType;a2._FSI_PointerCount=am.nPointers};var P=function(a2){if(!am.started){return}am.started=false;if(!a2){a2={}}if(am.nType===1&&typeof(aX.onPinchEnd)=="function"){L(a2);a2._FSI_PinchDistance=am.nPinchDistance;aX.onPinchEnd.call(I,a2,aR,F)}if(typeof(aX.onGestureEnd)=="function"){L(a2);aX.onGestureEnd.call(I,a2,aR,F)}am.name="none";am.nType=0;if(a2&&ac===1){ag();am.timeoutRestartDown=setTimeout(C,20)}};an()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.Callbacks!==b){return}a.Callbacks=function(f,m,k,c){if(typeof(m)!=="object"||typeof(m.cfg)!=="object"){m={cfg:{}}}if(typeof(k)!=="object"){k={}}var l=this;var q=0;var s={};var t=0;var g={};var n=new a.EmptyDebugger();var p={};var w={reg:{}};var o;var v={};var j;var r=function(){if(f){f.dumpListeners=l.dumpReg}};this.destroy=function(){if(n.on){this.removeConfigListeners();if(q>0){n.warn("WARNING: "+q+" listener(s) have not been removed:");for(var x in g){if(g.hasOwnProperty(x)){if(g[x].count>0){a.console.logCSS(g[x].dump(),"color:blue;","color:green;")}}}}}m={cfg:{}};this.checkListenerChanges()};this.removeConfigListeners=function(){for(var x in s){if(s.hasOwnProperty(x)){var y=s[x];if(y!==false){d(y.evt,y.fn)}}}s={}};this.setDebug=function(x){n=x};this.setConfig=function(x){l.removeConfigListeners();m=x};var u=function(A){if(!g[A]){if(s[A]===b){var z;var y=A.toLowerCase();var B=m.cfg[y];var x=typeof(B);if(x!=="undefined"){if(x==="function"){z=B}else{if(x==="string"&&typeof(window[B])==="function"){z=window[B]}}if(z&&h(A,z,f,true)){s[A]={evt:A,fn:z}}else{s[A]=false}}}if(!g[A]){g[A]=new e(A)}}return g[A]};var h=this.addListener=function(z,x,y,B){if(typeof(x)!="function"){n.error("Failed to add listener for "+z+". The function argument is not a function.");return false}var A;if(g[z]===b){A=g[z]=new e(z)}else{A=g[z]}A.addFunction(x,y,B);return true};var d=this.removeListener=function(y,x){var z=g[y];if(z===b||typeof(x)!="function"||x.__FSICallbackFunctionID===b){n.error("Unable to remove listener: no callback for "+y+" registered");return false}return z.removeFunction(x)};this.watchListeners=function(y,x){o=x;v=y;j=false;for(var z in y){if(y.hasOwnProperty(z)){j=true;l.isset(z);w.reg[z]=b}}w.bDirty=true;l.checkListenerChanges()};var i=function(x){if(v[x]){w.bDirty=true;if(w.reg[x]===b){w.reg[x]=g[x].count}if(w.nTimeout===b){w.nTimeout=setTimeout(l.checkListenerChanges,5)}}};this.checkListenerChanges=function(){if(typeof(o)==="function"){if(w.nTimeout!==b){clearTimeout(w.nTimeout);w.nTimeout=b}if(w.bDirty){var z={};for(var x in w.reg){if(w.reg.hasOwnProperty(x)){var y=(g[x]!==b&&g[x].count>0);var A=(w.reg[x]===b)?b:(w.reg[x]>0);if(y!==A){z[x]=y}}}o.apply(l,[z]);w.bDirty=false;w.reg={}}}};this.dumpReg=function(){var A;var B;if(f&&f.getAPIData){B=f.getAPIData().oCallbacks}if(B){for(A in B){if(B.hasOwnProperty(A)){u(A)}}}var x;if(n&&n.on){x=n}else{x=a.console}var y=[];x.group("Total listeners: "+q);for(A in g){if(g.hasOwnProperty(A)){y.push(g[A].dump())}}y.sort();for(var z=0;z<y.length;z++){x.logCSS(y[z],"color:blue;","color:green;")}x.groupEnd()};this.isset=function(x){return(u(x).count>0)};this.runPersistent=function(y,x){l.run(y,x);p[y]=[x]};this.run=function(C,z){var y;var E=u(C);if(E.count>0){var x=E.getFunctionsArray();for(var B=0;B<x.length;B++){var D=x[B];D.countCalled++;var A=D.fn.apply(D.scope,z);if(A!==b){y=A;if(E.handleCallbackResult){y=E.handleCallbackResult(y,z)}}}}return y};var e=function(B){var y=this;this.count=0;var C=false;var A;var z={};var x={};this.addFunction=function(E,F,J){if(j&&y.count===0){i(B)}q++;y.count++;C=true;if(F===b){F=f}var D=E.__FSICallbackFunctionID;if(D===b){D=E.__FSICallbackFunctionID=a.utils.getNewCallbackFunctionID()}if(x[D]===b){x[D]=[]}x[D].push(t);z[t]={fn:E,scope:F,countCalled:0};if(n.on){var I=x[D].length;if(I>1){var H="";try{H=" "+E.name+"()"}catch(G){}n.error(I+" listeners for "+B+" have been added for the same function "+H+". Did you forget to remove a listener?")}if(y.count>20){n.error(I+" listeners for "+B+" have been added for this instance. Did you forget to remove a listener?")}}if(typeof(k[B])==="function"){y.handleCallbackResult=k[B]}if(p[B]!==b){if(!c||c(B,p[B],J)){E.apply(F,p[B][0])}}t++};this.getFunctionsArray=function(){if(C){A=[];var D=z;for(var E in D){if(D.hasOwnProperty(E)){if(typeof(D[E].fn)==="function"){A.push(D[E])}}}C=false}return A};this.removeFunction=function(G){var E=G.__FSICallbackFunctionID;var D=x[E];if(D===b){if(n.on){var I="this function";try{I="the function "+G.name}catch(H){}n.error("Unable to remove listener: no callback for "+B+" registered for "+I)}return false}var F=D.pop();if(j&&y.count===1){i(B)}q--;y.count--;if(D.length===0){delete x[E]}C=true;delete z[F]};this.dump=function(){var F;if(y.count===0){F="%c"+B+": %c no listeners"}else{if(y.count===1){F="%c"+B+": %c"+y.count+" listener"}else{F="%c"+B+": %c"+y.count+" listeners"}}var E=y.getFunctionsArray();if(E&&E.length>0){for(var G=0;G<E.length;G++){try{var I=E[G].fn.name;if(typeof(I)!=="string"||I.length===0){I="anonymous"}}catch(H){I="anonymous"}F+="\n - "+I;var D=E[G].countCalled;if(D===0){F+=" (not called yet)"}else{if(D===1){F+=" (called once)"}else{F+=" (called "+E[G].countCalled+" times)"}}}}return F}};r()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.MetaDataReplacer!==b){return}a.MetaDataReplacer=function(d){d=d||{};var r=this;var o={};var e;var p=new RegExp("###[a-z0-9 .]+###","ig");var g=new RegExp("^language.","i");var n;var l;var c={};var m;var k;var q=function(){h();if(d.oLanguageData){r.setLanguageData(d.oLanguageData)}if(d.fnCallbackReplace){r.setReplaceCallback(d.fnCallbackReplace)}if(d.strLocale){r.setLocale(d.strLocale)}};var j=function(t){if(typeof(t)!=="string"){t=""}var F,D;var A={};A.strContentRaw=t;A.bHasPlaceHolders=false;var z,v,C,w;var y=t.match(p);if(y){F=D=t;A.strContentNoTemplates=t.replace(p,"");A.bHasPlaceHolders=true;var u=y;var s;var E=new RegExp(/^###/);var B=new RegExp(/###$/);A.oAllTemplates={};A.oNoMetaDataTemplates={};A.oMetaDataTemplates={};A.nTemplates=u.length;A.arAllReplacers=[];A.arMetaDataReplacers=[];A.arNoMetaDataReplacers=[];for(var x=0;x<u.length;x++){C=v=u[x];w=C.replace(E,"").replace(B,"");C=w.toLowerCase();if(!A.oAllTemplates[C]){A.oAllTemplates[C]=true;z=new RegExp(v,"ig");if(!k[C]&&!C.match(g)){D=D.replace(z,"");A.bNeedsMetaData=true;A.oMetaDataTemplates[C]=true;s=f(w,v);A.arMetaDataReplacers.push(s)}else{F=F.replace(z,"");s=f(w,v);A.arNoMetaDataReplacers.push(s);A.oNoMetaDataTemplates[C]=true}A.arAllReplacers.push(s)}}A.strContentMetaTemplatesOnly=F;A.strContentNoMetaTemplates=D;if(A.oAllTemplates["image.width"]||A.oAllTemplates["image.height"]){A.bNeedsImageDim=true}}else{A.bHasPlaceHolders=false;A.strContentNoTemplates=t}return A};var f=function(z,x){var C=z.toLowerCase();if(!c[C]){var s=new RegExp(x,"ig");var u;var A;var t;var B=z.split(".");if(B.length<2){u=function(){return"invalid key"}}else{z=z.toLowerCase();var w=B[0]+"."+B[1];w=w.toLowerCase();if(B[3]!=="raw"){t=n[z]}switch(w){case"image.index":u=function(D){return D.nIndex};break;case"image.number":u=function(D){return D.nIndex+1};break;case"image.width":u=function(D){return D.sourceWidth};break;case"image.height":u=function(D){return D.sourceHeight};break;case"image.filepath":u=function(D){return D.imagePath};break;case"image.filename":u=function(E){var D=E.imagePath.split("/");D=D[D.length-1];return D};break;case"image.filedir":u=function(E){var D=E.imagePath.split("/");D.pop();D=D.join("/");return D};break;default:var v=B[0];var y=B[1];if(v==="language"){u=function(){return o[y]||""}}else{v=v.toLowerCase();if(v==="general"){u=function(D){A=(D.oMetaData.general!==b)?D.oMetaData.general:D.oMetaData;return A[y]||""}}else{u=function(D){A=D.oMetaData[v];return(A&&A[y]!==b)?A[y]:""}}}break}}c[C]=function(F,D){var E=D._fsi_MetaDataReplacer_cache[z];if(E===b){E=u(D);if(t){E=t(E)}if(l){E=l(z,E)}D._fsi_MetaDataReplacer_cache[z]=E}return F.replace(s,E)}}return c[C]};var i=function(v,t,u){if(!t._fsi_MetaDataReplacer_cache){t._fsi_MetaDataReplacer_cache={}}for(var s=0;s<u.length;s++){v=u[s](v,t)}return v};var h=function(){e=d.oNumberSeperators;k={"image.index":true,"image.number":true,"image.filename":true,"image.filepath":true,"image.filedir":true};if(d.bItemsHaveWidthAndHeight){k["image.width"]=true;k["image.height"]=true}var v=a.utils.makeNiceNumber;var s=a.utils.makeNiceFileSize;var x=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=v(parseInt(z),0,e)}return y};var u=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=s(z,e)}return y};var w=new Date();var t;if(typeof(w.toLocaleDateString)==="function"){t=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=new Date(z).toLocaleString(m)}return y}}else{t=function(z){var y;z=parseInt(z);if(isNaN(z)){y="---"}else{y=new Date(z).toString(m)}return y}}n={"general.size":u,"image.width":x,"image.height":x,"image.index":x,"image.number":x,"general.lastmodified":t}};this.destroy=function(){c={}};this.setLanguageData=function(s){o=s};this.setLocale=function(s){m=s};this.setReplaceCallback=function(s){if(typeof(s)==="function"){l=s}else{l=false}};this.parseTemplate=j;this.replaceBasic=function(t,s){return i(s.strContentNoMetaTemplates,t,s.arNoMetaDataReplacers)};this.replaceMetaData=function(t,s){return i(s.strContentMetaTemplatesOnly,t,s.arMetaDataReplacers)};this.replaceAll=function(t,s){return i(s.strContentRaw,t,s.arAllReplacers)};q()}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.utils.API.ThumbBar!==b){return}a.utils.API.ThumbBar=function(d,e){var c=this;c.scriptMainFile="FSI.ThumbBar.js";c.oMethodAndPropertyExclusions={devParseAPI:true,attachedCallback:true,createdCallback:true,destroyOnDetach:true,detachedCallback:true,align:true};c.oMethods={addImages:{a:"arPathsOrObjects"},addListener:{a:"strListenerName, fn, iScope",r:"bSuccess"},assignFSIViewer:{a:"iFSIViewerInstance"},buttonDown:{a:"strCommand",r:"bSuccess"},buttonUp:{r:"bSuccess"},changeConfig:{a:"strCfgFileName, oParameters"},changeDir:{a:"strDirectory",r:"bSuccess"},closeZoom:{a:"evt, bImmediate"},destroy:{},dumpListeners:{},firstImage:{a:"nAnimationFrames"},focusImage:{a:"nImage"},getBuild:{r:"strBuild"},getCurrentImageIndex:{r:"nIndex"},getConfigValue:{a:"strName",r:"mixed"},getImageCount:{r:"nImages"},getInitDone:{r:"bDone"},getInstanceID:{r:"nInstanceID"},getInstanceName:{r:"strInstanceName"},getParameters:{r:"oParameters"},getScrollPos:{r:"fPosition"},getVersion:{r:"strVersion"},init:{a:"elementID, oParameters, bDebug"},isScrolling:{r:"bScrolling"},lastImage:{a:"nAnimationFrames"},nextImage:{a:"nAnimationFrames"},nextPage:{a:"nAnimationFrames"},previousImage:{a:"nAnimationFrames"},previousPage:{a:"nAnimationFrames"},printAPI:{},registerButton:{a:"DOMElement, strCommand",r:"bSuccess"},removeAllImages:{r:"bSuccess"},removeImages:{a:"arIndice"},setScrollPos:{a:"fPosition, nAnimationFrames",r:"fPosition"},startAutoRotate:{a:"fSpeed"},stopAutoRotate:{},removeListener:{a:"strListenerName, fn",r:"bSuccess"},testAPIListenersStart:{},testAPIListenersStop:{},traceConfigValue:{a:"strName"},unRegisterButton:{a:"DOMElement",r:"bSuccess"},zoomImage:{a:"nImage"}};c.oCallbacks={onAfterReplaceLabelTemplates:{a:"strLabel, oItem",r:"strNewLabel"},onBeforeReplaceLabelTemplates:{a:"strLabel, oItem",r:"strNewLabel"},onChangeConfig:{a:"strConfigFileName, oParameters"},onClick:{a:"nIndex, oItem"},onConfigsReady:{a:"oConfigValues"},onDestroy:{},onFocus:{a:"nImageIndex, strImagePath"},onInit:{a:"oParameters)"},onMetaData:{a:"oItem, oMetaData"},onMouseEnter:{a:"nIndex, oItem)"},onMouseLeave:{a:"nIndex, oItem)"},onReady:{},onReplaceTemplateValue:{a:"name, value",r:"newValue"},onResize:{a:"nWidth, nHeight, bResizeDone"},onScrollStart:{a:"fPosition"},onScrollEnd:{a:"fPosition"},onSetScrollRange:{a:"fTotalSize, fRange, bEndlessScrolling, nTotalImages"},onStart:{a:"strDirectory, nImages, arImagePaths"},onZoomEnd:{},onZoomReady:{a:"nImageIndex, strZoomedImageURL, elZoomedImage"},onZoomStart:{a:"nImageIndex, strImageURL"}}}}(window.$FSI=window.$FSI||{}));(function(a,b){if(a.ThumbBar!==b){return}a.ThumbBar=function(en,cO){var eF={};var af={strVersion:"2019",strBuild:"19.05.6483",strConfigSection:"ThumbBar",bHasListeners:true};var bB=new a.utils.ClassDef(this,"FSI ThumbBar",af);bB.oAPI=new a.utils.API.ThumbBar(this,eF);var aE=bB.instance;a.utils.guessFSIViewerLocation("fsithumbbar.js",3);var cm=a.utils.getViewerInstanceID();this.getInstanceID=function(){return cm};this.getInstanceName=function(){return bB.strClassName+" ["+D+"]"};var cG=(cO)?a.utils.cloneParameters(cO):{};var dL;var dm;var ce;var ds;var co={};var b1,dr,eC;var ef,v,eV;var bj;var U;var bJ;var bt={};var ay;var cf,d1,et;var aN={};var X;var b0={};var dF;var aB;var cd;var eu;var aT;var y;var D;var cD;var a6,aQ;var b9,dM;var du=0;var ep=false;var dh;var cY,cs,cF,T,R;var dg;var cZ;var dY={};var ag;var ew=false;var bH;var at;var cA;var aH,av,ba;var G;var c7={};var cw;var dk;var ad;var eJ=[];var c8,H;var ab;var bk,ey;var eR;var d;var bE;var dR=100;var a3;var cE=0;var ck={};var dz;var cL=0;var e;var eO=false;var d4=0;var cH;var dP;var V;var eE={};var bZ={};var dn={};var d8;var S;var ap;var B,ai;var dX;var a7;var bq;var c6;var bX={};var ct,cc;var ec;var ar;var aC={};var I;var ev=false;var ek;var bv;var by=false;var cr=false;var F;var cy,ea;var a9;var dv=false;var aU;var eY;var aY;var da;var cW;var eL;var aa,dN,bh;var dE=0;var aR=0;var aJ;var dH;var dG,bK;var bF=[];var a8;var Z;var eM={};var cM;var bp=(a.isMobileDevice)?" mobile":"";var aX={};var bs={};var cq,dB;var c9={};var ak;var c4;var d5=0;var dQ;var j;var c0;var b8;var ex;var dw={};var dW;var au;var bf;var bY={};var dO=0;var dC=0;var a5=512;var dy={ts:0,dist:0};var dt={passive:true,capture:false};var bg=/((\?)|&)(width|height)=[^&]*/ig;var bL=("filter" in document.body.style)?"filter":"webkitFilter";var x;var dq;var aK;var cJ;var Y=0;var d7=(a.isMobileDevice)?8:16;var ax=[];var a2=0;var ah,f,i;var dT="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";var eQ=true;var el;var eD;var l;var q;var r;var aD;var aS={strings:{dir:"",fpxservertemplate:"",effects:"",overlays:"",quality:"",cropRect:"",cropValues:"",format:"",presentationType:"flat",elementWidth:"10%",elementSpacing:"0.25%",placeHolderImage:"default",placeHolderPadEffect:"Pad(CC,FFFFFF)",metaDataTemplate:"details.json",autoCrop:""},booleans:{autoDestroy:true,autoResize:true,depthFadeout:true,enableZoom:true,ScrollBar:true,centerZoomedImage:true,endlessScrolling:false,useTouchZoom:true,vertical:false,autoElementSpacing:true},floats:{autoRotateSpeed:0,Alignment:1,PerspectiveAlignment:1,zoomShaderStartOpacity:0,zoomShaderEndOpacity:0.8},integers:{minElementWidth:24,minElementSpacing:0,initialImage:0,preloadCount:40,paddingTop:10,paddingBottom:0,garbageCollectionSize:-1,zoomMargin:40}};var cb=new a.EmptyDebugger();var eW=function(e1,e0){if(e0&&!cb.on&&e1.on){if(ek){ek.stopPendingRequests()}aE.destroy(true);aE.init(el,cG,true);return true}cb=e1;if(cb.on){cb.setPrefix(aE.getInstanceName())}};var b6=function(e1,e6,e0){var e3;var e2;el=e1;if(!e1){return}if(typeof(e1)==="object"){if(typeof(e1.id)==="string"){D=e1.id}}else{if(typeof(e1)==="string"){D=e1}}if(!D){D="fsi.thumbbar #"+cm}if(aE._fsi_parameters){e6=aE._fsi_parameters;delete aE._fsi_parameters}if(typeof(e1)==="object"&&e1.tagName!==b){e3=e1}else{e3=document.getElementById(e1)}if(!e3){return}if(ep){aE.destroy()}e3.setAttribute("data-fsi-id",D);cG=(e6)?a.utils.cloneParameters(e6):cG;var e7={};e7.onConfigsReady=cz;e7.onDebuggerChange=eW;ek=new a.Config(null,e7,{strSection:bB.strConfigSection});bv=eF.iCallbacks=new a.Callbacks(aE,ek);if(bv.isset("onInit")){bv.runPersistent("onInit",[cG])}var e5=cG;if(e0){e5=a.utils.cloneObject(cG);e5.debug=true}ek.init(e5);cb.log(aE.getVersion());dh=e3;e3.innerHTML="";ah=document.createElement("img");ah.crossOrigin="anonymous";ah.setAttribute("loading","eager");f=document.createElement("div");f.className="fsi-thumbbar-thumbnail";i=document.createElement("p");i.className="fsi-thumbbar-label";cY=document.createElement("div");var e4="fsi-thumbbar-root";if(a.isMobileDevice){e4+=" mobile"}cY.className=e4;e2="position:relative;width:100%;height:100%;border:0 none;margin:0px;padding:0px;overflow:hidden;";a.utils.setStyleAttr(cY,e2);cs=document.createElement("div");cs.className="fsi-thumbbar-container";e2="position:absolute;z-index:1;width:100%;height:100%;border:0 none;margin:0px;padding:0px;";e2+="text-align:left;vertical-align:top;";e2+="perspective:100px;perspective-origin:50% 100%;pointer-events:none;";if(a.isInternetExplorer){e2+="transform-style:preserve-3d;"}else{e2+="transform-style:flat;"}a.utils.setStyleAttr(cs,e2);cY.appendChild(cs);dh.appendChild(cY);aO();ep=true;eu={};ek.loadConfigs()};this.getConfigValue=function(e0){if(ek&&typeof(e0)==="string"){return ek.cfg[a.trim(e0.toLowerCase())]}};this.getParameters=function(){return a.utils.cloneParameters(cG)};var ez=function(e1){if(c7.bImageDragging){return}if(a.now()-dy.ts<25&&dy.dist>10){return}dy.ts=0;cF.style.pointerEvents="none";cs.style.pointerEvents="all";var e0=document.elementFromPoint(e1.clientX,e1.clientY);if(e0){var e2=e0.oSprite;if(!e2&&e0.parentNode){e2=e0.parentNode.oSprite}if(e2){bu(e2)}}cF.style.pointerEvents="all";cs.style.pointerEvents="none"};var bu=function(e0){if(bv.isset("onClick")){bv.run("onClick",[e0.nIndex,e0])}if(eu.enableZoom){K(e0)}if(eu.centerZoomedImage){be(e0)}};var bG=function(e0){if(e0===cF[G]){return}cF[G]=e0;c7.bIgnoreEvent=true;c7.bIgnoreEventPos=cF[G]};var dU=function(){if(c7.bIgnoreEvent){c7.bIgnoreEvent=false;var e3=c7.bIgnoreEventPos;c7.bIgnoreEventPos=false;if(cF[G]===e3){return}}if(c7.bImageDragging){if(!y.isAfterTouchRunning()){return}}var e1=(cA)?cF.offsetHeight:cF.offsetWidth;if(e1!==U){return}var e0=cF[G];var e2=cH;if(V){e2=bQ(e0,dE)}N(-e0,true,e2,1)};var bQ=function(e0,e3){var e2;var e1=Math.abs(Math.round(e0+e3));if(e1<20){e2=0}else{e2=Math.floor(Math.max(0,Math.min(20,e1/45)))}return e2};var ac=function(){em();dE=0};var eN=function(){aI();ax=[];for(var e0=0;e0<bF.length;e0++){bw(bF[e0])}cN();ab={};bY={};dY={};ax=[];bF=[];dO=0;du=0;cL=0;dV()};var em=function(){if(aB){clearTimeout(aB);aB=b}bJ=b;aT=b;ao();eN();if(bq){bq.style.display="none"}cq=0;return true};var cz=function(){em();if(bv.isset("onConfigsReady")){bv.runPersistent("onConfigsReady",[a.utils.cloneObject(ek.cfg)])}d8={};d8.nLabelHeight=0;d8.elContainer=f.cloneNode(true);cW=b;eL=b;ek.loadLanguageFile(aN,ek.cfg.language,ei,cb)};var ei=function(e1){cf=e1;d1=e1.locale||"en-US";if(ay){ay.setLanguageData(cf);ay.setLocale(d1)}et=a.utils.getNumberSeperators(ek);bv.runPersistent("onLanguageData",[cf]);var e0=ek.cfg.viewerselector;if(!e0){e0=ek.cfg.viewerid}if(e0){aE.assignFSIViewer(e0)}else{br()}};var br=function(){var e1=ek.cfg.dir;if(!e1||e1.length===0){var e0=ek.getImageList();if(e0){aZ(e0.arImages,e0)}else{aZ([],{})}}else{ek.loadImageList(ek.cfg.dir,aZ)}};var db=function(e0,e1){bv.run("onChangeConfig",[e0,e1]);if(cb.on){a.console.log("")}if(e1!==null&&typeof(e1)==="object"){cG=a.utils.cloneParameters(e1)}if(typeof(e0)==="string"){cG.cfg=e0}aE.destroy(true);cb=new a.EmptyDebugger();aE.init(el,cG)};var eT=function(e0){if(typeof(e0)!=="string"){return false}ac();ek.cfg.dir=e0;cz();return true};var aZ=function(e0,e1){if(!ep){return}if(!e0){e0=[]}cW=e1;eL=(cW&&cW.images&&cW.images[0]&&cW.images[0].width!==b&&cW.images[0].height!==b);eJ=e0;d4=e0.length;cb.log("Image list loaded ("+eJ.length+" images)");cC();aP()};var cC=function(){bo(eu)};var ej=function(e1,e0,e4,e2){for(var e3 in e4){if(e4.hasOwnProperty(e3)){e0[e3]=e1.getFloatParameter(e2+e3,e4[e3])}}};var cK=function(e1,e0,e4,e2){for(var e3 in e4){if(e4.hasOwnProperty(e3)){e0[e3]=e1.getIntParameter(e2+e3,e4[e3])}}};var b7=function(e2,e1,e0,e3){for(var e4 in e0){if(e0.hasOwnProperty(e4)){e1[e4]=e2.getStringParameter(e3+e4,e0[e4])}}};var s=function(e1,e0,e3,e2){for(var e4 in e3){if(e3.hasOwnProperty(e4)){e0[e4]=e1.makeBool(e1.getStringParameter(e2+e4),e3[e4])}}};var bS=function(e1,e0,e3,e2){var e4;if(e3&&e3.length>0){if(e0[e3]===b){e0[e3]={}}e2=e2[e3];e4=e0[e3]}else{e4=e0}if(e2.strings){b7(e1,e4,e2.strings,e3)}if(e2.booleans){s(e1,e4,e2.booleans,e3)}if(e2.floats){ej(e1,e4,e2.floats,e3)}if(e2.integers){cK(e1,e4,e2.integers,e3)}};var bo=function(e0){if(e0===b){e0={}}e0.serverBase=ek.serverBase;bS(ek,e0,"",aS);var e3=/[\dabcdef]{3,6}/i;for(var e4 in aS.strings){if(aS.strings.hasOwnProperty(e4)){if(e4.indexOf("Color")!==-1){var e2=eu[e4];if(e2.indexOf("#")!==0){var e1=e2.match(e3);if(e1){if(e1[0].length===e2.length&&(e1[0].length===3||e1[0].length===6)){eu[e4]="#"+e1[0]}}}}}}};var am=function(e2){var e1,e0;if(typeof(e2)==="string"){e0=e2.indexOf("%");e1=parseFloat(e2)}else{e0=-1;e1=e2}if(e0!==-1){e1=Math.round(aa.width*e1/100)}return{val:e1,bRelative:(e0!==-1)}};var dI=function(){var e5,e1;var e3=function(e8,e7){var e6=e7(e8);e6.width=e6.left+e6.right;e6.height=e6.top+e6.bottom;return e6};var e0=function(e8,e6){for(var e7 in e8){if(e8.hasOwnProperty(e7)){e8[e7]+=e6[e7]}}};var e4={};e4.nIndex=-1;e4.elContainer=f.cloneNode(true);e4.img=ah.cloneNode(false);e4.elContainer.appendChild(e4.img);bl(e4,true);b1=e3(e4.elContainer,a.utils.getElementBorders);dr=e3(e4.elContainer,a.utils.getElementMargins);eC=a.utils.cloneObject(b1);e0(eC,dr);ef=e3(e4.img,a.utils.getElementBorders);v=e3(e4.img,a.utils.getElementMargins);eV=a.utils.cloneObject(ef);e0(eV,v);bw(e4,true);e5=am(eu.elementWidth);if(isNaN(e5.val)){e5=am(aS.strings.elementWidth)}var e2=am(eu.minElementWidth);if(isNaN(e2.val)){e2.val=aS.integers.minElementWidth}if(e2.val>e5.val){e5=e2}e1=bX.width=e5.val;if(cA){cJ=e1-Math.ceil(eC.height+eV.height)}else{aY=e1-Math.ceil(eC.width+eV.width)}bX.widthRelative=e5.bRelative;e5=am(eu.elementSpacing);if(isNaN(e5.val)){e5=am(aS.strings.elementSpacing)}e2=am(eu.minElementSpacing);if(isNaN(e2.val)){e2.val=aS.integers.minElementSpacing}if(e2.val>e5.val){e5=e2}da=bX.spacing=e5.val;bX.spacingRelative=e5.bRelative;c1()};var z=function(){if(!cF){return}a.removeEvent(cF,"scroll",dU,dt);a.removeEvent(cF,"click",ez);if(l!==b){a4()}if(!a.isMobileDevice){a.removeEvent(cF,"mouseenter",J)}cY.removeChild(cF);cF=b};var aO=function(){cF=document.createElement("div");cF.className="fsi-thumbbar-scroll-bar";var e0="z-index:2;width:100%;height:100%;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.utils.setStyleAttr(cF,e0);R=document.createElement("div");a.utils.setStyleAttr(R,"width:1px;height:1px;visibility:hidden;");cF.appendChild(R);cY.appendChild(cF);a.addEvent(cF,"scroll",dU,dt);a.addEvent(cF,"click",ez);if(!a.isMobileDevice){a.addEvent(cF,"mouseenter",J)}};var eI=function(){if(!T){return}a.removeEvent(T,"scroll",W,dt);a.removeEvent(T,"mouseup",bI);a.removeEvent(T,"pointerup",bI);a.removeEvent(T,"touchend",bI);cY.removeChild(T);T=b};var t=function(){if(a.isInternetExplorer&&I>0){cF.style.display="";if(!T){cb.info("Using scroll bar optimization");T=document.createElement("div");T.className="fsi-thumbbar-scroll-bar fake";var e0="z-index:20;width:0px;height:0px;margin:0px;padding:0px;border:0 none;position:absolute;overflow:hidden;-webkit-overflow-scrolling:touch;";a.utils.setStyleAttr(T,e0);cY.appendChild(T);a.addEvent(T,"scroll",W,dt);a.addEvent(T,"mouseup",bI);a.addEvent(T,"pointerup",bI);a.addEvent(T,"touchend",bI)}T.style.overflowX=cF.style.overflowX;T.style.overflowY=cF.style.overflowY;while(T.firstChild){T.removeChild(T.firstChild)}T.appendChild(R.cloneNode(false));if(cA){T.style.width=I+"px";T.style.height="100%";if(eQ){T.style.bottom="";if(!c4){T.style.right="0px"}else{T.style.right=-I+"px"}cF.style.width=(cF.offsetWidth+I)+"px"}}else{T.style.width="100%";T.style.height=I+"px";if(eQ){if(!c4){T.style.bottom="0px"}else{T.style.bottom=-I+"px"}T.style.right="";cF.style.height=(cF.offsetHeight+I)+"px"}}a7=an;bq=T;dg=true}else{eI();a7=a.fnDoNothing;bq=cF;dg=false;if(c4){cF.style.display="";if(cA){cF.style.width=(cF.offsetWidth+I)+"px"}else{cF.style.height=(cF.offsetHeight+I)+"px"}}else{cF.style.display="none";cF.style.width=cF.style.height="100%"}}};var an=function(e0){T[G]=e0;c7.bIgnoreFakeEvent=true;c7.bIgnoreFakeEventPos=T[G]};var bI=function(){bG(-dE)};var W=function(){if(c7.bIgnoreFakeEvent){c7.bIgnoreFakeEvent=false;var e3=c7.bIgnoreFakeEventPos;c7.bIgnoreFakeEventPos=false;if(T[G]===e3){return}}var e1=(cA)?T.offsetHeight:T.offsetWidth;if(e1!==U){return}var e0=T[G];var e2=cH;if(V){e2=bQ(e0,dE)}N(-e0,true,e2,2)};var aP=function(){X={tpl:eu.metaDataTemplate};if(eu.autoCrop.length===2){b0.cropToFill=eu.autoCrop}else{b0.cropToFill=false}eh();ey=eu.initialImage;r=eu.useTouchZoom;if(r){if(typeof(a.TouchZoom)==="function"){ch()}else{aD=true;a.addEvent(window,"FSITouchZoomLoaded",ch)}}else{bm()}cA=eu.vertical;F=eu.presentationType.toLowerCase();by=eu.endlessScrolling;cq=eJ.length;aa=bh=dN=cB();dq=eu.autoRotateSpeed;dI();c8=a.utils.cloneArray(eJ);if(cW&&cW.images){H=a.utils.cloneArray(cW.images)}else{H=b}ab={};if(eu.autoResize===true){if(eY===b){eY=a.addCustomEvent(dh,"FSIElementDimension",aA);a.setCustomEventListenerProperty(eY,"treshold",200)}}else{if(eY!==b){a.removeCustomEvent(dh,"FSIElementDimension",aA);eY=b}}aw()};var eH=function(){var e2=bB.strClassName;if(!a.utils.cssClassExists(e2)){var e0="div.fsi-thumbbar-container .fsi-thumbbar-thumbnail{\n\tposition:absolute!important;\n\ttransform-origin: center;\n\tbox-sizing: content-box;\n\toverflow: hidden;\n\ttext-align:center;\n\tpadding:0!important;\n}\n";e0+="div.fsi-thumbbar-container .fsi-thumbbar-thumbnail > img{\n\tborder:0 none;\n\tmargin:0;\n\tdisplay:inline;\n\tbox-sizing: content-box;\n}\n";e0+="div.fsi-thumbbar-container .fsi-thumbbar-thumbnail p.fsi-thumbbar-label{\n\tposition:absolute;\n\twidth:100%;\n\tbox-sizing:border-box;\n\tbottom:0;\n\twhite-space: nowrap;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tbackground-color:#EEE;\n\tcolor:#000;\n\tfont-family:sans-serif;\n\ttext-align:center;\n\tvertical-align:middle;\n\tpadding:2px;\n\tmargin:0;\n\tfont-size:12px;\n\tline-height:normal;\n\tz-index: 1;\n}\n";e0+="div.fsi-thumbbar-container.stacks,\ndiv.fsi-thumbbar-container.ring {\n\t-webkit-transform: translate3d(0, 0, 0);\n\ttransform: translate3d(0, 0, 0);\n\t-moz-backface-visibility: hidden;\n\t-ms-backface-visibility: hidden;\n\t-webkit-backface-visibility: hidden;\n\tbackface-visibility: hidden;\n}\n";e0+="div.fsi-thumbbar-container.custom,\ndiv.fsi-thumbbar-container.ring img{\n\twill-change: transform,filter;\n}\n";e0+="div.fsi-thumbbar-container.stacks img{\n\twill-change: transform;\n}\n";e0+="div.fsi-thumbbar-container img.placeholder.none{\n\tdisplay:none;\n}\n";e0+="div.fsi-thumbbar-container img.placeholder.blank{\n\tbackground-color:#eee;\n}\n";var e1="R0lGODlhFwAXAIABAMzMzAAAACH5BAEAAAEALAAAAAAXABcAAAI5jI+py30AYwyyoiophncDvXWh9z0eiIkpqVqsOZ7wKjt2m70Gq6Nu7csBecNTjxia/ZI7I/AGjSYKADs=";e0+="div.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.default,\ndiv.fsi-thumbbar-root div.fsi-thumbbar-container img.placeholder.custom{\n\tbackground-color:#eee;\n\twidth:100%;\n\theight:100%;\n\tbackground-position:center center;\n\tbackground-repeat:no-repeat;\n\tbackground-image:url(data:image/gif;base64,"+e1+");\n}\n";e0+="div.fsi-thumbbar-shader{\n\tposition:absolute;\n\tz-index:10000;\n\tbox-sizing:border-box;\n\tbackground-color:#FFF;\n\topacity:0;\n}\n";e0+="div.fsi-thumbbar-zoom-div{\n\tposition:absolute;\n\tz-index:10001;\n\tmargin:0px!important;\n\tbox-sizing:content-box;\n\tbackground-color:#FFF;\n\tline-height:0;\n}\n";a.utils.addCSSClass(e2,e0)}};var a0=function(e1){var e0;if(eL&&cW.images[e1]){e0=cW.images[e1]}return e0};var aM=function(e1){var e0=typeof(e1);if(e0==="string"){e1=window[e1];e0=typeof(e1)}return(e0==="function")?e1:false};var aw=function(){ea=b;if(cA){G="scrollTop";aH=ed;av=dj;ba=cu}else{G="scrollLeft";aH=w;av=eG;ba=d0}a2++;cw=parseFloat(eu.Alignment);var e1;if(!isNaN(cw)){if(typeof(ek.cfg.alignment)!=="string"||ek.cfg.alignment.toLowerCase()!=="false"){if(cA){e1="center";if(cw<0.25){e1="left"}else{if(cw>0.75){e1="right"}}f.style.textAlign=e1}else{e1="middle";if(cw<0.25){e1="top"}else{if(cw>0.75){e1="bottom"}}ah.style.verticalAlign=e1}}}dk=eu.PerspectiveAlignment;if(!eu.depthFadeout){at=false}else{at=(!a.isInternetExplorer||a.versionInternetExplorer>11)}var e0=S={};if(eu.effects.length>0){e0.effects=eu.effects;eR="&effects="+eu.effects}else{eR=""}if(eu.overlays.length>0){e0.overlays=eu.overlays}if(eu.quality.length>0){e0.quality=eu.quality}if(eu.format.length>0){e0.format=eu.format}if(eu.fpxservertemplate.length>0){e0.renderer=eu.fpxservertemplate}eH();aI();ev=false;cF.style.display="";if(cA){cF.style.width="100%";ad=-1;cF.style.overflowX="hidden";cF.style.overflowY="auto";R.style.height=2*aa.width+"px";I=(cF.offsetWidth-cF.scrollWidth);U=cF.offsetHeight}else{cF.style.height="100%";ad=1;cF.style.overflowX="auto";cF.style.overflowY="hidden";R.style.width=2*aa.width+"px";I=(cF.offsetHeight-cF.scrollHeight);U=cF.offsetWidth}cF.style.display="none";c4=!eu.ScrollBar;ak=(eJ.length<2);if(ak){c4=true}V=(I>0);cH=(I>0&&!a.isChrome)?1:0;cL=0;a2++;if(eJ.length!==c8.length){eJ=a.utils.cloneArray(c8);if(H&&cW){cW.images=a.utils.cloneArray(H)}}cq=eJ.length;bx();bN();az();d8.width=aY;d8.height=cJ;dl();bb();if(!a.isMobileDevice){dc()}if(aU!==b){var e2=aU.offsetLeft/aU.nAdvance;dE=e2*dH;aU=b}dE=u(dE);cg();ev=true;if(cJ<1){cb.error("Insufficient instance height. Resulting image height is "+cJ+"px");return}dV();bk=Math.max(0,Math.min(cq-1,ey));dE=u(bk*-dH);dJ()};var az=function(){e=false;dG=aa.width/2;cr=false;var e3=F;c6=false;ai=false;switch(F){case"stacks":cZ=dK;break;case"flat":c6=true;cZ=c;cr=!by;eu.zoomCenteredImageOnly=false;if(!by){e=true;dG=dH/2}break;case"custom":var e1=aM(ek.cfg.custompresentationfunction);if(e1){B=e1}else{B=eK}e1=aM(ek.cfg.custompresentationinitfunction);if(e1){ai=e1}cZ=bi;break;default:e3="ring";ew=(F!=="innerring");cZ=bV;F="carousel";break}a.addClass(cs,e3);if(cA){dG-=co.height/2}else{dG-=co.width/2}var e0=(cA)?co.height:co.width;bK=(aa.width-e0)/2/Math.sin(1);if(F!=="stacks"){var e2;if(ew){e2=1}else{e2=0.75}bK=Math.sin(1)*(e2*aa.width)}bK=Math.round(bK);ag=10*Math.ceil(aa.width/e0);cs.style.perspective=bK+"px"};var bx=function(){bj=bH=0;da=bX.spacing;if(F==="flat"&&!by){var e1=(cA)?"height":"width";var e0=(co[e1]+da)*cq-da;if(e0<aa.width&&eu.autoElementSpacing){if(cq>1){da=(aa.width-cq*co[e1])/(cq-1);bj=da;bH=-da/2}else{da=(aa.width-co[e1])}}else{bj=da;bH=-da/2}}};this.removeAllImages=function(){if(!eJ||eJ.length<1){return false}ao();eN();eJ=[];cW={};c5();return true};this.removeImages=function(e2){var e5;var e7=[];if(typeof(e2)==="number"){e2=[e2]}if(typeof(e2)!=="object"||typeof(e2.pop)!=="function"){return e7}if(!eJ||eJ.length<1){return e7}var e8=er();ao();ax=[];var e3=function(fb,fa){return fa-fb};e2.sort(e3);var e9={};var e0=0;var e6=eJ.length-1;for(e5=0;e5<e2.length;e5++){var e1=e2[e5];if(e1<0||e1>e6){continue}if(e9[e1]){continue}e0++;var e4={};e4.nIndex=e1;e4.src=eJ[e1];eJ.splice(e1,1);e8.splice(e1,1);if(cW){if(cW.images){e4.image=cW.images[e1];cW.images.splice(e1,1)}if(cW.arConfigs){e4.iConfig=cW.arConfigs[e1];cW.arConfigs.splice(e1,1)}if(cW.arImageLists){e4.imageList=cW.arImageLists[e1];cW.arImageLists.splice(e1,1)}if(cW.arNodes){e4.node=cW.arNodes[e1];cW.arNodes.splice(e1,1)}bw(ab[e1]);e7.push(e4);delete ab[e1]}e9[e1]=true}if(e0>0){dd(e8);c5();e7.reverse()}return e7};this.addImages=function(fa,e9){ao();ax=[];if(isNaN(e9)||e9<-1||e9>=eJ.length){e9=b}if(typeof(fa)==="string"){fa=[fa]}if(typeof(fa)==="object"&&typeof(fa.pop)!=="function"){fa=[fa]}if(e9!==b){fa.reverse()}var e7=[];var e5;var e1;if(typeof(fa)!=="object"||typeof(fa.pop)!=="function"||fa.length<1){return e7}var fb=er();var fc=function(fd,fe){if(e9===b){fd.push(fe)}else{fd.splice(e9,0,fe)}};var e4=function(ff,fe){var fd;if(ff&&typeof(ff)==="object"){fd=ff;if(cW[fe]===b){cW[fe]=new Array(Math.max(0,e2-1))}switch(fe){case"arConfigs":ff=ff.clone();break;case"arImageLists":ff=a.utils.cloneObject(ff);break;case"arNodes":ff=ff.cloneNode(true);break}fc(cW[fe],ff)}else{if(cW[fe]!==b){fc(cW[fe],b)}}return fd};var e3=0;var e0;for(var e6=0;e6<fa.length;e6++){var e8=fa[e6];e5={nIndex:eJ.length};e0=b;e1=b;if(typeof(e8)==="string"&&e8.length>0){eL=false;e0=e8;e1={src:e0};e4(b,"arConfigs");e4(b,"arNodes");e4(b,"arImageLists")}else{if(typeof(e8)==="object"&&typeof(e8.src)==="string"&&e8.src.length>0){eL=false;var e2=eJ.length;e0=e8.src;if(e8.image===b){e1={src:e8.src}}else{e1=e8.image}if(e8.parameters){if(e8.iConfig===b){e8.iConfig=new a.Config();e8.iConfig.init()}e8.iConfig.setCfgValues(e8.parameters)}if(e8.iConfig&&e8.iConfig.cfg&&e8.iConfig.cfg.fpxserver===b){e8.iConfig.cfg.fpxserver=ek.cfg.fpxserver;e8.iConfig.requestBase=ek.requestBase}e4(e8.iConfig,"arConfigs");e4(e8.node,"arNodes");e4(e8.imageList,"arImageLists")}}if(e0){e3++;e5.src=e0;fc(eJ,e0);fc(fb,b);if(cW&&cW.images){fc(cW.images,e1)}if(cW&&cW.arImages&&eJ.length>cW.arImages.length){fc(cW.arImages,e0)}e7.push(e5)}}if(e3>0){dd(fb);c5();dV()}if(e9!==b){fa.reverse()}return e7};var er=function(){var e0=new Array(eJ.length);for(var e1 in ab){if(ab.hasOwnProperty(e1)){e0[ab[e1].nIndex]=ab[e1]}}return e0};var dd=function(e2){var e0={};for(var e1=0;e1<e2.length;e1++){var e3=e2[e1];if(e3){delete e3.placedX;delete e3.position;e3.nIndex=e1;e0[e1]=e3}}ab=e0};var c5=function(){var e0=c4;c8=eJ;ax=[];d4=cq=eJ.length;dl();bx();c4=!eu.ScrollBar;ak=(eJ.length<2);if(ak){c4=true}bN();bb();if(cM<=0){c4=true;bN()}dE=Math.max(dE,-cM);az();b2();if(e0!==c4){eN()}E()};var bN=function(){var e1=aa.height;if(!c4&&V){e1-=I}var e0=e1-eu.paddingTop-eu.paddingBottom;if(cA){aY=e0-Math.ceil(eC.height+eV.height);dH=Math.ceil(eV.height+eC.height)+cJ+da}else{cJ=e0-Math.ceil(eC.width+eV.width);dH=Math.ceil(eV.width+eC.width)+aY+da}f.style.width=(aY+eV.width)+"px";i.style.width=f.style.width;f.style.height=(cJ+eV.height)+"px";f.style.lineHeight=(cJ-2)+"px";c1()};var c1=function(){co.width=eV.width+eC.width+aY;co.height=eV.height+eC.height+cJ};var cg=function(){var e0;if(cA){e0=eu.paddingTop+dk*co.width;cs.style.perspectiveOrigin=e0+"px "+aa.width/2+"px"}else{e0=eu.paddingTop+dk*co.height;cs.style.perspectiveOrigin=aa.width/2+"px "+e0+"px"}};var dJ=function(){ap=b;if(cA){d8.width=Math.min(d8.width,d8.height)}else{d8.height=Math.min(d8.width,d8.height)}if(eu.placeHolderImage.length<1){eu.placeHolderImage="none"}var e1=eu.placeHolderImage.toLowerCase();switch(e1){case"blank":case"default":case"custom":ah.src=dT;ah.className=dM="placeholder "+e1+bp;d8.nMode=1;o();break;case"none":ah.className=dM="placeholder none"+bp;o();d8.nMode=1;break;default:ah.className=dM="placeholder image"+bp;d8.nMode=2;var e2=a0(0);if(e2){eo(null,e2)}else{var e0=ek.getImageInfoURL(eJ[bk]);ek.loadFile(e0,eo)}}};var eo=function(e2,e0){cS(d8,e0);var e1=a.utils.fitImageIntoSpace(d8.maxWidth,d8.maxHeight,aY,cJ);d8.width=e1.width;d8.height=e1.height;d8.bHasPadEffect=true;ah.src=de(d8,eu.placeHolderImage,{effects:eu.placeHolderPadEffect});o()};var bW=function(){if(!ek.cfg.imagelistparameterfilternegative&&!ek.cfg.imagelistparameterfilterpositive){if(!aT||aT.nItems){aT={}}return}if(ek.cfg.imagelistparameterfilterpositive){aT=ek.getParameterFilterFromString(ek.cfg.imagelistparameterfilterpositive,true)}else{aT=ek.getParameterFilterFromString(ek.cfg.imagelistparameterfilternegative,false)}};var o=function(){if(!cy&&eu.enableZoom){if(!ds){ds=a.addCustomEvent(aE,"FSIViewport",dp);a.setCustomEventListenerProperty(ds,"treshold",150);a.setCustomEventListenerProperty(ds,"fireTresholdEventOnly",true);a.triggerCustomEvent(ds)}}else{if(ds){a.removeCustomEvent(aE,"FSIViewport",dp);ds=b}}d={scope:aE,elementID:D,nMaxThumbWidth:dH,totalWidth:aa.width,totalHeight:aa.height,nPerspective:bK,nHorizontalFactor:ad};if(ai){ai.apply(this,[d])}dA();if(by){var e1=0;var e0=function(){for(var e2 in cW){if(cW.hasOwnProperty(e2)){if(typeof(cW[e2].concat)==="function"){cW[e2]=cW[e2].concat(cW[e2])}}}};while(eJ.length<=bF.length+2){e1++;eJ=eJ.concat(eJ);if(cW){e0()}cq=eJ.length}}dB=cq-1;bb();if(cM<=0&&!c4){c4=true;eN()}bN();if(eu.garbageCollectionSize<0){if(a.isMobileDevice){a3=2*(eu.preloadCount+bF.length)}else{a3=Math.max(250,6*(eu.preloadCount+bF.length))}}else{if(eu.garbageCollectionSize===0){a3=cq}else{a3=Math.max(eu.preloadCount+bF.length,eu.garbageCollectionSize)}}b2();bq.style.display="";if(eu.preloadCount>0){c9.bEnabled=true;cD=ci}else{c9.bEnabled=false;cD=a.fnDoNothing}p();if(dq){di()}bE=a.now();if(a3<cq){cb.info("Enabling garbage collection (max. "+a3+" images)")}else{cb.info("Garbage collection disabled");cj()}bG(-dE);if(dg){an(-dE)}cx();bv.run("onReady")};var b2=function(){var e0;if(e){e0=dH*cq-bj}else{e0=aa.width+(dH*cq);if(!by){e0-=dH}}bv.runPersistent("onSetScrollRange",[e0,e0-aa.width,by,cq]);if(cA){R.style.height=e0+"px";if(c6){cs.style.height=e0+"px"}}else{R.style.width=e0+"px";if(c6){cs.style.width=e0+"px"}}t();bq.style.display=""};var dp=function(e0){a6=e0.FSI_viewport_rect;aQ=e0.FSI_client_rect_body_top};var eh=function(){if(document.querySelectorAll===b){return}var e0=ek.cfg.cmdbuttonselector;if(typeof(e0)!=="string"){return false}var e3=document.querySelectorAll(e0);for(var e1=0;e1<e3.length;e1++){var e2=e3[e1].getAttribute("data-fsi-cmd");if(e2===null){e2=e3[e1].getAttribute("x-fsi-cmd")}if(typeof(e2)==="string"&&e2.length>0){cb.log("Registering button from config for command: "+e2);aE.registerButton(e3[e1],e2)}}ek.cfg.cmdbuttonselector=b};var dl=function(){if(cq<1){ec=eq}else{if(cr){ec=cU}else{ec=dx}}};var cx=function(){if(bv.isset("onStart")){bv.runPersistent("onStart",[eu.dir,eJ.length,a.utils.cloneArray(eJ)])}aV(0);bO()};var bb=function(){cM=cq*dH;if(!by){if(F==="flat"){cM-=aa.width}else{cM-=dH}cM-=bj;cM=Math.max(0,cM)}cM=Math.round(cM)};var dc=function(){if(!aa||aa.width<1||aa.height<1){return false}if(a.isIETouch){cY.style.msTouchAction="pan-y pinch-zoom double-tap-zoom"}if(!y){var e0={};e0.bMouseOnly=true;e0.afterTouch={enabled:true};e0.afterTouch.factorAmount=25;e0.afterTouch.factorFrames=3;e0.afterTouch.minFrames=5;e0.afterTouch.offsetFrames=1;e0.afterTouch.useAnimationFrame=true;e0.detectGestures=false;y=new a.TouchHandler(cF,e0,cQ,L,dZ);y.setCapture(true,false)}};var cQ=function(e0,e2){dy.ts=0;bs.x=e2.x;bs.y=e2.y;if(I>0){var e1=a.getBoundingClientRect(cF);if(cA){if(e2.x-e1.left>e1.width-I){return false}}else{if(e2.y-e1.top>e1.height-I){return false}}}eZ();dq=0;cancelAnimationFrame(Z);Z=b;y.enableAfterTouch(true);c7.bImageDragging=true;aX.startX=bs.x;aX.startY=bs.y;aX.offsetLeft=dE;E();return true};var L=function(e0,e2){bs.x=e2.x;bs.y=e2.y;if(c7.bImageDragging){if(cA){aX.dy=bs.x-aX.startX;aX.dx=bs.y-aX.startY}else{aX.dx=bs.x-aX.startX;aX.dy=bs.y-aX.startY}if(!eO){es(true)}var e1=dE;dE=u(aX.offsetLeft+aX.dx);E();if(dg){a7(-dE)}else{bG(-dE)}if(e1===dE||Math.abs(aX.dy)>3*Math.abs(aX.dx)){e0.FSI_allowEventDefault=true}}};var dZ=function(e1,e4){bs.x=e4.x;bs.y=e4.y;if(c7.bImageDragging){c7.bImageDragging=false;es(false);if(dg){bG(-dE)}}var e2=e4.x-e1.FSI_start_x;var e0=e4.y-e1.FSI_start_y;var e3=Math.sqrt(e2*e2+e0*e0);dy.ts=a.now();dy.dist=e3;E()};var P=function(e2,e3){var e0=false;e3=Math.ceil(e3);if(isNaN(e3)||e3<0){e3=0}if(isNaN(e2)){return false}e2=e2%cM;var e1=N(-e2,false,e3);if(e1!==false){e0=eM.end}return e0};var eA=function(e0){c7.bSetIsScrolling=e0;if(dP){clearTimeout(dP)}dP=setTimeout(Q,100)};var Q=function(){es(c7.bSetIsScrolling);dP=b;c9.nLoad=Math.min(cq,eu.preloadCount);ct()};var es=function(e0){if(dP){clearTimeout(dP);dP=b}if(e0===eO){return}eO=e0;if(eO){bv.run("onScrollStart",[-dE])}else{bv.run("onScrollEnd",[-dE])}if(!eO&&dm){cN()}};var aV=function(e0){d5=e0;bf=b;if(bv.isset("onFocus")){var e1=ab[e0];if(e1){bv.runPersistent("onFocus",[e1.nIndex,eJ[e1.nIndex]])}}};var bO=function(){if(!ep||!cy||a9||!ab||!ab[bk]){return}M(ab[bk]);a9=true;cP(ab[bk]);bJ=ab[bk].nIndex};var cP=function(e4){if(!e4||!cy||typeof(cy.changeImage)!=="function"){return}if(ea===e4.nIndex&&!e4.iConfig){return}ea=e4.nIndex;var e5={};var e2;if(cW.arConfigs){e2=cW.arConfigs[e4.nIndex]}if(e2){e2.cloneParameters(e2.cfg,e5)}var e0=false;var e6=false;var e7;if(cW.arImageLists){e7=cW.arImageLists[e4.nIndex]}if(e7&&e7.arImages){e5.fpxsources=e7.arImages.join(",");if(e5.fpxsources===cy.getConfigValue("fpxsources")){e0=true}}else{e5.fpxsrc=eJ[e4.nIndex];var e9=decodeURIComponent(cy.getConfigValue("fpxsrc"));if(e5.fpxsrc===e9){e0=true}else{e6=true}}e5.imageWidth=e4.sourceWidthNoPadEffect;e5.imageHeight=e4.sourceHeightNoPadEffect;if(!e2||!e2.cfg){e5.cropRect=ek.cfg.croprect;e5.cropValues=ek.cfg.cropvalues;e5.effects=ek.cfg.effects;e5.fpxServerTemplate=ek.cfg.fpxservertemplate;e5.imageFormat=ek.cfg.imageformat}else{e6=true;if(e0){if(aT===b){bW()}var e1=new a.Config();e1.init();var e3=b;if(cW.arNodes&&cW.arNodes[e4.nIndex]){e3=cW.arNodes[e4.nIndex]}e1.cfg={};e1.setParameterFilter(aT);if(e3){e1.parseConfig(e3,e3)}else{e1.setCfgValues(e2.cfg)}if(e1&&aF(e1.cfg)){e6=false}}}if(e6){if(e5.effects){e5.effects="ClearEffects(),"+e5.effects}var e8=(e2&&e2.cfg.cfg)?e2.cfg.cfg:b;cy.changeConfig(e8,e5)}else{if(!e0){cy.changeImage(e5)}if(e2&&e2.cfg){if(e2.cfg.initialview){cy.gotoViewString(e2.cfg.initialview,true)}else{cy.resetView(true)}}else{if(e0){cy.resetView(true)}}}};var cI={initialview:true,thumblabel:true};var aF=function(e0){var e1=true;for(var e2 in e0){if(e0.hasOwnProperty(e2)){if(!cI[e2]&&e2.indexOf(".node")===-1){e1=false;break}}}return e1};var K=function(fa){if(fa.bError){return}bJ=fa.nIndex;M(fa);if(cy!==b){cP(fa);return}d6(b,true);if(!fa.bReady){return}var fm=document.body.scrollWidth;var fg=document.body.scrollHeight;var fo=a.utils.getDocumentScaleWithPixelRatio();var fd=a6.left-aQ.left;var e2=a6.top-aQ.top;dQ=document.createElement("div");j=document.createElement("div");j.style.willChange="opacity";b8=document.createElement("img");dw.alphaShader=0;dQ.setAttribute("class","fsi-thumbbar-zoom-div");ex=fa.nIndex;c0=fa.img.cloneNode(true);c0.style.transform="";c0.style.position="static";c0.style[bL]="none";var fh=a.getBoundingClientRect(fa.img);c0.style.width=c0.style.height="100%";dQ.appendChild(c0);document.body.appendChild(dQ);var e1=a.getElementClientPos(document.body);var ff=-e1.left;var fe=-e1.top;var e6=a.utils.getElementBorders(dQ);var e4=a.utils.getElementPaddings(dQ);dw.startX=ff+fh.left-e6.left;dw.startY=fe+fh.top-e6.top;dw.startWidth=fh.width;dw.startHeight=fh.height;dQ.style.width=dw.startWidth+"px";dQ.style.height=dw.startHeight+"px";dQ.style.left=dw.startX+"px";dQ.style.top=dw.startY+"px";dQ.style.willChange="left,top,width,height";var fn=a.getViewportSize(window);a.addEvent(j,"mousedown",d6,false);a.addEvent(window,"touchstart",d6,{passive:false});a.addEvent(dQ,"mousedown",d6,false);a.addEvent(window,"scroll",d6,false);var fl=Math.ceil(eu.zoomMargin/fo);var e7=fn.width-fl-e6.left-e6.right-e4.left-e4.right;var e8=fn.height-fl-e6.top-e6.bottom-e4.top-e4.bottom;var fb=fa.maxWidth;var fk=fa.maxHeight;var fi=a.utils.fitImageIntoSpace(fb,fk,e7,e8);fb=fi.width;fk=fi.height;dw.endWidth=fb;dw.enddHeight=fk;dw.dWidth=fb-dw.startWidth;dw.dHeight=fk-dw.startHeight;dw.endX=fd+Math.round((fn.width-fb-e6.left-e6.right-e4.left-e4.right)/2);dw.endY=e2+Math.round((fn.height-fk-e6.top-e6.bottom-e4.top-e4.bottom)/2);dw.dx=dw.endX-dw.startX;dw.dy=dw.endY-dw.startY;var e9="left:"+fd+"px;top:"+e2+"px;";if(fo===1){e9+="width:100%;height:100%"}else{var e3=a6.width();var fc=a6.height();if(fd+e3>fm){e3-=fd+e3-fm}if(e2+fc>fg){fc-=e2+fc-fg}e9+="width:"+e3+"px;height:"+fc+"px"}dw.bImageReady=false;var e5=fa.img.src;e5=e5.replace(bg,"$1");var e0=Math.min(fa.maxWidth,Math.round(fo*fb));var fj=Math.min(fa.maxHeight,Math.round(fo*fk));e5+="&width="+e0+"&height="+fj;aK=true;a.addEvent(b8,"load",b3,false);b8.style.width=dw.endWidth+"px";b8.style.height=dw.endHeight+"px";b8.setAttribute("crossorigin","anonymous");b8.src=e5;dw.pos=0;dw.frames=bU(32);a.utils.setStyleAttr(j,e9);j.setAttribute("class","fsi-thumbbar-shader");document.body.appendChild(j);dw.alphaShader=eu.zoomShaderStartOpacity;cancelAnimationFrame(dW);dW=requestAnimationFrame(a1);dw.posFader=0;dw.framesShader=bU(12);dw.startAlpha=dw.alphaShader;dw.endAlpha=eu.zoomShaderEndOpacity;dw.dAlpha=dw.endAlpha-dw.startAlpha;dw.bRemoveOnEnd=false;au=requestAnimationFrame(g);bv.run("onZoomStart",[fa.nIndex,e5]);if(!a.isMobileDevice){a.addEvent(window,"resize",d6,false)}else{a.addEvent(window,"orientationchange",d6,false)}};var bz=a.Easing.easeOutCubic;var a1=function(){dw.pos++;if(dw.pos>dw.frames){dW=b;requestAnimationFrame(c2);return}var e0=bz(dw.pos,dw.frames,dw.startX,dw.dx);var e3=bz(dw.pos,dw.frames,dw.startY,dw.dy);var e1=bz(dw.pos,dw.frames,dw.startWidth,dw.dWidth);var e2=bz(dw.pos,dw.frames,dw.startHeight,dw.dHeight);dQ.style.left=e0.toFixed(2)+"px";dQ.style.top=e3.toFixed(2)+"px";dQ.style.width=e1.toFixed(2)+"px";dQ.style.height=e2.toFixed(2)+"px";dW=requestAnimationFrame(a1)};var c2=function(){if(!dQ||!dw.bImageReady||dW!==b){return}dQ.replaceChild(b8,dQ.firstChild);dQ.firstChild.style.width=b8.style.width;dQ.firstChild.style.height=b8.style.height;dQ.firstChild.src=b8.src;dQ.style.width="";dQ.style.height="";dQ.style.willChange="auto";j.style.willChange="auto";bv.run("onZoomReady",[ex,b8.src,b8]);b8=b};var b3=function(){dw.bImageReady=true;a.removeEvent(b8,"load",b3,false);aK=false;c2()};var d6=this.closeZoom=function(e0,e1){if(!dQ){return}bJ=b;M();bf=b;if(!a.isMobileDevice){a.removeEvent(window,"resize",d6,false)}else{a.removeEvent(window,"orientationchange",d6,false)}if(au){cancelAnimationFrame(au);au=b}cancelAnimationFrame(dW);dW=b;a.removeEvent(j,"mousedown",d6,false);a.removeEvent(dQ,"mousedown",d6,false);a.removeEvent(window,"touchstart",d6,{passive:false});a.removeEvent(window,"scroll",d6,false);if(aK){a.removeEvent(b8,"load",b3,false)}if(b8){b8=b}a.removeChild(dQ.parentNode,dQ);dQ=b;if(e1===true){a.removeChild(j.parentNode,j);j=b}else{j.style.willChange="opacity";dw.posFader=0;dw.framesShader=10;dw.startAlpha=dw.alphaShader;dw.endAlpha=0;dw.dAlpha=dw.endAlpha-dw.startAlpha;dw.bRemoveOnEnd=true;au=requestAnimationFrame(g)}bv.run("onZoomEnd");if(e0&&e0.touches&&e0.touches.length===1){e0.cancelBubble=true;if(e0.stopPropagation){e0.stopPropagation()}if(e0.preventDefault){e0.preventDefault()}}ex=b};var cT=function(e0){j.style.opacity=dw.alphaShader=e0};var g=function(){dw.posFader++;if(dw.posFader>dw.framesShader){if(dw.bRemoveOnEnd){a.removeChild(j.parentNode,j);j=b}au=b;return}var e0=bz(dw.posFader,dw.framesShader,dw.startAlpha,dw.dAlpha,3);cT(e0);au=requestAnimationFrame(g)};var be=function(e1,e0){if(!e1){return false}aV(e1.nIndex);return N(-e1.nIndex*dH,e0,30)};var u=function(e0){if(by){e0=Math.round(e0)%cM;if(e0>0){e0-=cM}}else{e0=Math.min(0,Math.max(-cM,e0))}return e0};var bU=function(e0){if(a.isMobileDevice){e0=Math.ceil(e0/1.3)}return e0};var N=function(e4,e1,e3,e0){if(ak){return}if(e3===b){e3=40}if(e3>0){e3=bU(e3)}eZ();if(by&&!e1){e4=u(e4);dE=u(dE);var e2=e4-dE;if(Math.abs(e2)>cM/2){if(e2>0){e4=-cM+e4}else{e4=cM+e4}}}if(!by){e4=Math.min(0,Math.max(e4,-cM))}if(e4===dE||(Z!==b&&e4===eM.end)){return false}es(true);cancelAnimationFrame(Z);Z=b;eM.frames=e3;eM.pos=0;eM.nScrollBarID=e0;eM.start=dE;eM.end=e4;if(!e0&&((by&&e1)||!by)){eM.end=u(eM.end)}eM.diff=eM.end-eM.start;if(e3<1){n()}else{Z=requestAnimationFrame(n)}return true};var n=function(){eM.pos++;if(eM.pos>=eM.frames){dE=u(eM.end);if(eM.bUpdateVisibleScrollBar){bq[G]=-dE}eA(false);Z=b;p();cp();if(dg&&eM.nScrollBarID!==2){a7(-dE)}if(!eM.nScrollBarID){bG(-dE)}eB();return}dE=u(bz(eM.pos,eM.frames,eM.start,eM.diff,3));if(dg&&eM.nScrollBarID!==2){a7(-dE)}else{if(!eM.nScrollBarID){bG(-dE)}}p();cp();Z=requestAnimationFrame(n)};var bA=function(e1){var e0=ek.getImageInfoURL(e1.imagePath,X);ek.loadFile(e0,dD,b,e1)};var cX=function(e2){if(e2.oTemplate&&e2.oTemplate.bNeedsMetaData){bA(e2)}else{if(eL){var e1=e2.oInfo=a0(e2.nIndex);eg(e2,e1)}else{e2.bInfoLoading=true;var e0=ek.getImageInfoURL(eJ[e2.nIndex]);ek.loadFile(e0,m,b,e2)}}};var m=function(e0,e1,e2){if(typeof(e1)==="object"){e2.oInfo=e1;e1.width=parseInt(e1.width);e1.height=parseInt(e1.height);if(isNaN(e1.width)){eb.call(e2.img)}}eg(e2,e1)};var cS=function(e1,e0){if(e1.bImageInfoCalculated){return}e1.bImageInfoCalculated=true;e1.nThumbnailDimWidth=aY;e1.nThumbnailDimHeight=cJ;e1.bInfoReady=true;e1.sourceWidth=e1.sourceWidthNoPadEffect=e0.width;e1.sourceHeight=e1.sourceHeightNoPadEffect=e0.height};var eg=function(e1,e0){if(!ep){return}if(!e0||!e1||e1.nStartID!==a2){return}if(e1.oTemplate&&e1.oTemplate.bNeedsMetaData&&!e1.oMetaData){return}e1.oInfo=e0;cS(e1,e0);eS(e1)};var bn=function(e0){if(cA){e0.offsetX=0;e0.offsetY=eu.paddingTop}else{e0.offsetX=0;e0.offsetY=eu.paddingTop}};var de=function(e4,e3,e1){if(e1===b){e1=S}var e0=ek;if(e4.iConfig){e0=e4.iConfig}e1.width=e4.width;if(e4.bHasPadEffect){e1.height=e4.height-e4.nLabelHeight}var e2=e0.getImageURLAsInViewer(e3,e4.sourceWidth,e4.sourceHeight,aY,cJ-e4.nLabelHeight,null,e1,b0);e4.maxWidth=e2.srcArea.width;e4.maxHeight=e2.srcArea.height;if(d8.nMode===1&&e4.img&&e2.dimFit){e4.img.style.width=e2.dimFit.width+"px";e4.img.style.height=e2.dimFit.height+"px"}return e2.url};var eS=function(e2){if(!e2.bInfoReady||e2.bThumbLoadStarted){return false}e2.imageURL=de(e2,e2.imagePath);e2.tsRemovedFromDOM=bE;var e0=e2.img;e2.nThumbnailDimWidth=aY;e2.nThumbnailDimHeight=cJ;e2.bThumbLoadStarted=true;e2.nStartID=a2;if(e2.width<1||e2.height<1){eb.call(e0)}else{Y++;aC[e2.nIndex]=e2;e2.bHasEvents=true;a.addEvent(e0,"load",cV);a.addEvent(e0,"error",eb);var e1=e2.imageURL;if(ek.hasImageParameterConditions){e1=ek.reWriteImageURLByConditions(e1)}e2.src=e0.src=e1}return true};var bC=function(e0){return(e0.nThumbnailDimWidth===aY&&e0.nThumbnailDimHeight===cJ)};var aj=function(e0){return(e0&&e0.nStartID===a2)};var bD=function(e0){if(e0.bHasEvents===true){delete aC[e0.nIndex];a.removeEvent(e0.img,"load",cV);a.removeEvent(e0.img,"error",eb);e0.bHasEvents=false}};var eb=function(e0){var e1=this.parentNode.oSprite;if(!e1){return}e1.bReady=false;e1.bError=true;if(isNaN(e1.sourceWidth)||isNaN(e1.sourceHeight)){e1.width=e1.sourceWidth=e1.maxWidth=d8.width;e1.height=e1.sourceHeight=e1.maxHeight=d8.height}e1.bLoadComplete=true;e1.bThumbLoading=false;e1.img.src=dT;e1.img.className="placeholder blank error";if(aj(e1)&&e0){Y--}bD(e1);ct()};var cV=function(){var e0=this.parentNode.oSprite;if(!e0||!ep){return}e0.img.style.width=e0.img.style.height="";bD(e0);if(e0.bLoadComplete||!aj(e0)){return}Y--;if(!bC(e0)){return}e0.bReady=true;e0.bLoadComplete=true;e0.placedX=b;a.removeClass(e0.img,dM);if(e0.bVisible){ee(e0)}cp();bY[e0.nIndex]=e0;dO++;if(b9&&b9.nIndex===e0.nIndex){M(e0)}ct();if(dO>=a3){ca()}};var ee=function(e0){if(!r||!e0.bReady){return}if(!e0.imgInOtherViewers){e0.imgInOtherViewers=e0.img;bZ[e0.nIndex]=e0;delete dn[e0.nIndex];ae(true)}};var eP=function(e0){if(!r||!e0.bReady){return}if(e0.imgInOtherViewers){delete e0.imgInOtherViewers;dn[e0.nIndex]=e0;bZ[e0.nIndex]=b;delete bZ[e0.nIndex];ae(true)}};var ae=function(e0){if(dm!==e0){dm=e0;if(ce===b&&!eO){ce=setTimeout(cN,500)}}};var ch=function(){if(aD){a.removeEvent(window,"FSITouchZoomLoaded",ch);aD=false}if(!dL){var e0={debug:false,useimagetiles:false,imgsrcattributename:"src",scanOnInit:false};dL=new a.TouchZoom(e0);dL.init(false,null,cb.on,false,true)}if(dm){var e1=dm;dm=b;ae(e1)}};var cN=function(){ce=b;if(!dm||!dL||eO){return}ae(false);var e2,e0;var e1=dL.getInstanceID();for(e2 in bZ){if(bZ.hasOwnProperty(e2)&&bZ[e2]){bZ[e2].img.FSITouchZoomInstanceID=e1;dL.addImage(bZ[e2].img,bZ[e2].oInfo)}}e0=[];for(e2 in dn){if(dn.hasOwnProperty(e2)&&dn[e2]){e0.push(dn[e2].img)}}if(e0.length>0){dL.removeImages(e0)}bZ={};dn={}};var cp=function(){if(bf===b){return}var e0=A(bf);if(!e0.bReady||!al(e0)){return}K(e0);bf=b};var J=function(e0){if(!bv.isset("onMouseEnter")&&!bv.isset("onMouseLeave")){return}l=e0;eD={};a.addEvent(cF,"mouseleave",a4);a.addEvent(cF,"mousemove",d3)};var a4=function(){a.removeEvent(cF,"mouseleave",a4);a.removeEvent(cF,"mousemove",d3);if(q!==b){clearTimeout(q)}q=b;if(eD.nIndex!==b){bv.run("onMouseLeave",[eD.nIndex,eD])}eD={};l=b};var d3=function(e0){l=e0;eB()};var eB=function(){if(!l){return}if(q===b){q=setTimeout(df,100)}};var df=function(){q=b;cF.style.pointerEvents="none";cs.style.pointerEvents="all";var e1=document.elementFromPoint(l.clientX,l.clientY);cF.style.pointerEvents="all";cs.style.pointerEvents="none";var e0;if(e1&&e1.parentNode&&e1.parentNode.oSprite){e0=e1.parentNode.oSprite.nIndex}if(eD.nIndex!==e0){if(eD.nIndex!==b){bv.run("onMouseLeave",[eD.nIndex,eD])}if(e0===b){eD={}}else{eD=e1.parentNode.oSprite;bv.run("onMouseEnter",[eD.nIndex,eD])}}};var A=function(e2,e5){e2%=cq;if(e2<0){e2+=cq}var e4=ab[e2];if(e4===b){du++;e4=ab[e2]={};e4.nStartID=a2;e4.nIndex=e2;e4.imagePath=eJ[e4.nIndex];if(cW&&cW.arConfigs&&cW.arConfigs[e4.nIndex]){e4.iConfig=cW.arConfigs[e4.nIndex]}}if(!e4.img){e4.elContainer=f.cloneNode(true);e4.nLabelHeight=0;e4.elContainer.oSprite=e4;if(e4.label===b){var e3;if(cW.arNodes){e3=cW.arNodes[e4.nIndex]}if(e3&&e3.getAttribute("label")){e4.label=e3.getAttribute("label")}if(!e4.label){var e0=e4.iConfig||ek;e4.label=e0.cfg.thumblabel}dS(e4)}var e1=e4.img=ah.cloneNode(false);if(r){e1.FSITouchZoomInstanceID=-1}if(e4.oTemplate){e4.elLabel=i.cloneNode(true);e4.elLabel.innerHTML=e4.label;e4.elContainer.appendChild(e4.elLabel);e4.nLabelHeight=O(e4);e4.elContainer.style.lineHeight=(cJ-2-e4.nLabelHeight)+"px"}e4.elContainer.appendChild(e1);if(e4.bPurged){delete e4.bPurged}else{bn(e4);if(d8.nMode===1&&eL){cS(e4,cW.images[e2])}else{e4.width=d8.width;e4.height=d8.height;e1.style.width=d8.width+"px";e1.style.height=d8.height+"px"}}}if(e5&&!e4.bImageLoadStarted){ax.push(e4)}return e4};var O=function(e3){var e1=!e3.bAppended;if(e1){bl(e3,true)}var e2=e3.elLabel.getBoundingClientRect();var e0=e2.height;if(e1){bw(e3,true)}return e0};var bM=function(){var e0={oLanguageData:cf,bItemsHaveWidthAndHeight:eL,oNumberSeperators:et,strLocale:d1};if(bv.isset("onReplaceTemplateValue")){e0.fnCallbackReplace=aW}ay=new a.MetaDataReplacer(e0)};var aW=function(e1,e2){var e0=bv.run("onReplaceTemplateValue",[e1,e2]);if(e0!==b){e2=e0}return e2};var dS=function(e2){var e1;if(typeof(e2.label)==="string"&&e2.label.length>0){e2.label=decodeURIComponent(e2.label);e1=bv.run("onBeforeReplaceLabelTemplates",[e2.label,e2]);if(e1===false){e2.label=b;return}else{if(typeof(e1)==="string"){e2.label=e1}}if(!bt[e2.label]){bt[e2.label]=true;if(!ay){bM()}bt[e2.label]=ay.parseTemplate(e2.label)}e2.oTemplate=bt[e2.label];if(e2.oTemplate.bHasPlaceHolders){if(eL&&e2.oTemplate.bNeedsImageDim){var e0=cW.images[e2.nIndex];e2.sourceWidth=parseInt(e0.width);e2.sourceHeight=parseInt(e0.height)}e2.label=ay.replaceBasic(e2,e2.oTemplate)}d2(e2)}else{e2.label=b}};var d2=function(e1){if(bv.isset("onAfterReplaceLabelTemplates")){var e0=bv.run("onAfterReplaceLabelTemplates",[e1.label,e1]);if(e0===false){e1.label=b}else{if(typeof(e0)==="string"){e1.label=e0}}}};var dD=function(e0,e1,e2){e2.oMetaData=e1;if(bv.isset("onMetaData")){bv.run("onMetaData",[e2,e1])}if(e2.sourceWidth===b){e2.sourceWidth=parseInt(e1.width);e2.sourceHeight=parseInt(e1.height)}e2.label=ay.replaceAll(e2,e2.oTemplate);d2(e2);if(e2.elLabel){e2.elLabel.innerHTML=e2.label;e2.nLabelHeight=O(e2);e2.elContainer.style.lineHeight=(cJ-2-e2.nLabelHeight)+"px"}m(e0,e1,e2)};var dV=function(){ct=cv;cc=aL};var aI=function(){ct=cc=a.fnDoNothing;if(ar){clearTimeout(ar);ar=b}};var cv=function(){if(!ar){ar=setTimeout(aL,25)}};var aL=function(){if(ar){clearTimeout(ar);ar=b}cD();while(ax.length>0&&Y<d7){var e0=ax.shift();if(!e0.bImageLoadStarted){e0.bImageLoadStarted=true;cL++;if(cL===cq&&a3>=cq){aI()}cX(e0)}}};var bR=function(e2,e0){if(!by){if(e2<0||e2>=cq){return 0}}var e1;var e3=A(e2);if(e0!==e3.position){e3.position=e0;e1=cZ(e3);if(e1&&!e3.bVisible){bl(e3)}e3.bVisible=e3.calculatedRet=e1}else{e1=e3.calculatedRet;if(e1&&!e3.bVisible){bl(e3)}e3.bVisible=e1}if(e3.bVisible){bF.push(e3);if(!e3.bImageLoadStarted){ax.push(e3)}}return e3.bVisible};var bV=function(e4){var e2,e3;e2=e4.position/bK;e3=Math.cos(e2);e4.z=e3;if(e3<0.5){return 0}e4.x=dG+bH+e4.offsetX+Math.sin(e2)*bK;e4.y=e4.offsetY;var e1=e4.elContainer.style;if(ew){av(e4.elContainer,e4.x,e4.y,-bK+bK*e4.z,ad*e2)}else{av(e4.elContainer,e4.x,e4.y,bK-bK*e4.z,-ad*e2)}if(at){var e0=(Math.round(120*e3)-20)/100;if(e0<0.99){e1[bL]="brightness("+e0+")"}else{e1[bL]="none"}}return 1};var dK=function(e2){var e0=dG+bH+e2.position+e2.offsetX;if(e0+3*dH<=0||e0>=aa.width+3*dH){return 0}e0=Math.max(-bK,Math.min(e2.position,bK));var e1=e2.position/bK;e2.z=Math.cos(e1);e2.x=dG+e2.offsetX+Math.sin(e0/bK)*bK;e2.y=e2.offsetY;aH(e2.elContainer,e2.x,e2.y);e2.elContainer.style.zIndex=ag+Math.round(ag*e2.z);return 1};var c=function(e0){e0.x=dG+bH+e0.position+e0.offsetX;if(e0.x+dH<=0||e0.x>=aa.width){return 0}e0.x=Math.round(e0.x-dE);e0.y=e0.offsetY;if(e0.x!==e0.placedX){e0.placedX=e0.x;if(cA){e0.elContainer.style.left=e0.y+"px";e0.elContainer.style.top=e0.x+"px"}else{e0.elContainer.style.left=e0.x+"px";e0.elContainer.style.top=e0.y+"px"}}return 1};var eK=function(e0){if(e0.x+dH<=0||e0.x>=aa.width){return 0}return 1};var bi=function(e1){e1.x=dG+e1.position+e1.offsetX;e1.y=e1.offsetY;e1.z=0;var e0=B.apply(d.scope,[d,e1]);if(e0){ba(e1)}return e0};var al=function(e0){return(e0&&e0.bVisible)};var dA=function(){if(ax.length>0){ax=[]}bF=[];var e3;var e1=u(dE);e3=Math.floor(-e1/dH);var e0=e1%dH;bR(e3,e0);var e2=ec(e3,e0);if(c9.bEnabled){c9.nLastLeftImage=e3-e2+1;c9.nLastRightImage=e3+e2-1;if(Z===b&&!eO){c9.nLoad=Math.min(cq,eu.preloadCount)}else{c9.nLoad=0}}};var bl=function(e1,e0){if(!e1.bAppended){dY[e1.nIndex]=e1;e1.bAppended=true;cs.appendChild(e1.elContainer);if(!e0){ee(e1)}}};var bw=function(e1,e0){if(e1.bAppended){e1.bAppended=false;if(!e0){eP(e1)}cs.removeChild(e1.elContainer);e1.tsRemovedFromDOM=bE;delete dY[e1.nIndex]}};var eq=function(){return 0};var dx=function(e3,e0){var e4;var e2=0;var e1=0;do{e2+=dH;e1++;e4=bR(e3-e1,e0-e2);e4+=bR(e3+e1,e0+e2)}while(e4>0&&e1<a5);return e1};var cU=function(e3,e0){var e4;var e2=0;var e1=0;do{e2+=dH;e1++;e4=bR(e3+e1,e0+e2)}while(e4>0&&e1<a5);return e1};var ci=function(){if(!c9.nLoad||ax.length>2){return}var e0=1;while(e0>0&&ax.length<6&&c9.nLoad>0){e0=0;if(by||c9.nLastLeftImage>0){A(--c9.nLastLeftImage,true);c9.nLoad--;e0++}if(by||c9.nLastRightImage<dB){A(++c9.nLastRightImage,true);c9.nLoad--;e0++}}};var ca=function(){if(dX){return}dX=setInterval(bd,dR);bE=a.now()};var cj=function(){if(!dX){return}clearInterval(dX);dX=b};var bd=function(){bE+=dR;if(dO>a3){cl()}else{cj()}};var cl=function(){if(c7.bImageDragging||dO<=a3){return}var e2=new Array(dO);var e3=0;var e5,e0;for(var e4 in bY){if(bY.hasOwnProperty(e4)){e5=bY[e4];if(!e5.bAppended&&e5.bReady){e2[e3++]=bY[e4]}}}e2=e2.splice(0,e3);e2.sort(cR);var e1=Math.max(0,Math.min(dO-a3,Math.min(e3,50)));for(e3=0;e3<e1;e3++){e5=e2[e3];e0=e5.nIndex;while(e5.elContainer.firstChild){e5.elContainer.removeChild(e5.elContainer.firstChild)}delete e5.elContainer;delete e5.elLabel;delete e5.img;delete e5.placedX;e5.bPurged=true;e5.bThumbLoadStarted=e5.bLoadComplete=e5.bReady=e5.bImageLoadStarted=false;delete bY[e0]}dC+=e1;dO-=e1;cL-=e1};var cR=function(e1,e0){return e1.tsRemovedFromDOM-e0.tsRemovedFromDOM};var E=function(){if(aJ!==b){return}aJ=requestAnimationFrame(bc)};var ao=function(){if(aJ!==b){cancelAnimationFrame(aJ);aJ=b}};var bc=function(){aJ=b;p()};var p=function(){var e0;if(!dX){bE=a.now()}if(aJ!==b){cancelAnimationFrame(aJ);aJ=b}for(e0 in dY){if(dY.hasOwnProperty(e0)){dY[e0].bVisible=false}}dA();for(e0 in dY){if(dY.hasOwnProperty(e0)){if(!dY[e0].bVisible){bw(dY[e0])}}}if(c6){aH(cs,dE,0)}ct()};var di=function(e0){if(x!==b){return}dE=u(dE);dq=a.sign(dq)*Math.min(Math.abs(dq),Math.abs(cM)/50);c7.nAutoRotateUpdateCount=0;a.addEvent(cF,"pointerdown",eZ);if(e0!==b&&!isNaN(e0)){dq=e0}x=requestAnimationFrame(h);es(true)};var h=function(){if(by){dE=u(dE-dq)}else{dE-=dq;if(dE>0||dE<-cM){dq=-dq;dE-=dq}}if(dg){a7(-dE)}bG(-dE);E();x=requestAnimationFrame(h);eB()};var eZ=function(){if(x===b){return}a.removeEvent(cF,"pointerdown",eZ);cancelAnimationFrame(x);x=b;es(false);return false};var cB=function(){var e0=a.getElementDimension(cY);if(e0.width<1){e0.width=1}if(e0.height<1){e0.height=1}if(cA){var e1=e0.width;e0.width=e0.height;e0.height=e1}return e0};var eU=function(){aa=dN=cB()};var aA=function(e0){if(!ev||c8.length<1){return}if(aU===b){ey=-dE/dH;dv=true;aU={};aU.offsetLeft=dE;aU.nAdvance=dH;aU.nCenter=dG;ao();eZ();cancelAnimationFrame(Z);y.cancel();y.enable(false)}if(e0.FSI_after_treshold!==b){dv=false;y.enable(true);aI();ax=[];eU();if(aa.width>1&&aa.height>1){dI();em();aw()}}bv.run("onResize",[aa.width,aa.height,(e0.FSI_after_treshold!==b)])};var w=function(e1,e0,e2){e1.style.transform="translate("+e0.toFixed(2)+"px,"+e2.toFixed(2)+"px)"};var ed=function(e1,e2,e0){e1.style.transform="translate("+e0.toFixed(2)+"px,"+e2.toFixed(2)+"px)"};var eG=function(e1,e0,e4,e3,e2){e1.style.transform="translate3d("+e0.toFixed(2)+"px,"+e4.toFixed(2)+"px,"+e3.toFixed(2)+"px) rotateY("+e2.toFixed(6)+"rad)"};var dj=function(e1,e4,e0,e3,e2){e1.style.transform="translate3d("+e0.toFixed(2)+"px,"+e4.toFixed(2)+"px,"+e3.toFixed(2)+"px) rotateX("+e2.toFixed(6)+"rad)"};var d0=function(e3){var e2="translate3d("+e3.x.toFixed(2)+"px,"+e3.y.toFixed(2)+"px,"+e3.z.toFixed(2)+"px)";if(e3.rx){e2+=" rotateX("+e3.rx.toFixed(6)+"rad)"}if(e3.ry){e2+=" rotateY("+e3.ry.toFixed(6)+"rad)"}if(e3.rz){e2+=" rotateZ("+e3.rz.toFixed(6)+"rad)"}if(e3.sx){e2+=" scaleX("+e3.sx.toFixed(2)+")"}if(e3.sy){e2+=" scaleY("+e3.sy.toFixed(2)+")"}if(e3.brightness!==b&&at){var e0=e3.brightness;var e1=e3.elContainer.style;if(e0<0.99){e1[bL]="brightness("+e0+")"}else{e1[bL]="none"}}if(e3.bSetZIndex){e3.elContainer.style.zIndex=ag+Math.round(ag*e3.z/bK)}e3.elContainer.style.transform=e2};var cu=function(e3){var e2="translate3d("+e3.y.toFixed(2)+"px,"+e3.x.toFixed(2)+"px,"+e3.z.toFixed(2)+"px)";if(e3.rx){e2+=" rotateY("+e3.rx.toFixed(6)+"rad)"}if(e3.ry){e2+=" rotateX("+e3.ry.toFixed(6)+"rad)"}if(e3.rz){e2+=" rotateZ("+e3.rz.toFixed(6)+"rad)"}if(e3.sx){e2+=" scaleY("+e3.sx.toFixed(2)+")"}if(e3.sy){e2+=" scaleX("+e3.sy.toFixed(2)+")"}if(e3.brightness!==b&&at){var e0=e3.brightness;var e1=e3.elContainer.style;if(e0<0.99){e1[bL]="brightness("+e0+")"}else{e1[bL]="none"}}if(e3.bSetZIndex){e3.elContainer.style.zIndex=ag+Math.round(ag*e3.z/bK)}e3.elContainer.style.transform=e2};var bP=function(e2){if(cE>0){for(var e3 in ck){if(ck.hasOwnProperty(e3)){var e0=ck[e3];for(var e1=0;e1<e0.length;e1++){if(!e2||e0[e1].bByConfig){aE.unRegisterButton(e0[e1].el)}}}}}};var M=function(e0){if(b9&&b9.img){a.removeClass(b9.elContainer,"fsi-selected-thumb")}if(e0){if(e0.elContainer){a.addClass(e0.elContainer,"fsi-selected-thumb")}b9=e0}else{b9=b}};var bm=function(){if(dL){if(a.touchZoom&&dL.getInstanceName()!==a.touchZoom.getInstanceName()){dL.destroy()}dL=b}};var d9=function(){if(!ep){return}ep=false;if(aD){a.removeEvent(window,"FSITouchZoomLoaded",ch);aD=false}M();if(ds!==b){a.removeCustomEvent(aE,"FSIViewport",dp);ds=b}bP();cj();if(ek){ek.destroy()}eN();bm();if(dP){clearTimeout(dP);dP=b}z();eI();dh.removeAttribute("data-fsi-id");aI();for(var e0 in aC){if(aC.hasOwnProperty(e0)){bD(aC[e0])}}aC={};if(eY!==b){a.removeCustomEvent(dh,"FSIElementDimension",aA);eY=b}ax=[];eZ();bf=b;d6(b,true);d5=0;cancelAnimationFrame(dW);cancelAnimationFrame(aJ);aJ=b;cancelAnimationFrame(Z);Z=b;cancelAnimationFrame(au);au=b;bF=[];c9={};if(y){y.destroy();y=b}dE=aR=0;a8=b;eJ=[];Y=0;a.removeChild(cY.parentNode,cY);if(bv){bv.run("onDestroy");bv.destroy()}};var c3=function(){if(!Z){return dE}else{return eM.end}};this.init=b6;this.destroy=d9;this.getInitDone=function(){return ep};this.addListener=function(e3,e1,e2){var e0=false;if(bv){e0=bv.addListener(e3,e1,e2)}return e0};this.changeDir=function(e0){return eT(e0)};this.removeListener=function(e2,e1){var e0=false;if(bv){e0=bv.removeListener(e2,e1)}return e0};this.getImageCount=function(){return d4};this.getCurrentImageIndex=function(){return bJ};this.setScrollPos=P;this.getScrollPos=function(){return -dE};this.isScrolling=function(){return eO};this.firstImage=function(e0){N(0,false,e0)};this.lastImage=function(e0){var e1=(by)?-cM+dH:-cM;N(e1,false,e0)};this.previousPage=function(e0){N(c3()+aa.width,false,e0)};this.nextPage=function(e0){N(c3()-aa.width,false,e0)};this.nextImage=function(e0){N(c3()-dH,false,e0)};this.previousImage=function(e0){N(c3()+dH,false,e0)};this.assignFSIViewer=function(e0){cd=e0;if(aB){clearTimeout(aB);aB=b}dF=0;aG(e0)};var aG=function(){var e0=cd;aB=b;dF++;var e1=e0;if(e1&&typeof(e1)==="string"){if(e1.toLowerCase()==="auto"){var e2=document.getElementsByTagName("fsi-viewer");if(e2&&e2.length>0){e0=e2[0]}else{e0=b}}else{e0=document.querySelector(e1);if(!e0){e0=document.getElementById(e1)}}}if(!e0||typeof(e0.changeImage)!=="function"){cy=b}else{cy=e0}a9=false;bO();if(!cy&&dF<10){aB=setTimeout(aG,250)}else{br()}return cy};this.focusImage=function(e0){if(isNaN(e0)){return}e0=Math.round(e0);if(e0<0||e0>=eJ){return false}var e1=A(e0);be(e1);return true};this.startAutoRotate=di;this.stopAutoRotate=eZ;this.zoomImage=function(e0){if(!eu.enableZoom||!this.focusImage(e0)){return false}var e1=A(e0);bf=e1.nIndex;cp()};this.destroyOnDetach=function(){if(eu&&eu.autoDestroy!==false){d9()}};var C={lastimage:{fn:this.lastImage,bSingleCommand:true},firstimage:{fn:this.firstImage,bSingleCommand:false},nextimage:{fn:this.nextImage},previousimage:{fn:this.previousImage},nextpage:{fn:this.nextPage,ntRepeat:350},previouspage:{fn:this.previousPage,ntRepeat:350}};var bT=this.buttonDown=function(e0){if(typeof(e0)!=="string"){return false}e0=e0.toLowerCase();if(!C[e0]){return false}if(eE.cmd){if(e0===eE.cmd){return false}aq()}if(C[e0].ntRepeat){eE.ntRepeat=C[e0].ntRepeat}else{eE.ntRepeat=125}eE.fn=C[e0].fn;eE.bSingleCommand=C[e0].bSingleCommand;eE.cmd=e0;eE.repeat=0;eE.nInterval=setInterval(eX,350);eX()};var eX=function(){eE.fn.apply(aE);eE.repeat++;if(eE.bSingleCommand){aq()}else{if(eE.repeat===2){clearInterval(eE.nInterval);eE.nInterval=setInterval(eX,eE.ntRepeat)}}};var aq=this.buttonUp=function(){if(eE.nInterval){clearInterval(eE.nInterval)}eE.cmd=b};this.registerButton=function(e1,e2,e3){if(typeof(e1)==="string"){e1=document.getElementById(e1)}if(!e1||typeof(e1)!=="object"||typeof(e1.tagName)!=="string"){return false}e2=e2.toLowerCase();if(!C[e2]){return false}if(!e1.x_fsi_thumbbar_cmd_count){e1.setAttribute("data-fsi-thumbbar-cmd",e2);e1.x_fsi_thumbbar_cmd_count=1}else{e1.x_fsi_thumbbar_cmd_count++}a.addEvent(e1,"contextmenu",a.preventDefaultEvent);a.addEvent(e1,"mousedown",cn);if(a.isEventSupported("touchstart")){a.addEvent(e1,"touchstart",cn,{passive:false})}cE++;var e0=ck[e2];if(e0===b){e0=ck[e2]=[]}e0.push({el:e1,bByConfig:e3});return true};this.changeConfig=db;var b4=function(e0){a.addEvent(window,"mouseup",b5);if(a.isEventSupported("touchstart")){a.addEvent(e0,"touchcancel",b5);a.addEvent(e0,"touchend",b5)}};var k=function(e0){a.removeEvent(window,"mouseup",b5);if(a.isEventSupported("touchstart")){a.removeEvent(e0,"touchcancel",b5);a.removeEvent(e0,"touchend",b5)}};this.unRegisterButton=function(e0){if(typeof(e0)==="string"){e0=document.getElementById(e0)}if(!e0||typeof(e0)!=="object"||typeof(e0.tagName)!=="string"||!e0.x_fsi_thumbbar_cmd_count){return false}if(--e0.x_fsi_thumbbar_cmd_count===0){e0.x_fsi_thumbbar_cmd_count=b;e0.removeAttribute("data-fsi-thumbbar-cmd")}a.removeEvent(e0,"mousedown",cn);if(a.isEventSupported("touchstart")){a.removeEvent(e0,"touchstart",cn,{passive:false})}k(e0);cE--;return true};var b5=function(){if(dz){a.removeClass(dz,"fsi-pressed")}aq();k(dz);dz=b};var cn=function(e0){if(dz){b5()}var e1=e0.target||e0.srcElement;if(!e1||!e1.getAttribute("data-fsi-thumbbar-cmd")){return}dz=e1;b4(e1);var e2=e1.getAttribute("data-fsi-thumbbar-cmd");a.addClass(e1,"fsi-pressed");bT(e2);a.preventDefaultEvent(e0);return true};if(typeof(cO)!=="object"||a.makeBool(cO.autoInit,true)){aE.init(en,cO)}};a.customTags.register("fsi-thumbbar",{constructorClass:a.ThumbBar,viewerCSS:"display:block;width:300px;height:300px;"});a.dispatchEvent("FSIThumbBarLoaded")}(window.$FSI=window.$FSI||{}));