/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ThresholdOpImage
extends ColormapOpImage {
    private double[] low;
    private double[] high;
    private double[] constants;
    private byte[][] byteTable = null;

    public ThresholdOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2, double[] dArray3) {
        super(renderedImage, imageLayout, map, true);
        int n = this.getSampleModel().getNumBands();
        this.low = new double[n];
        this.high = new double[n];
        this.constants = new double[n];
        for (int i = 0; i < n; ++i) {
            this.low[i] = dArray.length < n ? dArray[0] : dArray[i];
            this.high[i] = dArray2.length < n ? dArray2[0] : dArray2[i];
            this.constants[i] = dArray3.length < n ? dArray3[0] : dArray3[i];
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        this.initByteTable();
        for (int i = 0; i < 3; ++i) {
            byte[] byArray2 = byArray[i];
            byte[] byArray3 = this.byteTable[i >= this.byteTable.length ? 0 : i];
            int n = byArray2.length;
            for (int j = 0; j < n; ++j) {
                byArray2[j] = byArray3[byArray2[j] & 0xFF];
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getPixelStride();
        int n4 = rasterAccessor2.getScanlineStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getWidth() * n3;
        int n6 = rasterAccessor2.getHeight() * n4;
        int n7 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getByteDataArrays(), n3, n4, nArray2, rasterAccessor2.getByteDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getIntDataArrays(), n3, n4, nArray2, rasterAccessor2.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getFloatDataArrays(), n3, n4, nArray2, rasterAccessor2.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getDoubleDataArrays(), n3, n4, nArray2, rasterAccessor2.getDoubleDataArrays());
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2) {
        this.initByteTable();
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            byte[] byArray5 = this.byteTable[i];
            int n8 = nArray2[i] + n2;
            int n9 = nArray2[i];
            int n10 = nArray[i];
            while (n9 < n8) {
                int n11 = n9 + n;
                int n12 = n9;
                int n13 = n10;
                while (n12 < n11) {
                    byArray4[n12] = byArray5[byArray3[n13] & 0xFF];
                    n12 += n6;
                    n13 += n4;
                }
                n9 += n7;
                n10 += n5;
            }
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            double d = this.low[i];
            double d2 = this.high[i];
            short s = (short)this.constants[i];
            int n8 = nArray2[i] + n2;
            int n9 = nArray2[i];
            int n10 = nArray[i];
            while (n9 < n8) {
                int n11 = n9 + n;
                int n12 = n9;
                int n13 = n10;
                while (n12 < n11) {
                    short s2 = sArray3[n13];
                    sArray4[n12] = (double)s2 >= d && (double)s2 <= d2 ? s : s2;
                    n12 += n6;
                    n13 += n4;
                }
                n9 += n7;
                n10 += n5;
            }
        }
    }

    private void ushortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2) {
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            double d = this.low[i];
            double d2 = this.high[i];
            short s = (short)this.constants[i];
            int n8 = nArray2[i] + n2;
            int n9 = nArray2[i];
            int n10 = nArray[i];
            while (n9 < n8) {
                int n11 = n9 + n;
                int n12 = n9;
                int n13 = n10;
                while (n12 < n11) {
                    int n14 = sArray3[n13] & 0xFFFF;
                    sArray4[n12] = (double)n14 >= d && (double)n14 <= d2 ? s : (short)n14;
                    n12 += n6;
                    n13 += n4;
                }
                n9 += n7;
                n10 += n5;
            }
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4) {
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            double d = this.low[i];
            double d2 = this.high[i];
            int n8 = (int)this.constants[i];
            int n9 = nArray3[i] + n2;
            int n10 = nArray3[i];
            int n11 = nArray[i];
            while (n10 < n9) {
                int n12 = n10 + n;
                int n13 = n10;
                int n14 = n11;
                while (n13 < n12) {
                    int n15 = nArray5[n14];
                    nArray6[n13] = (double)n15 >= d && (double)n15 <= d2 ? n8 : n15;
                    n13 += n6;
                    n14 += n4;
                }
                n10 += n7;
                n11 += n5;
            }
        }
    }

    private void floatLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int n6, int n7, int[] nArray2, float[][] fArray2) {
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            double d = this.low[i];
            double d2 = this.high[i];
            float f = (float)this.constants[i];
            int n8 = nArray2[i] + n2;
            int n9 = nArray2[i];
            int n10 = nArray[i];
            while (n9 < n8) {
                int n11 = n9 + n;
                int n12 = n9;
                int n13 = n10;
                while (n12 < n11) {
                    float f2 = fArray3[n13];
                    fArray4[n12] = (double)f2 >= d && (double)f2 <= d2 ? f : f2;
                    n12 += n6;
                    n13 += n4;
                }
                n9 += n7;
                n10 += n5;
            }
        }
    }

    private void doubleLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6, int n7, int[] nArray2, double[][] dArray2) {
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            double d = this.low[i];
            double d2 = this.high[i];
            double d3 = this.constants[i];
            int n8 = nArray2[i] + n2;
            int n9 = nArray2[i];
            int n10 = nArray[i];
            while (n9 < n8) {
                int n11 = n9 + n;
                int n12 = n9;
                int n13 = n10;
                while (n12 < n11) {
                    double d4 = dArray3[n13];
                    dArray4[n12] = d4 >= d && d4 <= d2 ? d3 : d4;
                    n12 += n6;
                    n13 += n4;
                }
                n9 += n7;
                n10 += n5;
            }
        }
    }

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        int n = this.getSampleModel().getNumBands();
        this.byteTable = new byte[n][256];
        for (int i = 0; i < n; ++i) {
            double d = this.low[i];
            double d2 = this.high[i];
            byte by = (byte)this.constants[i];
            byte[] byArray = this.byteTable[i];
            for (int j = 0; j < 256; ++j) {
                byArray[j] = (double)j >= d && (double)j <= d2 ? by : (byte)j;
            }
        }
    }
}

