/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.media.jai.remote.SerializableState;

class InterfaceHandler
implements InvocationHandler {
    private Hashtable interfaceMap;

    public InterfaceHandler(Class[] classArray, SerializableState[] serializableStateArray) {
        if (classArray == null || serializableStateArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (classArray.length != serializableStateArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("InterfaceHandler0"));
        }
        int n = classArray.length;
        this.interfaceMap = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            Class clazz = classArray[i];
            SerializableState serializableState = serializableStateArray[i];
            if (!clazz.isAssignableFrom(serializableState.getObjectClass())) {
                throw new RuntimeException(JaiI18N.getString("InterfaceHandler1"));
            }
            Object object = serializableState.getObject();
            this.interfaceMap.put(clazz, object);
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        Object object2;
        Class<?> clazz = method.getDeclaringClass();
        if (!this.interfaceMap.containsKey(clazz)) {
            object2 = this.interfaceMap.keySet().toArray(new Class[0]);
            for (int i = 0; i < ((Class[])object2).length; ++i) {
                Class clazz2 = object2[i];
                if (!clazz.isAssignableFrom(clazz2)) continue;
                this.interfaceMap.put(clazz, this.interfaceMap.get(clazz2));
                break;
            }
            if (!this.interfaceMap.containsKey(clazz)) {
                throw new RuntimeException(clazz.getName() + JaiI18N.getString("InterfaceHandler2"));
            }
        }
        object2 = null;
        try {
            Object v = this.interfaceMap.get(clazz);
            object2 = method.invoke(v, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(method.getName() + JaiI18N.getString("InterfaceHandler3"));
        }
        return object2;
    }
}

