/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.component.plugins.Plugin;
import org.apache.log4j.component.plugins.Receiver;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.receivers.net.PortBased;
import org.apache.log4j.receivers.net.SocketNode13;
import org.apache.log4j.receivers.net.SocketNodeEventListener;
import org.apache.log4j.spi.LoggerRepository;

public class SocketHubReceiver
extends Receiver
implements SocketNodeEventListener,
PortBased {
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    protected String host;
    protected int port;
    protected int reconnectionDelay = 30000;
    public static final String ZONE = "_log4j_obj_tcpconnect_receiver.local.";
    protected boolean active = false;
    protected Connector connector;
    protected SocketNode13 socketNode;
    private List listenerList = Collections.synchronizedList(new ArrayList());
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;

    public SocketHubReceiver() {
    }

    public SocketHubReceiver(String h, int p) {
        this.host = h;
        this.port = p;
    }

    public SocketHubReceiver(String h, int p, LoggerRepository repo) {
        this.host = h;
        this.port = p;
        this.repository = repo;
    }

    public void addSocketNodeEventListener(SocketNodeEventListener l) {
        this.listenerList.add(l);
    }

    public void removeSocketNodeEventListener(SocketNodeEventListener l) {
        this.listenerList.remove(l);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String remoteHost) {
        this.host = remoteHost;
    }

    public void setPort(String remoteHost) {
        this.host = remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setReconnectionDelay(int delay) {
        int oldValue = this.reconnectionDelay;
        this.reconnectionDelay = delay;
        this.firePropertyChange("reconnectionDelay", oldValue, this.reconnectionDelay);
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin != null && testPlugin instanceof SocketHubReceiver) {
            SocketHubReceiver sReceiver = (SocketHubReceiver)testPlugin;
            return this.port == sReceiver.getPort() && this.host.equals(sReceiver.getHost()) && this.reconnectionDelay == sReceiver.getReconnectionDelay() && super.isEquivalent(testPlugin);
        }
        return false;
    }

    protected synchronized void setActive(boolean b) {
        this.active = b;
    }

    public void activateOptions() {
        if (!this.isActive()) {
            this.setActive(true);
            if (this.advertiseViaMulticastDNS) {
                this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
                this.zeroConf.advertise();
            }
            this.fireConnector(false);
        }
    }

    public synchronized void shutdown() {
        this.active = false;
        try {
            if (this.socketNode != null) {
                this.socketNode.close();
                this.socketNode = null;
            }
        }
        catch (Exception e) {
            this.getLogger().info((Object)"Excpetion closing socket", e);
        }
        if (this.connector != null) {
            this.connector.interrupted = true;
            this.connector = null;
        }
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
    }

    public void socketClosedEvent(Exception e) {
        if (e != null) {
            this.connector = null;
            this.fireConnector(true);
        }
    }

    private synchronized void fireConnector(boolean isReconnect) {
        if (this.active && this.connector == null) {
            this.getLogger().debug("Starting a new connector thread.");
            this.connector = new Connector(isReconnect);
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setSocket(Socket newSocket) {
        this.connector = null;
        this.socketNode = new SocketNode13(newSocket, this);
        this.socketNode.addSocketNodeEventListener(this);
        List list = this.listenerList;
        synchronized (list) {
            Iterator iter = this.listenerList.iterator();
            while (iter.hasNext()) {
                SocketNodeEventListener listener = (SocketNodeEventListener)iter.next();
                this.socketNode.addSocketNodeEventListener(listener);
            }
        }
        new Thread(this.socketNode).start();
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.advertiseViaMulticastDNS = advertiseViaMulticastDNS;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    public void socketOpened(String remoteInfo) {
    }

    private final class Connector
    extends Thread {
        boolean interrupted = false;
        boolean doDelay;

        public Connector(boolean isReconnect) {
            this.doDelay = isReconnect;
        }

        public void run() {
            while (!this.interrupted) {
                try {
                    if (this.doDelay) {
                        SocketHubReceiver.this.getLogger().debug("waiting for " + SocketHubReceiver.this.reconnectionDelay + " milliseconds before reconnecting.");
                        Connector.sleep(SocketHubReceiver.this.reconnectionDelay);
                    }
                    this.doDelay = true;
                    SocketHubReceiver.this.getLogger().debug("Attempting connection to " + SocketHubReceiver.this.host);
                    Socket s = new Socket(SocketHubReceiver.this.host, SocketHubReceiver.this.port);
                    SocketHubReceiver.this.setSocket(s);
                    SocketHubReceiver.this.getLogger().debug("Connection established. Exiting connector thread.");
                    break;
                }
                catch (InterruptedException e) {
                    SocketHubReceiver.this.getLogger().debug("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException e) {
                    SocketHubReceiver.this.getLogger().debug((Object)"Remote host {} refused connection.", SocketHubReceiver.this.host);
                }
                catch (IOException e) {
                    SocketHubReceiver.this.getLogger().debug("Could not connect to {}. Exception is {}.", SocketHubReceiver.this.host, e);
                }
            }
        }
    }
}

