/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.io;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.WriterAbstract;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;

public class WriterChannel
extends WriterAbstract {
    public WriterChannel(Path path, Set<StandardOpenOption> set) throws IOException {
        super(path, set);
    }

    public WriterChannel(Path path, StandardOpenOption ... standardOpenOptionArray) throws IOException {
        super(path, standardOpenOptionArray);
    }

    @Override
    public long position() throws IOException {
        return this.\u00d300000.position();
    }

    @Override
    public void seek(long l) throws IOException {
        this.\u00d300000.position(l);
    }

    @Override
    public void close() throws IOException {
        this.\u00d300000.close();
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.flip();
        this.\u00d300000.write(byteBuffer);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.\u00d300000.write(ByteBuffer.wrap(byArray));
    }

    @Override
    public void writeByte(byte by) throws IOException {
        this.\u00d300000.write(ByteBuffer.wrap(new byte[]{by}));
    }

    @Override
    public void writeShort(short s) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.order(this.super);
        byteBuffer.putShort(s);
        byteBuffer.flip();
        this.\u00d300000.write(byteBuffer);
    }

    @Override
    public void writeInt(int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(this.super);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        this.\u00d300000.write(byteBuffer);
    }

    @Override
    public void writeLong(long l) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(this.super);
        byteBuffer.putLong(l);
        byteBuffer.flip();
        this.\u00d300000.write(byteBuffer);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(this.super);
        byteBuffer.putFloat(f);
        byteBuffer.flip();
        this.\u00d300000.write(byteBuffer);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(this.super);
        byteBuffer.putDouble(d);
        byteBuffer.flip();
        this.\u00d300000.write(byteBuffer);
    }

    @Override
    public void writeTagByte(short s, byte by) throws IOException {
        this.writeTag(s, 1);
        this.writeByte(by);
    }

    @Override
    public void writeTagBytes(short s, byte[] byArray) throws IOException {
        this.writeTag(s, byArray.length);
        this.write(byArray);
    }

    @Override
    public void writeTagFloat(short s, float f) throws IOException {
        this.writeTag(s, 4);
        this.writeFloat(f);
    }

    @Override
    public void writeTagFloats(short s, float[] fArray) throws IOException {
        this.writeTag(s, fArray.length * 4);
        this.write(fArray);
    }

    @Override
    public void write(float[] fArray) throws IOException {
        for (float f : fArray) {
            this.writeFloat(f);
        }
    }

    @Override
    public void writeTagShort(short s, short s2) throws IOException {
        this.writeTag(s, 2);
        this.writeShort(s2);
    }

    @Override
    public void writeTagInt(short s, int n) throws IOException {
        this.writeTag(s, 4);
        this.writeInt(n);
    }

    @Override
    public void writeTagLong(short s, long l) throws IOException {
        this.writeTag(s, 8);
        this.writeLong(l);
    }

    @Override
    public void writeTagDouble(short s, double d) throws IOException {
        this.writeTagLong(s, Double.doubleToRawLongBits(d));
    }

    @Override
    public void writeTagUTF8(short s, String string) throws IOException {
        byte[] byArray = string.getBytes(FileOperations.new);
        this.writeTag(s, byArray.length);
        this.write(byArray);
    }

    private void writeTag(short s, int n) throws IOException {
        this.writeShort(s);
        this.writeInt(n);
    }
}

