/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.iptc;

import com.neptunelabs.fsiserver.imagereader.iptc.IptcDirectory;
import java.util.HashMap;
import java.util.Map;

public class IptcSimpleMapReader {
    public final HashMap<String, String> getIptcMap(byte[] byArray) {
        Map<Integer, String> map = this.extractIPTCTags(byArray);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Integer n = null;
        IptcDirectory iptcDirectory = new IptcDirectory();
        for (Integer n2 : map.keySet()) {
            n = n2;
            if (iptcDirectory.knowsTag(n)) {
                hashMap.put(iptcDirectory.getTagName(n), map.get(n));
                continue;
            }
            hashMap.put("UNKNOWN [" + n + "]", map.get(n));
        }
        return hashMap;
    }

    public final Map<Integer, String> extractIPTCTags(byte[] byArray) {
        int n;
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (byArray == null) {
            return null;
        }
        try {
            for (n = 0; n < byArray.length - 1 && this.get2Byte(byArray, n) != 7170; ++n) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte by = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < byArray.length) {
            if (byArray[n] != 28) {
                ++n;
                continue;
            }
            if (n + 5 >= byArray.length) break;
            ++n;
            try {
                by = byArray[n++];
                n2 = byArray[n++] & 0xFF;
                n3 = this.get2Byte(byArray, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isIptcStartTag(byArray, n + n3)) {
                n += 2;
            }
            if (n + n3 > byArray.length) {
                n3 = byArray.length - n;
            }
            this.processTag(hashMap, byArray, by, n2, n, n3);
            n += n3;
        }
        return hashMap;
    }

    private boolean isIptcStartTag(byte[] byArray, int n) {
        return n + 1 < byArray.length && byArray[n] == 28 && byArray[n + 1] == 2;
    }

    private int get2Byte(byte[] byArray, int n) throws Exception {
        if (n >= byArray.length) {
            throw new Exception("Attempt to read  from outside IPTC data buffer  OFFSET:" + n + "  BYTES: " + byArray.length);
        }
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private void processTag(Map<Integer, String> map, byte[] byArray, int n, int n2, int n3, int n4) {
        Integer n5 = new Integer(n2 | n << 8);
        String string = null;
        string = n4 < 1 ? "" : new String(byArray, n3, n4);
        if (map.containsKey(n5)) {
            string = map.get(n5) + " " + string;
        }
        map.put(n5, string);
    }
}

