/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrException;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SDBChecker
extends Thread {
    private static final int o00000 = 10000;
    private static final int \u00f400000 = 5000;
    private final SolrUpdater OO0000;
    private final SearchDatabaseSolr \u00f500000;
    private final SourceManagerSettings \u00d400000;
    private final ScannerDaemon oO0000;
    private volatile boolean Object = true;
    private final Path \u00f600000;
    private int \u00d200000 = 0;
    private int float = 0;
    private final Set<String> void = new HashSet<String>();
    private StatusValue \u00d600000 = StatusValue.\u00d300000;
    private boolean \u00d500000 = false;

    public SDBChecker(SourceManagerSettings sourceManagerSettings, ScannerDaemon scannerDaemon) {
        this.\u00f500000 = sourceManagerSettings.getSolr();
        this.OO0000 = sourceManagerSettings.getSolrUpdater();
        this.oO0000 = scannerDaemon;
        this.\u00d400000 = sourceManagerSettings;
        this.\u00f600000 = sourceManagerSettings.getStorageLocation().resolve(".sdbcheck");
        this.setName("Search Database Rebuilder");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (this.Object) {
                SDBChecker.sleep(10000L);
                if (!this.\u00d500000) {
                    this.\u00d500000 = this.testSDBConnection();
                }
                if (this.\u00d500000 && Files.exists(this.\u00f600000, new LinkOption[0])) {
                    this.\u00d400000.getLogger().log(3244, new Object[0]);
                    this.\u00d600000 = StatusValue.\u00d400000;
                    try {
                        Object object2;
                        Map<String, SourceConnectorReader> map;
                        if (Files.size(this.\u00f600000) > 0L) {
                            try {
                                map = FileOperations.getTextFileContentAsArrayList(this.\u00f600000, FileOperations.new);
                                Iterator iterator = map.iterator();
                                while (iterator.hasNext()) {
                                    object2 = (String)iterator.next();
                                    if (((String)object2).isEmpty()) continue;
                                    this.void.add((String)object2);
                                }
                            }
                            catch (IOException iOException) {
                                this.\u00d400000.getLogger().logException(iOException, 3246, iOException.getLocalizedMessage());
                            }
                        }
                        Files.deleteIfExists(this.\u00f600000);
                        this.OO0000.resetLoggingStatus();
                        this.\u00d200000 = 0;
                        for (String string : this.void) {
                            object2 = this.\u00d400000.getSourceConnectorFromAssetURLPath(string);
                            this.handleFile((SourceConnectorReader)object2, string, true);
                        }
                        map = this.\u00d400000.getEnabledConnectors();
                        for (Object object2 : map.entrySet()) {
                            if (!this.Object) break;
                            this.recurse(object2.getValue(), object2.getValue().getInboxDirectory());
                        }
                        this.reverseCheck();
                    }
                    catch (NotConfiguredException notConfiguredException) {
                    }
                    catch (SolrException solrException) {
                        this.\u00d400000.getLogger().logException(solrException, 3237, solrException.getLocalizedMessage());
                    }
                    catch (IOException iOException) {
                        this.\u00d400000.getLogger().logException(iOException, 3237, iOException.getLocalizedMessage());
                        this.\u00d500000 = false;
                    }
                    this.\u00d400000.getLogger().log(3245, this.\u00d200000, this.float);
                    this.\u00d600000 = StatusValue.\u00d300000;
                    continue;
                }
                if (this.\u00d500000 || !this.\u00f500000.isInitiated()) continue;
                this.\u00d400000.getLogger().log(3269, this.\u00f500000.getSolrServerURI());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.\u00d600000 = StatusValue.o00000;
    }

    private boolean testSDBConnection() {
        boolean bl = false;
        SolrResponse solrResponse = this.\u00f500000.getCoreStatusJSON();
        if (solrResponse.\u00d300000 == 200) {
            try {
                JsonNode jsonNode;
                String string = new String(solrResponse.super, solrResponse.\u00d400000);
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode2 = objectMapper.readTree(string);
                JsonNode jsonNode3 = jsonNode2.get("status");
                if (jsonNode3 != null && (jsonNode = jsonNode3.get(this.\u00f500000.getSolrCore())) != null) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void reverseCheck() throws IOException, NotConfiguredException {
        boolean bl = true;
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        while (bl && this.Object) {
            Set<String> set = this.\u00f500000.getCoreAssetList(n, 5000);
            if (set.size() == 0) {
                bl = false;
            } else {
                for (String string : set) {
                    if (this.oO0000.assetExists(string)) continue;
                    hashSet.add(string);
                }
            }
            n += 5000;
        }
        this.float = hashSet.size();
        if (hashSet.size() > 0) {
            this.OO0000.deleteAssetsAsync(hashSet);
        }
    }

    private void recurse(SourceConnectorReader sourceConnectorReader, PathCached pathCached) throws IOException {
        List<PathCached> list;
        if (this.Object && pathCached != null && (list = FileOperations.listAllFiles(pathCached.getPath())) != null) {
            for (PathCached pathCached2 : list) {
                if (!this.Object) break;
                String string = FileOperations.convertBackslash(sourceConnectorReader.getPrefix() + pathCached2.getAbsoluteName().substring(sourceConnectorReader.getInboxDirectory().getAbsolutePath().toString().length()));
                try {
                    this.handleFile(sourceConnectorReader, string, false);
                }
                catch (SolrException solrException) {
                    this.\u00d400000.getLogger().logException(solrException, 3243, string, solrException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    this.\u00d400000.getLogger().logException(exception, 3243, string, exception.getLocalizedMessage());
                }
                if (!pathCached2.isDirectory()) continue;
                this.recurse(sourceConnectorReader, pathCached2);
            }
        }
    }

    private void handleFile(SourceConnectorReader sourceConnectorReader, String string, boolean bl) throws NotConfiguredException, IOException {
        if (bl || !this.OO0000.entryExists(string)) {
            this.oO0000.getMetaDataAndUpdateSearchDatabase(string, false);
            ++this.\u00d200000;
        }
    }

    public void halt() {
        this.Object = false;
        this.interrupt();
    }

    public StatusValue getStatus() {
        return this.\u00d600000;
    }

    public boolean isCheckScheduled() {
        return Files.exists(this.\u00f600000, new LinkOption[0]);
    }

    public void scheduleCheck() {
        if (!this.isCheckScheduled()) {
            try {
                Files.createFile(this.\u00f600000, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum StatusValue {
        \u00d300000,
        \u00d400000,
        o00000;

    }
}

