/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.servlet;

import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.MainProcessorNG;
import com.neptunelabs.fsiserver.requestprocessor.ProcessorEnv;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.StaticFileRequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.servlet.AppRequestListener;
import com.neptunelabs.fsiserver.sourcemanager.SourceManager;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="FSI-Server", loadOnStartup=2, asyncSupported=true, urlPatterns={"/server", "/static/*"})
@Obfuscation
public class App
extends HttpServlet {
    private static final long serialVersionUID = 680864912460939021L;
    private ThreadPoolExecutor asyncRequestExecutor;
    private boolean acceptRequests = false;
    private RequestProcessorSettings requestProcessorSettings;
    private ServletContext servletContext;
    private FSILogger rpLogger;
    private ProcessorEnv processorEnv;
    private long requestTimeout;

    public void destroy() {
        this.acceptRequests = false;
        if (this.asyncRequestExecutor != null) {
            this.asyncRequestExecutor.shutdown();
            try {
                this.asyncRequestExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.shutdownRequestProcessorExecutor();
        this.shutdownSourceManager();
        this.shutdownDownloadJobProcessor();
        if (this.rpLogger != null) {
            this.rpLogger.log(2002, SoftwareVersion.getSoftware(true));
            this.rpLogger.log(2018, new Object[0]);
        }
    }

    public String getServletInfo() {
        return SoftwareVersion.getVersion(true, true, true);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletContext = servletConfig.getServletContext();
        Object object = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.startError");
        if (object == null) {
            this.asyncRequestExecutor = (ThreadPoolExecutor)this.servletContext.getAttribute("com.neptunelabs.fsiserver.RequestProcessorExecutor");
            this.rpLogger = (FSILogger)this.servletContext.getAttribute("logger.requestprocessor");
            long l = System.currentTimeMillis();
            this.requestProcessorSettings = (RequestProcessorSettings)this.servletContext.getAttribute("com.neptunelabs.fsiserver.RequestProcessorSettings");
            if (this.requestProcessorSettings.hasSectionEnabled("application")) {
                this.processorEnv = new ProcessorEnv();
                if (!this.requestProcessorSettings.hasSectionEnabled("application")) {
                    this.rpLogger.log(2006, new Object[0]);
                }
                this.requestTimeout = this.requestProcessorSettings.getPrefsLong("application", "requestTimeout");
                this.processorEnv.setSettings(this.requestProcessorSettings);
                Object object2 = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.startError");
                String string = object2 != null ? (String)object2 : null;
                this.processorEnv.setServletInitErrorMessage(string);
                Map map = (Map)this.servletContext.getAttribute("com.neptunelabs.fsiserver.SearchProcessors");
                this.processorEnv.setSearchProcessors(map);
                StaticFileRequestHandler staticFileRequestHandler = (StaticFileRequestHandler)this.servletContext.getAttribute("com.neptunelabs.fsiserver.StaticFileRequestHandler");
                this.processorEnv.setStaticFileRequestHandler(staticFileRequestHandler);
                SystemMonitor systemMonitor = (SystemMonitor)this.servletContext.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
                this.processorEnv.setSystemMonitor(systemMonitor);
                Map map2 = (Map)this.servletContext.getAttribute("com.neptunelabs.fsiserver.OutputCompressors");
                this.processorEnv.setOutputCompressors(map2);
                EffectsManager effectsManager = (EffectsManager)this.servletContext.getAttribute("com.neptunelabs.fsiserver.EffectManager");
                this.processorEnv.setEffectsManager(effectsManager);
                CacheManager cacheManager = (CacheManager)this.servletContext.getAttribute("com.neptunelabs.fsiserver.CacheManager");
                this.processorEnv.setCacheManager(cacheManager);
                SolrSearcher solrSearcher = (SolrSearcher)this.servletContext.getAttribute("com.neptunelabs.fsiserver.SolrSearcher");
                this.processorEnv.setSolrSearcher(solrSearcher);
                this.setupSystemMonitor();
                this.initDownloadJobProcessor();
                this.initSourceManager();
                this.initRequestProcessorExecutor(this.rpLogger, this.requestProcessorSettings);
                this.acceptRequests = true;
                this.rpLogger.log(2019, new Object[0]);
            }
            this.rpLogger.log(3204, "RequestProcessor", System.currentTimeMillis() - l);
            this.acceptRequests = true;
        } else {
            this.acceptRequests = false;
        }
    }

    private void setupSystemMonitor() {
        SystemMonitor systemMonitor = (SystemMonitor)this.servletContext.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
        systemMonitor.setLicence(this.requestProcessorSettings.getLicence());
        systemMonitor.setStorageDir(this.requestProcessorSettings.getStorageLocation());
        UserAuthenticationInterface userAuthenticationInterface = this.requestProcessorSettings.getUserAuthenticationInterface();
        if (userAuthenticationInterface != null) {
            systemMonitor.setGroupCount(userAuthenticationInterface.getGroupCount());
        }
    }

    private void initDownloadJobProcessor() {
        SourceManagerSettings sourceManagerSettings = (SourceManagerSettings)this.servletContext.getAttribute("settings.sourceManager");
        DownloadJobProcessor downloadJobProcessor = new DownloadJobProcessor(sourceManagerSettings, this.processorEnv);
        downloadJobProcessor.start();
        this.servletContext.setAttribute("com.neptunelabs.fsiserver.DownloadJobProcessor", (Object)downloadJobProcessor);
    }

    private void initSourceManager() {
        SourceManager sourceManager = new SourceManager(this.servletContext);
        sourceManager.init();
        this.servletContext.setAttribute("com.neptunelabs.fsiserver.SourceManager", (Object)sourceManager);
    }

    private void initRequestProcessorExecutor(FSILogger fSILogger, RequestProcessorSettings requestProcessorSettings) {
        int n = requestProcessorSettings.getPrefsInt("application", "executorPoolSize");
        int n2 = requestProcessorSettings.getPrefsInt("application", "executorPoolMaximumSize");
        long l = requestProcessorSettings.getPrefsLong("application", "executorTimeOut");
        int n3 = requestProcessorSettings.getPrefsInt("application", "executorQueueCapacity");
        this.asyncRequestExecutor = new ThreadPoolExecutor(n, n2, l, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(n3));
    }

    private void shutdownRequestProcessorExecutor() {
        if (this.asyncRequestExecutor != null) {
            this.asyncRequestExecutor.shutdown();
            try {
                this.asyncRequestExecutor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void shutdownSourceManager() {
        Object object = this.servletContext.getAttribute("com.neptunelabs.fsiserver.SourceManager");
        if (object != null) {
            ((SourceManager)object).destroy();
        }
    }

    private void shutdownDownloadJobProcessor() {
        Object object = this.servletContext.getAttribute("com.neptunelabs.fsiserver.DownloadJobProcessor");
        if (object != null) {
            ((DownloadJobProcessor)object).halt();
            try {
                ((DownloadJobProcessor)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.acceptRequests) {
            AppRequestListener appRequestListener = new AppRequestListener();
            AsyncContext asyncContext = httpServletRequest.startAsync();
            asyncContext.addListener((AsyncListener)new AppRequestListener());
            asyncContext.setTimeout(this.requestTimeout);
            MainProcessorNG mainProcessorNG = new MainProcessorNG(asyncContext, this.processorEnv);
            mainProcessorNG.setListener(appRequestListener);
            this.asyncRequestExecutor.execute(mainProcessorNG);
        } else {
            Object object = this.servletContext.getAttribute("com.neptunelabs.fsiserver.requestprocessor.startError");
            if (object != null) {
                httpServletResponse.sendError(500, (String)object);
            } else {
                httpServletResponse.sendError(503);
            }
        }
    }
}

