/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.ReaderAbstract;
import com.neptunelabs.fsiserver.framework.io.ReaderChannel;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class EISChainReader {
    public static Map<String, Integer> readAll(Path path) throws IOException {
        Map<String, Integer> map;
        block13: {
            map = null;
            try (ReaderChannel readerChannel = new ReaderChannel(path, StandardOpenOption.READ);){
                EISChainReader.readAndEvaluateMagic(readerChannel);
                EISChainReader.readAndHandleByteOrderEntry(readerChannel);
                short s = EISChainReader.readVersion(readerChannel);
                if (s == 1) {
                    map = EISChainReader.readAll(readerChannel);
                    break block13;
                }
                throw new IOException("Unknown EIS Chain Version: " + s + " in " + readerChannel);
            }
        }
        return map;
    }

    public static boolean isChainFile(Path path) throws IOException, ClosedByInterruptException {
        try (FileChannel fileChannel = (FileChannel)Files.newByteChannel(path, StandardOpenOption.READ);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            if (fileChannel.read(byteBuffer) != 8) {
                boolean bl = false;
                return bl;
            }
            boolean bl = Arrays.equals(byteBuffer.array(), EISEnvironment.\u00d600000);
            return bl;
        }
    }

    public static int findChainEntryNumber(Path path, String string) throws IOException {
        int n;
        block13: {
            n = -1;
            try (ReaderChannel readerChannel = new ReaderChannel(path, StandardOpenOption.READ);){
                EISChainReader.readAndEvaluateMagic(readerChannel);
                EISChainReader.readAndHandleByteOrderEntry(readerChannel);
                short s = EISChainReader.readVersion(readerChannel);
                if (s == 1) {
                    n = EISChainReader.readUntilEntryFound(readerChannel, string);
                    break block13;
                }
                throw new IOException("Unknown EIS Chain Version: " + s + " in " + readerChannel);
            }
        }
        return n;
    }

    public static int findChainEntryNumber(ReaderAbstract readerAbstract, String string) throws IOException {
        int n = -1;
        if (readerAbstract.position() != 8L) {
            readerAbstract.seek(8L);
        }
        EISChainReader.readAndHandleByteOrderEntry(readerAbstract);
        short s = EISChainReader.readVersion(readerAbstract);
        if (s != 1) {
            throw new IOException("Unknown EIS Chain Version: " + s + " in " + readerAbstract);
        }
        n = EISChainReader.readUntilEntryFound(readerAbstract, string);
        return n;
    }

    private static Map<String, Integer> readAll(ReaderAbstract readerAbstract) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        while (readerAbstract.position() < readerAbstract.length()) {
            int n = readerAbstract.readInt();
            int n2 = readerAbstract.readInt();
            byte[] byArray = new byte[n2];
            readerAbstract.read(byArray);
            String string = new String(byArray, FileOperations.new);
            hashMap.put(string, n);
        }
        return hashMap;
    }

    private static int readUntilEntryFound(ReaderAbstract readerAbstract, String string) throws IOException {
        int n = -1;
        while (readerAbstract.position() < readerAbstract.length()) {
            int n2 = readerAbstract.readInt();
            int n3 = readerAbstract.readInt();
            byte[] byArray = new byte[n3];
            readerAbstract.read(byArray);
            String string2 = new String(byArray, FileOperations.new);
            if (!string2.equals(string)) continue;
            n = n2;
            break;
        }
        return n;
    }

    private static void readAndEvaluateMagic(ReaderAbstract readerAbstract) throws IOException {
        byte[] byArray = new byte[8];
        readerAbstract.read(byArray);
        if (!Arrays.equals(byArray, EISEnvironment.\u00d600000)) {
            throw new IOException("Not a valid EIS Chain File (RAEM): " + readerAbstract);
        }
    }

    static void readAndEvaluateMagic(SeekableByteChannel seekableByteChannel) throws IOException {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        seekableByteChannel.read(byteBuffer);
        if (!Arrays.equals(byArray, EISEnvironment.\u00d600000)) {
            throw new IOException("Not a valid EIS Chain File: " + seekableByteChannel);
        }
    }

    private static ByteOrder readAndHandleByteOrderEntry(ReaderAbstract readerAbstract) throws IOException {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        byte by = readerAbstract.readByte();
        if (by == 126) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (by == -66) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        readerAbstract.setByteOrder(byteOrder);
        return byteOrder;
    }

    static ByteOrder readAndHandleByteOrderEntry(SeekableByteChannel seekableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        seekableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        byte by = byteBuffer.get();
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        if (by == 126) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (by == -66) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        return byteOrder;
    }

    private static short readVersion(ReaderAbstract readerAbstract) throws IOException {
        return readerAbstract.readShort();
    }

    static short readVersion(SeekableByteChannel seekableByteChannel, ByteOrder byteOrder) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        seekableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        byteBuffer.order(byteOrder);
        return byteBuffer.getShort();
    }
}

