/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.debug;

import com.neptunelabs.fsiserver.framework.helpers.HexDumpEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.metadata.IIOMetadata;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    private static final DateFormat super = new SimpleDateFormat("HH:mm:ss.S");
    private static final String \u00d300000 = "\t";
    private static final String \u00d200000 = "\n";

    public static void printStackTrace() {
        Debug.printStackTrace("unnamed");
    }

    public static void printStackTrace(String string) {
        StackTraceElement[] stackTraceElementArray;
        System.err.println("************ " + string + " ************");
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(Debug.class.getCanonicalName()) || stackTraceElement.getClassName().startsWith("java.lang.Thread")) continue;
            System.err.println("\tat " + stackTraceElement);
        }
        System.err.println("************ /" + string + " ************");
    }

    public static void log(String string) {
        Logger logger = Logger.getLogger("FSIServer");
        logger.info(string);
    }

    public static void echo(Object object) {
        Thread thread = Thread.currentThread();
        StackTraceElement stackTraceElement = thread.getStackTrace()[2];
        String string = stackTraceElement.getClassName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        String string3 = stackTraceElement.getMethodName();
        int n = stackTraceElement.getLineNumber();
        System.err.println(super.format(new Date()) + \u00d300000 + object + "\tat " + stackTraceElement);
    }

    public static void echoOld(Object object) {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(Debug.class.getCanonicalName()) || stackTraceElement.getClassName().startsWith("java.lang.Thread")) continue;
            System.err.println(super.format(new Date()) + " " + stackTraceElement.getMethodName() + ": " + object);
            break;
        }
    }

    public static void dumpIIOMetadata(IIOMetadata iIOMetadata) {
        if (iIOMetadata != null) {
            Node node = iIOMetadata.getAsTree("javax_imageio_1.0");
            System.err.println(Debug.printDocument(node));
        }
    }

    private static String printDocument(Node node) {
        OutputStream outputStream = new OutputStream(){
            private final StringBuilder o00000 = new StringBuilder();

            @Override
            public void write(int n) {
                this.o00000.append((char)n);
            }

            public String toString() {
                return this.o00000.toString();
            }
        };
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(node), new StreamResult(new OutputStreamWriter(outputStream, "UTF-8")));
        }
        catch (UnsupportedEncodingException | TransformerException exception) {
            exception.printStackTrace();
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return outputStream.toString();
    }

    public static void printHexDump(ByteBuffer byteBuffer) {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        int n = byteBuffer.position();
        byteBuffer.position(0);
        System.err.println(hexDumpEncoder.encode(byteBuffer));
        byteBuffer.position(n);
    }

    public static void printHexDump(byte[] byArray) {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        System.err.println(hexDumpEncoder.encode(byArray));
    }

    public static void dumpRequest(StringBuilder stringBuilder, HttpServletRequest httpServletRequest) {
        stringBuilder.append(\u00d300000).append("[Class] ").append(httpServletRequest.getClass().getName()).append(", instance=" + httpServletRequest.toString().trim()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[RequestedSessionId] ").append(httpServletRequest.getRequestedSessionId()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[RequestURI] ").append(httpServletRequest.getRequestURI()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[ServletPath] ").append(httpServletRequest.getServletPath()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[CharacterEncoding] ").append(httpServletRequest.getCharacterEncoding()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[ContentLength] ").append(httpServletRequest.getContentLength()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[ContentType] ").append(httpServletRequest.getContentType()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[Locale] ").append(httpServletRequest.getLocale()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[Locales] ").append(Collections.list(httpServletRequest.getLocales()).stream().map(locale -> locale.toString()).collect(Collectors.joining(", "))).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[Scheme] ").append(httpServletRequest.getScheme()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[isSecure] ").append(httpServletRequest.isSecure()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[Protocol] ").append(httpServletRequest.getProtocol()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[RemoteAddr] ").append(httpServletRequest.getRemoteAddr()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[RemoteHost] ").append(httpServletRequest.getRemoteHost()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[ServerName] ").append(httpServletRequest.getServerName()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[ServerPort] ").append(httpServletRequest.getServerPort()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[ContextPath] ").append(httpServletRequest.getContextPath()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[Method] ").append(httpServletRequest.getMethod()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[QueryString] ").append(httpServletRequest.getQueryString()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[PathInfo] ").append(httpServletRequest.getPathInfo()).append(\u00d200000);
        stringBuilder.append(\u00d300000).append("[RemoteUser] ").append(httpServletRequest.getRemoteUser()).append(\u00d200000);
    }

    public static void dumpRequestHeader(StringBuilder stringBuilder, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuilder.append(\u00d300000).append("[header] ").append(string).append("=").append(httpServletRequest.getHeader(string)).append(\u00d200000);
        }
    }

    public static void dumpRequestParameter(StringBuilder stringBuilder, HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuilder.append(\u00d300000).append("[param] ").append(string).append("=").append(httpServletRequest.getParameter(string)).append(\u00d200000);
        }
    }

    public static void dumpRequestSessionAttribute(StringBuilder stringBuilder, HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuilder.append(\u00d300000).append("[session] ").append(string).append("=").append(httpSession.getAttribute(string)).append(\u00d200000);
            }
        }
    }
}

