/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.freemarker;

import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.FileEventCallback;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.yworks.util.annotation.Obfuscation;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class TemplateCache {
    private final FSILogger \u00d400000;
    private final Configuration Object;
    private final HashMap<String, Template> \u00d200000 = new HashMap();
    private final HashMap<Path, TemplateType> o00000 = new HashMap();
    private final FileEventCursor \u00d500000;
    private DirectoryStream.Filter<Path> \u00d600000;

    public TemplateCache(FSILogger fSILogger, Configuration configuration, FileEventCursor fileEventCursor) {
        this.\u00d400000 = fSILogger;
        this.Object = configuration;
        this.\u00d500000 = fileEventCursor;
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:*.ftl");
        this.\u00d600000 = path -> pathMatcher.matches(path.getFileName());
    }

    public void registerTemplates(TemplateType templateType, Path path, boolean bl) throws IOException {
        if (Files.isReadable(path) && !this.o00000.containsKey(path)) {
            this.o00000.put(path, templateType);
            this.loadTemplates(templateType, path);
            if (bl && this.\u00d500000 != null) {
                FileEventCallback fileEventCallback = new FileEventCallback(this, "flush", null);
                ArrayList<FileEventCallback> arrayList = new ArrayList<FileEventCallback>();
                arrayList.add(fileEventCallback);
                this.\u00d500000.addPathMonitor(path, this.\u00d600000, true, arrayList);
            }
        } else if (Files.notExists(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
    }

    private void loadTemplates(TemplateType templateType, Path path) throws IOException {
        File file = null;
        TemplateLoader templateLoader = this.Object.getTemplateLoader();
        if (templateLoader instanceof FileTemplateLoader) {
            file = ((FileTemplateLoader)templateLoader).baseDir;
        }
        List<PathCached> list = FileOperations.getRecurseDirectoryFiles(path, this.\u00d600000);
        for (PathCached pathCached : list) {
            try {
                this.Object.setDirectoryForTemplateLoading(pathCached.getParent().toFile());
                Template template = this.Object.getTemplate(pathCached.getFileName());
                String string = templateType.name() + pathCached.getAbsoluteName().substring(path.toAbsolutePath().toString().length()).replace(File.separatorChar, '/');
                template.setCustomAttribute("checksum", (Object)template.toString().hashCode());
                this.\u00d200000.put(string, template);
            }
            catch (IOException iOException) {
                this.\u00d400000.logException(iOException, 1598, pathCached, iOException.getLocalizedMessage());
            }
        }
        if (file != null) {
            this.Object.setDirectoryForTemplateLoading(file);
        }
    }

    public Template getTemplate(TemplateType templateType, String string) throws IOException {
        String string2 = templateType.name() + "/" + string.replace(File.separatorChar, '/');
        Template template = this.\u00d200000.get(string2);
        if (template != null) {
            return template;
        }
        throw new NoSuchFileException(string);
    }

    public Configuration getConfiguration() {
        return this.Object;
    }

    @Obfuscation
    public void flush() {
        this.\u00d200000.clear();
        this.Object.clearTemplateCache();
        for (Path path : this.o00000.keySet()) {
            try {
                this.loadTemplates(this.o00000.get(path), path);
            }
            catch (IOException iOException) {}
        }
        if (this.\u00d400000 != null) {
            this.\u00d400000.log(1591, new Object[0]);
        }
    }

    public void dispose() {
        this.\u00d200000.clear();
        this.o00000.clear();
    }
}

