/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.helpers;

import java.nio.charset.Charset;

public final class URLDecoderFast {
    public static String decode(String string, Charset charset) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(n > 500 ? n / 2 : n);
        int n2 = 0;
        byte[] byArray = null;
        block6: while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '+': {
                    stringBuilder.append(' ');
                    ++n2;
                    bl = true;
                    continue block6;
                }
                case '%': {
                    char c2;
                    if (n2 + 5 < n && cArray[n2 + 1] == 'u') {
                        c2 = (char)(URLDecoderFast.hexNibbleDigit(cArray[n2 + 2]) << 12 | URLDecoderFast.hexNibbleDigit(cArray[n2 + 3]) << 8 | URLDecoderFast.hexNibbleDigit(cArray[n2 + 4]) << 4 | URLDecoderFast.hexNibbleDigit(cArray[n2 + 5]));
                        stringBuilder.append(c2);
                        n2 += 6;
                    } else {
                        try {
                            if (byArray == null) {
                                byArray = new byte[(n - n2) / 3];
                            }
                            c2 = '\u0000';
                            while (n2 + 2 < n && c == '%') {
                                byArray[c2++] = (byte)(URLDecoderFast.hexNibbleDigit(cArray[n2 + 1]) << 4 | URLDecoderFast.hexNibbleDigit(cArray[n2 + 2]));
                                if ((n2 += 3) >= n) continue;
                                c = cArray[n2];
                            }
                            if (n2 < n && c == '%') {
                                throw new IllegalArgumentException("URLUnescaper: Incomplete trailing escape (%) pattern");
                            }
                            stringBuilder.append(new String(byArray, 0, (int)c2, charset));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("URLUnescaper: Illegal hex characters in escape (%) pattern - " + numberFormatException.getMessage());
                        }
                    }
                    bl = true;
                    continue block6;
                }
            }
            stringBuilder.append(c);
            ++n2;
        }
        return bl ? stringBuilder.toString() : string;
    }

    private static int hexNibbleDigit(char c) {
        int n;
        switch (c) {
            case '0': {
                n = 0;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case 'A': 
            case 'a': {
                n = 10;
                break;
            }
            case 'B': 
            case 'b': {
                n = 11;
                break;
            }
            case 'C': 
            case 'c': {
                n = 12;
                break;
            }
            case 'D': 
            case 'd': {
                n = 13;
                break;
            }
            case 'E': 
            case 'e': {
                n = 14;
                break;
            }
            case 'F': 
            case 'f': {
                n = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("URLUnescaper: Illegal hex characters in escape (%) pattern: " + c);
            }
        }
        return n;
    }
}

