/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.color;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.fsiserver.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.fsiserver.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class ParallelColorOperation
extends EffectUtils {
    public ParallelColorOperation(FSILogger fSILogger) {
        super(fSILogger);
    }

    public FSIImage transform(FSIImage fSIImage, ColorOperatorImpl colorOperatorImpl, boolean bl) throws ProcessingException {
        ColorOperatorImpl[] colorOperatorImplArray = new ColorOperatorImpl[]{colorOperatorImpl};
        return this.transform(fSIImage, colorOperatorImplArray, bl);
    }

    public FSIImage transform(FSIImage fSIImage, List<ColorOperatorImpl> list, boolean bl) throws ProcessingException {
        ColorOperatorImpl[] colorOperatorImplArray = new ColorOperatorImpl[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            colorOperatorImplArray[i] = list.get(i);
        }
        return this.transform(fSIImage, colorOperatorImplArray, bl);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FSIImage transform(FSIImage fSIImage, ColorOperatorImpl[] colorOperatorImplArray, boolean bl) throws ProcessingException {
        FSIImage fSIImage2;
        block10: {
            int n;
            fSIImage2 = fSIImage.createCompatibleImage();
            int n2 = this.calcThreads(fSIImage);
            ExecutorService executorService = ExecutorPool.createExecutorService("PCO", n2);
            ArrayList<CompletableFuture<Void>> arrayList = new ArrayList<CompletableFuture<Void>>(n2);
            int[][] nArray = ParallelColorOperation.calcThreadImageRanges(fSIImage.getHeight(), n2);
            for (n = 0; n < n2; ++n) {
                int[] nArray2 = nArray[n];
                _o _o2 = new _o(nArray2[0], nArray2[1]);
                _o2.\u00d8O0000(colorOperatorImplArray);
                _o2.setAlphaSelection(this.\u00d200000);
                _o2.setImages(fSIImage, fSIImage2);
                arrayList.add(CompletableFuture.supplyAsync(_o2, executorService));
            }
            n = 0;
            try {
                n = ExecutorPool.shutdownAndWait(executorService, arrayList, 60) ? 1 : 0;
                ExecutorPool.getAllVoid(arrayList);
                if (n != 0) break block10;
            }
            catch (InterruptedException interruptedException) {
                if (n == 0) {
                    ParallelColorOperation.disposeImages(fSIImage2);
                }
                break block10;
                catch (ExecutionException executionException) {
                    try {
                        throw new ProcessingException(executionException);
                    }
                    catch (Throwable throwable) {
                        if (n == 0) {
                            ParallelColorOperation.disposeImages(fSIImage2);
                        }
                        throw throwable;
                    }
                }
            }
            ParallelColorOperation.disposeImages(fSIImage2);
        }
        if (!bl) {
            fSIImage.dispose();
        }
        return fSIImage2;
    }

    private final class _o
    extends EffectThreadAbstract {
        private ColorOperatorImpl[] \u00d3\u00d20000;

        _o(int n, int n2) {
            super(n, n2);
        }

        void \u00d8O0000(ColorOperatorImpl[] colorOperatorImplArray) {
            this.\u00d3\u00d20000 = colorOperatorImplArray;
        }

        public Void thissuper() {
            int n;
            int[] nArray = new int[this.\u00d200000];
            int n2 = n = this.\u00d600000 * this.\u00d200000;
            this.\u00d300000.setPosition(n);
            for (int i = this.\u00d600000; i <= this.class; ++i) {
                n = i * this.\u00d200000;
                this.\u00d300000.getSamples(nArray, 0, nArray.length);
                int n3 = 0;
                while (n3 < this.\u00d200000) {
                    int n4;
                    int n5 = n4 = ParallelColorOperation.this.\u00d200000 == null ? 255 : ParallelColorOperation.this.\u00d200000[n2] & 0xFF;
                    if (n4 > 0) {
                        int n6;
                        int n7 = n6 = nArray[n3];
                        for (ColorOperatorImpl colorOperatorImpl : this.\u00d3\u00d20000) {
                            n7 = colorOperatorImpl.transform(n7, 0);
                        }
                        if (n4 < 255) {
                            n7 = _o.blend(n6, n7, n4);
                        }
                        nArray[n3] = n7;
                    }
                    ++n3;
                    ++n2;
                }
                this.\u00d400000.setSamples((long)n, nArray);
            }
            return null;
        }
    }
}

