/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.helper;

import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import java.awt.color.ICC_Profile;
import java.nio.ByteOrder;

public final class ICCDumper {
    public static String dump(String string, byte[] byArray) {
        return ICCDumper.dump(string, ICC_Profile.getInstance(byArray));
    }

    public static String dump(String string, ICC_Profile iCC_Profile) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iCC_Profile != null) {
            byte[] byArray;
            float[] fArray;
            if (string != null) {
                stringBuilder.append("Name:" + string + "\n");
            }
            stringBuilder.append("ColorSpaceType:" + iCC_Profile.getColorSpaceType() + "\n");
            stringBuilder.append("MajorVersion:" + iCC_Profile.getMajorVersion() + "\n");
            stringBuilder.append("MinorVersion:" + iCC_Profile.getMinorVersion() + "\n");
            stringBuilder.append("NumComponents:" + iCC_Profile.getNumComponents() + "\n");
            stringBuilder.append("PCSType:" + iCC_Profile.getPCSType() + "\n");
            stringBuilder.append("ProfileClass:" + iCC_Profile.getProfileClass() + "\n");
            float[] fArray2 = ICCDumper.getXYZData(iCC_Profile, 0x77747074);
            if (fArray2 != null) {
                stringBuilder.append("WhitePoint:" + fArray2[0] + "x" + fArray2[1] + "x" + fArray2[2] + "\n");
            }
            if ((fArray = ICCDumper.getXYZData(iCC_Profile, 1651208308)) != null) {
                stringBuilder.append("BlackPoint:" + fArray[0] + "x" + fArray[1] + "x" + fArray[2] + "\n");
            }
            if ((byArray = iCC_Profile.getData(80)) != null) {
                stringBuilder.append("Creator:" + new String(byArray) + "\n");
            }
            if ((byArray = iCC_Profile.getData(48)) != null) {
                stringBuilder.append("Manufacturer:" + new String(byArray) + "\n");
            }
            if ((byArray = iCC_Profile.getData(84)) != null) {
                stringBuilder.append("ProfileID:" + new String(byArray) + "\n");
            }
            if ((byArray = iCC_Profile.getData(40)) != null) {
                stringBuilder.append("Platform:" + new String(byArray) + "\n");
            }
            if ((byArray = iCC_Profile.getData(1935897188)) != null) {
                stringBuilder.append("icSigScreeningDescTag:" + new String(byArray) + "\n");
            }
            if ((byArray = iCC_Profile.getData(1886610801)) != null) {
                stringBuilder.append("icSigProfileSequenceDescTag:" + new String(byArray) + "\n");
            }
            if ((byArray = iCC_Profile.getData(1684370275)) != null) {
                String string2 = null;
                int n = ICCDumper.getInt(byArray, 0);
                if (n == 1684370275) {
                    int n2;
                    for (n2 = ICCDumper.getInt(byArray, 8); byArray[12 + n2 - 1] == 0 && n2 >= 0; --n2) {
                    }
                    if (n2 > 0) {
                        string2 = new String(byArray, 12, n2).trim();
                    }
                } else if (n == 1835824483) {
                    int n3 = ICCDumper.getInt(byArray, 20);
                    byte[] byArray2 = new byte[n3];
                    int n4 = ICCDumper.getInt(byArray, 24);
                    System.arraycopy(byArray, n4, byArray2, 0, n3);
                    string2 = new String(byArray2, FileOperations.\u00d300000).trim();
                }
                stringBuilder.append("Description:" + string2 + "\n");
            }
        }
        return stringBuilder.toString();
    }

    private static int getInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 = n2 << 8 | 0xFF & byArray[i + n];
        }
        return n2;
    }

    private static float[] getXYZData(ICC_Profile iCC_Profile, int n) {
        byte[] byArray = iCC_Profile.getData(n);
        if (byArray == null) {
            return null;
        }
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.BIG_ENDIAN);
        if (byteArrayWalker.getInt(0) != 1482250784) {
            return null;
        }
        float[] fArray = new float[]{(float)byteArrayWalker.getInt(8) / 65536.0f, (float)byteArrayWalker.getInt(12) / 65536.0f, (float)byteArrayWalker.getInt(16) / 65536.0f};
        return fArray;
    }
}

