/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.mbeans;

import com.neptunelabs.fsiserver.framework.licensing.Licence;
import com.neptunelabs.fsiserver.imagereader.converter.FastMath;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@Obfuscation
public final class SystemMonitor
extends Thread {
    private final AtomicLong[] accumulators;
    private int lastSlowCheck = 60;
    private final AtomicLong ttfb10 = new AtomicLong(0L);
    private final AtomicLong ttfb25 = new AtomicLong(0L);
    private final AtomicLong ttfb50 = new AtomicLong(0L);
    private final AtomicLong ttfb100 = new AtomicLong(0L);
    private final AtomicLong ttfb250 = new AtomicLong(0L);
    private final AtomicLong ttfb500 = new AtomicLong(0L);
    private final AtomicLong ttfb1000 = new AtomicLong(0L);
    private final AtomicLong ttfb2500 = new AtomicLong(0L);
    private final AtomicLong ttfb5000 = new AtomicLong(0L);
    private final AtomicLong ttfb5000plus = new AtomicLong(0L);
    private final AtomicLong[] ttfb60Sec = new AtomicLong[60];
    private final AtomicInteger[] ttfb60Hits = new AtomicInteger[60];
    private final AtomicInteger ttfb60Pos = new AtomicInteger(0);
    private final AtomicLong ttlb10 = new AtomicLong(0L);
    private final AtomicLong ttlb25 = new AtomicLong(0L);
    private final AtomicLong ttlb50 = new AtomicLong(0L);
    private final AtomicLong ttlb100 = new AtomicLong(0L);
    private final AtomicLong ttlb250 = new AtomicLong(0L);
    private final AtomicLong ttlb500 = new AtomicLong(0L);
    private final AtomicLong ttlb1000 = new AtomicLong(0L);
    private final AtomicLong ttlb2500 = new AtomicLong(0L);
    private final AtomicLong ttlb5000 = new AtomicLong(0L);
    private final AtomicLong ttlb5000plus = new AtomicLong(0L);
    private final AtomicLong[] ttlb60Sec = new AtomicLong[60];
    private final AtomicInteger[] ttlb60Hits = new AtomicInteger[60];
    private final AtomicInteger ttlb60Pos = new AtomicInteger(0);
    private final AtomicInteger concurrentRequests = new AtomicInteger(0);
    private final AtomicInteger[] concurrentRequests60Sec = new AtomicInteger[60];
    private final AtomicInteger concurrentRequests60Pos = new AtomicInteger(0);
    private final AtomicInteger concurrentProcessing = new AtomicInteger(0);
    private final AtomicInteger[] concurrentProcessing60Sec = new AtomicInteger[60];
    private final AtomicInteger concurrentProcessing60Pos = new AtomicInteger(0);
    private boolean runDaemon = true;
    private static final long sleep = 1000L;
    private Path pool;
    private final int CPUs;
    private final ThreadMXBean tmb;
    private final RuntimeMXBean rmb;
    private long totalSpace = 0L;
    private long usedSpace = 0L;
    private long usableSpace = Long.MAX_VALUE;
    private long uptime = 0L;
    private int cpuLoad = 0;
    private final boolean imageCounted = false;
    private long imageCount = 0L;
    private long imageSize = 0L;
    private int groupCount = 0;
    private int connectorCount = 0;
    private long maxImageCount = 0L;
    private long expiresEndTime = 0L;
    private long prevUpTime;
    private Map<Long, Long> prevThreadCpuTime = null;
    private int serverInstances = 1;
    private long processingImages = 0L;
    private long processingSwapImages = 0L;
    private long lastScannerTime = 0L;
    private Timer monitorRing = null;

    public SystemMonitor() {
        this.setPriority(1);
        this.setDaemon(true);
        this.setName("System Monitor");
        this.accumulators = new AtomicLong[Accumulators.values().length];
        this.CPUs = Runtime.getRuntime().availableProcessors();
        this.tmb = ManagementFactory.getThreadMXBean();
        this.rmb = ManagementFactory.getRuntimeMXBean();
        this.prevUpTime = this.rmb.getUptime();
        this.setupAccumulators();
        this.setupRingbufferTimer();
    }

    public void setLicence(Licence licence) {
        this.maxImageCount = licence.getMaxImages();
        this.expiresEndTime = licence.getExpireTime();
    }

    public void setStorageDir(Path path) {
        this.pool = path;
    }

    private void setupRingbufferTimer() {
        RingBuffer ringBuffer = new RingBuffer();
        this.monitorRing = new Timer("SystemMonitor Ring");
        this.monitorRing.scheduleAtFixedRate((TimerTask)ringBuffer, 0L, 1000L);
    }

    private void setupAccumulators() {
        int n;
        for (Accumulators accumulators : Accumulators.values()) {
            this.accumulators[accumulators.ordinal()] = new AtomicLong(0L);
        }
        for (n = 0; n < this.ttfb60Sec.length; ++n) {
            this.ttfb60Sec[n] = new AtomicLong(0L);
        }
        for (n = 0; n < this.ttfb60Hits.length; ++n) {
            this.ttfb60Hits[n] = new AtomicInteger(0);
        }
        for (n = 0; n < this.ttlb60Sec.length; ++n) {
            this.ttlb60Sec[n] = new AtomicLong(0L);
        }
        for (n = 0; n < this.ttlb60Hits.length; ++n) {
            this.ttlb60Hits[n] = new AtomicInteger(0);
        }
        for (n = 0; n < this.concurrentRequests60Sec.length; ++n) {
            this.concurrentRequests60Sec[n] = new AtomicInteger(0);
        }
        for (n = 0; n < this.concurrentProcessing60Sec.length; ++n) {
            this.concurrentProcessing60Sec[n] = new AtomicInteger(0);
        }
    }

    @Override
    public void run() {
        while (this.runDaemon) {
            try {
                Thread.sleep(1000L);
                this.uptime = this.rmb.getUptime();
                if (++this.lastSlowCheck >= 60) {
                    this.lastSlowCheck = 0;
                    this.measurePoolSpace();
                }
                this.measureCPULoad();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void halt() {
        this.runDaemon = false;
        this.interrupt();
        if (this.monitorRing != null) {
            this.monitorRing.cancel();
            this.monitorRing.purge();
        }
    }

    public long increaseAccumulator(Accumulators accumulators) {
        return this.accumulators[accumulators.ordinal()].incrementAndGet();
    }

    public long increaseAccumulator(Accumulators accumulators, long l) {
        return this.accumulators[accumulators.ordinal()].addAndGet(l);
    }

    public long getAccumulator(Accumulators accumulators) {
        return this.accumulators[accumulators.ordinal()].get();
    }

    public void setTTFB(long l) {
        if (l <= 10L) {
            this.ttfb10.getAndIncrement();
        } else if (l <= 25L) {
            this.ttfb25.getAndIncrement();
        } else if (l <= 50L) {
            this.ttfb50.getAndIncrement();
        } else if (l <= 100L) {
            this.ttfb100.getAndIncrement();
        } else if (l <= 250L) {
            this.ttfb250.getAndIncrement();
        } else if (l <= 500L) {
            this.ttfb500.getAndIncrement();
        } else if (l <= 1000L) {
            this.ttfb1000.getAndIncrement();
        } else if (l <= 2500L) {
            this.ttfb2500.getAndIncrement();
        } else if (l <= 5000L) {
            this.ttfb5000.getAndIncrement();
        } else {
            this.ttfb5000plus.getAndIncrement();
        }
        int n = this.ttfb60Pos.get();
        this.ttfb60Sec[n].addAndGet(l);
        this.ttfb60Hits[n].incrementAndGet();
    }

    public int getAvgTTFB60() {
        return (int)SystemMonitor.calcBufferAVG(this.ttfb60Sec, this.ttfb60Hits);
    }

    public long getTTFB(int n) {
        if (n <= 10) {
            return this.ttfb10.get();
        }
        if (n <= 25) {
            return this.ttfb25.get();
        }
        if (n <= 50) {
            return this.ttfb50.get();
        }
        if (n <= 100) {
            return this.ttfb100.get();
        }
        if (n <= 250) {
            return this.ttfb250.get();
        }
        if (n <= 500) {
            return this.ttfb500.get();
        }
        if (n <= 1000) {
            return this.ttfb1000.get();
        }
        if (n <= 2500) {
            return this.ttfb2500.get();
        }
        if (n <= 5000) {
            return this.ttfb5000.get();
        }
        return this.ttfb5000plus.get();
    }

    public void setTTLB(long l) {
        if (l <= 10L) {
            this.ttlb10.getAndIncrement();
        } else if (l <= 25L) {
            this.ttlb25.getAndIncrement();
        } else if (l <= 50L) {
            this.ttlb50.getAndIncrement();
        } else if (l <= 100L) {
            this.ttlb100.getAndIncrement();
        } else if (l <= 250L) {
            this.ttlb250.getAndIncrement();
        } else if (l <= 500L) {
            this.ttlb500.getAndIncrement();
        } else if (l <= 1000L) {
            this.ttlb1000.getAndIncrement();
        } else if (l <= 2500L) {
            this.ttlb2500.getAndIncrement();
        } else if (l <= 5000L) {
            this.ttlb5000.getAndIncrement();
        } else {
            this.ttlb5000plus.getAndIncrement();
        }
        int n = this.ttlb60Pos.get();
        this.ttlb60Sec[n].addAndGet(l);
        this.ttlb60Hits[n].incrementAndGet();
    }

    public int getAvgTTLB60() {
        return (int)SystemMonitor.calcBufferAVG(this.ttlb60Sec, this.ttlb60Hits);
    }

    public long getTTLB(int n) {
        if (n <= 10) {
            return this.ttlb10.get();
        }
        if (n <= 25) {
            return this.ttlb25.get();
        }
        if (n <= 50) {
            return this.ttlb50.get();
        }
        if (n <= 100) {
            return this.ttlb100.get();
        }
        if (n <= 250) {
            return this.ttlb250.get();
        }
        if (n <= 500) {
            return this.ttlb500.get();
        }
        if (n <= 1000) {
            return this.ttlb1000.get();
        }
        if (n <= 2500) {
            return this.ttlb2500.get();
        }
        if (n <= 5000) {
            return this.ttlb5000.get();
        }
        return this.ttlb5000plus.get();
    }

    public void setConcurrentProcessing(int n) {
        this.concurrentProcessing.set(n);
        this.concurrentProcessing60Sec[this.concurrentProcessing60Pos.get()].set(n);
    }

    public int getConcurrentProcessing() {
        return this.concurrentProcessing.get();
    }

    public int getConcurrentProcessingMax() {
        return SystemMonitor.calcBufferMax(this.concurrentProcessing60Sec);
    }

    public void setConcurrentRequests(int n) {
        this.concurrentRequests.set(n);
        this.concurrentRequests60Sec[this.concurrentRequests60Pos.get()].set(n);
    }

    public int getConcurrentRequests() {
        return this.concurrentRequests.get();
    }

    public int getConcurrentRequestsMax() {
        return SystemMonitor.calcBufferMax(this.concurrentRequests60Sec);
    }

    public long getUptimeSec() {
        return this.uptime / 1000L;
    }

    public long getTotalStorageSpace() {
        return this.totalSpace;
    }

    public long getFreeStorageSpace() {
        return this.usableSpace;
    }

    public long getUsedStorageSpace() {
        return this.usedSpace;
    }

    public int getCPULoad() {
        return this.cpuLoad;
    }

    public void setScannerTime(long l) {
        this.lastScannerTime = l;
    }

    public long getScannerTime() {
        return this.lastScannerTime;
    }

    public long getAssetSize() {
        return this.imageSize;
    }

    public void setAssetSize(long l) {
        this.imageSize = l;
    }

    public long getAssetCount() {
        return this.imageCount;
    }

    public void setAssetCount(long l) {
        this.imageCount = l;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(int n) {
        this.groupCount = n;
    }

    public int getConnectorCount() {
        return this.connectorCount;
    }

    public void setConnectorCount(int n) {
        this.connectorCount = n;
    }

    public long getProcessingImages() {
        return this.processingImages;
    }

    public void setProcessingImages(long l) {
        this.processingImages = l;
    }

    public long getProcessingSwapImages() {
        return this.processingSwapImages;
    }

    public void setProcessingSwapImages(long l) {
        this.processingSwapImages = l;
    }

    public int getServerInstances() {
        return this.serverInstances;
    }

    public void setServerInstances(int n) {
        this.serverInstances = n;
    }

    public long getMaxImages() {
        return this.maxImageCount;
    }

    public long getExpireRestTime() {
        if (this.expiresEndTime > 0L) {
            return this.expiresEndTime - System.currentTimeMillis();
        }
        return 0L;
    }

    public boolean isImageCounted() {
        return false;
    }

    private void measurePoolSpace() {
        this.totalSpace = 0L;
        this.usableSpace = 0L;
        if (this.pool != null) {
            Iterable<FileStore> iterable = this.pool.getFileSystem().getFileStores();
            for (FileStore fileStore : iterable) {
                try {
                    this.totalSpace += fileStore.getTotalSpace();
                    this.usableSpace += fileStore.getUsableSpace();
                }
                catch (IOException iOException) {}
            }
            this.usedSpace = this.totalSpace - this.usableSpace;
        }
    }

    private void measureCPULoad() {
        if (this.tmb.isThreadCpuTimeEnabled()) {
            long l = this.uptime - this.prevUpTime;
            long[] lArray = this.tmb.getAllThreadIds();
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>(lArray.length);
            float f = 0.0f;
            for (long l2 : lArray) {
                if (l2 == -1L) continue;
                long l3 = this.tmb.getThreadCpuTime(l2);
                hashMap.put(l2, l3);
                if (this.prevThreadCpuTime == null || !this.prevThreadCpuTime.containsKey(l2)) continue;
                long l4 = l3 - this.prevThreadCpuTime.get(l2);
                float f2 = Math.min(99.0f, (float)l4 / ((float)l * 1000000.0f * (float)this.CPUs));
                f += f2;
            }
            this.cpuLoad = FastMath.round((f *= 100.0f) > 100.0f ? 100.0f : f);
            this.prevUpTime = this.uptime;
            this.prevThreadCpuTime = hashMap;
        }
    }

    private static long calcBufferAVG(AtomicLong[] atomicLongArray, AtomicInteger[] atomicIntegerArray) {
        int n = 0;
        float f = 0.0f;
        for (int i = 0; i < atomicLongArray.length; ++i) {
            long l = atomicLongArray[i].get();
            if (l == 0L) continue;
            n += atomicIntegerArray[i].get();
            f += (float)l;
        }
        return (long)(f / (float)n);
    }

    private static int calcBufferMax(AtomicInteger[] atomicIntegerArray) {
        int n = 0;
        for (AtomicInteger atomicInteger : atomicIntegerArray) {
            int n2 = atomicInteger.get();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static long calcBufferMax(AtomicLong[] atomicLongArray) {
        long l = 0L;
        for (AtomicLong atomicLong : atomicLongArray) {
            long l2 = atomicLong.get();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    private class RingBuffer
    extends TimerTask {
        RingBuffer() {
        }

        @Override
        public void run() {
            int n = SystemMonitor.this.ttfb60Pos.get();
            SystemMonitor.this.ttfb60Sec[n].set(0L);
            SystemMonitor.this.ttfb60Hits[n].set(0);
            if (n == 59) {
                SystemMonitor.this.ttfb60Pos.set(0);
            } else {
                SystemMonitor.this.ttfb60Pos.incrementAndGet();
            }
            int n2 = SystemMonitor.this.ttlb60Pos.get();
            SystemMonitor.this.ttlb60Sec[n2].set(0L);
            SystemMonitor.this.ttlb60Hits[n2].set(0);
            if (n2 == 59) {
                SystemMonitor.this.ttlb60Pos.set(0);
            } else {
                SystemMonitor.this.ttlb60Pos.incrementAndGet();
            }
            int n3 = SystemMonitor.this.concurrentRequests60Pos.get();
            SystemMonitor.this.concurrentRequests60Sec[n3].set(0);
            if (n3 == 59) {
                SystemMonitor.this.concurrentRequests60Pos.set(0);
            } else {
                SystemMonitor.this.concurrentRequests60Pos.incrementAndGet();
            }
            int n4 = SystemMonitor.this.concurrentProcessing60Pos.get();
            SystemMonitor.this.concurrentProcessing60Sec[n4].set(0);
            if (n4 == 59) {
                SystemMonitor.this.concurrentProcessing60Pos.set(0);
            } else {
                SystemMonitor.this.concurrentProcessing60Pos.incrementAndGet();
            }
        }
    }

    public static enum Accumulators {
        RP_HITS_ALL,
        RP_TRAFFIC_ALL,
        RP_HITS_STATIC,
        RP_TRAFFIC_STATIC,
        RP_HITS_MULTIRESOLUTION,
        RP_TRAFFIC_MULTIRESOLUTION,
        RP_HITS_STORAGE,
        RP_TRAFFIC_STORAGE,
        RP_HITS_IMAGE,
        RP_TRAFFIC_IMAGE,
        RP_HITS_INFO,
        RP_TRAFFIC_INFO,
        RP_HITS_LIST,
        RP_TRAFFIC_LIST,
        RP_HITS_SEARCH,
        RP_TRAFFIC_SEARCH,
        RP_HITS_CACHE,
        RP_TRAFFIC_CACHE,
        RP_HTTP_200,
        RP_HTTP_302,
        RP_HTTP_304,
        RP_HTTP_400,
        RP_HTTP_403,
        RP_HTTP_404,
        RP_HTTP_500,
        RP_HTTP_503,
        RP_METHOD_GET,
        RP_METHOD_HEAD,
        RP_METHOD_POST,
        RP_PIXEL_ALL,
        RP_PIXEL_MULTIRESOLUTION,
        RP_PIXEL_STORAGE,
        SM_IMPORTED_IMAGES,
        SM_PIXEL,
        SM_SWAP_CONVERSIONS,
        SM_IMPORTED_SUCCESS,
        SM_IMPORTED_SM_FAILED,
        SM_SCANTIME;

    }
}

