/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.effects;

import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.helpers.FloatingParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.area.Crop;
import com.neptunelabs.fsiserver.imagemanipulator.area.Emboss;
import com.neptunelabs.fsiserver.imagemanipulator.area.Flip;
import com.neptunelabs.fsiserver.imagemanipulator.area.Gaussian;
import com.neptunelabs.fsiserver.imagemanipulator.area.LinearGradient;
import com.neptunelabs.fsiserver.imagemanipulator.area.Pixelize;
import com.neptunelabs.fsiserver.imagemanipulator.area.perspective.PerspectiveDistortion;
import com.neptunelabs.fsiserver.imagemanipulator.color.AlphaMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.Brightness;
import com.neptunelabs.fsiserver.imagemanipulator.color.ChannelExchange;
import com.neptunelabs.fsiserver.imagemanipulator.color.ChannelLevel;
import com.neptunelabs.fsiserver.imagemanipulator.color.ChannelLevelTrunk;
import com.neptunelabs.fsiserver.imagemanipulator.color.ChannelRGBFilter;
import com.neptunelabs.fsiserver.imagemanipulator.color.ChannelSelect;
import com.neptunelabs.fsiserver.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.fsiserver.imagemanipulator.color.ColorOverlay;
import com.neptunelabs.fsiserver.imagemanipulator.color.Colorize;
import com.neptunelabs.fsiserver.imagemanipulator.color.Desaturate;
import com.neptunelabs.fsiserver.imagemanipulator.color.Fill;
import com.neptunelabs.fsiserver.imagemanipulator.color.Gamma;
import com.neptunelabs.fsiserver.imagemanipulator.color.GradientMap;
import com.neptunelabs.fsiserver.imagemanipulator.color.HueSaturation;
import com.neptunelabs.fsiserver.imagemanipulator.color.Invert;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteColor;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.fsiserver.imagemanipulator.color.Noise;
import com.neptunelabs.fsiserver.imagemanipulator.color.Opaque;
import com.neptunelabs.fsiserver.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.fsiserver.imagemanipulator.color.Posterize;
import com.neptunelabs.fsiserver.imagemanipulator.color.RGBMatrix;
import com.neptunelabs.fsiserver.imagemanipulator.color.Saturation;
import com.neptunelabs.fsiserver.imagemanipulator.color.Solarize;
import com.neptunelabs.fsiserver.imagemanipulator.color.Temperature;
import com.neptunelabs.fsiserver.imagemanipulator.color.Threshold;
import com.neptunelabs.fsiserver.imagemanipulator.color.Transparency;
import com.neptunelabs.fsiserver.imagemanipulator.color.WhiteBalance;
import com.neptunelabs.fsiserver.imagemanipulator.helper.Gradient;
import com.neptunelabs.fsiserver.imagemanipulator.helper.SmoothGradient;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.converter.FastMath;
import com.neptunelabs.fsiserver.imagereader.helper.Decode8BIM;
import com.neptunelabs.fsiserver.imagereader.helper.RangePixel;
import com.neptunelabs.fsiserver.imagereader.helper.RangeRelative;
import com.neptunelabs.fsiserver.imagereader.helper.Selection;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.effects.Effect;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class EffectsManager {
    private final FSILogger \u00d300000;
    private final Pattern o00000 = Pattern.compile("(\\w+\\([a-zA-Z0-9,\\+\\-\\.\\:]*?\\),?)+");
    private final Pattern new = Pattern.compile("(\\w+)\\(([a-zA-Z0-9,\\+\\-\\.\\:]*?)\\),?");

    public EffectsManager(FSILogger fSILogger) {
        this.\u00d300000 = fSILogger;
    }

    public Matcher findEffects(String string) {
        Matcher matcher = this.o00000.matcher(string);
        if (matcher.matches()) {
            return this.new.matcher(string);
        }
        return null;
    }

    public FSIImage applyEffects(FSIImage fSIImage, byte[] byArray, String string, Parameters parameters) throws IllegalArgumentException, ProcessingException {
        FSIImage fSIImage2 = null;
        Matcher matcher = this.findEffects(string);
        if (matcher != null) {
            Selection selection = null;
            while (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                if (string2.equalsIgnoreCase("Select")) {
                    selection = this.evalSelection(selection, string3, fSIImage, byArray, parameters);
                    continue;
                }
                FSIImage fSIImage3 = fSIImage2 != null ? fSIImage2 : fSIImage;
                try {
                    fSIImage2 = this.applyEffect(fSIImage3, string2, string3, parameters, selection);
                }
                catch (ProcessingException processingException) {
                    if (fSIImage2 != null) {
                        fSIImage2.dispose();
                    }
                    throw processingException;
                }
                if (fSIImage3 == fSIImage2 || fSIImage3 == fSIImage) continue;
                fSIImage3.dispose();
            }
        } else {
            throw new IllegalArgumentException(string);
        }
        if (fSIImage2 == null) {
            fSIImage2 = fSIImage;
        } else if (fSIImage2 != fSIImage) {
            fSIImage.dispose();
        }
        return fSIImage2;
    }

    private Selection evalSelection(Selection selection, String string, FSIImage fSIImage, byte[] byArray, Parameters parameters) throws NumberFormatException {
        Selection selection2 = null;
        String[] stringArray = string.split(",", 2);
        String string2 = stringArray[0];
        String string3 = stringArray.length > 1 ? stringArray[1] : null;
        if (string2.equalsIgnoreCase("new") || string2.equalsIgnoreCase("add") || string2.equalsIgnoreCase("sub")) {
            if (string3 != null) {
                String[] stringArray2 = string3.split(",", 2);
                String string4 = stringArray2[0];
                if (string4.equalsIgnoreCase("alpha")) {
                    int n = Integer.parseInt(stringArray2[1]);
                    if (n < fSIImage.getExtraAlphaCount()) {
                        byte[] byArray2 = new byte[fSIImage.getWidth() * fSIImage.getHeight()];
                        fSIImage.setPositionExtraAlpha(n, 0L);
                        fSIImage.getSamplesExtraAlpha(n, byArray2, 0, byArray2.length);
                        selection2 = new Selection(byArray2);
                    }
                } else if (string4.equalsIgnoreCase("path") && byArray != null) {
                    byte[] byArray3;
                    int n = Integer.parseInt(stringArray2[1]);
                    if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000)) {
                        int n2 = fSIImage.getWidth();
                        int n3 = fSIImage.getHeight();
                        float[] fArray = this.parseRangeParameterValue(parameters.get(Parameters.GeneralImage.\u00d3\u00d20000));
                        float f = -fArray[0];
                        float f2 = -fArray[1];
                        int n4 = FastMath.ceil((float)n2 / fArray[2]);
                        int n5 = FastMath.ceil((float)n3 / fArray[3]);
                        byArray3 = Decode8BIM.drawSelection(byArray, n, n2, n3, n4, n5, f, f2);
                    } else if (parameters.contains(Parameters.GeneralImage.o\u00d20000)) {
                        int n6 = fSIImage.getWidth();
                        int n7 = fSIImage.getHeight();
                        int n8 = Integer.parseInt(parameters.get(Parameters.GeneralImage.ifnew));
                        int n9 = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d3\u00d40000));
                        String[] stringArray3 = parameters.get(Parameters.GeneralImage.o\u00d20000).split(",", 5);
                        float f = (float)(-Integer.parseInt(stringArray3[0])) / (float)n8;
                        float f3 = (float)(-Integer.parseInt(stringArray3[1])) / (float)n9;
                        byArray3 = Decode8BIM.drawSelection(byArray, n, n6, n7, n8, n9, f, f3);
                    } else {
                        byArray3 = Decode8BIM.drawSelection(byArray, n, fSIImage.getWidth(), fSIImage.getHeight());
                    }
                    if (byArray3 != null) {
                        selection2 = new Selection(byArray3);
                    }
                } else if (string4.equalsIgnoreCase("rect")) {
                    RangePixel rangePixel;
                    String[] stringArray4 = stringArray2[1].split(",", 4);
                    RangeRelative rangeRelative = new RangeRelative(stringArray4);
                    if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000)) {
                        float[] fArray = this.parseRangeParameterValue(parameters.get(Parameters.GeneralImage.\u00d3\u00d20000));
                        int n = fSIImage.getWidth();
                        int n10 = fSIImage.getHeight();
                        int n11 = FastMath.ceil((float)n / fArray[2]);
                        int n12 = FastMath.ceil((float)n10 / fArray[3]);
                        int n13 = FastMath.floor((float)n11 * fArray[0]);
                        int n14 = FastMath.floor((float)n12 * fArray[1]);
                        rangePixel = RangePixel.create(rangeRelative, n11, n12, n13, n14, n, n10);
                    } else if (parameters.contains(Parameters.GeneralImage.o\u00d20000)) {
                        int n = fSIImage.getWidth();
                        int n15 = fSIImage.getHeight();
                        int n16 = Integer.parseInt(parameters.get(Parameters.GeneralImage.ifnew));
                        int n17 = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d3\u00d40000));
                        String[] stringArray5 = parameters.get(Parameters.GeneralImage.o\u00d20000).split(",", 5);
                        int n18 = Integer.parseInt(stringArray5[0]);
                        int n19 = Integer.parseInt(stringArray5[1]);
                        rangePixel = RangePixel.create(rangeRelative, n16, n17, n18, n19, n, n15);
                    } else {
                        rangePixel = RangePixel.create(rangeRelative, fSIImage.getWidth(), fSIImage.getHeight());
                    }
                    selection2 = new Selection(rangePixel);
                } else if (string4.equalsIgnoreCase("pixelrange")) {
                    String[] stringArray6 = stringArray2[1].split(",", 4);
                    RangePixel rangePixel = RangePixel.create(stringArray6, fSIImage.getWidth(), fSIImage.getHeight());
                    selection2 = new Selection(rangePixel);
                }
                if (!string2.equalsIgnoreCase("new") && selection != null && selection2 != null) {
                    if (string2.equalsIgnoreCase("add")) {
                        selection.addSelection(selection2);
                    } else if (string2.equalsIgnoreCase("sub")) {
                        selection.subtractSelection(selection2);
                    }
                    selection2 = selection;
                } else if (selection == null && string2.equalsIgnoreCase("sub")) {
                    selection2 = new Selection();
                }
            }
        } else if (string2.equalsIgnoreCase("clear")) {
            selection2 = new Selection();
        } else if (string2.equalsIgnoreCase("invert")) {
            if (selection != null) {
                selection.invert();
                selection2 = selection;
            } else {
                selection2 = new Selection();
                selection2.invert();
            }
        }
        return selection2;
    }

    private FSIImage applyEffect(FSIImage fSIImage, String string, String string2, Parameters parameters, Selection selection) throws ProcessingException {
        FSIImage fSIImage2;
        try {
            Effect effect = Effect.valueOf(string.toUpperCase());
            switch (effect) {
                case \u00d6O0000: {
                    Pixelize pixelize = new Pixelize(this.\u00d300000);
                    pixelize.setSelection(selection);
                    fSIImage2 = pixelize.transform(fSIImage, Integer.parseInt(string2), true);
                    break;
                }
                case Oo0000: {
                    fSIImage2 = this.applyBlurEffect(fSIImage, string2, selection);
                    break;
                }
                case supersuper: {
                    fSIImage2 = this.applySharpenEffect(fSIImage, string2, selection);
                    break;
                }
                case \u00f4O0000: {
                    fSIImage2 = this.applyGlowEffect(fSIImage, string2, selection);
                    break;
                }
                case \u00f400000: {
                    fSIImage2 = this.applyFlipEffect(fSIImage, string2);
                    break;
                }
                case \u00f6o0000: {
                    fSIImage2 = this.applyDistortEffect(fSIImage, string2);
                    break;
                }
                case dosuper: {
                    fSIImage2 = this.applyPadEffect(fSIImage, string2, parameters);
                    break;
                }
                case oO0000: {
                    Emboss emboss = new Emboss(this.\u00d300000);
                    emboss.setSelection(selection);
                    fSIImage2 = emboss.transform(fSIImage, true);
                    break;
                }
                case \u00d2O0000: {
                    fSIImage2 = this.applyLinearGradient(fSIImage, string2);
                    break;
                }
                default: {
                    fSIImage2 = this.applyColorOperation(effect, string2, fSIImage, selection);
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.\u00d300000.logException(numberFormatException, 3152, string, parameters, numberFormatException.getLocalizedMessage());
            fSIImage2 = fSIImage;
        }
        catch (ImageManipulatorException | IllegalArgumentException runtimeException) {
            this.\u00d300000.logException(runtimeException, 3153, string, parameters, runtimeException.getLocalizedMessage());
            fSIImage2 = fSIImage;
        }
        return fSIImage2;
    }

    private FSIImage applyBlurEffect(FSIImage fSIImage, String string, Selection selection) throws ProcessingException {
        int n = Integer.parseInt(string);
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("Effect parameter value out of range.");
        }
        Gaussian gaussian = new Gaussian(this.\u00d300000);
        gaussian.setSelection(selection);
        return gaussian.transform(fSIImage, n, 0.0f, -20, 0.0f, true);
    }

    private FSIImage applySharpenEffect(FSIImage fSIImage, String string, Selection selection) throws ProcessingException {
        float f = Float.parseFloat(string);
        if (f <= 0.0f || f > 100.0f) {
            throw new IllegalArgumentException("Effect parameter value out of range.");
        }
        Gaussian gaussian = new Gaussian(this.\u00d300000);
        gaussian.setSelection(selection);
        return gaussian.transform(fSIImage, 5, f, 0, 0.0f, true);
    }

    private FSIImage applyColorOperation(Effect effect, String string, FSIImage fSIImage, Selection selection) throws IllegalArgumentException, ProcessingException {
        ColorOperatorImpl colorOperatorImpl;
        switch (effect) {
            case interfacesuper: {
                colorOperatorImpl = this.getRGBMatrixOperator("0.393,0.769,0.189,0.349,0.686,0.168,0.272,0.534,0.131");
                break;
            }
            case void: {
                colorOperatorImpl = new Solarize();
                break;
            }
            case Object: {
                colorOperatorImpl = new Posterize(Integer.parseInt(string));
                break;
            }
            case \u00f6O0000: {
                colorOperatorImpl = new Saturation(string);
                break;
            }
            case \u00d2\u00d20000: {
                colorOperatorImpl = new Temperature(Integer.parseInt(string));
                break;
            }
            case \u00d4o0000: {
                colorOperatorImpl = this.getWhiteBalanceOperator(string);
                break;
            }
            case \u00d4O0000: {
                colorOperatorImpl = new ChannelSelect(string);
                break;
            }
            case \u00d5O0000: {
                colorOperatorImpl = this.getChannelLevelTrunkOperator(string);
                break;
            }
            case \u00f500000: {
                colorOperatorImpl = new Desaturate(string);
                break;
            }
            case public: {
                colorOperatorImpl = this.getGammaOperator(string);
                break;
            }
            case o00000: {
                colorOperatorImpl = new Invert(string);
                break;
            }
            case \u00d5o0000: {
                colorOperatorImpl = new Brightness(Integer.parseInt(string), 0);
                break;
            }
            case o\u00d20000: {
                colorOperatorImpl = new Brightness(0, Integer.parseInt(string));
                break;
            }
            case \u00d400000: {
                colorOperatorImpl = new ChannelExchange(string);
                break;
            }
            case Objectnew: {
                colorOperatorImpl = this.getGradientMapOperator(string);
                break;
            }
            case \u00d6o0000: {
                colorOperatorImpl = this.getHSLOperator(string);
                break;
            }
            case \u00d600000: {
                colorOperatorImpl = this.getColorizeOperator(string);
                break;
            }
            case O\u00d20000: {
                colorOperatorImpl = this.getColorOverlayOperator(string);
                break;
            }
            case \u00d200000: {
                colorOperatorImpl = this.getChannelLevelOperator(string);
                break;
            }
            case \u00f600000: {
                colorOperatorImpl = this.getChannelRGBFilterOperator(string);
                break;
            }
            case OO0000: {
                colorOperatorImpl = this.getThresholdOperator(string);
                break;
            }
            case \u00f4o0000: {
                colorOperatorImpl = this.getNoiseOperator(string);
                break;
            }
            case \u00f5o0000: {
                colorOperatorImpl = this.getRGBMatrixOperator(string);
                break;
            }
            case classsuper: {
                colorOperatorImpl = this.getFillOperator(string);
                break;
            }
            case intsuper: {
                colorOperatorImpl = this.getMatteOperator(string);
                break;
            }
            case \u00d2o0000: {
                colorOperatorImpl = this.getMatteColorOperator(string);
                break;
            }
            case \u00d500000: {
                if (!fSIImage.hasAlpha()) {
                    fSIImage.addAlpha();
                }
                colorOperatorImpl = this.getTransparencyEffect(string);
                break;
            }
            case oo0000: {
                colorOperatorImpl = new Opaque();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Effect");
            }
        }
        ParallelColorOperation parallelColorOperation = new ParallelColorOperation(this.\u00d300000);
        parallelColorOperation.setSelection(selection);
        return parallelColorOperation.transform(fSIImage, colorOperatorImpl, true);
    }

    private Noise getNoiseOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for noise effect.");
        }
        return new Noise(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Boolean.parseBoolean(stringArray[2]));
    }

    private RGBMatrix getRGBMatrixOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 9) {
            throw new IllegalArgumentException("Invalid parameter count for rgbmatrix effect.");
        }
        float[] fArray = new float[9];
        for (int i = 0; i < 9; ++i) {
            fArray[i] = Float.parseFloat(stringArray[i]);
        }
        return new RGBMatrix(fArray);
    }

    private Fill getFillOperator(String string) {
        int n = ColorParser.parseColor(string);
        boolean bl = ColorParser.hasAlpha(string);
        return new Fill(n, bl);
    }

    private WhiteBalance getWhiteBalanceOperator(String string) {
        int n = ColorParser.parseColor(string);
        return new WhiteBalance(n);
    }

    private MatteTransparent getMatteOperator(String string) {
        boolean bl;
        String string2;
        String[] stringArray = string.split(",");
        if (stringArray.length == 2) {
            string2 = stringArray[0];
            bl = Boolean.parseBoolean(stringArray[1]);
        } else if (stringArray.length == 1) {
            string2 = string;
            bl = false;
        } else {
            throw new IllegalArgumentException("Invalid parameter count for matteTransparent effect.");
        }
        int n = ColorParser.parseColor(string2);
        return new MatteTransparent(n, bl);
    }

    private MatteColor getMatteColorOperator(String string) {
        int n = ColorParser.parseColor(string);
        return new MatteColor(n);
    }

    private Gamma getGammaOperator(String string) {
        String string2;
        float f;
        String[] stringArray = string.split(",");
        if (stringArray.length > 2) {
            throw new IllegalArgumentException("Invalid parameter count for gamma effect.");
        }
        if (stringArray.length == 1) {
            f = Float.parseFloat(string);
            string2 = "all";
        } else {
            f = Float.parseFloat(stringArray[0]);
            string2 = stringArray[1];
        }
        return new Gamma(f, string2);
    }

    private Threshold getThresholdOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            throw new IllegalArgumentException("Invalid parameter count for threshold effect.");
        }
        return new Threshold(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), ColorParser.parseColor(stringArray[2]), ColorParser.parseColor(stringArray[3]));
    }

    private ColorOverlay getColorOverlayOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for color overlay effect.");
        }
        return new ColorOverlay(BlendMode.valueOf(stringArray[0].toUpperCase()), ColorParser.parseColor(stringArray[1]), Float.parseFloat(stringArray[2]));
    }

    private Colorize getColorizeOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for colorize effect.");
        }
        return new Colorize(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
    }

    private ChannelLevel getChannelLevelOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid parameter count for channel level effect.");
        }
        return new ChannelLevel(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
    }

    private ChannelLevelTrunk getChannelLevelTrunkOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            throw new IllegalArgumentException("Invalid parameter count for channel level trunk effect.");
        }
        return new ChannelLevelTrunk(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    private ChannelRGBFilter getChannelRGBFilterOperator(String string) {
        int n;
        try {
            n = ColorParser.parseColor(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid color parameter for channel rgb filter effect.");
        }
        return new ChannelRGBFilter(n);
    }

    private HueSaturation getHSLOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length < 4) {
            throw new IllegalArgumentException("Invalid parameter count for hsl effect.");
        }
        float f = 0.0f;
        int n = stringArray.length;
        if (stringArray.length > 4) {
            try {
                f = Float.parseFloat(stringArray[stringArray.length - 1]);
                --n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 3, n);
        return new HueSaturation(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), stringArray2, f);
    }

    private GradientMap getGradientMapOperator(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Invalid parameter count for gradientmap effect.");
        }
        String string2 = stringArray[0];
        Gradient gradient = new Gradient(this.\u00d300000);
        for (int i = 1; i < stringArray.length; ++i) {
            gradient.addGradientValue(ColorParser.parseColor(stringArray[i]));
        }
        return new GradientMap(gradient, string2);
    }

    private FSIImage applyDistortEffect(FSIImage fSIImage, String string) throws ProcessingException {
        String[] stringArray = string.split(",");
        if (stringArray.length != 8) {
            throw new IllegalArgumentException("Invalid parameter count for distortion effect.");
        }
        PerspectiveDistortion.FILTER fILTER = fSIImage.getWidth() * fSIImage.getHeight() > 250000 ? PerspectiveDistortion.FILTER.\u00d300000 : PerspectiveDistortion.FILTER.\u00d400000;
        PerspectiveDistortion perspectiveDistortion = new PerspectiveDistortion(this.\u00d300000);
        return perspectiveDistortion.transform(fSIImage, fILTER, new Point2D.Float(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1])), new Point2D.Float(Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3])), new Point2D.Float(Float.parseFloat(stringArray[4]), Float.parseFloat(stringArray[5])), new Point2D.Float(Float.parseFloat(stringArray[6]), Float.parseFloat(stringArray[7])), true);
    }

    private FSIImage applyGlowEffect(FSIImage fSIImage, String string, Selection selection) throws ProcessingException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Effect parameter value invalid.");
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("Effect parameter value out of range.");
        }
        Gaussian gaussian = new Gaussian(this.\u00d300000);
        gaussian.setSelection(selection);
        return gaussian.transform(fSIImage, n / 2, 0.0f, 0, (float)n * 2.5f, true);
    }

    private FSIImage applyFlipEffect(FSIImage fSIImage, String string) {
        int n;
        if (string.equalsIgnoreCase("horizontal")) {
            n = 0;
        } else if (string.equalsIgnoreCase("vertical")) {
            n = 1;
        } else {
            throw new IllegalArgumentException("Invalid parameter for flip.");
        }
        Flip flip = new Flip(this.\u00d300000);
        return flip.transform(fSIImage, n, true);
    }

    private FSIImage applyPadEffect(FSIImage fSIImage, String string, Parameters parameters) {
        FSIImage fSIImage2;
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Invalid parameter count for pad effect.");
        }
        Crop.CropPadPosition cropPadPosition = Crop.CropPadPosition.valueOf(stringArray[0].toUpperCase());
        int n = ColorParser.parseColor(stringArray[1]);
        if (parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000) && parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000)) {
            int n2 = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            int n3 = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            fSIImage2 = fSIImage.getWidth() != n2 || fSIImage.getHeight() != n3 ? Crop.transform(fSIImage, 0, 0, n2, n3, n, cropPadPosition, 0.0f, 0.0f, true) : fSIImage;
        } else {
            fSIImage2 = fSIImage;
        }
        return fSIImage2;
    }

    private FSIImage applyLinearGradient(FSIImage fSIImage, String string) throws ProcessingException {
        FSIImage fSIImage2;
        String[] stringArray = string.split(",");
        if (stringArray.length < 7) {
            throw new IllegalArgumentException("Invalid parameter count for linear gradient effect.");
        }
        try {
            Float f = Float.valueOf(stringArray[0]);
            Float f2 = Float.valueOf(stringArray[1]);
            Float f3 = Float.valueOf(stringArray[2]);
            Float f4 = Float.valueOf(stringArray[3]);
            if (f.floatValue() < 0.0f || f.floatValue() > 1.0f || f2.floatValue() < 0.0f || f2.floatValue() > 1.0f || f3.floatValue() < 0.0f || f3.floatValue() > 1.0f || f4.floatValue() < 0.0f || f4.floatValue() > 1.0f) {
                throw new IllegalArgumentException("Parameter start|stop out of range for linear gradient effect.");
            }
            Point2D.Float float_ = new Point2D.Float(f.floatValue(), f2.floatValue());
            Point2D.Float float_2 = new Point2D.Float(f3.floatValue(), f4.floatValue());
            BlendMode blendMode = BlendMode.valueOf(stringArray[4].toUpperCase());
            Float f5 = Float.valueOf(stringArray[5]);
            if (f5.floatValue() < 0.0f || f5.floatValue() > 100.0f) {
                throw new IllegalArgumentException("Parameter opacity out of range for linear gradient effect.");
            }
            SmoothGradient smoothGradient = new SmoothGradient(this.\u00d300000);
            for (int i = 6; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":", 2);
                Float f6 = Float.valueOf(stringArray2[0]);
                if (f6.floatValue() < 0.0f || f6.floatValue() > 1.0f) {
                    throw new IllegalArgumentException("Parameter for gradient position out of range for linear gradient effect.");
                }
                int n = ColorParser.parseColor(stringArray2[1]);
                smoothGradient.putGradientValue(f6.floatValue(), n);
            }
            LinearGradient linearGradient = new LinearGradient(this.\u00d300000);
            fSIImage2 = linearGradient.transform(fSIImage, smoothGradient, float_, float_2, blendMode, AlphaMode.String, f5.floatValue(), true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid parameter value for linear gradient effect.");
        }
        return fSIImage2;
    }

    private ColorOperatorImpl getTransparencyEffect(String string) {
        return new Transparency(Integer.parseInt(string));
    }

    private float[] parseRangeParameterValue(String string) {
        float[] fArray = new float[4];
        if (string != null) {
            String[] stringArray = string.split(",", 5);
            fArray[0] = FloatingParser.parseFloat(stringArray[0]);
            fArray[1] = FloatingParser.parseFloat(stringArray[1]);
            fArray[2] = FloatingParser.parseFloat(stringArray[2]);
            fArray[3] = FloatingParser.parseFloat(stringArray[3]);
        } else {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 1.0f;
            fArray[3] = 1.0f;
        }
        return fArray;
    }
}

