/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ICCInfoRenderer
extends RendererAbstract {
    private static final int \u00d2\u00d60000 = 1684370275;
    private static final int publicString = 1835824483;

    public ICCInfoRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
    }

    @Override
    public String getOption(String string) {
        return null;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        String string = parameters.getAssetURLPath();
        if (string == null) {
            return ICCInfoRenderer.generateMissingParameterResponse("source");
        }
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        try {
            byte[] byArray;
            List list;
            byte[] byArray2;
            List list2;
            byte[] byArray3;
            List list3;
            byte[] byArray4;
            List list4;
            byte[] byArray5;
            List list5;
            byte[] byArray6;
            String string2 = parameters.contains(Parameters.General.\u00d8\u00d40000) ? parameters.get(Parameters.General.\u00d8\u00d40000) : "info";
            Template template = this.Object.getTemplateCache().getTemplate(TemplateType.\u00d200000, string2 + ".ftl");
            TemplateAttributes templateAttributes = new TemplateAttributes(this.\u00d200000, template);
            templateAttributes.setRendererResponseContentType(rendererTextResponse);
            if (!this.checkTemplateAccessRestrictions(templateAttributes, httpSession)) {
                return ICCInfoRenderer.generateNotAuthorizedResponse();
            }
            Escaper.EscaperType escaperType = templateAttributes.getStaticEscape();
            SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string);
            PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
            if (permissionSet == null || !permissionSet.read.iccProfiles.booleanValue()) {
                return ICCInfoRenderer.generateNotAuthorizedResponse();
            }
            MetaData metaData = this.Object.getImageBuilder().getImageMetaData(sourceConnectorReader, string, 2, true, httpSession);
            if (metaData == null || !(metaData instanceof ImageMetaData)) throw new IllegalArgumentException("ICC requests not supported for non-image files.");
            ImageMetaData imageMetaData = (ImageMetaData)metaData;
            if (imageMetaData.getImportStatus() != 1) {
                rendererTextResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            }
            rendererTextResponse.setDateHeader("Last-Modified", metaData.getLastModified());
            byte[] byArray7 = null;
            ICCProfileWrap iCCProfileWrap = imageMetaData.getICC();
            if (iCCProfileWrap != null) {
                byArray7 = iCCProfileWrap.getBytes();
            }
            if (byArray7 == null || byArray7.length <= 0) throw new IllegalArgumentException("No ICC profile found.");
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray7);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            hashMap2.put("size", Long.toString(byArray7.length));
            hashMap2.put("version", iCC_Profile.getMajorVersion() + "." + iCC_Profile.getMinorVersion());
            hashMap2.put("components", Integer.toString(iCC_Profile.getNumComponents()));
            hashMap2.put("type", this.getProfileClass(iCC_Profile));
            iCC_Profile.getPCSType();
            iCC_Profile.getColorSpaceType();
            byte[] byArray8 = iCC_Profile.getData(1668313716);
            if (byArray8 != null) {
                hashMap3.put("copyright", this.readSimpleString(byArray8));
            }
            if ((byArray6 = iCC_Profile.getData(1684370275)) != null) {
                hashMap3.put("description", this.readSimpleString(byArray6));
            }
            if ((list5 = this.getXYZSequence(byArray5 = iCC_Profile.getData(0x77747074), escaperType)) != null) {
                hashMap.put("whitePoint", list5);
            }
            if ((list4 = this.getXYZSequence(byArray4 = iCC_Profile.getData(1651208308), escaperType)) != null) {
                hashMap.put("blackPoint", list4);
            }
            if ((list3 = this.getXYZSequence(byArray3 = iCC_Profile.getData(1918392666), escaperType)) != null) {
                hashMap.put("redColorant", list3);
            }
            if ((list2 = this.getXYZSequence(byArray2 = iCC_Profile.getData(1733843290), escaperType)) != null) {
                hashMap.put("greenColorant", list2);
            }
            if ((list = this.getXYZSequence(byArray = iCC_Profile.getData(1649957210), escaperType)) != null) {
                hashMap.put("blueColorant", list);
            }
            byte[] byArray9 = iCC_Profile.getData(1751474532);
            ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray9, ByteOrder.BIG_ENDIAN);
            int n = byteArrayWalker.getInt(64);
            hashMap2.put("intent", this.getIntent(n));
            hashMap2.put("cmm", ICCInfoRenderer.escapeString(this.toSignatureString(byteArrayWalker.getInt(4)), escaperType));
            hashMap2.put("manufacturer", ICCInfoRenderer.escapeString(this.toSignatureString(byteArrayWalker.getInt(48)), escaperType));
            hashMap2.put("creator", ICCInfoRenderer.escapeString(this.toSignatureString(byteArrayWalker.getInt(80)), escaperType));
            byte[] byArray10 = new byte[12];
            byteArrayWalker.position(24);
            byteArrayWalker.get(byArray10);
            hashMap2.put("date", ICCInfoRenderer.escapeString(Long.toString(this.getDate(byArray10)), escaperType));
            hashMap.put("header", this.getSimpleHeaderSequence(hashMap2, escaperType));
            hashMap.put("tags", this.getSimpleHeaderSequence(hashMap3, escaperType));
            hashMap.put("query", parameters);
            try (StringWriterFast stringWriterFast = new StringWriterFast();){
                Environment environment = template.createProcessingEnvironment(hashMap, (Writer)stringWriterFast);
                environment.process();
                rendererTextResponse.setBody(stringWriterFast.toString());
            }
            rendererTextResponse.setStatus(200);
            return rendererTextResponse;
        }
        catch (NoSuchFileException noSuchFileException) {
            return ICCInfoRenderer.generateNotFoundResponse();
        }
        catch (TemplateException | IOException throwable) {
            rendererTextResponse.setStatus(500);
            this.\u00d200000.logException((Exception)throwable, 3191, throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
            return rendererTextResponse;
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererTextResponse.setStatus(503);
            this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
        }
        return rendererTextResponse;
    }

    private List getSimpleHeaderSequence(Map<String, String> map, Escaper.EscaperType escaperType) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("key", ICCInfoRenderer.escapeString(entry.getKey(), escaperType));
            hashMap.put("name", ICCInfoRenderer.escapeString(entry.getValue(), escaperType));
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private List getSimpleFloatSequence(Map<String, Float> map, Escaper.EscaperType escaperType) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("key", ICCInfoRenderer.escapeString(entry.getKey(), escaperType));
            hashMap.put("name", entry.getValue());
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private String getProfileClass(ICC_Profile iCC_Profile) {
        int n = iCC_Profile.getProfileClass();
        String string = n == 0 ? "Input" : (n == 1 ? "Display" : (n == 2 ? "Output" : (n == 3 ? "Device" : (n == 4 ? "Conversion" : (n == 5 ? "Abstract" : (n == 6 ? "Named Color" : "Unknown"))))));
        return string;
    }

    private List getXYZSequence(byte[] byArray, Escaper.EscaperType escaperType) {
        if (byArray != null) {
            float[] fArray = this.getXYZ(byArray);
            HashMap<String, Float> hashMap = new HashMap<String, Float>();
            hashMap.put("X", Float.valueOf(fArray[0]));
            hashMap.put("Y", Float.valueOf(fArray[1]));
            hashMap.put("Z", Float.valueOf(fArray[2]));
            return this.getSimpleFloatSequence(hashMap, escaperType);
        }
        return null;
    }

    private String getIntent(int n) {
        switch (n) {
            case 0: {
                return "Perceptual";
            }
            case 1: {
                return "Relative";
            }
            case 3: {
                return "Absolute";
            }
            case 2: {
                return "Saturation";
            }
        }
        return "unknown indent";
    }

    private float[] getXYZ(byte[] byArray) {
        float[] fArray = new float[3];
        int n = 0;
        int n2 = 8;
        while (n < 3) {
            int n3 = this.intFromBigEndian(byArray, n2);
            fArray[n] = (float)n3 / 65536.0f;
            ++n;
            n2 += 4;
        }
        return fArray;
    }

    private int intFromBigEndian(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private String readSimpleString(byte[] byArray) {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.BIG_ENDIAN);
        int n = byteArrayWalker.getInt();
        if (n == 1684370275) {
            return this.readDESC(byteArrayWalker);
        }
        if (n == 1835824483) {
            return this.readMLUC(byteArrayWalker);
        }
        return null;
    }

    private String readDESC(ByteArrayWalker byteArrayWalker) {
        byteArrayWalker.position(byteArrayWalker.position() + 4);
        int n = byteArrayWalker.getInt();
        byte[] byArray = new byte[n];
        byteArrayWalker.get(byArray);
        return new String(byArray, FileOperations.o00000);
    }

    private String readMLUC(ByteArrayWalker byteArrayWalker) {
        byteArrayWalker.position(byteArrayWalker.position() + 4);
        int n = byteArrayWalker.getInt();
        byteArrayWalker.position(byteArrayWalker.position() + n - 8);
        int n2 = byteArrayWalker.getInt();
        byteArrayWalker.getInt();
        byte[] byArray = new byte[n2];
        byteArrayWalker.get(byArray);
        return new String(byArray, FileOperations.\u00d300000);
    }

    private String toSignatureString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(n >> 24 & 0xFF));
        stringBuilder.append((char)(n >> 16 & 0xFF));
        stringBuilder.append((char)(n >> 8 & 0xFF));
        stringBuilder.append((char)(n & 0xFF));
        return stringBuilder.toString();
    }

    private long getDate(byte[] byArray) {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.BIG_ENDIAN);
        short s = byteArrayWalker.getShort();
        short s2 = byteArrayWalker.getShort();
        short s3 = byteArrayWalker.getShort();
        short s4 = byteArrayWalker.getShort();
        short s5 = byteArrayWalker.getShort();
        short s6 = byteArrayWalker.getShort();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC_TIME"));
        calendar.set(s, s2, s3, s4, s5, s6);
        Date date = calendar.getTime();
        return date.getTime() / 1000L;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new TreeSet<String>();
    }

    @Override
    public void setOption(String string, String string2) {
    }
}

