/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.fsiserver.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.pyramidreader.FlatImageException;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.DirectoryImageRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.MimeTypeImageMapping;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MultiImageRenderer
extends RendererAbstract {
    private final SortingParameters \u00d4\u00d80000 = new SortingParameters();
    private final ImageBuilder intclass;
    private int \u00d5\u00d80000 = 32;
    private boolean \u00d2\u00d80000 = true;
    private String o\u00d80000 = null;
    private String O\u00d80000 = null;

    public MultiImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        int n;
        String string2;
        this.intclass = requestProcessorSettings.getImageBuilder();
        this.\u00d4\u00d80000.\u00d300000 = RendererEnvironment.\u00d400000;
        this.\u00d4\u00d80000.for = RendererEnvironment.\u00f500000;
        this.\u00d4\u00d80000.o00000 = RendererEnvironment.o00000;
        this.\u00d4\u00d80000.\u00f500000 = this.float.getDefaultSortLanguage();
        this.\u00d4\u00d80000.\u00f800000 = this.float.getDefaultSortCountry();
        this.\u00d4\u00d80000.\u00d800000 = false;
        int n2 = requestProcessorSettings.getPrefsInt("limits", "maxwidth");
        if (n2 > 0) {
            this.\u00d5O0000 = n2;
        }
        if ((n2 = requestProcessorSettings.getPrefsInt("limits", "maxheight")) > 0) {
            this.\u00d4O0000 = n2;
        }
        if ((string2 = requestProcessorSettings.getPrefsString("limits", "defaultwidth")).equalsIgnoreCase("source")) {
            this.\u00f4O0000 = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        string2 = requestProcessorSettings.getPrefsString("limits", "defaultheight");
        if (string2.equalsIgnoreCase("source")) {
            this.\u00d500000 = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        RendererResponse rendererResponse = this.checkStandardImageRequestParameters(parameters);
        if (rendererResponse != null) {
            return rendererResponse;
        }
        if (parameters.getType() != Parameters.Type.\u00d300000) {
            throw new IllegalArgumentException("invalid type");
        }
        rendererResponse = this.processImageRequest(this.intclass, httpServletRequest);
        return rendererResponse;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("keepAspectRatio")) {
            this.\u00d2\u00d80000 = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("errorFallback")) {
            this.o\u00d80000 = string2;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            this.O\u00d80000 = string2;
        } else if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            if (string2.equalsIgnoreCase("source")) {
                this.\u00f4O0000 = 0;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 0) {
                        this.\u00f4O0000 = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.\u00d200000.log(3043, string2, string, this.void);
                }
            }
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            if (string2.equalsIgnoreCase("source")) {
                this.\u00d500000 = 0;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 0) {
                        this.\u00d500000 = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.\u00d200000.log(3043, string2, string, this.void);
                }
            }
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("maxImages")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 1) {
                    this.\u00d5\u00d80000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("defaultsortfield")) {
            this.\u00d4\u00d80000.\u00d300000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("forcesortfield")) {
            this.\u00d4\u00d80000.\u00d200000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("defaultsortorder")) {
            this.\u00d4\u00d80000.for = SortDirection.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("forcesortorder")) {
            this.\u00d4\u00d80000.\u00f600000 = SortDirection.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("defaultsortmethod")) {
            this.\u00d4\u00d80000.o00000 = SortMethod.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("forcesortmethod")) {
            this.\u00d4\u00d80000.oO0000 = SortMethod.valueOf(string2.toUpperCase());
        } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
            this.\u00d4\u00d80000.\u00f500000 = string2.toLowerCase();
        } else if (string.equalsIgnoreCase("forcesortlanguage")) {
            this.\u00d4\u00d80000.null = string2.toLowerCase();
        } else if (string.equalsIgnoreCase("defaultsortcountry")) {
            this.\u00d4\u00d80000.\u00f800000 = string2.toUpperCase();
        } else if (string.equalsIgnoreCase("forcesortcountry")) {
            this.\u00d4\u00d80000.\u00d600000 = string2.toUpperCase();
        } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
            this.\u00d4\u00d80000.\u00d800000 = Boolean.valueOf(string2.toLowerCase());
        } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
            this.\u00d4\u00d80000.\u00d500000 = Boolean.valueOf(string2.toLowerCase());
            this.\u00d4\u00d80000.String = true;
        }
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("keepAspectRatio")) {
            string2 = String.valueOf(this.\u00d2\u00d80000);
        } else if (string.equalsIgnoreCase("errorFallback")) {
            string2 = this.o\u00d80000;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            string2 = this.O\u00d80000;
        } else if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        } else if (string.equalsIgnoreCase("maxImages")) {
            string2 = String.valueOf(this.\u00d5\u00d80000);
        } else if (string.equalsIgnoreCase("defaultsortfield")) {
            string2 = this.\u00d4\u00d80000.\u00d300000.name();
        } else if (string.equalsIgnoreCase("forcesortfield") && this.\u00d4\u00d80000.\u00d200000 != null) {
            string2 = this.\u00d4\u00d80000.\u00d200000.name();
        } else if (string.equalsIgnoreCase("defaultsortorder")) {
            string2 = this.\u00d4\u00d80000.for.name();
        } else if (string.equalsIgnoreCase("forcesortorder") && this.\u00d4\u00d80000.\u00f600000 != null) {
            string2 = this.\u00d4\u00d80000.\u00f600000.name();
        } else if (string.equalsIgnoreCase("defaultsortmethod")) {
            string2 = this.\u00d4\u00d80000.o00000.name();
        } else if (string.equalsIgnoreCase("forcesortmethod") && this.\u00d4\u00d80000.oO0000 != null) {
            string2 = this.\u00d4\u00d80000.oO0000.name();
        } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
            string2 = this.\u00d4\u00d80000.\u00f500000;
        } else if (string.equalsIgnoreCase("forcesortlanguage")) {
            string2 = this.\u00d4\u00d80000.null;
        } else if (string.equalsIgnoreCase("defaultsortcountry")) {
            string2 = this.\u00d4\u00d80000.\u00f800000;
        } else if (string.equalsIgnoreCase("forcesortcountry")) {
            string2 = this.\u00d4\u00d80000.\u00d600000;
        } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
            string2 = Boolean.toString(this.\u00d4\u00d80000.\u00d800000);
        } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
            string2 = Boolean.toString(this.\u00d4\u00d80000.\u00d500000);
        }
        return string2;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("keepaspectratio");
        treeSet.add("errorfallback");
        treeSet.add("importingfallback");
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("defaultSortField");
        treeSet.add("forceSortField");
        treeSet.add("defaultSortOrder");
        treeSet.add("forceSortOrder");
        treeSet.add("defaultSortMethod");
        treeSet.add("forceSortMethod");
        treeSet.add("defaultSortLanguage");
        treeSet.add("forceSortLanguage");
        treeSet.add("defaultSortCountry");
        treeSet.add("forceSortCountry");
        treeSet.add("defaultSortCaseSensitive");
        treeSet.add("forceSortCaseSensitive");
        return treeSet;
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        int n;
        RendererTextResponse rendererTextResponse = null;
        if (parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = MultiImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
        }
        if (rendererTextResponse == null && parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = MultiImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
        }
        return rendererTextResponse;
    }

    private RendererResponse processImageRequest(ImageBuilder imageBuilder, HttpServletRequest httpServletRequest) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse rendererImageResponse;
        block12: {
            rendererImageResponse = new RendererImageResponse();
            Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
            String string = parameters.getAssetURLPath();
            HttpSession httpSession = httpServletRequest.getSession(false);
            boolean bl = this.checkParameterCombinationForImageRequest(parameters);
            if (!bl) {
                rendererImageResponse.setStatus(400);
            } else {
                try {
                    SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string, httpSession);
                    if (sourceConnectorReader != null) {
                        PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                        if (permissionSet != null && permissionSet.read.renderedImages.booleanValue()) {
                            Pair<Integer, Boolean> pair = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
                            Pair<Integer, Boolean> pair2 = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
                            if (pair.getItem2().booleanValue()) {
                                parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(pair.getItem1()));
                            }
                            if (pair2.getItem2().booleanValue()) {
                                parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(pair2.getItem1()));
                            }
                            try {
                                this.processFileImageRequest(sourceConnectorReader, imageBuilder, string, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
                                break block12;
                            }
                            catch (NoSuchFileException noSuchFileException) {
                                rendererImageResponse.setStatus(404);
                                break block12;
                            }
                            catch (IOException iOException) {
                                rendererImageResponse.setStatus(500);
                                break block12;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException("Invalid range value");
                            }
                        }
                        return MultiImageRenderer.generateNotAuthorizedResponse();
                    }
                    return MultiImageRenderer.generateNotFoundResponse();
                }
                catch (NotConfiguredException notConfiguredException) {
                    this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
                    return MultiImageRenderer.generateUnavailableResponse();
                }
            }
        }
        return rendererImageResponse;
    }

    private boolean checkParameterCombinationForImageRequest(Parameters parameters) {
        if (parameters.contains(Parameters.GeneralImage.o\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d4\u00d40000) || parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000) || parameters.contains(Parameters.GeneralImage.whilenew)) {
            return !parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) && !parameters.contains(Parameters.GeneralImage.thisObject) && !parameters.contains(Parameters.GeneralImage.returnnew) && !parameters.contains(Parameters.GeneralImage.nullObject) && !parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000) && !parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000) && !parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000);
        }
        return true;
    }

    private void processFileImageRequest(SourceConnectorReader sourceConnectorReader, ImageBuilder imageBuilder, String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnectorReader == null || sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.super) {
            this.processDynamicFileImageRequest(sourceConnectorReader, imageBuilder, string, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
        } else {
            this.processMimeTypeImageRequest(string, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
        }
    }

    private void processDynamicFileImageRequest(SourceConnectorReader sourceConnectorReader, ImageBuilder imageBuilder, String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        Object object;
        Object object2;
        ArrayList<FSIImageLimited> arrayList = new ArrayList<FSIImageLimited>();
        PoolFileEntryComparator poolFileEntryComparator = DirectoryImageRendererUtils.getComparator(parameters, this.\u00d4\u00d80000);
        int n = 0;
        int n2 = this.\u00d5\u00d80000;
        if (parameters.contains(Parameters.DirectoryImage.o\u00d60000)) {
            try {
                object2 = parameters.get(Parameters.DirectoryImage.o\u00d60000);
                object = ((String)object2).split(",", 2);
                if (((String[])object).length == 1) {
                    n2 = Integer.parseInt((String)object[0]);
                } else if (((Object)object).length == 2) {
                    n2 = Integer.parseInt((String)object[1]);
                    n = Integer.parseInt((String)object[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object2 = httpServletRequest.getSession(false);
        object = imageBuilder.getPoolList(sourceConnectorReader, string, (HttpSession)object2);
        List<PoolFileEntry> list = ((PoolList)object).getFilesAsList();
        list.sort(poolFileEntryComparator);
        this.limitList(list, n, n2);
        MetaData metaData = null;
        for (PoolFileEntry poolFileEntry : list) {
            Object object3;
            boolean bl;
            short s;
            String string2 = string + "/" + poolFileEntry.o00000;
            MetaData metaData2 = imageBuilder.getImageMetaData(sourceConnectorReader, string2, 0, true, (HttpSession)object2);
            if (metaData2 == null) {
                rendererImageResponse.setStatus(404);
                return;
            }
            if (!(metaData2 instanceof ImageMetaData)) {
                throw new IllegalArgumentException("processDynamicFileImageRequest called for non-image profile.");
            }
            ImageMetaData imageMetaData = (ImageMetaData)metaData2;
            if (pair.getItem1() == 0) {
                pair.setItem1(Math.min(imageMetaData.getWidth(), this.\u00d5O0000));
            }
            if (pair2.getItem1() == 0) {
                pair2.setItem1(Math.min(imageMetaData.getHeight(), this.\u00d4O0000));
            }
            if ((s = (short)imageMetaData.getImportStatus()) != 1 && s != 4) {
                this.createFallbackResponse(string2, parameters, s, rendererImageResponse);
                return;
            }
            boolean bl2 = parameters.get(Parameters.General.\u00f5\u00d40000) != null && parameters.get(Parameters.General.\u00f5\u00d40000).equals("_private");
            boolean bl3 = bl = httpServletRequest.getAttribute("mimeImageRequest") != null && (Boolean)httpServletRequest.getAttribute("mimeImageRequest") != false;
            if (bl || bl2) {
                sourceConnectorReader = null;
            }
            if (bl2 && !bl) {
                rendererImageResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            } else {
                long l = imageMetaData.getLastModified();
                rendererImageResponse.setDateHeader("Last-Modified", l);
            }
            FSIImageLimited fSIImageLimited = null;
            double[] dArray = Arrays.copyOf(oO0000, 4);
            int[] nArray = Arrays.copyOf(supersuper, 4);
            boolean bl4 = false;
            if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) || parameters.contains(Parameters.GeneralImage.thisObject) || parameters.contains(Parameters.GeneralImage.returnnew) || parameters.contains(Parameters.GeneralImage.nullObject) || parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000)) {
                MultiImageRenderer.getRelativeRangeFromParameters(parameters, dArray);
            } else if (parameters.contains(Parameters.GeneralImage.o\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d4\u00d40000) || parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000) || parameters.contains(Parameters.GeneralImage.whilenew)) {
                bl4 = true;
                this.getPixelRangeFromParameters(parameters, nArray);
            }
            try {
                if (bl4) {
                    object3 = MultiImageRenderer.getReferenceDimensions(parameters);
                    fSIImageLimited = imageBuilder.getImagePixelBased(null, sourceConnectorReader, string2, object3[0], object3[1], nArray[0], nArray[1], nArray[2], nArray[3], this.\u00d2\u00d80000, FSIInterpolation.o00000);
                } else {
                    fSIImageLimited = imageBuilder.getImage(null, sourceConnectorReader, string2, pair, pair2, dArray[0], dArray[1], dArray[2], dArray[3], this.\u00d2\u00d80000, FSIInterpolation.o00000, null);
                }
            }
            catch (FlatImageException flatImageException) {
                this.createFallbackResponse(string2, parameters, (short)5, rendererImageResponse);
                return;
            }
            if (fSIImageLimited != null) {
                object3 = parameters.get(Parameters.General.\u00f5\u00d40000);
                if (object3 != null && ((String)object3).equals("_private")) {
                    ParallelColorOperation parallelColorOperation = new ParallelColorOperation(this.\u00d200000);
                    fSIImageLimited = (FSIImageLimited)parallelColorOperation.transform((FSIImage)fSIImageLimited, new MatteTransparent(0xFFFFFF, false), false);
                }
                arrayList.add(fSIImageLimited);
                if (metaData != null) continue;
                metaData = metaData2;
                continue;
            }
            rendererImageResponse.setStatus(500);
        }
        rendererImageResponse.setMetaData(metaData);
        rendererImageResponse.setMultiImageResponse(true);
        rendererImageResponse.setResponseImages(arrayList.toArray(new FSIImageLimited[arrayList.size()]));
        rendererImageResponse.setStatus(200);
    }

    private void processMimeTypeImageRequest(String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        String string2 = this.getSuffixFromAssetURLPath(string);
        String string3 = MimeTypeImageMapping.getImageFilename(string2);
        String string4 = "_service/mime-types/" + string3;
        httpServletRequest.setAttribute("mimeImageRequest", (Object)true);
        this.processDynamicFileImageRequest(null, this.intclass, string4, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
    }

    private String getSuffixFromAssetURLPath(String string) {
        try {
            int n = string.lastIndexOf(".") + 1;
            String string2 = string.substring(n);
            if (string2.equals("gz") || string2.equals("bz2")) {
                n = string.lastIndexOf(".", n - 2);
                string2 = string.substring(n);
            }
            return string2;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "";
        }
    }
}

