/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.FloatingParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.area.LayerBlend;
import com.neptunelabs.fsiserver.imagemanipulator.color.AlphaMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class OverlayImageRenderer
extends RendererAbstract {
    private final ImageBuilder o\u00d30000;
    private boolean floatnew = true;
    private boolean O\u00d30000 = true;
    private final List<_o> \u00d2\u00d30000 = new ArrayList<_o>();
    private final Pattern \u00f5\u00d20000 = Pattern.compile("(.*?)\\(([0-9]*)(?:,(TL|TC|TR|CL|CC|CR|BL|BC|BR))?+(?:,([0-9\\.]*))?+(?:,([0-9\\.]*))?+\\),?");
    private String \u00f4\u00d20000 = null;
    private String voidnew = null;
    private String \u00f6\u00d20000 = "";

    public OverlayImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.o\u00d30000 = requestProcessorSettings.getImageBuilder();
        int n = requestProcessorSettings.getPrefsInt("limits", "maxwidth");
        if (n > 0) {
            this.\u00d5O0000 = n;
        }
        if ((n = requestProcessorSettings.getPrefsInt("limits", "maxheight")) > 0) {
            this.\u00d4O0000 = n;
        }
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        RendererResponse rendererResponse = this.checkStandardImageRequestParameters(parameters);
        if (rendererResponse != null) {
            return rendererResponse;
        }
        if (parameters.getType() != Parameters.Type.if) {
            throw new IllegalArgumentException("invalid type");
        }
        rendererResponse = this.processImageRequest(this.o\u00d30000, parameters);
        return rendererResponse;
    }

    private _o extractLayerProperties(Matcher matcher, boolean bl) {
        _o _o2;
        block11: {
            block10: {
                block9: {
                    _o2 = new _o();
                    _o2.\u00d500000 = matcher.group(1);
                    try {
                        _o2.new = Integer.parseInt(matcher.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!bl) break block9;
                        this.\u00d200000.log(3043, matcher.group(2), "opacity", this.void);
                    }
                }
                if (matcher.group(3) != null) {
                    _o2.o00000 = matcher.group(3);
                }
                if (matcher.group(4) != null) {
                    try {
                        _o2.\u00d400000 = Float.parseFloat(matcher.group(4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!bl) break block10;
                        this.\u00d200000.log(3043, matcher.group(2), "pos1", this.void);
                    }
                }
            }
            if (matcher.group(5) != null) {
                try {
                    _o2.\u00d300000 = Float.parseFloat(matcher.group(5));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) break block11;
                    this.\u00d200000.log(3043, matcher.group(2), "pos2", this.void);
                }
            }
        }
        return _o2;
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        int n;
        RendererTextResponse rendererTextResponse = null;
        if (!parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000) && !parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000)) {
            rendererTextResponse = OverlayImageRenderer.generateMissingParameterResponse("width or height");
        } else if (parameters.getAssetURLPath() == null) {
            rendererTextResponse = OverlayImageRenderer.generateMissingParameterResponse("source");
        }
        if (rendererTextResponse == null && parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = OverlayImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
        }
        if (rendererTextResponse == null && parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = OverlayImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
        }
        return rendererTextResponse;
    }

    private RendererImageResponse processImageRequest(ImageBuilder imageBuilder, Parameters parameters) throws IllegalArgumentException, ProcessingException, InterruptedException {
        Object object;
        Object object2;
        RendererImageResponse rendererImageResponse = new RendererImageResponse();
        String string = parameters.getAssetURLPath();
        if (string == null) {
            throw new IllegalArgumentException("source required");
        }
        ArrayList<_o> arrayList = new ArrayList<_o>();
        _o _o2 = new _o();
        _o2.\u00d500000 = URL.cleanUpSourceParameter(string);
        arrayList.add(_o2);
        arrayList.addAll(this.\u00d2\u00d30000);
        String string2 = parameters.get(Parameters.FileImage.\u00f5O0000);
        if (string2 != null && string2.length() > 0) {
            object2 = this.\u00f5\u00d20000.matcher(string2);
            while (((Matcher)object2).find()) {
                object = this.extractLayerProperties((Matcher)object2, false);
                arrayList.add((_o)object);
            }
        }
        object2 = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
        object = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
        if (((Boolean)((Pair)object2).getItem2()).booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(((Pair)object2).getItem1()));
        }
        if (((Boolean)((Pair)object).getItem2()).booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(((Pair)object).getItem1()));
        }
        try {
            this.processFileImageRequest(imageBuilder, arrayList, parameters, (Pair<Integer, Boolean>)object2, (Pair<Integer, Boolean>)object, rendererImageResponse);
        }
        catch (NoSuchFileException noSuchFileException) {
            rendererImageResponse.setStatus(404);
        }
        catch (IOException iOException) {
            rendererImageResponse.setStatus(500);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid range value");
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererImageResponse.setStatus(503);
            this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
        }
        return rendererImageResponse;
    }

    private void processFileImageRequest(ImageBuilder imageBuilder, List<_o> list, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, RendererImageResponse rendererImageResponse) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        Object object;
        double[] dArray = Arrays.copyOf(oO0000, 4);
        int[] nArray = Arrays.copyOf(supersuper, 4);
        double[] dArray2 = Arrays.copyOf(oO0000, 4);
        int[] nArray2 = Arrays.copyOf(supersuper, 4);
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) || parameters.contains(Parameters.GeneralImage.thisObject) || parameters.contains(Parameters.GeneralImage.returnnew) || parameters.contains(Parameters.GeneralImage.nullObject) || parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000)) {
            OverlayImageRenderer.getRelativeRangeFromParameters(parameters, dArray);
        } else if (parameters.contains(Parameters.GeneralImage.o\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d4\u00d40000) || parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000) || parameters.contains(Parameters.GeneralImage.whilenew)) {
            bl3 = true;
            this.getPixelRangeFromParameters(parameters, nArray);
        }
        if (parameters.contains(Parameters.FileImage.\u00d8O0000)) {
            object = parameters.get(Parameters.FileImage.\u00d8O0000).split(",", 5);
            dArray2[0] = FloatingParser.parseDouble(object[0]);
            dArray2[1] = FloatingParser.parseDouble(object[1]);
            dArray2[2] = FloatingParser.parseDouble(object[2]);
            dArray2[3] = FloatingParser.parseDouble(object[3]);
            d = dArray2[2];
            d2 = dArray2[3];
            bl = true;
        } else if (parameters.contains(Parameters.FileImage.\u00f8O0000)) {
            object = parameters.get(Parameters.FileImage.\u00f8O0000).split(",", 5);
            nArray2[0] = Integer.parseInt(object[0]);
            nArray2[1] = Integer.parseInt(object[1]);
            nArray2[2] = Integer.parseInt(object[2]);
            nArray2[3] = Integer.parseInt(object[3]);
            bl2 = true;
        }
        object = null;
        try {
            for (_o _o2 : list) {
                object = this.loadAndBlendLayer((FSIImage)object, imageBuilder, _o2, pair, pair2, dArray, nArray, dArray2, nArray2, d, d2, bl, bl2, bl3);
            }
        }
        catch (ProcessingException processingException) {
            if (object != null) {
                object.dispose();
            }
            throw processingException;
        }
        rendererImageResponse.setStatus(200);
        rendererImageResponse.setResponseImage((FSIImageLimited)object);
        rendererImageResponse.setDateHeader("Last-Modified", System.currentTimeMillis());
    }

    private FSIImage loadAndBlendLayer(FSIImage fSIImage, ImageBuilder imageBuilder, _o _o2, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, double[] dArray, int[] nArray, double[] dArray2, int[] nArray2, double d, double d2, boolean bl, boolean bl2, boolean bl3) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        boolean bl4 = fSIImage == null;
        FSIImageLimited fSIImageLimited = null;
        try {
            SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(_o2.\u00d500000);
            if (bl4 || this.O\u00d30000) {
                if (bl3 || bl2 && bl4) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    if (bl3) {
                        n4 = nArray[0];
                        n3 = nArray[1];
                        n2 = nArray[2];
                        n = nArray[3];
                    } else {
                        n4 = nArray2[0] + (int)(dArray[0] * (double)nArray2[2]);
                        n3 = nArray2[1] + (int)(dArray[1] * (double)nArray2[3]);
                        n2 = (int)(dArray[2] * (double)nArray2[2]);
                        n = (int)(dArray[3] * (double)nArray2[3]);
                    }
                    fSIImageLimited = imageBuilder.getImage(null, sourceConnectorReader, _o2.\u00d500000, pair, pair2, n4, n3, n2, n, this.floatnew, FSIInterpolation.o00000, null);
                } else {
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if (bl && bl4) {
                        d6 = dArray2[0] + dArray[0] * d;
                        d5 = dArray2[1] + dArray[1] * d2;
                        d4 = d * dArray[2];
                        d3 = d2 * dArray[3];
                    } else if (bl2 && bl4) {
                        d6 = 0.0;
                        d5 = 0.0;
                        d4 = 0.0;
                        d3 = 0.0;
                    } else {
                        d6 = dArray[0];
                        d5 = dArray[1];
                        d4 = dArray[2];
                        d3 = dArray[3];
                    }
                    fSIImageLimited = imageBuilder.getImage(null, sourceConnectorReader, _o2.\u00d500000, pair, pair2, d6, d5, d4, d3, this.floatnew, FSIInterpolation.o00000, null);
                }
            } else {
                fSIImageLimited = imageBuilder.getImage(null, sourceConnectorReader, _o2.\u00d500000, pair, pair2, 0.0, 0.0, 1.0, 1.0, this.floatnew, FSIInterpolation.o00000, null);
            }
            if (bl4) {
                fSIImage = fSIImageLimited;
            } else if (fSIImage != null) {
                Pair<Integer, Integer> pair3 = this.calculateOffset(_o2, fSIImageLimited, fSIImage.getWidth(), fSIImage.getHeight());
                LayerBlend layerBlend = new LayerBlend(this.\u00d200000);
                fSIImage = layerBlend.transform(fSIImage, fSIImageLimited, pair3.getItem1(), pair3.getItem2(), BlendMode.interface, AlphaMode.o00000, _o2.new, false);
            }
        }
        catch (FSIImageException fSIImageException) {
            this.\u00d200000.log(2504, _o2.\u00d500000, fSIImageException.getLocalizedMessage());
            if (fSIImageLimited != null) {
                fSIImageLimited.dispose();
            }
        }
        catch (ProcessingException processingException) {
            OverlayImageRenderer.disposeImages(fSIImageLimited);
            throw processingException;
        }
        return fSIImage;
    }

    private Pair<Integer, Integer> calculateOffset(_o _o2, FSIImageLimited fSIImageLimited, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (_o2.o00000.equals("TL")) {
            n3 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n) : (int)_o2.\u00d400000;
            n4 = _o2.\u00d300000 < 1.0f ? (int)(_o2.\u00d300000 * (float)n2) : (int)_o2.\u00d300000;
        } else if (_o2.o00000.equals("TC")) {
            n3 = (int)((float)n / 2.0f - (float)fSIImageLimited.getWidth() / 2.0f);
            n4 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n2) : (int)_o2.\u00d400000;
        } else if (_o2.o00000.equals("TR")) {
            int n5 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n) : (int)_o2.\u00d400000;
            n3 = n - n5 - fSIImageLimited.getWidth();
            n4 = _o2.\u00d300000 < 1.0f ? (int)(_o2.\u00d300000 * (float)n2) : (int)_o2.\u00d300000;
        } else if (_o2.o00000.equals("CL")) {
            n3 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n) : (int)_o2.\u00d400000;
            n4 = (int)((float)n2 / 2.0f - (float)fSIImageLimited.getHeight() / 2.0f);
        } else if (_o2.o00000.equals("CC")) {
            n3 = (int)((float)n / 2.0f - (float)fSIImageLimited.getWidth() / 2.0f);
            n4 = (int)((float)n2 / 2.0f - (float)fSIImageLimited.getHeight() / 2.0f);
        } else if (_o2.o00000.equals("CR")) {
            int n6 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n) : (int)_o2.\u00d400000;
            n3 = n - n6 - fSIImageLimited.getWidth();
            n4 = (int)((float)n2 / 2.0f - (float)fSIImageLimited.getHeight() / 2.0f);
        } else if (_o2.o00000.equals("BL")) {
            n3 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n) : (int)_o2.\u00d400000;
            int n7 = _o2.\u00d300000 < 1.0f ? (int)(_o2.\u00d300000 * (float)n2) : (int)_o2.\u00d300000;
            n4 = n2 - n7 - fSIImageLimited.getHeight();
        } else if (_o2.o00000.equals("BC")) {
            n3 = (int)((float)n / 2.0f - (float)fSIImageLimited.getWidth() / 2.0f);
            int n8 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n2) : (int)_o2.\u00d400000;
            n4 = n2 - n8 - fSIImageLimited.getHeight();
        } else if (_o2.o00000.equals("BR")) {
            int n9 = _o2.\u00d400000 < 1.0f ? (int)(_o2.\u00d400000 * (float)n) : (int)_o2.\u00d400000;
            n3 = n - n9 - fSIImageLimited.getWidth();
            int n10 = _o2.\u00d300000 < 1.0f ? (int)(_o2.\u00d300000 * (float)n2) : (int)_o2.\u00d300000;
            n4 = n2 - n10 - fSIImageLimited.getHeight();
        }
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(n3, n4);
        return pair;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("keepaspectratio");
        treeSet.add("errorfallback");
        treeSet.add("importingfallback");
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("overlay");
        treeSet.add("applyrangetooverlays");
        return treeSet;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("keepAspectRatio")) {
            string2 = String.valueOf(this.floatnew);
        } else if (string.equalsIgnoreCase("errorFallback")) {
            string2 = this.\u00f4\u00d20000;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            string2 = this.voidnew;
        } else if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("applyRangeToOverlays")) {
            string2 = String.valueOf(this.O\u00d30000);
        } else if (string.equalsIgnoreCase("overlay")) {
            string2 = this.\u00f6\u00d20000;
        }
        return string2;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("keepAspectRatio")) {
            this.floatnew = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("errorFallback")) {
            this.\u00f4\u00d20000 = string2;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            this.voidnew = string2;
        } else if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("overlay")) {
            Matcher matcher = this.\u00f5\u00d20000.matcher(string2);
            while (matcher.find()) {
                _o _o2 = this.extractLayerProperties(matcher, true);
                this.\u00d2\u00d30000.add(_o2);
            }
            this.\u00f6\u00d20000 = string2;
        } else if (string.equalsIgnoreCase("applyRangeToOverlays")) {
            this.O\u00d30000 = Boolean.parseBoolean(string2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class _o {
        String \u00d500000;
        String o00000 = "CC";
        int new = 100;
        float \u00d400000 = 0.0f;
        float \u00d300000 = 0.0f;

        _o() {
        }
    }
}

