/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.download.DownloadJobComparator;
import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheLoad;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.comparator.FSIStringComparator;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.SortingUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntryComparator;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.cache.CacheableArrayList;
import com.neptunelabs.fsiserver.utils.comparators.PoolDirectoryEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiserver.utils.comparators.SortMethod;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class StandardListRenderer
extends RendererAbstract {
    private PoolEntrySortingField o\u00d50000;
    private SortDirection floatString;
    private SortMethod interfaceObject;
    private String \u00f4\u00d50000 = null;
    private String \u00f6\u00d50000 = null;
    private boolean \u00d5\u00d50000 = false;
    private PoolEntrySortingField O\u00d50000 = null;
    private SortDirection \u00f5\u00d50000 = null;
    private SortMethod o\u00d60000 = null;
    private String voidString = null;
    private String \u00d4\u00d50000 = null;
    private boolean \u00d2\u00d50000 = false;
    private boolean ObjectString = false;
    private final ImageBuilder \u00d6\u00d50000;
    private final CacheManager O\u00d60000;

    public StandardListRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        this.\u00d6\u00d50000 = requestProcessorSettings.getImageBuilder();
        this.o\u00d50000 = RendererEnvironment.\u00d400000;
        this.floatString = RendererEnvironment.\u00f500000;
        this.interfaceObject = RendererEnvironment.o00000;
        this.\u00f4\u00d50000 = this.float.getDefaultSortLanguage();
        this.\u00f6\u00d50000 = this.float.getDefaultSortCountry();
        this.\u00d5\u00d50000 = false;
        this.O\u00d60000 = requestProcessorSettings.getCacheManager();
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (parameters.getAssetURLPath() == null) {
            return StandardListRenderer.generateMissingParameterResponse("source");
        }
        if (parameters.getType() != Parameters.Type.\u00d500000) {
            throw new IllegalArgumentException("Invalid type requested");
        }
        RendererResponse rendererResponse = this.processListRequest(this.\u00d6\u00d50000, parameters, map, httpSession);
        return rendererResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("defaultSortField");
        treeSet.add("forceSortField");
        treeSet.add("defaultSortOrder");
        treeSet.add("forceSortOrder");
        treeSet.add("defaultSortMethod");
        treeSet.add("forceSortMethod");
        treeSet.add("defaultSortLanguage");
        treeSet.add("forceSortLanguage");
        treeSet.add("defaultSortCountry");
        treeSet.add("forceSortCountry");
        treeSet.add("defaultSortCaseSensitive");
        treeSet.add("forceSortCaseSensitive");
        return treeSet;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("defaultsortfield") && this.o\u00d50000 != null) {
            string2 = this.o\u00d50000.name();
        } else if (string.equalsIgnoreCase("forcesortfield") && this.O\u00d50000 != null) {
            string2 = this.O\u00d50000.name();
        } else if (string.equalsIgnoreCase("defaultsortorder") && this.floatString != null) {
            string2 = this.floatString.name();
        } else if (string.equalsIgnoreCase("forcesortorder") && this.\u00f5\u00d50000 != null) {
            string2 = this.\u00f5\u00d50000.name();
        } else if (string.equalsIgnoreCase("defaultsortmethod") && this.interfaceObject != null) {
            string2 = this.interfaceObject.name();
        } else if (string.equalsIgnoreCase("forcesortmethod") && this.o\u00d60000 != null) {
            string2 = this.o\u00d60000.name();
        } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
            string2 = this.\u00f4\u00d50000;
        } else if (string.equalsIgnoreCase("forcesortlanguage")) {
            string2 = this.voidString;
        } else if (string.equalsIgnoreCase("defaultsortcountry")) {
            string2 = this.\u00f6\u00d50000;
        } else if (string.equalsIgnoreCase("forcesortcountry")) {
            string2 = this.\u00d4\u00d50000;
        } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
            string2 = Boolean.toString(this.\u00d5\u00d50000);
        } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
            string2 = Boolean.toString(this.ObjectString);
        }
        return string2;
    }

    @Override
    public void setOption(String string, String string2) {
        try {
            if (string.equalsIgnoreCase("defaultsortfield")) {
                this.o\u00d50000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("forcesortfield")) {
                this.O\u00d50000 = PoolEntrySortingField.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("defaultsortorder")) {
                this.floatString = SortDirection.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("forcesortorder")) {
                this.\u00f5\u00d50000 = SortDirection.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("defaultsortmethod")) {
                this.interfaceObject = SortMethod.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("forcesortmethod")) {
                this.o\u00d60000 = SortMethod.valueOf(string2.toUpperCase());
            } else if (string.equalsIgnoreCase("defaultsortlanguage")) {
                this.\u00f4\u00d50000 = string2.toLowerCase();
            } else if (string.equalsIgnoreCase("forcesortlanguage")) {
                this.voidString = string2.toLowerCase();
            } else if (string.equalsIgnoreCase("defaultsortcountry")) {
                this.\u00f6\u00d50000 = string2.toUpperCase();
            } else if (string.equalsIgnoreCase("forcesortcountry")) {
                this.\u00d4\u00d50000 = string2.toUpperCase();
            } else if (string.equalsIgnoreCase("defaultsortcasesensitive")) {
                this.\u00d5\u00d50000 = Boolean.valueOf(string2.toLowerCase());
            } else if (string.equalsIgnoreCase("forcesortcasesensitive")) {
                this.ObjectString = Boolean.valueOf(string2.toLowerCase());
                this.\u00d2\u00d50000 = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.\u00d200000.log(2035, this.void + ".xml", string2, string);
        }
    }

    private RendererResponse processListRequest(ImageBuilder imageBuilder, Parameters parameters, Map<String, Object> map, HttpSession httpSession) {
        RendererTextResponse rendererTextResponse;
        try {
            Template template = this.determineListTemplate(parameters);
            TemplateAttributes templateAttributes = new TemplateAttributes(this.\u00d200000, template);
            String string = templateAttributes.getStaticTypeFilter();
            Escaper.EscaperType escaperType = templateAttributes.getStaticEscape();
            if (!this.checkTemplateAccessRestrictions(templateAttributes, httpSession)) {
                rendererTextResponse = StandardListRenderer.generateNotAuthorizedResponse();
            } else {
                HashMap<String, Parameters> hashMap = new HashMap<String, Parameters>();
                hashMap.put("query", parameters);
                String string2 = parameters.getAssetURLPath();
                if (string2.equals("/")) {
                    rendererTextResponse = this.processRootListRequest(imageBuilder, parameters, httpSession, template, escaperType, hashMap);
                } else if (string2.equals("_trash")) {
                    rendererTextResponse = this.processTrashListRequest(imageBuilder, parameters, httpSession, template, escaperType, hashMap);
                    rendererTextResponse.setCacheable(false);
                } else if (string2.equals("_downloads")) {
                    rendererTextResponse = this.processDownloadsListRequest(parameters, httpSession, template, hashMap);
                    rendererTextResponse.setCacheable(false);
                } else {
                    rendererTextResponse = StandardListRenderer.multiSources(parameters.get(Parameters.General.privateObject)) ? this.processMultiListRequest(imageBuilder, parameters, httpSession, template, string, escaperType, hashMap, parameters.get(Parameters.General.privateObject)) : this.processNormalListRequest(imageBuilder, parameters, httpSession, template, string, escaperType, hashMap, string2);
                }
                templateAttributes.setRendererResponseContentType(rendererTextResponse);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            rendererTextResponse = StandardListRenderer.generateNotFoundResponse();
        }
        catch (NotConfiguredException notConfiguredException) {
            rendererTextResponse = StandardListRenderer.generateUnavailableResponse();
        }
        catch (TemplateException | IOException throwable) {
            rendererTextResponse = StandardListRenderer.generateErrorResponse();
            this.\u00d200000.logException((Exception)throwable, 3158, throwable.getLocalizedMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            rendererTextResponse = StandardListRenderer.generateErrorResponse();
        }
        return rendererTextResponse;
    }

    private RendererTextResponse processNormalListRequest(ImageBuilder imageBuilder, Parameters parameters, HttpSession httpSession, Template template, String string, Escaper.EscaperType escaperType, Map map, String string2) throws IOException, TemplateException, NotConfiguredException {
        Object object;
        long l = System.currentTimeMillis();
        SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string2, httpSession);
        if (sourceConnectorReader == null) {
            return StandardListRenderer.generateNotAuthorizedResponse();
        }
        PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
        if (permissionSet == null || !permissionSet.list.files.booleanValue() && !permissionSet.list.directories.booleanValue()) {
            return StandardListRenderer.generateNotAuthorizedResponse();
        }
        map.put("currentDir", StandardListRenderer.escapeString(string2 + "/", escaperType));
        int n = 0;
        int n2 = -1;
        if (parameters.contains(Parameters.List.\u00d8\u00d50000)) {
            try {
                object = parameters.get(Parameters.List.\u00d8\u00d50000);
                String[] stringArray = ((String)object).split(",", 2);
                if (stringArray.length == 1) {
                    n2 = Integer.parseInt(stringArray[0]);
                } else if (stringArray.length == 2) {
                    n2 = Integer.parseInt(stringArray[1]);
                    n = Integer.parseInt(stringArray[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object = new ArrayList();
        boolean bl = this.setTypeFilters(parameters, string, (List<String>)object);
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        SortDirection sortDirection = this.determineSortOrder(parameters);
        FSIStringComparator fSIStringComparator = this.determineSortComparator(parameters, sortDirection);
        PoolEntrySortingField poolEntrySortingField = this.determineSortField(parameters);
        PoolFileEntryComparator poolFileEntryComparator = new PoolFileEntryComparator(poolEntrySortingField, fSIStringComparator, sortDirection);
        PoolDirectoryEntryComparator poolDirectoryEntryComparator = new PoolDirectoryEntryComparator(poolEntrySortingField, fSIStringComparator, sortDirection);
        Set<String> set = this.evaluateItemsParameter(parameters);
        PoolList poolList = null;
        long l2 = System.currentTimeMillis();
        poolList = imageBuilder.getPoolList(sourceConnectorReader, string2, httpSession);
        long l3 = System.currentTimeMillis();
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        long l4 = 0L;
        if (poolList != null) {
            l4 = poolList.\u00d4\u00d60000;
            rendererTextResponse.setDateHeader("Last-Modified", l4);
        }
        boolean bl3 = !string2.startsWith("_configs") && !string2.startsWith("_viewers");
        List<Object> list = null;
        if (poolList != null && permissionSet.list.files.booleanValue() && (!bl || bl && object.contains("file"))) {
            CacheLoad cacheLoad;
            CacheKey cacheKey = null;
            if (bl3 && (cacheLoad = this.O\u00d60000.get(cacheKey = CacheKey.getInstance(string2, 'D', "sortedImageList:" + l4 + "_" + (Object)((Object)sortDirection) + "_" + (Object)((Object)poolEntrySortingField) + (set != null ? parameters.get(Parameters.List.\u00f5\u00d50000) : "")), CacheType.\u00d300000)) != null) {
                list = cacheLoad.\u00d300000 != null ? (CacheableArrayList)cacheLoad.\u00d300000 : CacheableArrayList.unpack(cacheLoad.new);
            }
            if (list == null) {
                list = poolList.getFilesAsList();
                if (!(list = this.applyItemsFilterToPoolFileEntryList(list, set)).isEmpty()) {
                    this.sortingPoolList(list, poolEntrySortingField, fSIStringComparator, sortDirection);
                    if (bl3) {
                        this.O\u00d60000.put(cacheKey, new CacheableArrayList<PoolFileEntry>((Collection<PoolFileEntry>)list), true);
                    }
                }
            }
            n3 = list.size();
        }
        long l5 = System.currentTimeMillis();
        List<Object> list2 = null;
        if (permissionSet.list.directories.booleanValue() && (!bl || bl && object.contains("directory"))) {
            CacheLoad cacheLoad;
            CacheKey cacheKey = null;
            if (bl3 && (cacheLoad = this.O\u00d60000.get(cacheKey = CacheKey.getInstance(string2, 'D', "sortedDirList:" + l4 + "_" + (Object)((Object)sortDirection) + "_" + (Object)((Object)poolEntrySortingField) + (set != null ? parameters.get(Parameters.List.\u00f5\u00d50000) : "")), CacheType.\u00d300000)) != null) {
                list2 = cacheLoad.\u00d300000 != null ? (CacheableArrayList)cacheLoad.\u00d300000 : CacheableArrayList.unpack(cacheLoad.new);
            }
            if (list2 == null && poolList != null && !(list2 = poolList.getDirectoriesAsList()).isEmpty()) {
                list2.sort(poolDirectoryEntryComparator);
                if (bl3) {
                    this.O\u00d60000.put(cacheKey, new CacheableArrayList<PoolDirectoryEntry>((Collection<PoolDirectoryEntry>)list2), true);
                }
            }
            if (list2 != null) {
                n4 = list2.size();
            }
        }
        long l6 = System.currentTimeMillis();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("entryCount", n3 + n4);
        hashMap.put("imageCount", n3);
        hashMap.put("directoryCount", n4);
        hashMap.put("completeCount", 0);
        hashMap.put("lastModified", l4);
        hashMap.put("connectorType", (Object)sourceConnectorReader.getMountType());
        map.put("summary", hashMap);
        n = this.ensureValidListOffset(n, n3 + n4);
        if (n2 < 0) {
            n2 = n3 + n4 - n;
        }
        _o _o2 = new _o(n, n2, n4, n3);
        if (parameters.contains(Parameters.List.\u00f4\u00d50000)) {
            this.applyListRangeParameter(poolFileEntryComparator, poolDirectoryEntryComparator, parameters.get(Parameters.List.\u00f4\u00d50000), list2, list, _o2);
        }
        long l7 = System.currentTimeMillis();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(template.getCustomAttribute("checksum"));
        stringBuilder.append(string2);
        stringBuilder.append(l4);
        stringBuilder.append((Object)sortDirection);
        stringBuilder.append((Object)poolEntrySortingField);
        stringBuilder.append(fSIStringComparator);
        List list3 = this.buildFinalList(list2, list, _o2, escaperType, string2, httpSession, false, stringBuilder);
        map.put("ilist", list3);
        this.renderTemplate(template, map, rendererTextResponse);
        long l8 = System.currentTimeMillis();
        this.\u00d200000.log(3001, l2 - l, l3 - l2, l5 - l3, l6 - l5, l7 - l6, l8 - l7);
        rendererTextResponse.setETagModifier(stringBuilder.toString());
        rendererTextResponse.setStatus(200);
        return rendererTextResponse;
    }

    private Set<String> evaluateItemsParameter(Parameters parameters) {
        HashSet<String> hashSet = null;
        if (parameters.contains(Parameters.List.\u00f5\u00d50000)) {
            hashSet = new HashSet<String>();
            String[] stringArray = parameters.get(Parameters.List.\u00f5\u00d50000).split(",");
            hashSet.addAll(Arrays.asList(stringArray));
        }
        return hashSet;
    }

    private List<PoolFileEntry> applyItemsFilterToPoolFileEntryList(List<PoolFileEntry> list, Set<String> set) {
        if (set != null) {
            ArrayList<PoolFileEntry> arrayList = new ArrayList<PoolFileEntry>();
            for (PoolFileEntry poolFileEntry : list) {
                if (!set.contains(poolFileEntry.o00000)) continue;
                arrayList.add(poolFileEntry);
            }
            return arrayList;
        }
        return list;
    }

    private List<PoolDirectoryEntry> applyItemsFilterToPoolDirectoryEntryList(List<PoolDirectoryEntry> list, Set<String> set) {
        if (set != null) {
            ArrayList<PoolDirectoryEntry> arrayList = new ArrayList<PoolDirectoryEntry>();
            for (PoolDirectoryEntry poolDirectoryEntry : list) {
                if (!set.contains(poolDirectoryEntry.o00000)) continue;
                arrayList.add(poolDirectoryEntry);
            }
            return arrayList;
        }
        return list;
    }

    private PoolEntrySortingField determineSortField(Parameters parameters) throws IOException {
        PoolEntrySortingField poolEntrySortingField = RendererEnvironment.\u00d400000;
        if (this.O\u00d50000 != null) {
            poolEntrySortingField = this.O\u00d50000;
        } else if (parameters.contains(Parameters.Sorting.\u00d3\u00d50000) && parameters.get(Parameters.Sorting.\u00d3\u00d50000).trim().length() > 0) {
            try {
                poolEntrySortingField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.\u00d3\u00d50000).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Illegal sort field");
            }
        } else {
            poolEntrySortingField = this.o\u00d50000;
        }
        return poolEntrySortingField;
    }

    private void renderTemplate(Template template, Map map, RendererTextResponse rendererTextResponse) throws IOException, TemplateException {
        try (StringWriterFast stringWriterFast = new StringWriterFast();){
            Environment environment = template.createProcessingEnvironment((Object)map, (Writer)stringWriterFast);
            environment.process();
            rendererTextResponse.setBody(stringWriterFast.toString());
        }
    }

    private RendererTextResponse processMultiListRequest(ImageBuilder imageBuilder, Parameters parameters, HttpSession httpSession, Template template, String string, Escaper.EscaperType escaperType, Map map, String string2) throws IOException, TemplateException, NotConfiguredException {
        int n;
        Object object;
        String[] stringArray = string2.split(",", 2);
        PermissionSet[] permissionSetArray = new PermissionSet[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = URL.cleanUpSourceParameter(stringArray[i], "/");
            object = this.Object.getUserAuthenticationInterface().getPermissions(string3, httpSession, true);
            if (object == null || !object.list.files.booleanValue() && !object.list.directories.booleanValue()) {
                return StandardListRenderer.generateNotAuthorizedResponse();
            }
            permissionSetArray[i] = object;
        }
        long l = 0L;
        object = new List[stringArray.length];
        List[] listArray = new List[stringArray.length];
        _o[] _oArray = new _o[stringArray.length];
        SortDirection sortDirection = this.determineSortOrder(parameters);
        FSIStringComparator fSIStringComparator = this.determineSortComparator(parameters, sortDirection);
        PoolEntrySortingField poolEntrySortingField = this.determineSortField(parameters);
        PoolFileEntryComparator poolFileEntryComparator = new PoolFileEntryComparator(poolEntrySortingField, fSIStringComparator, sortDirection);
        PoolDirectoryEntryComparator poolDirectoryEntryComparator = new PoolDirectoryEntryComparator(poolEntrySortingField, fSIStringComparator, sortDirection);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.setTypeFilters(parameters, string, arrayList);
        for (n = 0; n < stringArray.length; ++n) {
            Object object2;
            Object object3;
            String string4 = URL.cleanUpSourceParameter(stringArray[n], "/");
            map.put("currentDir" + (n + 1), StandardListRenderer.escapeString(string4, escaperType));
            PermissionSet permissionSet = permissionSetArray[n];
            SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string4);
            PoolList poolList = imageBuilder.getPoolList(sourceConnectorReader, string4, httpSession);
            if (poolList != null) {
                l = Math.max(l, poolList.\u00d4\u00d60000);
            }
            int n2 = 0;
            int n3 = -1;
            if (parameters.contains(Parameters.List.\u00d8\u00d50000)) {
                try {
                    String string5 = parameters.get(Parameters.List.\u00d8\u00d50000);
                    String[] stringArray2 = string5.split(",");
                    if (stringArray2.length == 1) {
                        n3 = Integer.parseInt(stringArray2[0]);
                    } else if (stringArray2.length == 2) {
                        n3 = Integer.parseInt(stringArray2[1]);
                        n2 = Integer.parseInt(stringArray2[0]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = false;
            PoolList poolList2 = imageBuilder.getPoolList(sourceConnectorReader, string4, httpSession);
            if (permissionSet.list.files.booleanValue() && (!bl || bl && arrayList.contains("file"))) {
                object[n] = poolList2.getFilesAsList();
                if (!object[n].isEmpty()) {
                    this.sortingPoolList(object[n], poolEntrySortingField, fSIStringComparator, sortDirection);
                }
                n4 = poolList2.getFileCount();
            }
            if (permissionSet.list.directories.booleanValue() && (!bl || bl && arrayList.contains("directory"))) {
                object3 = poolList2.getDirectoryNamesAsList();
                listArray[n] = new ArrayList();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    String string6 = (String)object2.next();
                    PoolListSummary poolListSummary = imageBuilder.getPoolListSummary(sourceConnectorReader, string4 + string6, httpSession);
                    PoolDirectoryEntry poolDirectoryEntry = new PoolDirectoryEntry(string6, poolListSummary.\u00d200000, poolListSummary.getFileCount(), poolListSummary.getDirectoryCount());
                    listArray[n].add(poolDirectoryEntry);
                }
                if (!listArray[n].isEmpty()) {
                    listArray[n].sort(poolDirectoryEntryComparator);
                }
                n5 = poolList2.getDirectoryCount();
            }
            object3 = new HashMap();
            object3.put("entryCount", n4 + n5);
            object3.put("imageCount", n4);
            object3.put("directoryCount", n5);
            object3.put("completeCount", 0);
            if (poolList != null) {
                object3.put("lastModified", poolList.\u00d4\u00d60000);
            }
            map.put("summary" + (n + 1), object3);
            object2 = this.Object.getSourceConnectorFromAssetURLPath(string4);
            if (object2 == null) {
                throw new NoSuchFileException(string4);
            }
            n2 = this.ensureValidListOffset(n2, n4 + n5);
            if (n3 < 0) {
                n3 = n4 + n5 - n2;
            }
            _oArray[n] = new _o(n2, n3, n5, n4);
            if (!parameters.contains(Parameters.List.\u00f4\u00d50000)) continue;
            this.applyListRangeParameter(poolFileEntryComparator, poolDirectoryEntryComparator, parameters.get(Parameters.List.\u00f4\u00d50000), listArray[n], object[n], _oArray[n]);
        }
        n = 0;
        if (listArray[0] != null) {
            int n6 = listArray[0].size();
            for (int i = 1; i < listArray.length; ++i) {
                if (listArray[i].size() == n6) continue;
                n = 1;
                break;
            }
        }
        if (object[0] != null) {
            int n7 = object[0].size();
            for (int i = 1; i < ((List[])object).length; ++i) {
                if (object[i].size() == n7) continue;
                n = 1;
                break;
            }
        }
        if (n != 0) {
            throw new IOException("Different source directory counts");
        }
        List list = this.buildFinalMultiList(listArray, (List<PoolFileEntry>[])object, _oArray, escaperType, imageBuilder, stringArray, httpSession);
        map.put("ilist", list);
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        this.renderTemplate(template, map, rendererTextResponse);
        rendererTextResponse.setDateHeader("Last-Modified", l);
        rendererTextResponse.setStatus(200);
        return rendererTextResponse;
    }

    private Map getSimpleHashFromDownloadJob(DownloadJob downloadJob) {
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("src", downloadJob.getID());
        stringBuilder.append(downloadJob.getID());
        hashMap.put("fileName", downloadJob.getName());
        hashMap.put("size", downloadJob.getArchiveSize());
        hashMap.put("status", downloadJob.getStatus().ordinal());
        stringBuilder.append(downloadJob.getStatus().ordinal());
        hashMap.put("createdBy", downloadJob.getUser());
        hashMap.put("creationDate", downloadJob.getCreationTime());
        hashMap.put("lastmodified", downloadJob.getLastModified());
        stringBuilder.append(downloadJob.getLastModified());
        if (downloadJob.getScheduledStart() > 0L) {
            hashMap.put("scheduleDate", downloadJob.getScheduledStart());
        }
        if (downloadJob.getStartTime() > 0L) {
            hashMap.put("startDate", downloadJob.getStartTime());
        }
        int n = 0;
        if (downloadJob.getStatus() == DownloadJob.JobState.void) {
            hashMap.put("duration", downloadJob.getFinishedTime() - downloadJob.getStartTime());
            n = 100;
        } else {
            n = downloadJob.getProgressCount().get() * 100 / downloadJob.getFileCount();
            if (downloadJob.getStatus() == DownloadJob.JobState.\u00d500000 && downloadJob.getQueuePos() > 0) {
                hashMap.put("queuePos", downloadJob.getQueuePos());
            }
        }
        hashMap.put("progress", n);
        stringBuilder.append(n);
        hashMap.put("eTagModificationHash", stringBuilder.toString());
        return hashMap;
    }

    private RendererTextResponse processDownloadsListRequest(Parameters parameters, HttpSession httpSession, Template template, Map map) throws IOException, TemplateException, NotConfiguredException {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        ArrayList<Map> arrayList;
        Object object5;
        String string;
        Object object6 = this.getDownloadsList(httpSession);
        UserAuthenticationInterface userAuthenticationInterface = this.Object.getUserAuthenticationInterface();
        Set<String> set = userAuthenticationInterface.getGroupNamesForUser(userAuthenticationInterface.getUser(string = (String)httpSession.getAttribute("id")));
        if (!set.contains("administrators")) {
            object5 = new ArrayList();
            arrayList = object6.iterator();
            block0: while (arrayList.hasNext()) {
                object4 = arrayList.next();
                object3 = ((DownloadJob)object4).getGroups();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    String string2 = object2.next();
                    if (string2.equalsIgnoreCase("authenticated") || !set.contains(string2)) continue;
                    object5.add(object4);
                    continue block0;
                }
            }
            object6 = object5;
        }
        if (parameters.contains(Parameters.List.\u00f5\u00d50000)) {
            object5 = new ArrayList();
            arrayList = parameters.get(Parameters.List.\u00f5\u00d50000);
            object4 = new HashSet();
            object4.addAll(Arrays.asList(((String)((Object)arrayList)).split(",")));
            object3 = object6.iterator();
            while (object3.hasNext()) {
                object2 = (DownloadJob)object3.next();
                if (!object4.contains(((DownloadJob)object2).getID())) continue;
                object5.add(object2);
                break;
            }
            object6 = object5;
        }
        if ((object5 = parameters.get(Parameters.Sorting.\u00d3\u00d50000)) != null) {
            arrayList = this.determineSortOrder(parameters);
            object4 = this.determineSortComparator(parameters, (SortDirection)((Object)arrayList));
            object3 = new DownloadJobComparator((String)object5, (SortDirection)((Object)arrayList), (FSIStringComparator)object4);
            object6.sort(object3);
        }
        arrayList = new ArrayList<Map>();
        int n = 0;
        object3 = this.\u00d400000.getDownloadsFolder();
        long l = FileOperations.getSafeLastModified(object3);
        StringBuilder stringBuilder = new StringBuilder();
        Pair<Integer, Integer> pair = this.parseLimitParameter(parameters);
        int n2 = pair.getItem1();
        int n3 = pair.getItem2();
        int n4 = 0;
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            serializable = (DownloadJob)object7.next();
            if (((DownloadJob)serializable).getLastModified() > l) {
                l = ((DownloadJob)serializable).getLastModified();
            }
            if (n3 >= 0) {
                if (n4 >= n2 && n4 < n2 + n3) {
                    object = this.getSimpleHashFromDownloadJob((DownloadJob)serializable);
                    stringBuilder.append(object.get("eTagModificationHash"));
                    object.put("id", n++);
                    arrayList.add((Map)object);
                }
            } else {
                object = this.getSimpleHashFromDownloadJob((DownloadJob)serializable);
                stringBuilder.append(object.get("eTagModificationHash"));
                object.put("id", n++);
                arrayList.add((Map)object);
            }
            ++n4;
        }
        stringBuilder.append(l);
        map.put("currentDir", "_downloads/");
        object7 = new HashMap();
        object7.put("entryCount", arrayList.size());
        object7.put("imageCount", arrayList.size());
        object7.put("directoryCount", 0);
        object7.put("completeCount", arrayList.size());
        object7.put("lastModified", l);
        object7.put("connectorType", "DOWNLOAD");
        map.put("summary", object7);
        serializable = new HashMap();
        serializable.put("readOnly", "false");
        serializable.put("writeEnabled", "false");
        serializable.put("downloadOrigin", "true");
        serializable.put("publicFileAccess", "false");
        serializable.put("publicFileMetaAccess", "false");
        serializable.put("publicFileListAccess", "false");
        serializable.put("publicDirListAccess", "false");
        map.put("restrictions", serializable);
        map.put("ilist", arrayList);
        object = new RendererTextResponse();
        this.renderTemplate(template, map, (RendererTextResponse)object);
        ((RendererResponse)object).setETagModifier(stringBuilder.toString());
        ((RendererResponse)object).setDateHeader("Last-Modified", l);
        ((RendererResponse)object).setStatus(200);
        return object;
    }

    private RendererTextResponse processTrashListRequest(ImageBuilder imageBuilder, Parameters parameters, HttpSession httpSession, Template template, Escaper.EscaperType escaperType, Map map) throws IOException, TemplateException, NotConfiguredException {
        List<TrashListEntry> list = this.getTrashList(httpSession);
        long l = this.getTrashLastModified(httpSession, imageBuilder);
        Pair<Integer, Integer> pair = this.parseLimitParameter(parameters);
        int n = pair.getItem1();
        int n2 = pair.getItem2();
        SortDirection sortDirection = this.determineSortOrder(parameters);
        FSIStringComparator fSIStringComparator = this.determineSortComparator(parameters, sortDirection);
        TrashListEntryComparator trashListEntryComparator = new TrashListEntryComparator(parameters.get(Parameters.Sorting.\u00d3\u00d50000), fSIStringComparator, sortDirection);
        list.sort(trashListEntryComparator);
        int n3 = list.size();
        n = this.ensureValidListOffset(n, n3);
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        hashMap.put("entryCount", n3);
        hashMap.put("imageCount", n3);
        hashMap.put("directoryCount", 0);
        hashMap.put("completeCount", n3);
        hashMap.put("lastModified", l);
        map.put("summary", hashMap);
        map.put("currentDir", "_trash/");
        _o _o2 = new _o(n, n2, 0, n3);
        StringBuilder stringBuilder = new StringBuilder();
        List list2 = this.buildTrashList(list, _o2, escaperType, stringBuilder);
        map.put("ilist", list2);
        StringWriter stringWriter = new StringWriter();
        Environment environment = template.createProcessingEnvironment((Object)map, (Writer)stringWriter);
        environment.process();
        stringWriter.flush();
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setBody(stringWriter.toString());
        rendererTextResponse.setStatus(200);
        rendererTextResponse.setETagModifier(stringBuilder.toString());
        return rendererTextResponse;
    }

    private Pair<Integer, Integer> parseLimitParameter(Parameters parameters) {
        int n = 0;
        int n2 = -1;
        if (parameters.contains(Parameters.List.\u00d8\u00d50000)) {
            try {
                String string = parameters.get(Parameters.List.\u00d8\u00d50000);
                String[] stringArray = string.split(",");
                if (stringArray.length == 1) {
                    n2 = Integer.parseInt(stringArray[0]);
                } else if (stringArray.length == 2) {
                    n2 = Integer.parseInt(stringArray[1]);
                    n = Integer.parseInt(stringArray[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new Pair<Integer, Integer>(n, n2);
    }

    private List buildTrashList(List<TrashListEntry> list, _o _o2, Escaper.EscaperType escaperType, StringBuilder stringBuilder) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        if (_o2.o00000 >= 0) {
            for (int i = _o2.o00000; i < _o2.new; ++i) {
                TrashListEntry trashListEntry = list.get(i);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("id", n++);
                hashMap.put("src", StandardListRenderer.escapeString("_trash/" + trashListEntry.class + "/" + trashListEntry.\u00d200000, escaperType));
                hashMap.put("sourcePath", StandardListRenderer.escapeString(trashListEntry.\u00d300000, escaperType));
                hashMap.put("fileName", StandardListRenderer.escapeString(trashListEntry.\u00d600000, escaperType));
                hashMap.put("lastmodified", trashListEntry.super);
                hashMap.put("deletionDate", trashListEntry.\u00d800000);
                hashMap.put("size", trashListEntry.\u00d400000);
                arrayList.add(hashMap);
                stringBuilder.append(trashListEntry.\u00d300000);
                stringBuilder.append(trashListEntry.super);
                stringBuilder.append(trashListEntry.\u00d800000);
            }
        }
        return arrayList;
    }

    private RendererTextResponse processRootListRequest(ImageBuilder imageBuilder, Parameters parameters, HttpSession httpSession, Template template, Escaper.EscaperType escaperType, Map map) throws IOException, TemplateException, NotConfiguredException {
        Object noSuchFileException;
        Object object;
        SourceConnectorReader sourceConnectorReader;
        Object object4;
        Object object5;
        map.put("currentDir", "/");
        PoolList poolList = imageBuilder.getPoolList(null, "/", httpSession);
        if (poolList == null) {
            throw new NoSuchFileException("/");
        }
        long l = poolList.\u00d4\u00d60000;
        int n = 0;
        int n2 = -1;
        if (parameters.contains(Parameters.List.\u00d8\u00d50000)) {
            try {
                object5 = parameters.get(Parameters.List.\u00d8\u00d50000);
                object4 = ((String)object5).split(",");
                if (((String[])object4).length == 1) {
                    n2 = Integer.parseInt(object4[0]);
                } else if (((String[])object4).length == 2) {
                    n2 = Integer.parseInt(object4[1]);
                    n = Integer.parseInt(object4[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object5 = this.determineSortOrder(parameters);
        object4 = this.determineSortComparator(parameters, (SortDirection)((Object)object5));
        PoolEntrySortingField poolEntrySortingField = RendererEnvironment.\u00d400000;
        if (this.O\u00d50000 != null) {
            poolEntrySortingField = this.O\u00d50000;
        } else if (parameters.contains(Parameters.Sorting.\u00d3\u00d50000)) {
            try {
                poolEntrySortingField = PoolEntrySortingField.valueOf(parameters.get(Parameters.Sorting.\u00d3\u00d50000).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("Illegal sort field");
            }
        } else {
            poolEntrySortingField = this.o\u00d50000;
        }
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        List<PoolFileEntry> list = null;
        Set<String> set = poolList.getDirectoryNameSet();
        List<PoolDirectoryEntry> list2 = new ArrayList<PoolDirectoryEntry>();
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            for (String object32 : set) {
                sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath("/" + object32);
                if (sourceConnectorReader == null || !sourceConnectorReader.isEnabled()) continue;
                if ("_downloads".equals(sourceConnectorReader.getPrefix())) {
                    object = new PoolDirectoryEntry(object32, Files.getLastModifiedTime(this.\u00d400000.getDownloadsFolder(), new LinkOption[0]).toMillis(), -1L, -1L);
                    list2.add((PoolDirectoryEntry)object);
                    bl4 = true;
                    continue;
                }
                object = this.Object.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                if (object == null || !((PermissionSet)object).list.connector.booleanValue()) continue;
                try {
                    noSuchFileException = imageBuilder.getPoolListSummary(sourceConnectorReader, "/" + object32, httpSession);
                    long _o2 = ((PermissionSet)object).read.basicMetadata != false ? ((PoolListSummary)noSuchFileException).\u00d200000 : 0L;
                    long list3 = ((PermissionSet)object).read.basicMetadata != false ? ((PoolListSummary)noSuchFileException).getFileCount() : 0L;
                    long environment = ((PermissionSet)object).read.basicMetadata != false ? ((PoolListSummary)noSuchFileException).getDirectoryCount() : 0L;
                    PoolDirectoryEntry poolDirectoryEntry = new PoolDirectoryEntry(object32, _o2, list3, environment);
                    list2.add(poolDirectoryEntry);
                    bl3 |= ((PermissionSet)object).write.moveToTrash.booleanValue();
                }
                catch (NoSuchFileException noSuchFileException2) {
                    noSuchFileException2.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bl3 = false;
        PoolFileEntryComparator poolFileEntryComparator = new PoolFileEntryComparator(poolEntrySortingField, (Comparator<String>)object4, (SortDirection)((Object)object5));
        PoolDirectoryEntryComparator poolDirectoryEntryComparator = new PoolDirectoryEntryComparator(poolEntrySortingField, (Comparator<String>)object4, (SortDirection)((Object)object5));
        list2.sort(poolDirectoryEntryComparator);
        sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath("_configs", httpSession);
        if (sourceConnectorReader != null) {
            object = imageBuilder.getPoolListSummary(sourceConnectorReader, "_configs", httpSession);
            list2.add(0, new PoolDirectoryEntry("_configs", ((PoolListSummary)object).\u00d200000, ((PoolListSummary)object).getFileCount(), ((PoolListSummary)object).getDirectoryCount()));
        }
        if (!bl4 && (object = this.Object.getUserAuthenticationInterface().getPermissions("_downloads", httpSession, true)) != null && ((PermissionSet)object).list.files.booleanValue()) {
            list2.add(0, new PoolDirectoryEntry("_downloads", System.currentTimeMillis(), 0L, 0L));
        }
        if (bl3) {
            list2.add(0, new PoolDirectoryEntry("_trash", System.currentTimeMillis(), 0L, 0L));
        }
        object = this.evaluateItemsParameter(parameters);
        list2 = this.applyItemsFilterToPoolDirectoryEntryList(list2, (Set<String>)object);
        n3 = list2.size();
        noSuchFileException = new HashMap<String, Integer>();
        noSuchFileException.put("entryCount", 0 + n3);
        noSuchFileException.put("imageCount", 0);
        noSuchFileException.put("directoryCount", n3);
        noSuchFileException.put("completeCount", 0);
        noSuchFileException.put("lastModified", l);
        map.put("summary", noSuchFileException);
        n = this.ensureValidListOffset(n, 0 + n3);
        if (n2 < 0) {
            n2 = 0 + n3 - n;
        }
        _o _o2 = new _o(n, n2, n3, 0);
        if (parameters.contains(Parameters.List.\u00f4\u00d50000)) {
            this.applyListRangeParameter(poolFileEntryComparator, poolDirectoryEntryComparator, parameters.get(Parameters.List.\u00f4\u00d50000), list2, list, _o2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        List list3 = this.buildFinalList(list2, list, _o2, escaperType, "/", httpSession, true, stringBuilder);
        map.put("ilist", list3);
        StringWriter stringWriter = new StringWriter();
        Environment environment = template.createProcessingEnvironment((Object)map, (Writer)stringWriter);
        environment.process();
        stringWriter.flush();
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        rendererTextResponse.setBody(stringWriter.toString());
        rendererTextResponse.setStatus(200);
        rendererTextResponse.setETagModifier(stringBuilder.toString());
        return rendererTextResponse;
    }

    private Template determineListTemplate(Parameters parameters) throws IOException {
        String string = "image_list.xml";
        if (parameters.contains(Parameters.General.\u00d8\u00d40000)) {
            string = parameters.get(Parameters.General.\u00d8\u00d40000);
        }
        return this.Object.getTemplateCache().getTemplate(TemplateType.super, string + ".ftl");
    }

    private boolean setTypeFilters(Parameters parameters, String string, List<String> list) {
        boolean bl = false;
        if (string == null || string.trim().length() == 0) {
            String string2 = parameters.get(Parameters.List.\u00f8\u00d50000);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n = 10;
                while (stringTokenizer.hasMoreElements() && n-- > 0) {
                    String string3 = (String)stringTokenizer.nextElement();
                    list.add(string3.toLowerCase());
                }
                bl = true;
            }
        } else {
            list.add(string.toLowerCase());
            bl = true;
        }
        return bl;
    }

    private SortDirection determineSortOrder(Parameters parameters) {
        SortDirection sortDirection = this.\u00f5\u00d50000 != null ? this.\u00f5\u00d50000 : SortingUtils.extractSortOrderFromParameters(parameters, this.floatString);
        return sortDirection;
    }

    private FSIStringComparator determineSortComparator(Parameters parameters, SortDirection sortDirection) throws IOException {
        SortMethod sortMethod = this.o\u00d60000 != null ? this.o\u00d60000 : SortingUtils.extractSortMethodFromParameters(parameters, this.interfaceObject);
        String string = this.voidString != null ? this.voidString : SortingUtils.extractStringParameterFromParameters(parameters, Parameters.Sorting.\u00d4\u00d50000, this.\u00f4\u00d50000);
        String string2 = this.\u00d4\u00d50000 != null ? this.\u00d4\u00d50000 : SortingUtils.extractStringParameterFromParameters(parameters, Parameters.Sorting.\u00d5\u00d50000, this.\u00f6\u00d50000);
        boolean bl = this.\u00d2\u00d50000 ? this.ObjectString : (parameters.contains(Parameters.Sorting.returnString) ? Boolean.valueOf(parameters.get(Parameters.Sorting.returnString)) : this.\u00d5\u00d50000);
        return this.float.getFSIStringComparator(sortDirection, sortMethod, string, string2, bl);
    }

    private int ensureValidListOffset(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        return n;
    }

    private void applyListRangeParameter(PoolFileEntryComparator poolFileEntryComparator, PoolDirectoryEntryComparator poolDirectoryEntryComparator, String string, List<PoolDirectoryEntry> list, List<PoolFileEntry> list2, _o _o2) {
        String[] stringArray = string.split(",", 2);
        if (stringArray.length == 2) {
            String[] stringArray2 = stringArray[0].split(";", 5);
            PoolFileEntry poolFileEntry = new PoolFileEntry("", 0L, 0L, -1, -1, 0);
            if (stringArray2.length >= 1) {
                poolFileEntry.o00000 = stringArray2[0];
            }
            try {
                if (stringArray2.length >= 2) {
                    poolFileEntry.\u00d200000 = Long.parseLong(stringArray2[1]);
                }
                if (stringArray2.length >= 3) {
                    poolFileEntry.\u00d500000 = Long.parseLong(stringArray2[2]);
                }
                if (stringArray2.length >= 4) {
                    poolFileEntry.\u00d600000 = Integer.parseInt(stringArray2[3]);
                }
                if (stringArray2.length >= 5) {
                    poolFileEntry.String = Integer.parseInt(stringArray2[4]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] stringArray3 = stringArray[1].split(";", 5);
            PoolFileEntry poolFileEntry2 = new PoolFileEntry("", 0L, 0L, -1, -1, 0);
            if (stringArray2.length >= 1) {
                poolFileEntry2.o00000 = stringArray3[0];
            }
            try {
                if (stringArray2.length >= 2) {
                    poolFileEntry2.\u00d200000 = Long.parseLong(stringArray3[1]);
                }
                if (stringArray2.length >= 3) {
                    poolFileEntry2.\u00d500000 = Long.parseLong(stringArray3[2]);
                }
                if (stringArray2.length >= 4) {
                    poolFileEntry2.\u00d600000 = Integer.parseInt(stringArray3[3]);
                }
                if (stringArray2.length >= 5) {
                    poolFileEntry2.String = Integer.parseInt(stringArray3[4]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray2[0].equals("directory")) {
                _o2.\u00d400000 = this.findNearestDirectoryEntry(poolDirectoryEntryComparator, list, new PoolDirectoryEntry(poolFileEntry.o00000, poolFileEntry.\u00d200000, 0L, 0L));
                _o2.o00000 = 0;
            } else {
                _o2.\u00d400000 = list.size();
                _o2.o00000 = this.findNearestListEntry(poolFileEntryComparator, list2, poolFileEntry);
            }
            if (stringArray3[0].equals("directory")) {
                _o2.\u00d300000 = this.findNearestDirectoryEntry(poolDirectoryEntryComparator, list, new PoolDirectoryEntry(poolFileEntry2.o00000, poolFileEntry2.\u00d200000, 0L, 0L)) + 1;
                _o2.new = 0;
            } else {
                _o2.\u00d300000 = list.size();
                _o2.new = this.findNearestListEntry(poolFileEntryComparator, list2, poolFileEntry2) + 1;
            }
        }
    }

    private int findNearestDirectoryEntry(PoolDirectoryEntryComparator poolDirectoryEntryComparator, List<PoolDirectoryEntry> list, PoolDirectoryEntry poolDirectoryEntry) {
        int n;
        int n2;
        for (n2 = 0; n2 < list.size() && (n = poolDirectoryEntryComparator.compare(poolDirectoryEntry, list.get(n2))) < 0; ++n2) {
        }
        return n2;
    }

    private int findNearestListEntry(PoolFileEntryComparator poolFileEntryComparator, List<PoolFileEntry> list, PoolFileEntry poolFileEntry) {
        PoolFileEntry poolFileEntry2;
        int n;
        for (n = 0; n < list.size() && poolFileEntryComparator.compare(poolFileEntry, poolFileEntry2 = list.get(n)) < 0; ++n) {
        }
        return n;
    }

    private Map getSimpleHashFromPropertySet(PropertySet propertySet) {
        if (propertySet == null) {
            return null;
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        if (propertySet.general.size() > 0) {
            hashMap.put("general", this.getSimpleSequenceFromItemList(propertySet.general));
        }
        if (propertySet.custommetadatafields.size() > 0) {
            hashMap.put("customMetadataFields", this.getSimpleSequenceFromItemList(propertySet.custommetadatafields));
        }
        if (propertySet.publishingsets.size() > 0) {
            hashMap.put("publishingSets", this.getSimpleSequenceFromItemList(propertySet.publishingsets));
        }
        if (propertySet.hideApps.size() > 0) {
            hashMap.put("hideApps", this.getSimpleSequenceFromItemList(propertySet.hideApps));
        }
        if (propertySet.hidePublishingTabs.size() > 0) {
            hashMap.put("hidePublishingTabs", this.getSimpleSequenceFromItemList(propertySet.hidePublishingTabs));
        }
        if (propertySet.custom.size() > 0) {
            hashMap.put("custom", this.getSimpleSequenceFromItemList(propertySet.custom));
        }
        return hashMap;
    }

    private List getSimpleSequenceFromItemList(List<PropertySet.ItemType> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertySet.ItemType itemType : list) {
            if (!itemType.value) continue;
            arrayList.add(itemType.name);
        }
        return arrayList;
    }

    private Map getSimpleHashFromPermissionSet(PermissionSet permissionSet) {
        HashMap hashMap = new HashMap();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        hashMap2.put("renderedImages", permissionSet.read.renderedImages);
        hashMap2.put("files", permissionSet.read.files);
        hashMap2.put("downloadSource", permissionSet.read.downloadSource);
        hashMap2.put("copy", permissionSet.read.copy);
        hashMap2.put("basicMetadata", permissionSet.read.basicMetadata);
        hashMap2.put("extendedMetadata", permissionSet.read.extendedMetadata);
        hashMap2.put("iccProfiles", permissionSet.read.iccProfiles);
        hashMap2.put("totalAssetsCount", permissionSet.read.totalAssetsCount);
        hashMap2.put("storageStatus", permissionSet.read.storageStatus);
        hashMap.put("read", hashMap2);
        HashMap<String, Boolean> hashMap3 = new HashMap<String, Boolean>();
        hashMap3.put("files", permissionSet.list.files);
        hashMap3.put("directories", permissionSet.list.directories);
        hashMap3.put("connector", permissionSet.list.connector);
        hashMap3.put("searchResults", permissionSet.list.searchResults);
        hashMap.put("list", hashMap3);
        HashMap<String, Boolean> hashMap4 = new HashMap<String, Boolean>();
        hashMap4.put("createDirectory", permissionSet.write.createDirectory);
        hashMap4.put("upload", permissionSet.write.upload);
        hashMap4.put("paste", permissionSet.write.paste);
        hashMap4.put("delete", permissionSet.write.delete);
        hashMap4.put("moveToTrash", permissionSet.write.moveToTrash);
        hashMap4.put("rename", permissionSet.write.rename);
        hashMap4.put("overwrite", permissionSet.write.overwrite);
        hashMap4.put("moveWithinConnector", permissionSet.write.moveWithinConnector);
        hashMap4.put("extendedMetadata", permissionSet.write.extendedMetadata);
        hashMap.put("write", hashMap4);
        HashMap<String, Boolean> hashMap5 = new HashMap<String, Boolean>();
        hashMap5.put("batchRendering", permissionSet.tasks.batchRendering);
        hashMap5.put("createArchive", permissionSet.tasks.createArchive);
        hashMap5.put("reimportFiles", permissionSet.tasks.reimportFiles);
        hashMap.put("tasks", hashMap5);
        return hashMap;
    }

    private List buildFinalList(List<PoolDirectoryEntry> list, List<PoolFileEntry> list2, _o _o2, Escaper.EscaperType escaperType, String string, HttpSession httpSession, boolean bl, StringBuilder stringBuilder) throws NotConfiguredException {
        Object object;
        PoolEntry poolEntry;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 1;
        StringBuilder stringBuilder2 = new StringBuilder();
        if (_o2.\u00d400000 >= 0) {
            for (n = _o2.\u00d400000; n < _o2.\u00d300000; ++n) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                poolEntry = list.get(n);
                stringBuilder2.append(n2 + poolEntry.o00000);
                if (string.equals("/") && poolEntry.o00000.equals("_trash")) {
                    object = new HashMap();
                    object.put("id", n2++);
                    object.put("type", "directory");
                    object.put("src", StandardListRenderer.escapeString(poolEntry.o00000, escaperType));
                    object.put("connectorType", "TRASH");
                    if (bl) {
                        object5 = this.Object.getUserAuthenticationInterface().getPermissions("_trash", httpSession, true);
                        object4 = this.getSimpleHashFromPermissionSet((PermissionSet)object5);
                        object.put("userpermissions", object4);
                        object3 = this.Object.getUserAuthenticationInterface().getPermissions("_trash", null, true);
                        object2 = this.getSimpleHashFromPermissionSet((PermissionSet)object3);
                        object.put("publicpermissions", object2);
                    }
                    arrayList.add(object);
                    continue;
                }
                if (string.equals("/") && poolEntry.o00000.equals("_downloads")) {
                    object = new HashMap();
                    object.put("id", n2++);
                    object.put("type", "directory");
                    object.put("src", StandardListRenderer.escapeString(poolEntry.o00000, escaperType));
                    object.put("connectorType", "DOWNLOADS");
                    if (bl) {
                        object5 = this.Object.getUserAuthenticationInterface().getPermissions("_downloads", httpSession, true);
                        if (object5 == null) {
                            object5 = PermissionSet.getAllForbiddenPermissionSet();
                        }
                        object4 = this.getSimpleHashFromPermissionSet((PermissionSet)object5);
                        object.put("userpermissions", object4);
                        object3 = this.Object.getUserAuthenticationInterface().getPermissions("_downloads", null, true);
                        if (object3 == null) {
                            object3 = PermissionSet.getAllForbiddenPermissionSet();
                        }
                        object2 = this.getSimpleHashFromPermissionSet((PermissionSet)object3);
                        object.put("publicpermissions", object2);
                    }
                    arrayList.add(object);
                    continue;
                }
                if (string.startsWith("_config") || string.startsWith("_viewers")) {
                    object = new HashMap();
                    object.put("id", n2++);
                    object.put("type", "directory");
                    object.put("src", StandardListRenderer.escapeString(poolEntry.o00000, escaperType));
                    object.put("connectorType", "STATIC");
                    object.put("lastmodified", poolEntry.\u00d200000);
                    if (poolEntry.null > 0L) {
                        object.put("hasSub", true);
                        object.put("dirs", poolEntry.null);
                    } else {
                        object.put("hasSub", false);
                        object.put("dirs", 0);
                    }
                    object.put("images", poolEntry.\u00f500000);
                    arrayList.add(object);
                    continue;
                }
                object = this.Object.getSourceConnectorFromAssetURLPath(string + "/" + poolEntry.o00000, httpSession);
                if (object == null) continue;
                object5 = new HashMap<String, Object>();
                object5.put("id", n2++);
                object5.put("type", "directory");
                object5.put("src", StandardListRenderer.escapeString(poolEntry.o00000, escaperType));
                object5.put("size", 0);
                if (bl) {
                    SourceManagerSettings sourceManagerSettings;
                    SourceConnectorReader sourceConnectorReader;
                    Object object6;
                    if (((SourceConnectorReader)object).getComment() != null) {
                        object5.put("comment", StandardListRenderer.escapeString(((SourceConnectorReader)object).getComment(), escaperType));
                    }
                    object5.put("connectorType", ((SourceConnectorReader)object).getMountType());
                    object4 = this.Object.getUserAuthenticationInterface().getPermissions((SourceConnectorReader)object, httpSession, true);
                    object3 = this.getSimpleHashFromPermissionSet((PermissionSet)object4);
                    object5.put("userpermissions", object3);
                    object2 = this.Object.getUserAuthenticationInterface().getPermissions((SourceConnectorReader)object, null, true);
                    Map map = this.getSimpleHashFromPermissionSet((PermissionSet)object2);
                    object5.put("publicpermissions", map);
                    PropertySet propertySet = this.Object.getUserAuthenticationInterface().getProperties((SourceConnectorReader)object, httpSession);
                    Map map2 = this.getSimpleHashFromPropertySet(propertySet);
                    object5.put("properties", map2);
                    stringBuilder2.append(((PermissionSet)object4).hashCode());
                    stringBuilder2.append(((PermissionSet)object2).hashCode());
                    stringBuilder2.append(propertySet.hashCode());
                    if (((PermissionSet)object4).read.totalAssetsCount.booleanValue() && (object6 = this.Object.getServletContext().getAttribute("settings.sourceManager")) != null && (sourceConnectorReader = (sourceManagerSettings = (SourceManagerSettings)object6).getSourceConnector(((SourceConnectorReader)object).getPrefix())) != null) {
                        object5.put("connectorTotalContent", sourceConnectorReader.getCurrentImageCount());
                        stringBuilder2.append(sourceConnectorReader.getCurrentImageCount());
                    }
                }
                stringBuilder2.append(poolEntry.\u00d200000);
                object5.put("lastmodified", poolEntry.\u00d200000);
                if (poolEntry.null > 0L) {
                    object5.put("hasSub", true);
                    object5.put("dirs", poolEntry.null);
                } else {
                    object5.put("hasSub", false);
                    object5.put("dirs", 0);
                }
                object5.put("images", poolEntry.\u00f500000);
                arrayList.add(object5);
            }
        }
        if (_o2.o00000 >= 0) {
            for (n = _o2.o00000; n < _o2.new; ++n) {
                poolEntry = list2.get(n);
                object = new HashMap<String, Object>();
                object.put("id", n2++);
                object.put("type", "file");
                object.put("src", StandardListRenderer.escapeString(((PoolFileEntry)poolEntry).o00000, escaperType));
                if (((PoolFileEntry)poolEntry).\u00d600000 > 0) {
                    object.put("width", ((PoolFileEntry)poolEntry).\u00d600000);
                }
                if (((PoolFileEntry)poolEntry).String > 0) {
                    object.put("height", ((PoolFileEntry)poolEntry).String);
                }
                object.put("lastmodified", ((PoolFileEntry)poolEntry).\u00d200000);
                object.put("size", ((PoolFileEntry)poolEntry).\u00d500000);
                if (((PoolFileEntry)poolEntry).\u00d800000 != 0) {
                    object.put("importstatus", ((PoolFileEntry)poolEntry).\u00d800000);
                }
                stringBuilder2.append(n2 + ((PoolFileEntry)poolEntry).o00000 + ((PoolFileEntry)poolEntry).\u00d200000 + ((PoolFileEntry)poolEntry).\u00d500000 + ((PoolFileEntry)poolEntry).\u00d800000);
                arrayList.add(object);
            }
        }
        stringBuilder.append(stringBuilder2.toString().hashCode());
        return arrayList;
    }

    private List buildFinalMultiList(List<PoolDirectoryEntry>[] listArray, List<PoolFileEntry>[] listArray2, _o[] _oArray, Escaper.EscaperType escaperType, ImageBuilder imageBuilder, String[] stringArray, HttpSession httpSession) throws NoSuchFileException, IOException, NotConfiguredException {
        Object object;
        int n;
        int n2;
        HashMap<String, Object> hashMap;
        int n3;
        ArrayList arrayList = new ArrayList();
        int n4 = 1;
        if (_oArray[0].\u00d400000 >= 0) {
            for (n3 = _oArray[0].\u00d400000; n3 < _oArray[0].\u00d300000; ++n3) {
                hashMap = new HashMap<String, Object>();
                n2 = 0;
                n = 1;
                while (n2 < stringArray.length) {
                    object = listArray[n2].get((int)n3).o00000;
                    hashMap.put("id" + n, n4++);
                    hashMap.put("type" + n, "directory");
                    hashMap.put("src" + n, StandardListRenderer.escapeString((String)object, escaperType));
                    hashMap.put("importstatus" + n, 0);
                    hashMap.put("size" + n, 0);
                    SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(stringArray[n2]);
                    PoolListSummary poolListSummary = imageBuilder.getPoolListSummary(sourceConnectorReader, stringArray[n2] + (String)object, httpSession);
                    hashMap.put("lastmodified" + n, poolListSummary.\u00d200000);
                    if (poolListSummary.getDirectoryCount() > 0L) {
                        hashMap.put("hasSub" + n, true);
                        hashMap.put("dirs" + n, poolListSummary.getDirectoryCount());
                    } else {
                        hashMap.put("hasSub" + n, false);
                        hashMap.put("dirs" + n, 0);
                    }
                    hashMap.put("images" + n, poolListSummary.getFileCount());
                    ++n2;
                    ++n;
                }
                arrayList.add(hashMap);
            }
        }
        if (_oArray[0].o00000 >= 0) {
            for (n3 = _oArray[0].o00000; n3 < _oArray[0].new; ++n3) {
                hashMap = new HashMap();
                n2 = 0;
                n = 1;
                while (n2 < stringArray.length) {
                    object = listArray2[n2].get(n3);
                    hashMap.put("id" + n, n4++);
                    hashMap.put("type" + n, "file");
                    hashMap.put("src" + n, StandardListRenderer.escapeString(((PoolFileEntry)object).o00000, escaperType));
                    if (((PoolFileEntry)object).\u00d600000 > 0) {
                        hashMap.put("width" + n, ((PoolFileEntry)object).\u00d600000);
                    }
                    if (((PoolFileEntry)object).String > 0) {
                        hashMap.put("height" + n, ((PoolFileEntry)object).String);
                    }
                    hashMap.put("lastmodified" + n, ((PoolFileEntry)object).\u00d200000);
                    hashMap.put("size" + n, ((PoolFileEntry)object).\u00d500000);
                    hashMap.put("importstatus" + n, ((PoolFileEntry)object).\u00d800000);
                    ++n2;
                    ++n;
                }
                arrayList.add(hashMap);
            }
        }
        return arrayList;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class _o {
        int \u00d400000;
        int \u00d300000;
        int o00000;
        int new;

        _o(int n, int n2, int n3, int n4) {
            this.\u00d400000 = Math.max(0, n);
            this.\u00d300000 = Math.min(n3, this.\u00d400000 + n2);
            this.o00000 = Math.max(0, n - n3);
            this.new = Math.min(n4, n + n2 - n3);
        }

        public String toString() {
            return "Range Definition: startDirs: " + this.\u00d400000 + " stopDirs: " + this.\u00d300000 + " startFiles: " + this.o00000 + " stopFiles: " + this.new;
        }
    }
}

