/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.solr;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.neptunelabs.fsiserver.framework.helpers.StringUtils;
import com.neptunelabs.fsiserver.framework.helpers.URLEncoderFast;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.search.AsyncDatabaseJob;
import com.neptunelabs.fsiserver.search.DeleteAssetMetadataJob;
import com.neptunelabs.fsiserver.search.InsertMetadataJob;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrException;
import com.neptunelabs.fsiserver.search.solr.SolrResponse;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SolrUpdater
extends Thread {
    private static final int do = 30000;
    private static final int super = 1000;
    private static final int class = 10000;
    private final LinkedBlockingQueue<AsyncDatabaseJob> \u00d600000 = new LinkedBlockingQueue(10000);
    private final ConcurrentLinkedQueue<_Oo> \u00d300000 = new ConcurrentLinkedQueue();
    private final SourceManagerSettings \u00d400000;
    private final SearchDatabaseSolr OO0000;
    private final FSILogger \u00d3O0000;
    private final AtomicInteger \u00d2O0000 = new AtomicInteger(0);
    private Timer \u00d200000 = null;
    private _o int = null;
    private boolean \u00f800000;
    private volatile boolean \u00f400000 = false;
    private boolean \u00d800000 = false;
    private AtomicLong \u00f600000 = new AtomicLong(Long.MIN_VALUE);

    public SolrUpdater(SourceManagerSettings sourceManagerSettings, SearchDatabaseSolr searchDatabaseSolr, String string) {
        this.\u00d400000 = sourceManagerSettings;
        this.OO0000 = searchDatabaseSolr;
        this.\u00d3O0000 = sourceManagerSettings.getLogger();
        this.setName(string);
    }

    private static String cleanKey(String string) {
        return string.toLowerCase().replace(" ", "_").replace("/", "_or_");
    }

    public boolean isEnabled() {
        return this.\u00f800000;
    }

    public void setEnabled(boolean bl) {
        this.\u00f800000 = bl;
    }

    public boolean hasError() {
        return this.\u00f800000;
    }

    @Override
    public void run() {
        this.int = new _o();
        this.\u00d200000 = new Timer(this.getName() + "-Committer", true);
        this.\u00d200000.scheduleAtFixedRate((TimerTask)this.int, 5000L, 1000L);
        this.\u00d800000 = true;
        while (this.\u00d800000) {
            try {
                AsyncDatabaseJob asyncDatabaseJob = this.\u00d600000.take();
                this.\u00d2O0000.incrementAndGet();
                if (asyncDatabaseJob != null) {
                    if (asyncDatabaseJob instanceof InsertMetadataJob) {
                        this.insertMetaData((InsertMetadataJob)asyncDatabaseJob);
                    } else if (asyncDatabaseJob instanceof DeleteAssetMetadataJob) {
                        this.deleteAsset((DeleteAssetMetadataJob)asyncDatabaseJob);
                    } else if (this.\u00d3O0000 != null) {
                        this.\u00d3O0000.log(3185, "asyncJobQueue", "Unknown Async Database Job-Type" + asyncDatabaseJob.getClass().getName());
                    }
                } else {
                    SolrUpdater.yield();
                }
                this.\u00d2O0000.decrementAndGet();
            }
            catch (SolrException solrException) {
                this.\u00d3O0000.logException(solrException, 3185, "");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void halt() {
        this.\u00d800000 = false;
        if (this.\u00f800000) {
            this.interrupt();
            if (this.\u00d200000 != null) {
                this.\u00d200000.cancel();
                this.\u00d200000.purge();
            }
            this.OO0000.halt();
        }
    }

    private boolean insertMetaData(InsertMetadataJob insertMetadataJob) throws SolrException {
        boolean bl = false;
        this.waitFlushingCMDQueue();
        Map<String, String> map = insertMetadataJob.getMetaData();
        String string = insertMetadataJob.getAssetURLPath();
        String[] stringArray = string.split("/", 2);
        String string2 = stringArray[0];
        int n = string.lastIndexOf(47);
        if (n != -1) {
            String string3;
            String string4;
            String string5 = string.substring(n + 1).trim();
            String string6 = string.substring(0, n).trim();
            int n2 = string5.lastIndexOf(".");
            if (n2 > 0) {
                string4 = string5.substring(0, n2);
                string3 = string5.substring(n2 + 1);
            } else {
                string4 = string5;
                string3 = null;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode objectNode2 = objectMapper.createObjectNode();
            objectNode2.put("id", string);
            for (Map.Entry<String, String> objectNode3 : map.entrySet()) {
                String string7 = objectNode3.getKey();
                String string8 = SolrUpdater.cleanKey(string7);
                if (objectNode3.getValue() == null || string8 == null) continue;
                objectNode2.put(string8, objectNode3.getValue());
            }
            objectNode2.put("asset.fullpath", string);
            objectNode2.put("file.fullpath", string.toLowerCase());
            objectNode2.put("file.connector", string2);
            objectNode2.put("file.path", string6);
            String string9 = string5.toLowerCase();
            objectNode2.put("file.name", string9);
            objectNode2.put("file.prefix", string4.toLowerCase());
            if (string3 != null) {
                objectNode2.put("file.suffix", string3.toLowerCase());
            }
            ObjectNode objectNode = objectMapper.createObjectNode();
            objectNode.set("doc", (JsonNode)objectNode2);
            if (insertMetadataJob.isExplicitLogEnabled()) {
                this.\u00d300000.offer(new _Oo("add", objectNode, string));
            } else {
                this.\u00d300000.offer(new _Oo("add", objectNode));
            }
        }
        return false;
    }

    private boolean deleteAsset(DeleteAssetMetadataJob deleteAssetMetadataJob) throws SolrException {
        boolean bl = false;
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (String string : deleteAssetMetadataJob.getAssetURLPaths()) {
            ObjectNode objectNode = objectMapper.createObjectNode();
            if (string.endsWith("*")) {
                objectNode.put("query", "asset.fullpath:" + string);
            } else {
                objectNode.put("id", string);
            }
            arrayNode.add((JsonNode)objectNode);
        }
        this.\u00d300000.offer(new _Oo("delete", arrayNode));
        return false;
    }

    /*
     * Exception decompiling
     */
    private SolrResponse updateJSON(String var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean setMetaDataASync(String string, Map<String, String> map, boolean bl) {
        if (this.\u00f800000) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            InsertMetadataJob insertMetadataJob = new InsertMetadataJob(string, map, bl);
            return this.insertJob(insertMetadataJob);
        }
        this.logToSDBCheck(bl ? string : null);
        return true;
    }

    public boolean deleteAssetWithPrefixAsync(String string) {
        if (this.\u00f800000) {
            DeleteAssetMetadataJob deleteAssetMetadataJob = new DeleteAssetMetadataJob(string + "*");
            return this.insertJob(deleteAssetMetadataJob);
        }
        return true;
    }

    public boolean deleteAssetAsync(String string) {
        if (this.\u00f800000) {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            DeleteAssetMetadataJob deleteAssetMetadataJob = new DeleteAssetMetadataJob(string);
            return this.insertJob(deleteAssetMetadataJob);
        }
        this.logToSDBCheck(null);
        return true;
    }

    public boolean deleteAssetsAsync(Set<String> set) {
        if (this.\u00f800000) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : set) {
                if (string.endsWith("/")) {
                    hashSet.add(string.substring(0, string.length() - 1));
                    continue;
                }
                hashSet.add(string);
            }
            DeleteAssetMetadataJob deleteAssetMetadataJob = new DeleteAssetMetadataJob(hashSet);
            return this.insertJob(deleteAssetMetadataJob);
        }
        this.logToSDBCheck(null);
        return true;
    }

    private boolean insertJob(AsyncDatabaseJob asyncDatabaseJob) {
        boolean bl = true;
        try {
            asyncDatabaseJob.setJobCounter(this.\u00f600000.getAndIncrement());
            this.\u00d600000.put(asyncDatabaseJob);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        return bl;
    }

    public void waitForPseudoFlush() {
        if (this.\u00d600000.size() > 0) {
            boolean bl;
            long l = this.\u00f600000.get();
            do {
                AsyncDatabaseJob asyncDatabaseJob;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boolean bl2 = bl = this.\u00d600000.size() > 0;
                if (!bl || (asyncDatabaseJob = this.\u00d600000.peek()) == null || asyncDatabaseJob.getJobCounter() < l) continue;
                bl = false;
            } while (bl);
        }
        while (this.\u00d2O0000.get() > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.int.\u00d200000();
    }

    private void waitFlushingCMDQueue() {
        if (this.\u00d300000.size() > 10000) {
            while (this.\u00d300000.size() > 10000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean entryExists(String string) throws IOException {
        boolean bl = false;
        if (this.\u00f800000) {
            URLEncoderFast uRLEncoderFast = new URLEncoderFast("", false);
            String string2 = "q=asset.fullpath:" + uRLEncoderFast.escape("\"" + string + "\"") + "&fl=asset.fullpath";
            SolrResponse solrResponse = this.OO0000.searchJSON(string2);
            if (solrResponse.\u00d300000 == 200 && solrResponse.super != null) {
                try {
                    String string3 = new String(solrResponse.super, solrResponse.\u00d400000);
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode jsonNode = objectMapper.readTree(string3);
                    JsonNode jsonNode2 = jsonNode.get("response");
                    int n = jsonNode2.get("numFound").asInt();
                    bl = n == 1;
                }
                catch (JsonParseException jsonParseException) {
                    throw new SolrException("Invalid response from Solr Server: " + jsonParseException.getLocalizedMessage());
                }
            } else {
                String string4 = solrResponse.\u00d200000 != null ? "Invalid response from Solr Server: " + solrResponse.\u00d200000 + " for: " + string + " Q:" + string2 : "Invalid statusCode from Solr Server: " + solrResponse.\u00d300000 + " for: " + string + " Q:" + string2;
                throw new SolrException(string4);
            }
        }
        return bl;
    }

    public void resetLoggingStatus() {
        this.\u00f400000 = false;
    }

    private void logToSDBCheck(String string) {
        try {
            Path path = this.\u00d400000.getStorageLocation().resolve(".sdbcheck");
            if (string != null && string.length() > 0) {
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                FileOperations.writeTextFileContent(path, string, FileOperations.new, true);
            } else if (!this.\u00f400000) {
                if (Files.notExists(path, new LinkOption[0])) {
                    FileOperations.writeTextFileContent(path, "", FileOperations.new, false);
                }
                this.\u00f400000 = true;
            }
        }
        catch (IOException iOException) {
            this.\u00d3O0000.logException(iOException, 3238, iOException.getLocalizedMessage());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class _Oo {
        private final String \u00d400000;
        private final ObjectNode \u00d200000;
        private final ArrayNode class;
        private final String \u00d300000;

        _Oo(String string, ObjectNode objectNode) {
            this.\u00d400000 = string;
            this.\u00d200000 = objectNode;
            this.\u00d300000 = null;
            this.class = null;
        }

        _Oo(String string, ArrayNode arrayNode) {
            this.\u00d400000 = string;
            this.\u00d200000 = null;
            this.\u00d300000 = null;
            this.class = arrayNode;
        }

        _Oo(String string, ObjectNode objectNode, String string2) {
            this.\u00d400000 = string;
            this.\u00d200000 = objectNode;
            this.\u00d300000 = string2;
            this.class = null;
        }

        boolean \u00d200000() {
            return this.\u00d300000 != null;
        }

        String \u00d300000() {
            return this.\u00d300000;
        }

        String super() {
            return this.\u00d400000;
        }

        String \u00d400000() {
            if (this.\u00d200000 != null) {
                return this.\u00d200000.toString();
            }
            return this.class.toString();
        }
    }

    private class _o
    extends TimerTask {
        private long \u00d200000 = System.currentTimeMillis();

        _o() {
        }

        @Override
        public void run() {
            this.o00000(false);
        }

        void \u00d200000() {
            this.o00000(true);
        }

        private void o00000(boolean bl) {
            long l = System.currentTimeMillis();
            int n = Math.min(1000, SolrUpdater.this.\u00d300000.size());
            long l2 = l - this.\u00d200000;
            if (n > 0 && (bl || l2 >= 30000L || n == 1000)) {
                Object object;
                this.\u00d200000 = l;
                ArrayList<String> arrayList = new ArrayList<String>();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('{');
                for (int i = 0; i < n; ++i) {
                    object = (_Oo)SolrUpdater.this.\u00d300000.poll();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    if (((_Oo)object).\u00d200000()) {
                        arrayList.add(((_Oo)object).\u00d300000());
                    }
                    stringBuilder2.append('\"');
                    stringBuilder2.append(((_Oo)object).super());
                    stringBuilder2.append('\"');
                    stringBuilder2.append(':');
                    stringBuilder2.append(((_Oo)object).\u00d400000());
                    if (i + 1 < n) {
                        stringBuilder2.append(',');
                        stringBuilder2.append('\n');
                    }
                    stringBuilder.append(stringBuilder2.toString());
                }
                stringBuilder.append(",\n\"commit\": {}\n}");
                String string = stringBuilder.toString();
                object = SolrUpdater.this.updateJSON(string, false);
                if (((SolrResponse)object).\u00d300000 != 200) {
                    SolrUpdater.this.logToSDBCheck(StringUtils.join(arrayList, '\n'));
                }
            }
        }
    }
}

