/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.ImageFormatScanner;
import com.neptunelabs.fsiserver.imagereader.MetaScanner;
import com.neptunelabs.fsiserver.imagereader.exif.ExifParser;
import com.neptunelabs.fsiserver.imagereader.iptc.IptcDirectoryReader;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.DirectoryImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidEISFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DirectoryImportHandler
extends Thread {
    private static final String[] \u00d500000 = new String[]{":2eDS_Store", ":2elocalized"};
    private static final String[] \u00d3O0000 = new String[]{".erez", "Network Trash Folder", "Temporary Items"};
    private static final int \u00d600000 = 7;
    private final BlockingQueue<DirectoryImportJob> \u00d200000 = new LinkedBlockingQueue<DirectoryImportJob>();
    private final SourceManagerSettings null;
    private final SwapPool oO0000;
    private final ImageListFileReader \u00f800000;
    private final ImageListFileWriter for;
    private final Converter_V1002 String;
    private final DeleteDaemon \u00f500000;
    private final StorageManager \u00d2O0000;
    private final FSILogger private;
    private final DateFormat \u00f600000 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private ScannerDaemon \u00d5O0000;
    private volatile DirectoryImportJob o00000;
    private volatile _o \u00d300000 = _o.\u00d500000;
    private boolean \u00d800000 = false;

    public DirectoryImportHandler(ImageListFileReader imageListFileReader, ImageListFileWriter imageListFileWriter, SourceManagerSettings sourceManagerSettings, SwapPool swapPool, Converter_V1002 converter_V1002, DeleteDaemon deleteDaemon, StorageManager storageManager) {
        this.\u00f800000 = imageListFileReader;
        this.for = imageListFileWriter;
        this.null = sourceManagerSettings;
        this.oO0000 = swapPool;
        this.String = converter_V1002;
        this.\u00f500000 = deleteDaemon;
        this.\u00f600000.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.\u00d2O0000 = storageManager;
        this.private = sourceManagerSettings.getLogger();
        this.setDaemon(true);
        this.setName("Directory Import Handler");
    }

    public void setScannerDaemon(ScannerDaemon scannerDaemon) {
        this.\u00d5O0000 = scannerDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            if (this.\u00d300000 == _o.\u00d300000) {
                this.\u00d300000 = _o.o00000;
                return;
            }
            try {
                this.\u00d300000 = _o.\u00d500000;
                DirectoryImportJob directoryImportJob = this.\u00d200000.take();
                if (directoryImportJob != null) {
                    this.\u00d300000 = _o.String;
                    this.o00000 = directoryImportJob;
                    this.private.log(3264, directoryImportJob.null);
                    long l = System.currentTimeMillis();
                    directoryImportJob.setStartTime(l);
                    this.handleDirectory(directoryImportJob);
                    this.private.log(3270, directoryImportJob.null, System.currentTimeMillis() - l, this.\u00d200000.size());
                    this.o00000 = null;
                    continue;
                }
                DirectoryImportHandler.yield();
                continue;
            }
            catch (NotConfiguredException | InterruptedException exception) {
                this.\u00d300000 = _o.\u00d300000;
                continue;
            }
            catch (CorruptStorageException corruptStorageException) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = this.o00000 != null ? this.o00000.o00000.toAbsolutePath().toString() : "unknown directory";
                this.private.log(3232, string, exception.getClass().getName() + " : " + exception.getMessage());
                continue;
            }
            finally {
                this.o00000 = null;
                continue;
            }
            break;
        }
    }

    public void processJob(DirectoryImportJob directoryImportJob) throws NotConfiguredException, IOException {
        if (!this.\u00d200000.contains(directoryImportJob)) {
            this.handleDirectory(directoryImportJob);
        }
    }

    private int getCurrentReaderVersion(ImageFormat.Type type) {
        int n;
        switch (type) {
            case super: {
                n = 514;
                break;
            }
            case \u00d600000: {
                n = 259;
                break;
            }
            case int: {
                n = 258;
                break;
            }
            case \u00d400000: {
                n = 258;
                break;
            }
            case \u00d300000: {
                n = 258;
                break;
            }
            case \u00d800000: {
                n = 259;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public void cancelCurrent() {
        if (this.\u00d300000 != _o.\u00d500000) {
            this.\u00d800000 = true;
        }
    }

    public DirectoryImportJob getCurrentJob() {
        return this.o00000;
    }

    private void handleDirectory(DirectoryImportJob directoryImportJob) throws CorruptStorageException, NotConfiguredException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PoolList poolList;
        Path path;
        if (directoryImportJob.\u00d600000 == null) {
            directoryImportJob.\u00d600000 = this.null.getStorageHelper().getDirectoryFile(directoryImportJob.null);
        }
        if (Files.notExists(path = directoryImportJob.\u00d600000, new LinkOption[0])) {
            poolList = new PoolList(path, directoryImportJob.null);
        } else {
            try {
                poolList = this.\u00f800000.getListFileContents(path, directoryImportJob.null);
            }
            catch (NoSuchFileException noSuchFileException) {
                poolList = new PoolList(path, directoryImportJob.null);
            }
            catch (IOException iOException) {
                this.private.log(3249, directoryImportJob.null, path);
                poolList = new PoolList(path, directoryImportJob.null);
            }
        }
        ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
        Set<String> set = poolList.getImageNameSet();
        Set<String> set2 = poolList.getDirectoryNameSet();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object5 = this.listAllFiles(directoryImportJob.o00000);
        if (object5 == null) {
            if (Files.exists(directoryImportJob.o00000, new LinkOption[0])) {
                object5 = new ArrayDeque<PathCached>();
            } else {
                this.\u00f500000.removeStorageDirectory(directoryImportJob.null, "V1002");
                return;
            }
        }
        int n = 0;
        int n2 = object5.size();
        Object object62 = object5.iterator();
        while (object62.hasNext()) {
            object4 = object62.next();
            if (this.\u00d800000) {
                this.\u00d800000 = false;
                return;
            }
            if (this.\u00d300000 == _o.\u00d300000) break;
            ++n;
            if (((PathCached)object4).isRegularFile()) {
                object3 = ImageFormatScanner.getInstance();
                object2 = ((ImageFormatScanner)object3).scanFile((PathCached)object4);
                FileImportJob fileImportJob = new FileImportJob(QueueType.String, (PathCached)object4, (ImageFormat)object2, (String)(object = directoryImportJob.null + "/" + ((PathCached)object4).getFileName()));
                if (!this.String.isFileBeingProcessed(fileImportJob)) {
                    Map<Pair<String, String>, String> map;
                    Object object7;
                    Object object8;
                    if (directoryImportJob.\u00d500000.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
                        boolean bl = false;
                        PoolFileEntry poolFileEntry = poolList.getImage(((PathCached)object4).getFileName());
                        if (poolFileEntry != null && poolFileEntry.\u00d800000 == 2) {
                            bl = true;
                        }
                        if (bl || ((ImageFormat)object2).\u00d400000 && ((ImageFormat)object2).super != ImageFormat.Type.\u00d200000 && this.isValidFilename((PathCached)object4, true)) {
                            ImageMetaData imageMetaData;
                            boolean bl2;
                            boolean bl3;
                            block123: {
                                int n3;
                                bl3 = false;
                                bl2 = false;
                                object8 = this.null.getStorageHelper().getEisFile((String)object);
                                imageMetaData = null;
                                if (directoryImportJob.String) {
                                    if (Files.exists((Path)object8, new LinkOption[0])) {
                                        object7 = this.\u00d2O0000.getRealEISImageFile((String)object);
                                        if (object7 != null) {
                                            try {
                                                EISReader eISReader = new EISReader((String)object, (Path)object7, this.null, this.oO0000, false);
                                                map = null;
                                                try {
                                                    long l;
                                                    long l2;
                                                    int n4;
                                                    imageMetaData = eISReader.getImageMetaData();
                                                    if (directoryImportJob.\u00d800000 && imageMetaData.getImportStatus() == 3 && (n4 = imageMetaData.getImageReaderVersion()) != (n3 = this.getCurrentReaderVersion(((ImageFormat)object2).super))) {
                                                        this.private.log(3226, object, "broken image and recheck enabled");
                                                        bl3 = true;
                                                    }
                                                    if (imageMetaData == null) break block123;
                                                    if (!bl3) {
                                                        if (imageMetaData.getImportStatus() == 4) {
                                                            this.private.log(3226, object, "status is reimport");
                                                            bl3 = true;
                                                        } else if (imageMetaData.getImportStatus() == 2) {
                                                            this.private.log(3226, object, "status is queued");
                                                            bl3 = true;
                                                        } else if (imageMetaData.getImportStatus() == 0) {
                                                            this.private.log(3226, object, "status is unknown");
                                                            bl3 = true;
                                                        }
                                                    }
                                                    if (!bl3 && (l2 = ((PathCached)object4).size()) != (l = imageMetaData.getSourceFileSize())) {
                                                        this.private.log(3226, object, "filesize has changed " + l2 + "!=" + l + " in " + object8);
                                                        bl3 = true;
                                                    }
                                                    if (!bl3) {
                                                        long l3 = imageMetaData.getLastModified();
                                                        if (((PathCached)object4).lastModified() != l3) {
                                                            this.private.log(3226, object, "lm-date has changed");
                                                            bl3 = true;
                                                        }
                                                    }
                                                }
                                                catch (Throwable throwable) {
                                                    map = throwable;
                                                    throw throwable;
                                                }
                                                finally {
                                                    if (eISReader != null) {
                                                        if (map != null) {
                                                            try {
                                                                eISReader.close();
                                                            }
                                                            catch (Throwable throwable) {
                                                                ((Throwable)((Object)map)).addSuppressed(throwable);
                                                            }
                                                        } else {
                                                            eISReader.close();
                                                        }
                                                    }
                                                }
                                            }
                                            catch (NoSuchFileException noSuchFileException) {
                                                bl3 = true;
                                                bl2 = true;
                                            }
                                            catch (NotAValidEISFileException notAValidEISFileException) {
                                                Files.delete((Path)object7);
                                                this.private.log(3226, object, "corrupt storage file");
                                                bl3 = true;
                                                bl2 = true;
                                            }
                                            catch (IOException iOException) {
                                                this.private.log(3227, object, object7, iOException.getLocalizedMessage());
                                            }
                                            catch (Exception exception) {
                                                this.private.log(3227, object, object7, exception.getLocalizedMessage());
                                                bl2 = true;
                                            }
                                        } else {
                                            bl3 = true;
                                            bl2 = true;
                                        }
                                    } else {
                                        this.private.log(3226, object, "new file");
                                        bl3 = true;
                                        bl2 = true;
                                    }
                                } else if (set.contains(((PathCached)object4).getFileName())) {
                                    long l;
                                    long l4;
                                    object7 = poolList.getImage(((PathCached)object4).getFileName());
                                    if (directoryImportJob.\u00d800000 && ((PoolFileEntry)object7).\u00d800000 == 3) {
                                        if (Files.exists((Path)object8, new LinkOption[0])) {
                                            Path path2 = this.\u00d2O0000.getRealEISImageFile((String)object);
                                            if (path2 != null) {
                                                try {
                                                    map = new EISReader((String)object, path2, this.null, this.oO0000, false);
                                                    Throwable throwable = null;
                                                    try {
                                                        imageMetaData = ((EISReader)((Object)map)).getImageMetaData();
                                                        n3 = imageMetaData.getImageReaderVersion();
                                                        int n5 = this.getCurrentReaderVersion(((ImageFormat)object2).super);
                                                        if (n3 != n5) {
                                                            this.private.log(3226, object, "broken image and recheck enabled");
                                                            bl3 = true;
                                                        }
                                                    }
                                                    catch (Throwable throwable2) {
                                                        throwable = throwable2;
                                                        throw throwable2;
                                                    }
                                                    finally {
                                                        if (map != null) {
                                                            if (throwable != null) {
                                                                try {
                                                                    ((EISReader)((Object)map)).close();
                                                                }
                                                                catch (Throwable throwable3) {
                                                                    throwable.addSuppressed(throwable3);
                                                                }
                                                            } else {
                                                                ((EISReader)((Object)map)).close();
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (Exception exception) {
                                                    bl3 = true;
                                                }
                                            } else {
                                                bl3 = true;
                                                bl2 = true;
                                            }
                                        } else {
                                            bl3 = true;
                                            bl2 = true;
                                        }
                                    }
                                    if (!bl3) {
                                        if (((PoolFileEntry)object7).\u00d800000 == 4) {
                                            this.private.log(3226, object, "status is reimport");
                                            bl3 = true;
                                        } else if (((PoolFileEntry)object7).\u00d800000 == 2) {
                                            this.private.log(3226, object, "status is queued");
                                            bl3 = true;
                                        } else if (((PoolFileEntry)object7).\u00d800000 == 0) {
                                            this.private.log(3226, object, "status is unknown");
                                            bl3 = true;
                                        }
                                    }
                                    if (!bl3 && (l4 = ((PathCached)object4).size()) != (l = ((PoolFileEntry)object7).\u00d500000)) {
                                        this.private.log(3226, object, "filesize has changed " + l4 + "!=" + l + " in " + object8.toString());
                                        bl3 = true;
                                    }
                                    if (!bl3) {
                                        long l5 = ((PoolFileEntry)object7).\u00d200000;
                                        if (((PathCached)object4).lastModified() != l5) {
                                            this.private.log(3226, object, "lm-date has changed");
                                            bl3 = true;
                                        }
                                    }
                                } else if (Files.exists((Path)object8, new LinkOption[0])) {
                                    bl3 = true;
                                } else {
                                    this.private.log(3226, object, "new file");
                                    bl3 = true;
                                    bl2 = true;
                                }
                            }
                            if (bl3 && this.\u00d300000 != _o.\u00d300000) {
                                object7 = new FileImportJob(QueueType.String, directoryImportJob.\u00d500000, (PathCached)object4, (ImageFormat)object2, (Path)object8, (String)object, Converter_V1002.evaluatePriority(QueueType.String), directoryImportJob.\u00d800000);
                                ((FileImportJob)object7).o00000 = path;
                                if (bl2) {
                                    EISImageWriter eISImageWriter = new EISImageWriter(this.null, 2, -1);
                                    eISImageWriter.setAssetURLPath(((FileImportJob)object7).void);
                                    this.\u00d2O0000.executeStorageDataProvider((Path)object8, eISImageWriter);
                                    map = new PoolFileEntry(((PathCached)object4).getFileName(), ((PathCached)object4).lastModified(), ((PathCached)object4).size(), -1, -1, 2);
                                    arrayList.add((PoolEntry)((Object)map));
                                }
                                linkedList.add(object7);
                            } else if (this.\u00d300000 != _o.\u00d300000 && directoryImportJob.String && imageMetaData != null && ((object7 = poolList.getImage(((PathCached)object4).getFileName())) == null || ((PoolFileEntry)object7).\u00d500000 != imageMetaData.getSourceFileSize() || ((PoolFileEntry)object7).\u00d800000 != imageMetaData.getImportStatus() || ((PoolFileEntry)object7).\u00d200000 != imageMetaData.getLastModified() || ((PoolFileEntry)object7).\u00d600000 != imageMetaData.getWidth() || ((PoolFileEntry)object7).String != imageMetaData.getHeight())) {
                                PoolFileEntry poolFileEntry2 = new PoolFileEntry(((PathCached)object4).getFileName(), ((PathCached)object4).lastModified(), imageMetaData.getSourceFileSize(), imageMetaData.getWidth(), imageMetaData.getHeight(), imageMetaData.getImportStatus());
                                arrayList.add(poolFileEntry2);
                            }
                        }
                    } else {
                        long l = ((PathCached)object4).size();
                        PoolFileEntry poolFileEntry = poolList.getImage(((PathCached)object4).getFileName());
                        if ((poolFileEntry == null || poolFileEntry.\u00d500000 != l || poolFileEntry.\u00d200000 != ((PathCached)object4).lastModified() || poolFileEntry.\u00d800000 != 1) && (directoryImportJob.\u00d500000.getMountType() == SourceConnectorReader.SourceConnectorType.super || directoryImportJob.\u00d500000.getMountType() == SourceConnectorReader.SourceConnectorType.class && ((ImageFormat)object2).\u00d400000)) {
                            PoolFileEntry poolFileEntry3 = new PoolFileEntry(((PathCached)object4).getFileName(), ((PathCached)object4).lastModified(), l, -1, -1, 1);
                            object8 = new HashMap();
                            object8.put("file.type", "file");
                            object8.put("file.name", ((PathCached)object4).getFileName());
                            object8.put("file.prefix", ((ImageFormat)object2).\u00d200000);
                            object8.put("file.suffix", ((ImageFormat)object2).\u00d300000);
                            object8.put("file.size", java.lang.String.valueOf(l));
                            object8.put("file.lastmodified", this.\u00f600000.format(new Date(((PathCached)object4).lastModified())));
                            if (directoryImportJob.\u00d500000.getMountType() == SourceConnectorReader.SourceConnectorType.class && this.\u00d300000 != _o.\u00d300000 && this.isPyramidFileSupported((PathCached)object4, (ImageFormat)object2)) {
                                this.private.log(3141, object4, n, n2);
                                MetaScanner metaScanner = new MetaScanner(this.null.getLogger());
                                object7 = metaScanner.scanImage((PathCached)object4, false);
                                poolFileEntry3.String = ((FSIMetaData)object7).getHeight();
                                poolFileEntry3.\u00d600000 = ((FSIMetaData)object7).getWidth();
                                object8.put("file.height", java.lang.String.valueOf(((FSIMetaData)object7).getHeight()));
                                object8.put("file.width", java.lang.String.valueOf(((FSIMetaData)object7).getWidth()));
                                byte[] byArray = ((FSIMetaData)object7).getIPTC();
                                if (byArray != null && byArray.length > 0) {
                                    map = IptcDirectoryReader.getIptcMap(byArray);
                                    for (Map.Entry<Pair<String, String>, String> entry : map.entrySet()) {
                                        object8.put("iptc." + entry.getKey().getItem2(), entry.getValue());
                                    }
                                }
                                if ((map = (Map<Pair<String, String>, String>)((FSIMetaData)object7).getExif()) != null && ((Map<Pair<String, String>, String>)map).length > 0) {
                                    ExifParser exifParser = ExifParser.getInstance(this.null.getLogger());
                                    exifParser.setName(((PathCached)object4).getAbsolutePath().toString());
                                    exifParser.scanExif((byte[])map);
                                    Map<Pair<Integer, String>, String> map2 = exifParser.getShortMap();
                                    for (Map.Entry<Pair<Integer, String>, String> entry : map2.entrySet()) {
                                        object8.put("exif." + entry.getKey().getItem2(), entry.getValue());
                                    }
                                }
                            }
                            if (this.\u00d300000 != _o.\u00d300000) {
                                boolean bl;
                                if (this.null.getSolrUpdater() != null && !(bl = this.null.getSolrUpdater().setMetaDataASync(directoryImportJob.null + "/" + ((PathCached)object4).getFileName(), (Map<String, String>)object8, false))) {
                                    this.private.log(3236, directoryImportJob.null + "/" + ((PathCached)object4).getFileName());
                                }
                                arrayList.add(poolFileEntry3);
                            }
                        }
                    }
                }
            } else if (this.isRecursableDir((PathCached)object4) && this.\u00d300000 != _o.\u00d300000) {
                if (set2.contains(((PathCached)object4).getFileName())) {
                    set2.remove(((PathCached)object4).getFileName());
                } else {
                    arrayList.add(new PoolDirectoryEntry(((PathCached)object4).getFileName(), ((PathCached)object4).lastModified(), 0L, 0L));
                }
            }
            set.remove(((PathCached)object4).getFileName());
        }
        if (this.\u00d300000 != _o.\u00d300000) {
            object5 = new HashSet();
            for (String string : set) {
                object62 = directoryImportJob.null + "/" + string;
                object4 = URL.getParentAssetURLPath(directoryImportJob.null);
                object3 = this.null.getStorageHelper().getDirectoryFile((String)object4);
                this.for.removeEntry(path, directoryImportJob.null, (Path)object3, (String)object4, string, poolList.\u00d4\u00d60000);
                if (directoryImportJob.\u00d500000.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000) {
                    try {
                        this.\u00f500000.removeStorageFileV1002((String)object62, directoryImportJob.\u00d500000, false);
                    }
                    catch (IOException iOException) {
                        this.null.getLogger().logException(iOException, 3228, "remove", object62, "");
                        iOException.printStackTrace();
                    }
                }
                object5.add(object62);
            }
            if (this.null.getSolrUpdater() != null && object5.size() > 0) {
                this.null.getSolrUpdater().deleteAssetsAsync((Set<String>)object5);
            }
        }
        if (this.\u00d300000 != _o.\u00d300000) {
            for (String string : set2) {
                String string2 = directoryImportJob.null + "/" + string;
                this.\u00f500000.removeStorageDirectory(string2, "V1002");
            }
        }
        long l = directoryImportJob.\u00d300000;
        if (this.\u00d300000 == _o.\u00d300000) {
            l = -1L;
        }
        if (arrayList.size() > 0) {
            String string = URL.getParentAssetURLPath(directoryImportJob.null);
            object62 = this.null.getStorageHelper().getDirectoryFile(string);
            this.for.updateEntries(path, directoryImportJob.null, (Path)object62, string, arrayList, l);
            this.\u00d5O0000.getMetaDataAndUpdateSearchDatabase(directoryImportJob.null, false);
        } else if (poolList.\u00d4\u00d60000 != directoryImportJob.\u00d300000) {
            this.for.updateLastModified(path, directoryImportJob.null, l);
            this.\u00d5O0000.getMetaDataAndUpdateSearchDatabase(directoryImportJob.null, false);
        } else if (this.\u00d300000 != _o.\u00d300000) {
            String string = URL.getParentAssetURLPath(directoryImportJob.null);
            object62 = this.null.getStorageHelper().getDirectoryFile(string);
            object4 = this.\u00f800000.getListFileContents(path, directoryImportJob.null);
            object3 = this.\u00f800000.getListFileContents((Path)object62, string);
            object2 = string.length() > 1 ? directoryImportJob.null.substring(string.length() + 1) : directoryImportJob.null;
            object = ((PoolList)object3).getDirectory((String)object2);
            boolean bl = false;
            if (object != null) {
                if (((PoolDirectoryEntry)object).\u00f500000 != (long)((PoolList)object4).getFileCount()) {
                    ((PoolDirectoryEntry)object).\u00f500000 = ((PoolList)object4).getFileCount();
                    bl = true;
                }
                if (((PoolDirectoryEntry)object).null != (long)((PoolList)object4).getDirectoryCount()) {
                    ((PoolDirectoryEntry)object).null = ((PoolList)object4).getDirectoryCount();
                    bl = true;
                }
                if (((PoolDirectoryEntry)object).\u00d200000 != ((PoolList)object4).\u00d4\u00d60000) {
                    ((PoolDirectoryEntry)object).\u00d200000 = ((PoolList)object4).\u00d4\u00d60000;
                    bl = true;
                }
            }
            if (bl) {
                this.for.updateEntry((Path)object62, string, null, null, (PoolEntry)object, -1L);
                this.\u00d5O0000.getMetaDataAndUpdateSearchDatabase(string, false);
            }
        }
        if (linkedList.size() > 0 && this.\u00d300000 != _o.\u00d300000) {
            for (Object object62 : linkedList) {
                while (!this.String.enqueueJob((FileImportJob)object62)) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.\u00d300000 = _o.\u00d300000;
                        break;
                    }
                }
                if (this.\u00d300000 != _o.\u00d300000) continue;
                break;
            }
        }
    }

    public boolean isValidFilename(PathCached pathCached, boolean bl) throws IOException {
        int n = (int)((System.currentTimeMillis() - pathCached.lastModified()) / 1000L);
        if (bl && (n > 7 || n < 0) || !bl) {
            if (!pathCached.isReadable()) {
                return false;
            }
            if (pathCached.isHidden()) {
                return false;
            }
            for (String string : \u00d500000) {
                if (!pathCached.getFileName().equals(string)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean isRecursableDir(PathCached pathCached) {
        if (!pathCached.isDirectory()) {
            return false;
        }
        if (pathCached.isHidden()) {
            return false;
        }
        for (String string : \u00d3O0000) {
            if (!pathCached.getFileName().equals(string)) continue;
            return false;
        }
        return true;
    }

    private boolean isPyramidFileSupported(PathCached pathCached, ImageFormat imageFormat) {
        if (pathCached.isHidden()) {
            return false;
        }
        for (String string : \u00d500000) {
            if (!pathCached.getFileName().equals(string)) continue;
            return false;
        }
        boolean bl = false;
        if (imageFormat.super == ImageFormat.Type.\u00d800000) {
            bl = true;
        } else if (imageFormat.super == ImageFormat.Type.\u00d600000) {
            bl = true;
        }
        return bl;
    }

    public boolean submitDirectory(SourceConnectorReader sourceConnectorReader, Path path, long l, String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        DirectoryImportJob directoryImportJob = new DirectoryImportJob(sourceConnectorReader, path, string, l, bl, bl2);
        if ((this.o00000 == null || !directoryImportJob.equals(this.o00000) && !this.\u00d200000.contains(directoryImportJob)) && (bl3 = this.\u00d200000.offer(directoryImportJob))) {
            this.private.log(3224, path);
        }
        return bl3;
    }

    public boolean isDirectoryEnqueued(Path path, String string, boolean bl) {
        DirectoryImportJob directoryImportJob = new DirectoryImportJob(null, null, string, 0L, false, bl);
        boolean bl2 = this.\u00d200000.contains(directoryImportJob);
        if (!bl2) {
            bl2 = directoryImportJob.equals(this.o00000);
        }
        return bl2;
    }

    public void shutdown() {
        this.\u00d300000 = _o.\u00d300000;
        this.\u00d200000.clear();
        this.interrupt();
    }

    private Deque<PathCached> listAllFiles(final Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        final ArrayDeque<PathCached> arrayDeque = new ArrayDeque<PathCached>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult super(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                if (DirectoryImportHandler.this.\u00d300000 == _o.\u00d300000) {
                    return FileVisitResult.TERMINATE;
                }
                if (path.equals(path2)) {
                    return FileVisitResult.CONTINUE;
                }
                arrayDeque.add(new PathCached(path2, basicFileAttributes));
                return FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult \u00d300000(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                if (DirectoryImportHandler.this.\u00d300000 == _o.\u00d300000) {
                    return FileVisitResult.TERMINATE;
                }
                if (basicFileAttributes.isRegularFile()) {
                    arrayDeque.add(new PathCached(path2, basicFileAttributes));
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult \u00d200000(Path path2, IOException iOException) throws IOException {
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return arrayDeque;
    }

    private static enum _o {
        \u00d500000,
        String,
        \u00d300000,
        o00000;

    }
}

