/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.metadata;

import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.framework.cache.CacheableData;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.collections.PairComparator;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.converter.ColorType;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.exif.ExifParser;
import com.neptunelabs.fsiserver.imagereader.exif.ExifTag;
import com.neptunelabs.fsiserver.imagereader.exif.ExifTagMapping;
import com.neptunelabs.fsiserver.imagereader.exif.ExifValueType;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetaData
implements CacheableData<MetaData> {
    private String \u00d8\u00d30000;
    long \u00d4\u00d30000 = -1L;
    private Map<String, String> \u00d3\u00d30000;
    private static final byte whilenew = 0;
    private static final byte thisObject = 1;
    private static final byte \u00d5\u00d30000 = 2;
    private static final byte o\u00d30000 = 3;

    public MetaData() {
    }

    private MetaData(MetaData metaData) {
        this.\u00d8\u00d30000 = metaData.getAssetURLPath();
        this.\u00d4\u00d30000 = metaData.getLastModified();
        HashMap hashMap = (HashMap)metaData.getCustomMetaData();
        this.\u00d3\u00d30000 = (Map)hashMap.clone();
    }

    public final void setAssetURLPath(String string) {
        this.\u00d8\u00d30000 = string;
    }

    public final void setLastModified(long l) {
        this.\u00d4\u00d30000 = l;
    }

    public final String getAssetURLPath() {
        return this.\u00d8\u00d30000;
    }

    public final long getLastModified() {
        return this.\u00d4\u00d30000;
    }

    public void setCustomMetaData(Map<String, String> map) {
        this.\u00d3\u00d30000 = map;
    }

    public Map<String, String> getCustomMetaData() {
        return this.\u00d3\u00d30000;
    }

    public Map<Integer, Pair<String, String>> getExifSortedMap(FSILogger fSILogger, String string, boolean bl) {
        List<ExifTag> list = this.getCustomExifTagList();
        return this.convertExifListToSortedMap(list, bl, fSILogger, string);
    }

    List<ExifTag> getCustomExifTagList() {
        ArrayList<ExifTag> arrayList = new ArrayList<ExifTag>();
        Map<String, String> map = this.getUnSortedMapByPrefix("exif.");
        if (map != null && map.size() > 0) {
            ExifTagMapping exifTagMapping = ExifTagMapping.getInstance();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Pair<Integer, Integer> pair = exifTagMapping.getTagIDByLongName(entry.getKey());
                if (pair == null) continue;
                String string = exifTagMapping.getShortName(pair.getItem1(), pair.getItem2());
                String string2 = exifTagMapping.getLongName(pair.getItem1(), pair.getItem2());
                ExifTag exifTag = new ExifTag(pair.getItem2(), string, string2, ExifValueType.Text, entry.getValue(), null);
                arrayList.add(exifTag);
            }
        }
        return arrayList;
    }

    public List<Pair<String, String>> getSortedFSIList() {
        Map<String, String> map = this.getUnSortedFSIMap();
        List<Pair<String, String>> list = this.mapToList(map);
        list.sort(new PairComparator());
        return list;
    }

    public List<Pair<String, String>> getSortedIPTCList() {
        Map<String, String> map = this.getUnSortedIPTCMap();
        List<Pair<String, String>> list = this.mapToList(map);
        list.sort(new PairComparator());
        return list;
    }

    Map<String, String> getUnSortedIPTCMap() {
        return this.getUnSortedMapByPrefix("iptc.");
    }

    private Map<String, String> getUnSortedFSIMap() {
        return this.getUnSortedMapByPrefix("fsi.");
    }

    private Map<String, String> getUnSortedMapByPrefix(String string) {
        if (this.\u00d3\u00d30000 != null) {
            return this.filterCustomMetaDataByPrefix(string);
        }
        return null;
    }

    Map<Integer, Pair<String, String>> convertExifListToSortedMap(List<ExifTag> list, boolean bl, FSILogger fSILogger, String string) {
        TreeMap<Integer, Pair<String, String>> treeMap = new TreeMap<Integer, Pair<String, String>>();
        ExifParser exifParser = ExifParser.getInstance(fSILogger);
        List<Integer> list2 = exifParser.getTagSortMap();
        Collections.sort(list);
        int n = 1;
        boolean bl2 = false;
        for (Integer comparable : list2) {
            ExifTag exifTag = null;
            for (ExifTag exifTag2 : list) {
                if (comparable.intValue() != exifTag2.getTag()) continue;
                this.transferExif(treeMap, exifTag2, bl, n++);
                exifTag = exifTag2;
                bl2 = true;
                break;
            }
            if (!bl2 || exifTag == null) continue;
            list.remove(exifTag);
            bl2 = false;
        }
        for (ExifTag exifTag : list) {
            this.transferExif(treeMap, exifTag, bl, n++);
        }
        return treeMap;
    }

    private void transferExif(Map<Integer, Pair<String, String>> map, ExifTag exifTag, boolean bl, int n) {
        if (!bl) {
            map.put(n, new Pair<String, String>(exifTag.getShortDescription(), exifTag.getValueAsText()));
        } else {
            map.put(n, new Pair<String, String>(exifTag.getLongDescription(), exifTag.getValueAsText()));
        }
    }

    private List<Pair<String, String>> mapToList(Map<String, String> map) {
        ArrayList<Pair<String, String>> arrayList = new ArrayList<Pair<String, String>>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                arrayList.add(new Pair<String, String>(entry.getKey(), entry.getValue()));
            }
        }
        return arrayList;
    }

    private Map<String, String> filterCustomMetaDataByPrefix(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.\u00d3\u00d30000.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            hashMap.put(entry.getKey().substring(string.length()), entry.getValue());
        }
        return hashMap;
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MetaData unpack(byte[] byArray) {
        MetaData metaData;
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.nativeOrder());
        try {
            byte[] byArray2;
            int n;
            Object[] objectArray;
            int n2;
            int n3;
            Object object;
            byte by = byteArrayWalker.get();
            switch (by) {
                case 1: {
                    metaData = new FileMetaData();
                    break;
                }
                case 2: {
                    metaData = new DirectoryMetaData();
                    break;
                }
                case 3: {
                    metaData = new ImageMetaData();
                    break;
                }
                default: {
                    metaData = new MetaData();
                }
            }
            int n4 = byteArrayWalker.getInt();
            if (n4 > 0) {
                object = new byte[n4];
                byteArrayWalker.get((byte[])object);
                metaData.setAssetURLPath(new String((byte[])object, FileOperations.new));
            }
            metaData.setLastModified(byteArrayWalker.getLong());
            n4 = byteArrayWalker.getInt();
            if (n4 > 0) {
                object = new HashMap();
                for (n3 = 0; n3 < n4; ++n3) {
                    String string;
                    n2 = byteArrayWalker.getInt();
                    if (n2 > 0) {
                        byte[] byArray3 = new byte[n2];
                        byteArrayWalker.get(byArray3);
                        objectArray = new String(byArray3, FileOperations.new);
                    } else {
                        objectArray = null;
                    }
                    n = byteArrayWalker.getInt();
                    if (n > 0) {
                        byArray2 = new byte[n];
                        byteArrayWalker.get(byArray2);
                        string = new String(byArray2, FileOperations.new);
                    } else {
                        string = null;
                    }
                    object.put(objectArray, string);
                }
            }
            switch (by) {
                case 3: {
                    object = (ImageMetaData)metaData;
                    ((ImageMetaData)object).setContainterMinorVersion(byteArrayWalker.getShort());
                    ((ImageMetaData)object).setFormatVersion(byteArrayWalker.getShort());
                    ((ImageMetaData)object).setImportStatus(byteArrayWalker.get());
                    ((ImageMetaData)object).setWidth(byteArrayWalker.getInt());
                    ((ImageMetaData)object).setHeight(byteArrayWalker.getInt());
                    n4 = byteArrayWalker.getInt();
                    if (n4 > 0) {
                        Level[] levelArray = new Level[n4];
                        for (n2 = 0; n2 < n4; ++n2) {
                            objectArray = new Level(n2);
                            objectArray.Object = byteArrayWalker.getInt();
                            objectArray.\u00d200000 = byteArrayWalker.getInt();
                            objectArray.\u00d400000 = byteArrayWalker.getInt();
                            objectArray.o00000 = byteArrayWalker.getInt();
                            levelArray[n2] = objectArray;
                        }
                        ((ImageMetaData)object).setZoomLevels(levelArray);
                    }
                    ((ImageMetaData)object).setHasAlpha((n3 = (int)byteArrayWalker.get()) == 1);
                    n2 = byteArrayWalker.getInt();
                    ((ImageMetaData)object).setByteOrder(n2 == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                    ((ImageMetaData)object).setTileFormat(byteArrayWalker.get());
                    n4 = byteArrayWalker.getInt();
                    if (n4 > 0) {
                        objectArray = new ArrayList();
                        for (n = 0; n < n4; ++n) {
                            int n5 = byteArrayWalker.getInt();
                            if (n5 <= 0) continue;
                            byArray2 = new byte[n5];
                            byteArrayWalker.get(byArray2);
                            objectArray.add(byArray2);
                        }
                        ((ImageMetaData)object).setIPTCRaw((List<byte[]>)objectArray);
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setXMP((byte[])objectArray);
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setEXIF((byte[])objectArray);
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setSelections((byte[])objectArray);
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new String[n4];
                        for (n = 0; n < n4; ++n) {
                            int n6 = byteArrayWalker.getInt();
                            if (n6 <= 0) continue;
                            byArray2 = new byte[n6];
                            byteArrayWalker.get(byArray2);
                            objectArray[n] = new String(byArray2, FileOperations.new);
                        }
                        ((ImageMetaData)object).setAlphaNames((String[])objectArray);
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setAlphaTypes((byte[])objectArray);
                    }
                    ((ImageMetaData)object).setExtraAlphaCount(byteArrayWalker.getInt());
                    n4 = byteArrayWalker.getInt();
                    if (n4 > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setHistogram(Histogram.unserialize((byte[])objectArray));
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ICCProfileWrap iCCProfileWrap = new ICCProfileWrap((byte[])objectArray);
                        ((ImageMetaData)object).setICC(iCCProfileWrap);
                    }
                    ((ImageMetaData)object).setColorType(ColorType.values()[byteArrayWalker.getInt()]);
                    ((ImageMetaData)object).setImageReaderVersion(byteArrayWalker.getInt());
                    n4 = byteArrayWalker.getInt();
                    if (n4 > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setImportModuleName(new String((byte[])objectArray, FileOperations.new));
                    }
                    if ((n4 = byteArrayWalker.getInt()) > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setImportModuleVersion(new String((byte[])objectArray, FileOperations.new));
                    }
                    ((ImageMetaData)object).setImportTime(byteArrayWalker.getLong());
                    n4 = byteArrayWalker.getInt();
                    if (n4 > 0) {
                        objectArray = new byte[n4];
                        byteArrayWalker.get((byte[])objectArray);
                        ((ImageMetaData)object).setKeyHook((byte[])objectArray);
                    }
                    ((FileMetaData)object).setSourceFileSize(byteArrayWalker.getLong());
                    break;
                }
                case 1: {
                    ((FileMetaData)metaData).setSourceFileSize(byteArrayWalker.getLong());
                    break;
                }
                case 2: {
                    ((DirectoryMetaData)metaData).setFiles(byteArrayWalker.getInt());
                    ((DirectoryMetaData)metaData).setSubdirectories(byteArrayWalker.getInt());
                }
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            metaData = null;
        }
        return metaData;
    }

    @Override
    public CacheableData<MetaData> copy() {
        return new MetaData(this);
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.\u00d400000;
    }

    public int hashCode() {
        StringBuilder stringBuilder = this.\u00d8\u00d30000 != null ? new StringBuilder(this.\u00d8\u00d30000) : new StringBuilder("null");
        stringBuilder.append(this.\u00d4\u00d30000);
        if (this.\u00d3\u00d30000 != null) {
            for (Map.Entry entry : this.\u00d3\u00d30000.entrySet()) {
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append((String)entry.getValue());
            }
        }
        String string = stringBuilder.toString();
        return string.hashCode();
    }
}

