/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.framework.systeminformation;

import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.io.DirectOutputStream;
import com.neptunelabs.fsiserver.framework.systeminformation.B;
import com.neptunelabs.fsiserver.framework.systeminformation.OperatingPlatform;
import com.neptunelabs.fsiserver.framework.systeminformation.OperatingSystem;
import com.neptunelabs.fsiserver.framework.systeminformation.VMVendor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;

public final class SystemInformation
implements Serializable {
    private static final long serialVersionUID = -5755039192523708059L;
    private final Properties \u00d200000;
    private OperatingSystem \u00d300000 = OperatingSystem.OO0000;
    private OperatingPlatform o00000 = OperatingPlatform.void;

    public SystemInformation() {
        this.\u00d200000 = System.getProperties();
        String string = this.\u00d200000.getProperty("os.name");
        String string2 = this.\u00d200000.getProperty("os.version");
        if (string.equals("AIX")) {
            this.\u00d300000 = OperatingSystem.\u00d4o0000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("Digital Unix")) {
            this.\u00d300000 = OperatingSystem.new;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("FreeBSD")) {
            this.\u00d300000 = OperatingSystem.\u00d5O0000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("HP UX")) {
            this.\u00d300000 = OperatingSystem.\u00d300000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("Irix")) {
            this.\u00d300000 = OperatingSystem.\u00d500000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("Linux")) {
            this.\u00d300000 = OperatingSystem.\u00d4O0000;
            this.o00000 = OperatingPlatform.\u00f600000;
        } else if (string.equals("Mac OS")) {
            this.\u00d300000 = OperatingSystem.oo0000;
            this.o00000 = OperatingPlatform.\u00d500000;
        } else if (string.equals("Mac OS X")) {
            this.\u00d300000 = OperatingSystem.forsuper;
            this.o00000 = OperatingPlatform.\u00f400000;
        } else if (string.equals("MPE/iX")) {
            this.\u00d300000 = OperatingSystem.\u00f800000;
            this.o00000 = OperatingPlatform.o00000;
        } else if (string.equals("Netware 4.11")) {
            this.\u00d300000 = OperatingSystem.\u00d5o0000;
            this.o00000 = OperatingPlatform.Object;
        } else if (string.equals("OS/2")) {
            this.\u00d300000 = OperatingSystem.\u00d3o0000;
            this.o00000 = OperatingPlatform.\u00d200000;
        } else if (string.equals("Solaris")) {
            this.\u00d300000 = OperatingSystem.\u00f5O0000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("SunOS")) {
            this.\u00d300000 = OperatingSystem.\u00d3O0000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("OpenVMS")) {
            this.\u00d300000 = OperatingSystem.Oo0000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.equals("OSF1")) {
            this.\u00d300000 = OperatingSystem.\u00f500000;
            this.o00000 = OperatingPlatform.\u00f500000;
        } else if (string.toLowerCase().indexOf("win") >= 0) {
            if (string2.equals("5.0")) {
                this.\u00d300000 = OperatingSystem.\u00d8o0000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("5.1")) {
                this.\u00d300000 = OperatingSystem.\u00f5o0000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("5.2")) {
                this.\u00d300000 = string.contains("XP") ? OperatingSystem.\u00f5o0000 : OperatingSystem.nullsuper;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("6.0")) {
                this.\u00d300000 = string.contains("Vista") ? OperatingSystem.if : OperatingSystem.\u00f8O0000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("6.1")) {
                this.\u00d300000 = string.contains("7") ? OperatingSystem.\u00f4O0000 : OperatingSystem.\u00f8O0000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("6.2")) {
                this.\u00d300000 = string.contains("8") ? OperatingSystem.thissuper : OperatingSystem.\u00d800000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("6.3")) {
                this.\u00d300000 = string.contains("8") ? OperatingSystem.thissuper : OperatingSystem.\u00d800000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string2.equals("10.0")) {
                this.\u00d300000 = OperatingSystem.\u00f400000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string.equals("Windows 95")) {
                this.\u00d300000 = OperatingSystem.o00000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string.equals("Windows 98")) {
                this.\u00d300000 = OperatingSystem.\u00f4o0000;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string.equals("Windows NT")) {
                this.\u00d300000 = OperatingSystem.while;
                this.o00000 = OperatingPlatform.\u00d600000;
            } else if (string.equals("Windows CE")) {
                this.\u00d300000 = OperatingSystem.\u00d400000;
                this.o00000 = OperatingPlatform.\u00d600000;
            }
        } else if (string.equals("OS/390")) {
            this.\u00d300000 = OperatingSystem.\u00d8O0000;
            this.o00000 = OperatingPlatform.\u00f500000;
        }
    }

    public final Properties getProperties() {
        return this.\u00d200000;
    }

    private String getOSInformation() {
        return this.\u00d200000.getProperty("os.name") + " " + this.\u00d200000.getProperty("os.version");
    }

    public final String getJVMInformation() {
        return this.\u00d200000.getProperty("java.vm.vendor") + " " + this.\u00d200000.getProperty("java.vm.name") + " " + this.\u00d200000.getProperty("java.vm.version");
    }

    public final int getProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public String getJVMVersionDetailed() {
        return (String)this.\u00d200000.get("java.version");
    }

    public String getFileEncoding() {
        return this.\u00d200000.getProperty("file.encoding");
    }

    public String getJNUEncoding() {
        String string = this.\u00d200000.getProperty("sun.jnu.encoding");
        return string != null ? string : "";
    }

    public String getJVMVersionDetailedWithArch() {
        String string = this.getJVMVersionDetailed();
        string = this.is64() ? string + " 64 Bit" : string + " 32 Bit";
        return string;
    }

    public float getJVMVersion() {
        Float f = Float.valueOf(0.0f);
        try {
            f = Float.valueOf((String)this.\u00d200000.get("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f.floatValue();
    }

    public OperatingSystem getOperatingSystem() {
        return this.\u00d300000;
    }

    public String getOperationSystemString() {
        return this.\u00d200000.getProperty("os.name");
    }

    public OperatingPlatform getOperatingPlatform() {
        return this.o00000;
    }

    public boolean is64() {
        boolean bl = false;
        int n = Integer.valueOf((String)this.\u00d200000.get("sun.arch.data.model"));
        if (n == 64) {
            bl = true;
        }
        return bl;
    }

    public VMVendor getVMVendor() {
        VMVendor vMVendor = VMVendor.void;
        String string = (String)this.\u00d200000.get("java.vm.vendor");
        if (string.contains("OpenJDK")) {
            vMVendor = VMVendor.o00000;
        } else if (string.contains("Sun Microsystems")) {
            vMVendor = VMVendor.\u00d200000;
        } else if (string.contains("Oracle")) {
            vMVendor = VMVendor.Object;
        } else if (string.contains("IBM")) {
            vMVendor = VMVendor.\u00d500000;
        } else if (string.contains("Apple")) {
            vMVendor = VMVendor.\u00d600000;
        }
        return vMVendor;
    }

    public File getCurrentVolume() {
        File file;
        File file2 = file = this.getCurrentDirectory();
        while ((file = file.getParentFile()) != null) {
            file2 = file;
        }
        return file2;
    }

    private File getCurrentDirectory() {
        File file;
        File file2 = null;
        String string = (String)this.\u00d200000.get("user.dir");
        if (string != null && (file = new File(string)).exists()) {
            file2 = file;
        }
        return file2;
    }

    public Path getTempDirectory() {
        Path path;
        Path path2 = null;
        String string = (String)this.\u00d200000.get("java.specification.version");
        if (string != null && Files.isWritable(path = Paths.get(string, new String[0]))) {
            path2 = path;
        }
        return path2;
    }

    private String getHostname() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private byte[][] getHostAddresses() {
        Object object = null;
        try {
            InetAddress[] inetAddressArray = InetAddress.getAllByName(this.getHostname());
            int n = 0;
            for (InetAddress inetAddress : inetAddressArray) {
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isAnyLocalAddress() || inetAddress.isMulticastAddress()) continue;
                ++n;
            }
            object = new byte[n][];
            int n2 = 0;
            for (int i = 0; i < inetAddressArray.length; ++i) {
                if (inetAddressArray[i].isLoopbackAddress() || inetAddressArray[i].isLinkLocalAddress() || inetAddressArray[i].isAnyLocalAddress() || inetAddressArray[i].isMulticastAddress()) continue;
                object[n2++] = inetAddressArray[i].getAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return object;
    }

    public ByteOrder getPreferedByteOrder() {
        return ByteOrder.nativeOrder();
    }

    public UUID getSystemUUID() {
        UUID uUID = null;
        uUID = B.\u00d200000(this.o00000);
        return uUID;
    }

    public byte[][] getMacs() {
        Object object = null;
        try {
            Object object2;
            int n = 0;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (((NetworkInterface)object2).isLoopback() || ((NetworkInterface)object2).getHardwareAddress() == null) continue;
                ++n;
            }
            if (n > 0) {
                object = new byte[n][];
                object2 = NetworkInterface.getNetworkInterfaces();
                int n2 = 0;
                while (object2.hasMoreElements()) {
                    NetworkInterface networkInterface = (NetworkInterface)object2.nextElement();
                    if (networkInterface.isLoopback() || networkInterface.getHardwareAddress() == null) continue;
                    object[n2++] = networkInterface.getHardwareAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return object;
    }

    public String getLMR() {
        String string = null;
        try (ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast(128);
             DirectOutputStream directOutputStream = new DirectOutputStream(byteArrayOutputStreamFast);){
            UUID uUID;
            String string2;
            String string3;
            byte[][] byArray;
            Object object;
            directOutputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[][] byArray2 = this.getMacs();
            if (byArray2 != null) {
                directOutputStream.writeInt(1);
                directOutputStream.writeInt(byArray2.length);
                object = byArray2;
                int n = ((Object)object).length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = object[i];
                    directOutputStream.writeInt(((Object)object2).length);
                    directOutputStream.write((byte[])object2);
                }
            }
            if ((object = this.getHostname()) != null) {
                directOutputStream.writeInt(2);
                byte[] byArray3 = ((String)object).getBytes(this.getFileEncoding());
                directOutputStream.writeInt(byArray3.length);
                directOutputStream.write(byArray3);
            }
            if ((byArray = this.getHostAddresses()) != null) {
                directOutputStream.writeInt(3);
                directOutputStream.writeInt(byArray.length);
                for (byte[] byArray4 : byArray) {
                    directOutputStream.writeInt(byArray4.length);
                    directOutputStream.write(byArray4);
                }
            }
            if ((string3 = this.getOSInformation()) != null) {
                directOutputStream.writeInt(4);
                byte[] byArray5 = string3.getBytes(this.getFileEncoding());
                directOutputStream.writeInt(byArray5.length);
                directOutputStream.write(byArray5);
            }
            if ((string2 = SoftwareVersion.getVersion(true, true, true)) != null) {
                directOutputStream.writeInt(5);
                byte[] byArray6 = string2.getBytes(StandardCharsets.US_ASCII);
                directOutputStream.writeInt(byArray6.length);
                directOutputStream.write(byArray6);
            }
            if ((uUID = this.getSystemUUID()) != null) {
                directOutputStream.writeInt(6);
                long l = uUID.getMostSignificantBits();
                long l2 = uUID.getLeastSignificantBits();
                byte[] byArray7 = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putLong(l).putLong(l2).array();
                directOutputStream.writeInt(byArray7.length);
                directOutputStream.write(byArray7);
            }
            directOutputStream.close();
            byte[] byArray8 = byteArrayOutputStreamFast.toByteArray();
            string = SystemInformation.xWrite(byArray8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private static String xWrite(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = new int[2];
        int n = 170;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = (n ^ i * 146) & 0xFF;
            n = n2 ^= n3;
            nArray[0] = n2 & 0xF;
            nArray[1] = n2 >> 4 & 0xF;
            for (int j = 0; j < 2; ++j) {
                int n4 = (1 ^ nArray[j] & 3 ^ nArray[j] >> 2 & 3) << 4;
                int n5 = j;
                nArray[n5] = nArray[n5] | n4 & 0x30;
                int n6 = nArray[j] < 2 ? 45 : (nArray[j] < 12 ? 46 : (nArray[j] < 38 ? 53 : 59));
                stringBuilder.append((char)(nArray[j] + n6));
            }
        }
        return stringBuilder.toString();
    }

    public String dumpSystemInformation() {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<Object> enumeration = this.\u00d200000.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuilder.append(string);
            stringBuilder.append(':');
            stringBuilder.append(this.\u00d200000.getProperty(string));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

