/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.area;

import com.neptunelabs.fsiserver.imagemanipulator.area.PaddingPositions;
import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import java.nio.BufferOverflowException;
import java.nio.IntBuffer;

public final class Padding {
    private Padding() {
    }

    public static FSIImage transform(FSIImage fSIImage, int n, int n2, PaddingPositions paddingPositions, boolean bl) throws ImageManipulatorException {
        if (fSIImage == null) {
            throw new ImageManipulatorException("Padding Input Image is null");
        }
        if (n <= 0 || n2 <= 0) {
            throw new ImageManipulatorException("New image size invalid: " + n + "x" + n2);
        }
        if (fSIImage instanceof FSIImageLimited) {
            return Padding.transformLimited((FSIImageLimited)fSIImage, n, n2, paddingPositions, bl);
        }
        throw new IllegalArgumentException("Padding is currently only implemented for FSIImageLimited");
    }

    private static FSIImage transformLimited(FSIImageLimited fSIImageLimited, int n, int n2, PaddingPositions paddingPositions, boolean bl) throws ImageManipulatorException {
        FSIImageLimited fSIImageLimited2;
        int n3 = fSIImageLimited.getWidth();
        int n4 = fSIImageLimited.getHeight();
        if (n != n3 || n2 != n4) {
            fSIImageLimited2 = fSIImageLimited.createCompatibleImage(n, n2);
            IntBuffer intBuffer = fSIImageLimited.getSamplesBuffer();
            IntBuffer intBuffer2 = fSIImageLimited2.getSamplesBuffer();
            int n5 = paddingPositions.\u00d400000;
            int n6 = paddingPositions.\u00d300000;
            int n7 = 0;
            int n8 = 0;
            int n9 = n3 > n ? n + n7 : n3;
            int n10 = n4 > n2 ? n2 + n8 : n4;
            int n11 = 0;
            int n12 = 0;
            try {
                n12 = n8;
                int n13 = n6;
                while (n12 < n10) {
                    n11 = n7;
                    int n14 = n5;
                    while (n11 < n9) {
                        int n15 = intBuffer.get(n12 * n3 + n11);
                        if (n14 >= 0 && n14 < n && n13 >= 0 && n13 < n2) {
                            fSIImageLimited2.setSample(n14, n13, n15);
                        }
                        ++n11;
                        ++n14;
                    }
                    ++n12;
                    ++n13;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new ImageManipulatorException("Crop out of bounds (BO): " + n7 + "x" + n8 + ":" + n + "x" + n2 + " of " + n3 + "x" + n4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ImageManipulatorException("Crop out of bounds (IO): " + n7 + "x" + n8 + ":" + n + "x" + n2 + " of " + n3 + "x" + n4 + " on position " + n11 + "x" + n12 + " " + n9 + ":" + n10);
            }
        } else {
            fSIImageLimited2 = fSIImageLimited.createCopy();
        }
        if (!bl) {
            fSIImageLimited.dispose();
        }
        return fSIImageLimited2;
    }
}

