/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagemanipulator.combine;

import com.neptunelabs.fsiserver.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import java.nio.BufferUnderflowException;

public final class Join {
    private Join() {
    }

    public static FSIImage transform(FSIImage fSIImage, FSIImage fSIImage2, JoinPosition joinPosition) throws ImageManipulatorException {
        return Join.transform(fSIImage, fSIImage2, joinPosition, false);
    }

    public static FSIImage transform(FSIImage fSIImage, FSIImage fSIImage2, JoinPosition joinPosition, boolean bl) throws ImageManipulatorException {
        int n;
        int n2;
        if (fSIImage == null || fSIImage2 == null) {
            throw new ImageManipulatorException("Join Image parameter is null");
        }
        if (!fSIImage.isImageCompatible(fSIImage2)) {
            throw new ImageManipulatorException("Cannot Join incompatible images.");
        }
        if (joinPosition == JoinPosition.\u00d200000 && fSIImage.getHeight() != fSIImage2.getHeight()) {
            throw new ImageManipulatorException("Cannot Right Join images with different height.");
        }
        if (joinPosition == JoinPosition.\u00d300000 && fSIImage.getWidth() != fSIImage2.getWidth()) {
            throw new ImageManipulatorException("Cannot Bottom Join images with different width.");
        }
        if (joinPosition == JoinPosition.\u00d200000) {
            n2 = fSIImage.getHeight();
            n = fSIImage.getWidth() + fSIImage2.getWidth();
        } else {
            n2 = fSIImage.getHeight() + fSIImage2.getHeight();
            n = fSIImage.getWidth();
        }
        FSIImage fSIImage3 = fSIImage.createCompatibleImage(n, n2);
        if (joinPosition == JoinPosition.\u00d200000) {
            fSIImage.setPosition(0L);
            fSIImage2.setPosition(0L);
            fSIImage3.setPosition(0L);
            int n3 = 0;
            try {
                for (int i = 0; i < fSIImage.getHeight(); ++i) {
                    int n4;
                    for (n4 = 0; n4 < fSIImage.getWidth(); ++n4) {
                        n3 = (int)fSIImage.getPosition();
                        fSIImage3.setSample(fSIImage.getSample());
                    }
                    for (n4 = 0; n4 < fSIImage2.getWidth(); ++n4) {
                        fSIImage3.setSample(fSIImage2.getSample());
                    }
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                ImageManipulatorException imageManipulatorException = new ImageManipulatorException("BufferUnderflow at " + n3);
                imageManipulatorException.initCause(bufferUnderflowException);
                throw imageManipulatorException;
            }
        } else {
            int n5;
            fSIImage.setPosition(0L);
            fSIImage2.setPosition(0L);
            fSIImage3.setPosition(0L);
            for (n5 = 0; n5 < fSIImage.getWidth() * fSIImage.getHeight(); ++n5) {
                fSIImage3.setSample(fSIImage.getSample());
            }
            for (n5 = 0; n5 < fSIImage2.getWidth() * fSIImage2.getHeight(); ++n5) {
                fSIImage3.setSample(fSIImage2.getSample());
            }
        }
        if (!bl) {
            fSIImage.dispose();
            fSIImage2.dispose();
        }
        return fSIImage3;
    }

    public static enum JoinPosition {
        \u00d200000,
        \u00d300000;

    }
}

