/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader;

import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class MagicFormatScanner {
    private static final byte[] \u00d200000 = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] o00000 = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};

    protected MagicFormatScanner() {
    }

    public static ImageFormat.Type evaluate(Path path) throws IOException {
        ImageFormat.Type type = ImageFormat.Type.\u00d200000;
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, StandardOpenOption.READ);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            seekableByteChannel.read(byteBuffer);
            byteBuffer.flip();
            if (type == ImageFormat.Type.\u00d200000 && MagicFormatScanner.checkJPG(byteBuffer)) {
                type = ImageFormat.Type.\u00d400000;
            }
            if (type == ImageFormat.Type.\u00d200000 && MagicFormatScanner.checkTIF(byteBuffer)) {
                type = ImageFormat.Type.\u00d800000;
            }
            if (type == ImageFormat.Type.\u00d200000 && MagicFormatScanner.checkBMP(byteBuffer)) {
                type = ImageFormat.Type.super;
            }
            if (type == ImageFormat.Type.\u00d200000 && MagicFormatScanner.checkPNG(byteBuffer)) {
                type = ImageFormat.Type.\u00d300000;
            }
            if (type == ImageFormat.Type.\u00d200000 && MagicFormatScanner.checkGIF(byteBuffer)) {
                type = ImageFormat.Type.int;
            }
            if (type == ImageFormat.Type.\u00d200000 && MagicFormatScanner.checkFPX(byteBuffer)) {
                type = ImageFormat.Type.\u00d600000;
            }
        }
        return type;
    }

    private static boolean checkBMP(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.position(0);
        if (byteBuffer.get() == 66 && byteBuffer.get() == 77) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkPNG(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.position(0);
        byte[] byArray = new byte[8];
        byteBuffer.get(byArray);
        if (Arrays.equals(byArray, \u00d200000)) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkGIF(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.position(0);
        if (byteBuffer.get() == 71 && byteBuffer.get() == 73 && byteBuffer.get() == 70) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkJPG(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.position(0);
        if (byteBuffer.get() == -1 && byteBuffer.get() == -40) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkFPX(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.position(0);
        byte[] byArray = new byte[8];
        byteBuffer.get(byArray);
        if (Arrays.equals(byArray, o00000)) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkTIF(ByteBuffer byteBuffer) {
        boolean bl = false;
        byteBuffer.position(0);
        if (byteBuffer.get() == 73 && byteBuffer.get() == 73 && byteBuffer.get() == 42 && byteBuffer.get() == 0) {
            bl = true;
        } else {
            byteBuffer.position(0);
            if (byteBuffer.get() == 77 && byteBuffer.get() == 77 && byteBuffer.get() == 0 && byteBuffer.get() == 42) {
                bl = true;
            }
        }
        return bl;
    }
}

