/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.helper;

import com.neptunelabs.fsiserver.imagereader.helper.RangePixel;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Selection {
    private byte[] super;

    public Selection() {
        this.super = null;
    }

    public Selection(FSIImage fSIImage) {
        FSIImage fSIImage2 = fSIImage.createSlice();
        int n = (int)fSIImage2.getIntSize();
        this.super = new byte[n];
        fSIImage2.setPosition(0L);
        for (int i = 0; i < n; ++i) {
            this.super[i] = (byte)(fSIImage2.getSample() >> 24 & 0xFF);
        }
    }

    public Selection(RangePixel rangePixel) {
        this.super = new byte[rangePixel.\u00d200000 * rangePixel.String];
        int n = rangePixel.\u00d600000 + rangePixel.\u00d300000;
        int n2 = rangePixel.\u00d500000 + rangePixel.o00000;
        for (int i = rangePixel.\u00d500000; i < n2; ++i) {
            for (int j = rangePixel.\u00d600000; j < n; ++j) {
                int n3 = i * rangePixel.\u00d200000 + j;
                this.super[n3] = -1;
            }
        }
    }

    public Selection(byte[] byArray) {
        this.super = byArray;
    }

    public byte[] getAlphaSelection() {
        return this.super;
    }

    public void invert() {
        if (this.super != null) {
            for (int i = 0; i < this.super.length; ++i) {
                this.super[i] = (byte)(255 - this.super[i]);
            }
        }
    }

    public void addSelection(Selection selection) {
        byte[] byArray = selection.getAlphaSelection();
        if (this.super != null) {
            for (int i = 0; i < byArray.length; ++i) {
                int n = (this.super[i] & 0xFF) + (byArray[i] & 0xFF);
                if (n > 255) {
                    n = 255;
                }
                this.super[i] = (byte)(n & 0xFF);
            }
        } else {
            this.super = byArray;
        }
    }

    public void subtractSelection(Selection selection) {
        if (this.super != null) {
            byte[] byArray = selection.getAlphaSelection();
            for (int i = 0; i < byArray.length; ++i) {
                int n = (this.super[i] & 0xFF) - (byArray[i] & 0xFF);
                if (n < 0) {
                    n = 0;
                }
                this.super[i] = (byte)(n & 0xFF);
            }
        }
    }
}

