/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.image;

import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.framework.cache.CacheableData;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.converter.FSIImageConverter;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageUnlimited;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public abstract class FSIImage
implements CacheableData<FSIImage> {
    final FSILogger privateclass;
    final SwapPool \u00f4\u00d80000;
    final String Stringclass;
    final int \u00f8\u00d60000;
    final int \u00f8\u00d80000;
    final long \u00f5\u00d80000;
    final long o\u00d80000;
    final ByteOrder \u00d8\u00d80000;
    boolean forclass = false;
    boolean \u00d5\u00d80000 = false;
    FSIImageMode \u00d3\u00d80000;
    volatile boolean O\u00d80000 = false;
    private byte[] \u00d4\u00d80000 = null;
    private byte[] nullclass = null;

    FSIImage(FSILogger fSILogger, SwapPool swapPool, int n, int n2, String string, FSIImageMode fSIImageMode, ByteOrder byteOrder) {
        this.privateclass = fSILogger;
        this.\u00f4\u00d80000 = swapPool;
        this.\u00f8\u00d60000 = n;
        this.\u00f8\u00d80000 = n2;
        this.Stringclass = string;
        this.\u00d3\u00d80000 = fSIImageMode;
        this.\u00d8\u00d80000 = byteOrder;
        this.\u00f5\u00d80000 = (long)n * (long)n2;
        this.o\u00d80000 = this.\u00f5\u00d80000 * 4L;
    }

    public abstract FSIImage createSlice() throws FSIImageException;

    public abstract FSIImage createCompatibleImage(int var1, int var2) throws FSIImageException;

    public abstract FSIImage createCompatibleImage() throws FSIImageException;

    public abstract FSIImage createCopy() throws FSIImageException;

    public abstract boolean createExtraAlpha(int var1);

    public abstract int getExtraAlphaCount();

    public abstract void copyInPlace(FSIImage var1, int var2, int var3) throws FSIImageException;

    public abstract void setSample(int var1) throws FSIImageException;

    public abstract void setSample(long var1, int var3) throws FSIImageException;

    public abstract void setSample(int var1, int var2, int var3) throws FSIImageException;

    public abstract void setSampleExtraAlpha(int var1, byte var2) throws FSIImageException;

    public abstract void setSampleExtraAlpha(int var1, long var2, byte var4) throws FSIImageException;

    public abstract void setSampleExtraAlpha(int var1, int var2, int var3, byte var4) throws FSIImageException;

    public abstract void setSampleSafe(int var1, int var2, int var3);

    public abstract void setSamples(long var1, int[] var3) throws FSIImageException;

    public abstract void setSamplesExtraAlpha(int var1, long var2, byte[] var4) throws FSIImageException;

    public abstract void setSamples(long var1, IntBuffer var3) throws FSIImageException;

    public abstract void setSamples(int var1, int var2, int var3, int var4, int[] var5) throws FSIImageException;

    public abstract int getSample() throws FSIImageException;

    public abstract int getSample(long var1) throws FSIImageException;

    public abstract int getSample(int var1, int var2) throws FSIImageException;

    public abstract byte getSampleExtraAlpha(int var1) throws FSIImageException;

    public abstract byte getSampleExtraAlpha(int var1, long var2) throws FSIImageException;

    public abstract byte getSampleExtraAlpha(int var1, int var2, int var3) throws FSIImageException;

    public abstract void getSampleFloat(int var1, int var2, float[] var3) throws FSIImageException;

    public abstract void getSampleFloat(int var1, int var2, float[] var3, int var4) throws FSIImageException;

    public abstract void getSampleRangeBytes(int var1, int var2, int var3, int var4, byte[] var5) throws FSIImageException;

    public abstract void getSampleRange(int var1, int var2, int var3, int var4, int[] var5) throws FSIImageException;

    public abstract void getSampleExtraAlphaRange(int var1, int var2, int var3, int var4, int var5, byte[] var6) throws FSIImageException;

    public abstract void getSamples(int[] var1, int var2, int var3) throws FSIImageException;

    public abstract void getSamplesExtraAlpha(int var1, byte[] var2, int var3, int var4) throws FSIImageException;

    public abstract boolean isMapped();

    public abstract void clear();

    public abstract long getPosition();

    public abstract void setPosition(long var1);

    public abstract void setPositionExtraAlpha(int var1, long var2);

    public abstract void setPosition(int var1, int var2);

    public abstract void setPositionExtraAlpha(int var1, int var2, int var3);

    public abstract void dispose() throws FSIImageException;

    public boolean hasError() {
        return this.\u00d5\u00d80000;
    }

    public String getSource() {
        return this.Stringclass;
    }

    public void setCustomData(byte[] byArray, byte[] byArray2) {
        this.\u00d4\u00d80000 = byArray;
        this.nullclass = byArray2;
    }

    public Pair<byte[], byte[]> getCustomData() {
        if (this.\u00d4\u00d80000 != null && this.nullclass != null) {
            return new Pair<byte[], byte[]>(this.\u00d4\u00d80000, this.nullclass);
        }
        return null;
    }

    public abstract String toString();

    public abstract boolean addAlpha();

    public void forceAlpha(boolean bl) {
        this.forclass = bl;
    }

    public int getWidth() {
        return this.\u00f8\u00d60000;
    }

    public int getHeight() {
        return this.\u00f8\u00d80000;
    }

    public long getIntSize() {
        return this.\u00f5\u00d80000;
    }

    public long getByteSize() {
        return this.o\u00d80000;
    }

    public ByteOrder getByteOrder() {
        return this.\u00d8\u00d80000;
    }

    public FSIImageMode getMode() {
        return this.\u00d3\u00d80000;
    }

    public void setMode(FSIImageMode fSIImageMode) {
        this.\u00d3\u00d80000 = fSIImageMode;
        this.forclass = fSIImageMode == FSIImageMode.\u00d200000 || fSIImageMode == FSIImageMode.\u00d500000;
    }

    public boolean hasAlpha() {
        return this.forclass;
    }

    public abstract boolean hasExtraAlpha();

    public boolean isImageCompatible(FSIImage fSIImage) {
        return this.\u00d3\u00d80000 == fSIImage.getMode();
    }

    public void removeAlpha() {
        if (this.forclass) {
            if (this.\u00d3\u00d80000 == FSIImageMode.\u00d200000) {
                this.\u00d3\u00d80000 = FSIImageMode.o00000;
            } else if (this.\u00d3\u00d80000 == FSIImageMode.\u00d500000) {
                this.\u00d3\u00d80000 = FSIImageMode.\u00d400000;
            }
            this.forclass = false;
        }
        for (int i = 0; i < this.\u00f8\u00d60000; ++i) {
            for (int j = 0; j < this.\u00f8\u00d80000; ++j) {
                this.setSample(i, j, 0xFF000000 | this.getSample(i, j));
            }
        }
    }

    public boolean isDisposed() {
        return this.O\u00d80000;
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.\u00d800000;
    }

    public static FSIImage unpack(FSILogger fSILogger, SwapPool swapPool, byte[] byArray) {
        ByteArrayWalker byteArrayWalker = ByteArrayWalker.wrap(byArray, ByteOrder.nativeOrder());
        try {
            byte by = byteArrayWalker.get();
            boolean bl = byteArrayWalker.get() == 1;
            String string = null;
            int n = byteArrayWalker.getInt();
            if (n > 0) {
                byte[] byArray2 = new byte[n];
                byteArrayWalker.get(byArray2);
                string = new String(byArray2);
            }
            int n2 = byteArrayWalker.getInt();
            int n3 = byteArrayWalker.getInt();
            byte by2 = byteArrayWalker.get();
            ByteOrder byteOrder = by2 == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            byte by3 = byteArrayWalker.get();
            FSIImageMode fSIImageMode = FSIImageMode.values()[by3];
            FSIImage fSIImage = by == 0 ? new FSIImageLimited(fSILogger, swapPool, byteOrder, n2, n3, string, fSIImageMode) : new FSIImageUnlimited(fSILogger, swapPool, byteOrder, n2, n3, string, fSIImageMode, null, false);
            fSIImage.\u00d5\u00d80000 = bl;
            byteArrayWalker.getLong();
            byteArrayWalker.getLong();
            boolean bl2 = byteArrayWalker.get() == 1;
            boolean bl3 = byteArrayWalker.get() == 1;
            fSIImage.forclass = bl2;
            fSIImage.O\u00d80000 = bl3;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            int n4 = byteArrayWalker.getInt();
            if (n4 > 0) {
                byArray3 = new byte[n4];
                byteArrayWalker.get(byArray3);
            }
            if ((n4 = byteArrayWalker.getInt()) > 0) {
                byArray4 = new byte[n4];
                byteArrayWalker.get(byArray4);
            }
            fSIImage.setCustomData(byArray3, byArray4);
            long l = byteArrayWalker.getInt();
            int n5 = 0;
            while ((long)n5 < l) {
                fSIImage.setSample(byteArrayWalker.getInt());
                ++n5;
            }
            return fSIImage;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return null;
        }
    }

    static int getPos(int n, int n2, int n3) {
        return n2 * n3 + n;
    }

    public static void writePNG(FSIImage fSIImage, Path path) {
        BufferedImage bufferedImage = FSIImageConverter.convertToBufferedImage(fSIImage);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", path.toFile());
            System.err.println("Write File: " + path + " Size:" + Files.size(path));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

