/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.metareader;

import com.neptunelabs.fsiserver.framework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.ReaderAbstract;
import com.neptunelabs.fsiserver.framework.io.ReaderChannel;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.converter.ColorType;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.FSISubImageMetaData;
import com.neptunelabs.fsiserver.imagereader.metareader.MetaReaderAbstract;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.zip.InflaterOutputStream;

public final class MetaReaderPNG
extends MetaReaderAbstract {
    public static final int \u00f6o0000 = 256;
    private ReaderAbstract \u00f5o0000 = null;
    private static final byte[] \u00f4o0000 = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] \u00d5o0000 = new byte[]{73, 72, 68, 82};
    private static final byte[] \u00d6o0000 = new byte[]{105, 67, 67, 80};
    private static final byte[] dosuper = new byte[]{73, 69, 78, 68};

    public MetaReaderPNG(FSILogger fSILogger, ImageFormat imageFormat) {
        super(fSILogger, imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanImage(PathCached pathCached, boolean bl) {
        block63: {
            this.Object = new FSIMetaData(pathCached);
            try {
                this.\u00f5o0000 = new ReaderChannel(pathCached.getPath(), StandardOpenOption.READ);
                this.\u00f5o0000.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            catch (NoSuchFileException noSuchFileException) {
                this.\u00d2O0000.logException(noSuchFileException, 3801, pathCached);
                this.float |= 1;
            }
            catch (IOException iOException) {
                this.\u00d2O0000.logException(iOException, 3802, pathCached);
                this.float |= 2;
            }
            finally {
                if (this.float != 0) {
                    this.close();
                }
            }
            if (this.float == 0 && this.\u00f5o0000 != null) {
                try {
                    byte[] byArray = new byte[8];
                    this.\u00f5o0000.read(byArray);
                    if (Arrays.equals(byArray, \u00f4o0000)) {
                        boolean bl2 = false;
                        byte[] byArray2 = new byte[4];
                        int n = 20;
                        FSISubImageMetaData fSISubImageMetaData = this.Object.createImage(0);
                        this.Object.OO0000 = ByteOrder.BIG_ENDIAN;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        while (!bl2 && n-- > 0) {
                            int n2;
                            int n3 = this.\u00f5o0000.readInt();
                            this.\u00f5o0000.read(byArray2);
                            if (Arrays.equals(byArray2, \u00d5o0000)) {
                                fSISubImageMetaData.interface = this.\u00f5o0000.readInt();
                                fSISubImageMetaData.\u00d4O0000 = this.\u00f5o0000.readInt();
                                fSISubImageMetaData.\u00f800000 = this.\u00f5o0000.read();
                                n2 = this.\u00f5o0000.read();
                                this.Object.if = this.getColorType(n2);
                                this.Object.\u00f500000 = this.hasAlpha(n2);
                                if (this.Object.\u00f500000 && this.Object.if != ColorType.\u00f800000) {
                                    if (this.Object.if == ColorType.\u00d200000) {
                                        this.Object.\u00d3O0000 = 3;
                                    } else if (this.Object.if == ColorType.\u00f600000) {
                                        this.Object.\u00d3O0000 = 1;
                                    }
                                    this.Object.\u00d800000 = false;
                                }
                                fSISubImageMetaData.OO0000 = this.getSamplesPerPixel(fSISubImageMetaData.\u00f800000);
                                this.\u00f5o0000.skip(3L);
                                bl3 = true;
                            } else if (bl && Arrays.equals(byArray2, \u00d6o0000)) {
                                block62: {
                                    n2 = 0;
                                    while (this.\u00f5o0000.read() != 0) {
                                        ++n2;
                                    }
                                    int n4 = this.\u00f5o0000.read();
                                    int n5 = n3 - n2 - 2;
                                    if (n4 == 0) {
                                        byte[] byArray3 = new byte[n5];
                                        this.\u00f5o0000.read(byArray3);
                                        try (ByteArrayOutputStreamFast byteArrayOutputStreamFast = new ByteArrayOutputStreamFast(byArray3.length);
                                             InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(byteArrayOutputStreamFast);){
                                            inflaterOutputStream.write(byArray3);
                                            inflaterOutputStream.close();
                                            byte[] byArray4 = byteArrayOutputStreamFast.toByteArray();
                                            fSISubImageMetaData.\u00d6O0000 = new ICCProfileWrap(byArray4);
                                            break block62;
                                        }
                                    }
                                    this.\u00f5o0000.skip(n5);
                                }
                                bl4 = true;
                            } else if (Arrays.equals(byArray2, dosuper)) {
                                bl2 = true;
                            } else if (n3 > 0) {
                                this.\u00f5o0000.skip(n3);
                            }
                            if (bl && bl4 && bl3 || !bl && bl3) break;
                            this.\u00f5o0000.skip(4L);
                        }
                        this.float |= this.validateMetaData(fSISubImageMetaData);
                        if (this.float == 0) {
                            this.Object.addImage(fSISubImageMetaData);
                        }
                        break block63;
                    }
                    if (this.\u00d2O0000 != null) {
                        this.\u00d2O0000.log(3850, this.Object.o00000);
                    }
                    this.float |= 4;
                }
                catch (Error error) {
                    this.\u00d2O0000.logError(error, 3850, this.Object.o00000);
                    this.float |= 4;
                }
                catch (NoSuchFileException noSuchFileException) {
                    this.\u00d2O0000.logException(noSuchFileException, 3801, this.Object.o00000);
                    this.float |= 1;
                }
                catch (IOException iOException) {
                    this.\u00d2O0000.logException(iOException, 3850, this.Object.o00000);
                    this.float |= 2;
                }
                catch (Exception exception) {
                    this.\u00d2O0000.logException(exception, 3850, this.Object.o00000);
                    this.float |= 4;
                }
                finally {
                    this.close();
                }
            }
        }
    }

    private boolean hasAlpha(int n) {
        boolean bl = false;
        if (n == 3 || n == 4 || n == 6) {
            bl = true;
        }
        return bl;
    }

    private ColorType getColorType(int n) {
        ColorType colorType = ColorType.int;
        if (n == 0 || n == 4) {
            colorType = ColorType.\u00f600000;
        } else if (n == 2 || n == 6) {
            colorType = ColorType.\u00d200000;
        } else if (n == 3) {
            colorType = ColorType.\u00f800000;
        }
        return colorType;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    private int getSamplesPerPixel(int n) {
        int n2 = 1;
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 16: {
                n2 = -1;
                break;
            }
            case 24: 
            case 32: {
                n2 = 3;
            }
        }
        return n2;
    }

    private void close() {
        try {
            if (this.\u00f5o0000 != null) {
                this.\u00f5o0000.close();
            }
        }
        catch (IOException iOException) {
            if (this.\u00d2O0000 != null) {
                this.\u00d2O0000.logException(iOException, 3811, this.Object.o00000, iOException.getLocalizedMessage());
            }
            this.float |= 2;
        }
    }
}

