/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.imagereader.reader;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.MemoryManager;
import com.neptunelabs.fsiserver.framework.io.PluginLoader;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imageio.SeekableByteChannelImageInputStream;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageWrap;
import com.neptunelabs.fsiserver.imagereader.helper.ReaderHelperAbstact;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageException;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageUnlimited;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.imagereader.reader.ConverterImageReaderAbstract;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.NoSuchFileException;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ConverterImageReaderTIFF
extends ConverterImageReaderAbstract {
    public static final int O\u00d20000 = 259;
    private static final long \u00f8o0000 = 0x1000000L;

    public ConverterImageReaderTIFF(FSILogger fSILogger, SwapPool swapPool, BufferedImageConverter bufferedImageConverter, PluginLoader pluginLoader, ByteOrder byteOrder, boolean bl) {
        super(fSILogger, swapPool, bufferedImageConverter, pluginLoader, byteOrder, bl, 259);
    }

    @Override
    public void setFile(FSIMetaData fSIMetaData) {
        long l;
        this.nullsuper = fSIMetaData;
        if (fSIMetaData.while > 0xFFFFFFFEL) {
            if (this.new != null) {
                this.new.log(3806, fSIMetaData.o00000);
            }
            this.oo0000 = true;
        }
        if (!(this.oo0000 || (l = 4L * (long)fSIMetaData.getWidth() * (long)fSIMetaData.getHeight()) <= MemoryManager.getFreeHeapSpace() && l <= Integer.MAX_VALUE)) {
            this.Stringsuper = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readImage() throws IOException {
        this.\u00d500000 = true;
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl = false;
        if (this.\u00f4O0000 && this.nullsuper.while < this.thissuper) {
            bl = true;
            byteArrayInputStream = new ByteArrayInputStream(FileOperations.readFile(this.new, this.nullsuper.\u00f400000.getPath()));
        }
        ImageInputStream imageInputStream = null;
        try {
            imageInputStream = byteArrayInputStream == null ? new SeekableByteChannelImageInputStream(this.nullsuper.\u00f400000.getPath()) : ImageIO.createImageInputStream(byteArrayInputStream);
        }
        catch (NoSuchFileException noSuchFileException) {
            this.new.logException(noSuchFileException, 3801, this.nullsuper.o00000);
            this.oo0000 = true;
        }
        catch (IOException iOException) {
            this.new.logException(iOException, 3802, this.nullsuper.o00000);
            this.oo0000 = true;
        }
        TIFFImageReader tIFFImageReader = new TIFFImageReader(new TIFFImageReaderSpi());
        if (!this.oo0000 && imageInputStream != null) {
            boolean bl2 = this.isOldFSITool(this.nullsuper.getImage().int);
            tIFFImageReader.setIsOldFSITool(bl2);
            tIFFImageReader.setInput(imageInputStream);
            try {
                Object object;
                int n;
                int n2;
                int n3;
                int n4;
                FSIImageMode fSIImageMode = this.nullsuper.\u00f500000 ? FSIImageMode.\u00d200000 : FSIImageMode.o00000;
                this.\u00f5O0000 = this.Stringsuper || this.\u00d3O0000 ? new FSIImageUnlimited(this.new, this.o00000, this.\u00d3o0000, this.nullsuper.getWidth(), this.nullsuper.getHeight(), this.nullsuper.o00000, fSIImageMode, null, false) : new FSIImageLimited(this.new, this.o00000, this.\u00d3o0000, this.nullsuper.getWidth(), this.nullsuper.getHeight(), this.nullsuper.o00000, fSIImageMode, this.Stringsuper | this.\u00d3O0000);
                if (this.nullsuper.\u00d4O0000 > 0 && (n4 = this.nullsuper.\u00d4O0000) > 0) {
                    this.\u00f5O0000.createExtraAlpha(n4);
                }
                this.nullsuper.getSamplesPerPixel();
                if (this.\u00d5o0000) {
                    this.nullsuper.oO0000 = new Histogram();
                }
                n4 = this.nullsuper.getWidth();
                int n5 = this.nullsuper.getHeight();
                int n6 = this.nullsuper.getTileWidth();
                int n7 = this.nullsuper.getTileHeight();
                if (n6 == -1) {
                    n6 = n4;
                }
                if (n7 == -1) {
                    n7 = n5;
                }
                int n8 = (int)Math.ceil((float)n4 / (float)n6);
                int n9 = (int)Math.ceil((float)n5 / (float)n7);
                int n10 = n8 * n9;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                boolean bl3 = false;
                long l = 4L * (long)n6 * (long)n7;
                if (l > MemoryManager.getFreeHeapSpace() || l > 0x1000000L) {
                    bl3 = true;
                }
                if ((n3 = (n2 = n6 * n7 * 4) * (n = 1000)) > 0x7800000 && (n = (int)Math.floor(0x7800000 / n2)) < 1) {
                    n = 1;
                }
                boolean bl4 = true;
                ExecutorService executorService = ExecutorPool.createExecutorService("Reader TIFF", ExecutorPool.getMaxCPUThreads(), 1);
                LinkedList<CompletableFuture<Boolean>> linkedList = new LinkedList<CompletableFuture<Boolean>>();
                while (n11 < n10 && !this.\u00f8O0000 && !this.oo0000) {
                    n14 = n12;
                    n15 = n13;
                    object = tIFFImageReader.readTile(0, n12, n13);
                    BufferedImageWrap bufferedImageWrap = new BufferedImageWrap((BufferedImage)object, this.\u00d4o0000.getClutCache());
                    bufferedImageWrap.setDefaultICCProfiles(this.\u00d5O0000, this.forsuper, this.\u00d800000);
                    bufferedImageWrap.setICCProfile(this.nullsuper.getICC());
                    bufferedImageWrap.setSawAdobeMarker(this.nullsuper.\u00d400000);
                    bufferedImageWrap.setUseFallbackConverter(this.\u00d8O0000);
                    bufferedImageWrap.initColorConverter(this.nullsuper.if);
                    bufferedImageWrap.\u00f5O0000 = this.nullsuper.oO0000;
                    bufferedImageWrap.\u00f600000 = this.nullsuper.o00000;
                    if (this.nullsuper.\u00d3O0000 != -1) {
                        bufferedImageWrap.setAlphaBand(this.nullsuper.\u00d3O0000);
                        bufferedImageWrap.setHasAlpha(true);
                        bufferedImageWrap.setIsAlphaPremultiplied(this.nullsuper.\u00d800000);
                        bufferedImageWrap.setAlphaStart(this.nullsuper.\u00d3O0000);
                    }
                    int n16 = n14 * n6;
                    int n17 = n15 * n7;
                    ReaderHelperAbstact._o _o2 = new ReaderHelperAbstact._o(bufferedImageWrap, this.\u00d4o0000, this.\u00f5O0000, n16, n17);
                    linkedList.add(CompletableFuture.supplyAsync(_o2, executorService));
                    if (++n14 == n8) {
                        CompletableFuture completableFuture;
                        n14 = 0;
                        ++n15;
                        while ((completableFuture = (CompletableFuture)linkedList.poll()) != null) {
                            bl4 &= ((Boolean)completableFuture.get()).booleanValue();
                        }
                    }
                    if (++n12 == n8) {
                        n12 = 0;
                        ++n13;
                    }
                    ++n11;
                }
                while ((object = (CompletableFuture)linkedList.poll()) != null) {
                    bl4 &= ((Boolean)((CompletableFuture)object).get()).booleanValue();
                }
                if (!(bl4 &= ExecutorPool.shutdownAndWait(executorService, linkedList, 60))) {
                    this.oo0000 = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                this.new.logException(nullPointerException, 3804, this.nullsuper.o00000, "1 " + nullPointerException.getLocalizedMessage());
                this.oo0000 = true;
            }
            catch (FSIImageException fSIImageException) {
                this.new.logException(fSIImageException, 3804, this.nullsuper.o00000, "2 " + fSIImageException.getLocalizedMessage());
                this.oo0000 = true;
            }
            catch (ExecutionException executionException) {
                if (!this.\u00f8O0000) {
                    this.new.logException(executionException, 3804, this.nullsuper.o00000, "3 " + executionException.getLocalizedMessage());
                }
                this.oo0000 = true;
            }
            catch (InterruptedException | ClosedByInterruptException exception) {
                exception.printStackTrace();
                this.OO0000 = true;
            }
            catch (Exception exception) {
                this.new.logException(exception, 3804, this.nullsuper.o00000, "4 " + exception.getLocalizedMessage());
                this.oo0000 = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.new.logError(outOfMemoryError, 3804, this.nullsuper.o00000, "5 " + outOfMemoryError.getLocalizedMessage());
                this.oo0000 = true;
            }
            catch (Error error) {
                this.new.logError(error, 3804, this.nullsuper.o00000, "6 " + error.getLocalizedMessage());
                this.oo0000 = true;
            }
            finally {
                tIFFImageReader.reset();
                tIFFImageReader.dispose();
                this.closeReaderInput(tIFFImageReader);
                this.oO0000 = true;
            }
        }
        if (imageInputStream != null) {
            try {
                imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.nullsuper.oO0000 != null) {
            this.nullsuper.oO0000.digest();
        }
        return !this.oo0000;
    }

    @Override
    public void destroy() {
        this.shutdown();
        if (this.\u00d500000) {
            while (!this.oO0000 && !this.oo0000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        super.destroy();
    }

    private void closeReaderInput(ImageReader imageReader) {
        if (imageReader == null) {
            return;
        }
        Object object = imageReader.getInput();
        if (object != null && object instanceof ImageInputStream) {
            try {
                ((ImageInputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

