/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.download.DownloadJob;
import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheLoad;
import com.neptunelabs.fsiserver.framework.cache.CacheType;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.area.LayerBlend;
import com.neptunelabs.fsiserver.imagemanipulator.area.SimpleBorder;
import com.neptunelabs.fsiserver.imagemanipulator.color.BlendMode;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.fsiserver.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageMode;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.MimeTypeImageMapping;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.cache.CacheableArrayList;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.PoolFileEntryComparator;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StandardDirectoryImageRenderer
extends RendererAbstract {
    private final ImageBuilder \u00f5\u00d30000;
    private final PoolEntrySortingField \u00f6\u00d30000;
    private final Comparator<String> \u00d6\u00d30000;
    private static final float \u00f4\u00d30000 = 0.85714287f;
    private static final float superObject = 0.7222222f;
    private static final float classObject = 0.16190477f;

    public StandardDirectoryImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        int n;
        String string2;
        this.\u00f5\u00d30000 = requestProcessorSettings.getImageBuilder();
        int n2 = requestProcessorSettings.getPrefsInt("limits", "maxwidth");
        if (n2 > 0) {
            this.\u00d5O0000 = n2;
        }
        if ((n2 = requestProcessorSettings.getPrefsInt("limits", "maxheight")) > 0) {
            this.\u00d4O0000 = n2;
        }
        if ((string2 = requestProcessorSettings.getPrefsString("limits", "defaultwidth")).equalsIgnoreCase("source")) {
            this.\u00f4O0000 = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        string2 = requestProcessorSettings.getPrefsString("limits", "defaultheight");
        if (string2.equalsIgnoreCase("source")) {
            this.\u00d500000 = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.\u00f6\u00d30000 = RendererEnvironment.\u00d400000;
        this.\u00d6\u00d30000 = requestProcessorSettings.getDefaultStringComparator();
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        RendererResponse rendererResponse = this.checkStandardImageRequestParameters(parameters);
        if (rendererResponse != null) {
            return rendererResponse;
        }
        if (parameters.getType() != Parameters.Type.\u00d300000) {
            throw new IllegalArgumentException("invalid type");
        }
        rendererResponse = this.processImageRequest(httpServletRequest);
        return rendererResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("keepaspectratio");
        treeSet.add("errorfallback");
        treeSet.add("importingfallback");
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            if (string2.equalsIgnoreCase("source")) {
                this.\u00f4O0000 = 0;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 0) {
                        this.\u00f4O0000 = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            if (string2.equalsIgnoreCase("source")) {
                this.\u00d500000 = 0;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 0) {
                        this.\u00d500000 = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        int n;
        RendererTextResponse rendererTextResponse = null;
        if (parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = StandardDirectoryImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
        }
        if (rendererTextResponse == null && parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = StandardDirectoryImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
        }
        return rendererTextResponse;
    }

    private RendererResponse processImageRequest(HttpServletRequest httpServletRequest) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse rendererImageResponse;
        block9: {
            rendererImageResponse = new RendererImageResponse();
            Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
            String string = parameters.getAssetURLPath();
            HttpSession httpSession = httpServletRequest.getSession(false);
            try {
                SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string, httpSession);
                PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(string, httpSession, true);
                if (permissionSet != null && permissionSet.read.renderedImages.booleanValue()) {
                    Pair<Integer, Boolean> pair = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
                    Pair<Integer, Boolean> pair2 = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
                    if (pair.getItem2().booleanValue()) {
                        parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(pair.getItem1()));
                    }
                    if (pair2.getItem2().booleanValue()) {
                        parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(pair2.getItem1()));
                    }
                    try {
                        this.processDirectoryImageRequest(sourceConnectorReader, permissionSet, string, parameters, pair, pair2, httpSession, rendererImageResponse);
                        break block9;
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        rendererImageResponse.setStatus(404);
                        break block9;
                    }
                    catch (IOException iOException) {
                        rendererImageResponse.setStatus(500);
                        break block9;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("Invalid range value");
                    }
                }
                rendererImageResponse.setStatus(403);
            }
            catch (NotConfiguredException notConfiguredException) {
                rendererImageResponse.setStatus(503);
                this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
            }
        }
        return rendererImageResponse;
    }

    private void processDirectoryImageRequest(SourceConnectorReader sourceConnectorReader, PermissionSet permissionSet, String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpSession httpSession, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnectorReader == null && string.equals("_trash")) {
            this.handleTrashDirImageRequest(pair, pair2, httpSession, rendererImageResponse);
        } else if (string.equals("_downloads")) {
            this.handleDownloadsDirImageRequest(pair, pair2, httpSession, rendererImageResponse);
        } else {
            this.handleDefaultDirImageRequest(sourceConnectorReader, permissionSet, this.\u00f5\u00d30000, string, parameters, pair, pair2, httpSession, rendererImageResponse);
        }
    }

    private void handleTrashDirImageRequest(Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpSession httpSession, RendererImageResponse rendererImageResponse) throws NoSuchFileException, IOException, NotConfiguredException, ProcessingException, InterruptedException {
        List<TrashListEntry> list = this.getTrashList(httpSession);
        long l = 0L;
        for (TrashListEntry trashListEntry : list) {
            l = Math.max(trashListEntry.\u00d800000, l);
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        FSIImageLimited fSIImageLimited = new FSIImageLimited(this.\u00d200000, this.Object.getSwapPool(), this.Object.getByteOrder(), (int)pair.getItem1(), pair2.getItem1(), null, FSIImageMode.\u00d200000);
        rendererImageResponse.setDateHeader("Last-Modified", l);
        rendererImageResponse.setETagModifier(Integer.toString(list.size()));
        rendererImageResponse.setResponseImage(fSIImageLimited);
        rendererImageResponse.setStatus(200);
    }

    private void handleDownloadsDirImageRequest(Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpSession httpSession, RendererImageResponse rendererImageResponse) throws NotConfiguredException {
        List<DownloadJob> list = this.getDownloadsList(httpSession);
        long l = 0L;
        for (DownloadJob downloadJob : list) {
            l = Math.max(downloadJob.getCreationTime(), l);
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        FSIImageLimited fSIImageLimited = new FSIImageLimited(this.\u00d200000, this.Object.getSwapPool(), this.Object.getByteOrder(), (int)pair.getItem1(), pair2.getItem1(), null, FSIImageMode.\u00d200000);
        rendererImageResponse.setDateHeader("Last-Modified", l);
        rendererImageResponse.setETagModifier(Integer.toString(list.size()));
        rendererImageResponse.setResponseImage(fSIImageLimited);
        rendererImageResponse.setStatus(200);
    }

    private void handleDefaultDirImageRequest(SourceConnectorReader sourceConnectorReader, PermissionSet permissionSet, ImageBuilder imageBuilder, String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpSession httpSession, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException {
        Object object;
        block19: {
            long l;
            Object object2;
            List<Object> list = null;
            boolean bl = !string.startsWith("_configs") && !string.startsWith("_viewers");
            CacheKey cacheKey = null;
            if (bl) {
                cacheKey = CacheKey.getInstance(string, 'D', "dirImageList");
                CacheLoad cacheLoad = this.Object.getCacheManager().get(cacheKey, CacheType.\u00d300000);
                if (cacheLoad != null) {
                    list = cacheLoad.\u00d300000 != null ? (CacheableArrayList)cacheLoad.\u00d300000 : CacheableArrayList.unpack(cacheLoad.new);
                }
            }
            int n = 3;
            if (list == null) {
                object = imageBuilder.getPoolList(sourceConnectorReader, string, httpSession);
                list = ((PoolList)object).getFilesAsList();
                if (list.size() < 1000) {
                    object2 = new PoolFileEntryComparator(this.\u00f6\u00d30000, this.\u00d6\u00d30000, SortDirection.\u00d300000);
                    list.sort((Comparator<Object>)object2);
                }
                list = this.limitList((List<PoolFileEntry>)list, 0, 3);
                if (bl) {
                    this.Object.getCacheManager().put(cacheKey, new CacheableArrayList<Object>((Collection<Object>)list), true);
                }
                l = ((PoolList)object).\u00d4\u00d60000;
            } else {
                object = imageBuilder.getPoolListSummary(sourceConnectorReader, string, httpSession);
                l = ((PoolListSummary)object).\u00d200000;
            }
            if (sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.super) {
                list.removeIf(poolFileEntry -> poolFileEntry.\u00d800000 != 1);
            }
            rendererImageResponse.setDateHeader("Last-Modified", l);
            object = null;
            object2 = null;
            try {
                object = new FSIImageLimited(this.\u00d200000, this.Object.getSwapPool(), this.Object.getByteOrder(), (int)pair.getItem1(), pair2.getItem1(), null, FSIImageMode.\u00d200000);
                float f = 0.1f;
                int n2 = ((FSIImage)object).getWidth();
                int n3 = ((FSIImage)object).getHeight();
                int n4 = Math.round((float)((FSIImage)object).getHeight() * 0.033333335f);
                if (permissionSet.read.renderedImages.booleanValue() && permissionSet.list.files.booleanValue() && list.size() > 0) {
                    int n5 = list.size();
                    int n6 = 3 - n5;
                    SourceConnectorReader sourceConnectorReader2 = this.Object.getSourceConnectorFromAssetURLPath(string);
                    LayerBlend layerBlend = new LayerBlend(this.\u00d200000);
                    ParallelColorOperation parallelColorOperation = new ParallelColorOperation(this.\u00d200000);
                    SimpleBorder simpleBorder = new SimpleBorder(this.\u00d200000);
                    for (int i = 0; i < n5; ++i) {
                        PoolEntry poolEntry = (PoolEntry)list.get(n5 - i - 1);
                        object2 = null;
                        try {
                            PoolFileEntry poolFileEntry2 = (PoolFileEntry)poolEntry;
                            FSIInterpolation fSIInterpolation = poolFileEntry2.\u00d600000 < n2 && poolFileEntry2.String < n3 ? FSIInterpolation.\u00d200000 : FSIInterpolation.o00000;
                            float f2 = 1.0f - (float)(3 - n6 - 1) * 0.1f;
                            Pair<Integer, Boolean> pair3 = new Pair<Integer, Boolean>(Math.round((float)n2 * 0.85714287f * f2), false);
                            Pair<Integer, Boolean> pair4 = new Pair<Integer, Boolean>(Math.round((float)n3 * 0.7222222f * f2), false);
                            if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.super) {
                                String string2 = this.getSuffixFromAssetURLPath(poolFileEntry2.o00000);
                                String string3 = "_service/mime-types/" + MimeTypeImageMapping.getImageFilename(string2);
                                object2 = this.\u00f5\u00d30000.getImage(null, null, string3, pair3, pair4, 0.0, 0.0, 1.0, 1.0, true, FSIInterpolation.o00000, null);
                            } else {
                                object2 = this.\u00f5\u00d30000.getImage(null, sourceConnectorReader2, string + '/' + poolFileEntry2.o00000, pair3, pair4, 0.0, 0.0, 1.0, 1.0, true, fSIInterpolation, null);
                            }
                        }
                        catch (NoSuchFileException noSuchFileException) {
                        }
                        catch (Exception exception) {
                            this.\u00d200000.log(2504, string + '/' + poolEntry.o00000, exception.getLocalizedMessage());
                        }
                        if (object2 != null) {
                            if (sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.super) {
                                if (((FSIImage)object2).hasAlpha()) {
                                    object2 = parallelColorOperation.transform((FSIImage)object2, new MatteTransparent(0xFFFFFF, false), false);
                                }
                                object2 = simpleBorder.transform((FSIImage)object2, -6710887, 1, false);
                            }
                            int n7 = Math.round((float)((FSIImage)object).getHeight() * 0.16190477f);
                            int n8 = n7 + n6 * n4;
                            int n9 = Math.round((float)(((FSIImage)object).getWidth() - ((FSIImage)object2).getWidth()) / 2.0f);
                            object = layerBlend.transform((FSIImage)object, (FSIImage)object2, n9, n8, BlendMode.interface, 100.0f, false);
                        }
                        ++n6;
                    }
                    break block19;
                }
                object = new FSIImageLimited(this.\u00d200000, this.Object.getSwapPool(), this.Object.getByteOrder(), (int)pair.getItem1(), pair2.getItem1(), null, FSIImageMode.\u00d200000);
            }
            catch (ProcessingException processingException) {
                StandardDirectoryImageRenderer.disposeImages(new FSIImage[]{object, object2});
                throw processingException;
            }
        }
        rendererImageResponse.setResponseImage((FSIImageLimited)object);
        rendererImageResponse.setStatus(200);
    }

    private String getSuffixFromAssetURLPath(String string) {
        try {
            int n = string.lastIndexOf(".") + 1;
            String string2 = string.substring(n);
            if (string2.equals("gz") || string2.equals("bz2")) {
                n = string.lastIndexOf(".", n - 2);
                string2 = string.substring(n);
            }
            return string2;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "";
        }
    }
}

