/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagemanipulator.area.Padding;
import com.neptunelabs.fsiserver.imagemanipulator.area.PaddingPositions;
import com.neptunelabs.fsiserver.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.fsiserver.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.imagereader.pyramidreader.FlatImageException;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.MimeTypeImageMapping;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class StandardImageRenderer
extends RendererAbstract {
    private final ImageBuilder classclass;
    private boolean \u00f6\u00d60000 = true;
    private String \u00f4\u00d60000 = null;
    private String superclass = null;
    private boolean \u00f5\u00d60000 = false;

    public StandardImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
        int n;
        String string2;
        this.classclass = requestProcessorSettings.getImageBuilder();
        int n2 = requestProcessorSettings.getPrefsInt("limits", "maxwidth");
        if (n2 > 0) {
            this.\u00d5O0000 = n2;
        }
        if ((n2 = requestProcessorSettings.getPrefsInt("limits", "maxheight")) > 0) {
            this.\u00d4O0000 = n2;
        }
        if ((string2 = requestProcessorSettings.getPrefsString("limits", "defaultwidth")).equalsIgnoreCase("source")) {
            this.\u00f4O0000 = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        string2 = requestProcessorSettings.getPrefsString("limits", "defaultheight");
        if (string2.equalsIgnoreCase("source")) {
            this.\u00d500000 = 0;
        } else {
            try {
                n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.calculateRendererChecksum();
    }

    @Override
    void calculateRendererChecksum() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.\u00f4O0000);
        stringBuilder.append(this.\u00d500000);
        stringBuilder.append(this.\u00d5O0000);
        stringBuilder.append(this.\u00d4O0000);
        stringBuilder.append(this.\u00f6\u00d60000);
        stringBuilder.append(this.\u00f5\u00d60000);
        if (this.\u00d600000 != null) {
            for (double d : this.\u00d600000) {
                stringBuilder.append(d);
            }
        }
        this.\u00f500000 = stringBuilder.toString();
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("keepAspectRatio")) {
            string2 = String.valueOf(this.\u00f6\u00d60000);
        } else if (string.equalsIgnoreCase("errorFallback")) {
            string2 = this.\u00f4\u00d60000;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            string2 = this.superclass;
        } else if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        RendererResponse rendererResponse = this.checkStandardImageRequestParameters(parameters);
        if (rendererResponse != null) {
            return rendererResponse;
        }
        if (parameters.getType() != Parameters.Type.if) {
            throw new IllegalArgumentException("invalid type");
        }
        rendererResponse = this.processImageRequest(this.classclass, httpServletRequest);
        return rendererResponse;
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("keepaspectratio");
        treeSet.add("errorfallback");
        treeSet.add("importingfallback");
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("noredirect");
        treeSet.add("padding");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("keepAspectRatio")) {
            this.\u00f6\u00d60000 = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("errorFallback")) {
            this.\u00f4\u00d60000 = string2;
        } else if (string.equalsIgnoreCase("importingFallback")) {
            this.superclass = string2;
        } else if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            if (string2.equalsIgnoreCase("source")) {
                this.\u00f4O0000 = 0;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 0) {
                        this.\u00f4O0000 = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            if (string2.equalsIgnoreCase("source")) {
                this.\u00d500000 = 0;
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n > 0) {
                        this.\u00d500000 = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (string.equalsIgnoreCase("noredirect")) {
            this.\u00f5\u00d60000 = Boolean.parseBoolean(string2);
        } else if (string.equalsIgnoreCase("padding")) {
            this.\u00d600000 = this.evaluatePadding(string2);
        }
        this.calculateRendererChecksum();
    }

    private RendererResponse checkStandardImageRequestParameters(Parameters parameters) {
        int n;
        RendererTextResponse rendererTextResponse = null;
        if (parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = StandardImageRenderer.generateInvalidParameterValueResponse("width", parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
            }
        }
        if (rendererTextResponse == null && parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000)) {
            n = -1;
            try {
                n = Integer.parseInt(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n <= 0) {
                rendererTextResponse = StandardImageRenderer.generateInvalidParameterValueResponse("height", parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
            }
        }
        if (rendererTextResponse == null && !parameters.contains(Parameters.General.privateObject)) {
            rendererTextResponse = StandardImageRenderer.generateInvalidParameterValueResponse("source", "empty");
        }
        return rendererTextResponse;
    }

    private RendererResponse processImageRequest(ImageBuilder imageBuilder, HttpServletRequest httpServletRequest) throws IllegalArgumentException, ProcessingException, InterruptedException {
        RendererImageResponse rendererImageResponse;
        block16: {
            rendererImageResponse = new RendererImageResponse();
            Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
            boolean bl = this.checkParameterCombinationForImageRequest(parameters);
            if (!bl) {
                rendererImageResponse.setStatus(400);
            } else {
                try {
                    HttpSession httpSession = httpServletRequest.getSession(false);
                    String string = parameters.getAssetURLPath();
                    Pair<Integer, Boolean> pair = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
                    Pair<Integer, Boolean> pair2 = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
                    SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string, httpSession);
                    if (sourceConnectorReader != null) {
                        PermissionSet permissionSet = this.Object.getUserAuthenticationInterface().getPermissions(sourceConnectorReader, httpSession, true);
                        if (permissionSet != null && permissionSet.read.renderedImages.booleanValue()) {
                            if (pair.getItem2().booleanValue()) {
                                parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(pair.getItem1()));
                            }
                            if (pair2.getItem2().booleanValue()) {
                                parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(pair2.getItem1()));
                            }
                            try {
                                this.processFileImageRequest(sourceConnectorReader, imageBuilder, string, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
                                break block16;
                            }
                            catch (NoSuchFileException noSuchFileException) {
                                try {
                                    this.process404ImageRequest(sourceConnectorReader, imageBuilder, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                rendererImageResponse.setStatus(404);
                                break block16;
                            }
                            catch (IOException iOException) {
                                rendererImageResponse.setStatus(500);
                                iOException.printStackTrace();
                                break block16;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException("Invalid range value");
                            }
                        }
                        rendererImageResponse.setStatus(403);
                        break block16;
                    }
                    try {
                        this.process404ImageRequest(sourceConnectorReader, imageBuilder, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    rendererImageResponse.setStatus(404);
                }
                catch (NotConfiguredException notConfiguredException) {
                    rendererImageResponse.setStatus(503);
                    this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
                }
            }
        }
        return rendererImageResponse;
    }

    private void processFileImageRequest(SourceConnectorReader sourceConnectorReader, ImageBuilder imageBuilder, String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.super) {
            boolean bl = parameters.contains(Parameters.GeneralImage.StringObject);
            this.processDynamicFileImageRequest(sourceConnectorReader, imageBuilder, string, parameters, pair, pair2, httpServletRequest, rendererImageResponse, bl);
        } else {
            this.processMimeTypeImageRequest(string, parameters, pair, pair2, httpServletRequest, rendererImageResponse);
        }
    }

    private void process404ImageRequest(SourceConnectorReader sourceConnectorReader, ImageBuilder imageBuilder, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse) throws IOException, NotConfiguredException, ProcessingException, InterruptedException {
        if (sourceConnectorReader != null && sourceConnectorReader.getFallbackImage() != null) {
            this.processDynamicFileImageRequest(sourceConnectorReader, imageBuilder, sourceConnectorReader.getFallbackImage(), parameters, pair, pair2, httpServletRequest, rendererImageResponse, false);
        }
    }

    private void processMimeTypeImageRequest(String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse) throws IOException, ProcessingException {
        String string2 = this.getSuffixFromAssetURLPath(string);
        String string3 = MimeTypeImageMapping.getImageFilename(string2);
        String string4 = "_service/mime-types/" + string3;
        SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string4);
        httpServletRequest.setAttribute("mimeImageRequest", (Object)true);
        this.processDynamicFileImageRequest(sourceConnectorReader, this.classclass, string4, parameters, pair, pair2, httpServletRequest, rendererImageResponse, false);
    }

    private String getSuffixFromAssetURLPath(String string) {
        try {
            int n = string.lastIndexOf(".") + 1;
            String string2 = string.substring(n);
            if (string2.equals("gz") || string2.equals("bz2")) {
                n = string.lastIndexOf(".", n - 2);
                string2 = string.substring(n);
            }
            return string2;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "";
        }
    }

    private boolean checkParameterCombinationForImageRequest(Parameters parameters) {
        return !parameters.contains(Parameters.GeneralImage.o\u00d20000) && !parameters.contains(Parameters.GeneralImage.\u00d4\u00d40000) && !parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) && !parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000) && !parameters.contains(Parameters.GeneralImage.whilenew) || !parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) && !parameters.contains(Parameters.GeneralImage.thisObject) && !parameters.contains(Parameters.GeneralImage.returnnew) && !parameters.contains(Parameters.GeneralImage.nullObject) && !parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000) && !parameters.contains(Parameters.GeneralImage.\u00f5\u00d30000) && !parameters.contains(Parameters.GeneralImage.\u00d8\u00d30000);
    }

    /*
     * Loose catch block
     */
    private void processDynamicFileImageRequest(SourceConnectorReader sourceConnectorReader, ImageBuilder imageBuilder, String string, Parameters parameters, Pair<Integer, Boolean> pair, Pair<Integer, Boolean> pair2, HttpServletRequest httpServletRequest, RendererImageResponse rendererImageResponse, boolean bl) throws IOException, ProcessingException {
        block60: {
            MetaData metaData;
            int n = 0;
            if (bl) {
                n |= 0x40;
            }
            if ((metaData = imageBuilder.getImageMetaData(sourceConnectorReader, string, n, false, httpServletRequest.getSession(false))) == null) {
                rendererImageResponse.setStatus(404);
                return;
            }
            if (!(metaData instanceof ImageMetaData)) {
                throw new IllegalArgumentException("processDynamicFileImageRequest called for non-image connector:" + metaData);
            }
            ImageMetaData imageMetaData = (ImageMetaData)metaData;
            Throwable throwable = null;
            try (EISReader eISReader = imageMetaData.getEISReaderHook();){
                Object object;
                Object object2;
                FSIImageLimited fSIImageLimited;
                boolean bl2;
                block63: {
                    Object object3;
                    short s;
                    rendererImageResponse.setMetaData(metaData);
                    if (pair.getItem1() == 0) {
                        pair.setItem1(Math.min(imageMetaData.getWidth(), this.\u00d5O0000));
                    }
                    if (pair2.getItem1() == 0) {
                        pair2.setItem1(Math.min(imageMetaData.getHeight(), this.\u00d4O0000));
                    }
                    if ((s = (short)imageMetaData.getImportStatus()) != 1 && s != 4) {
                        if (this.\u00f5\u00d60000) {
                            if (s != 3 || s != 5) {
                                rendererImageResponse.setStatus(500);
                            } else if (s != 2) {
                                rendererImageResponse.setStatus(503);
                                rendererImageResponse.setHeader("Retry-After", "30");
                            }
                        } else {
                            this.createFallbackResponse(string, parameters, s, rendererImageResponse);
                        }
                        break block60;
                    }
                    bl2 = false;
                    long l = httpServletRequest.getDateHeader("If-Modified-Since") / 1000L * 1000L;
                    long l2 = imageMetaData.getLastModified();
                    if (l2 == l) {
                        bl2 = true;
                    }
                    rendererImageResponse.setDateHeader("Last-Modified", l2);
                    String string2 = this.\u00f500000 + parameters.hashCode64() + imageMetaData.hashCode();
                    if (sourceConnectorReader != null) {
                        string2 = string2 + sourceConnectorReader.getImportEffectsHash();
                    }
                    rendererImageResponse.setETagModifier(string2);
                    fSIImageLimited = null;
                    if (bl2) break block63;
                    object2 = Arrays.copyOf(oO0000, 4);
                    object = Arrays.copyOf(supersuper, 4);
                    boolean bl3 = false;
                    if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) || parameters.contains(Parameters.GeneralImage.thisObject) || parameters.contains(Parameters.GeneralImage.returnnew) || parameters.contains(Parameters.GeneralImage.nullObject) || parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000)) {
                        StandardImageRenderer.getRelativeRangeFromParameters(parameters, (double[])object2);
                    } else if (parameters.contains(Parameters.GeneralImage.o\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00d4\u00d40000) || parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00f8\u00d20000) || parameters.contains(Parameters.GeneralImage.whilenew)) {
                        bl3 = true;
                        this.getPixelRangeFromParameters(parameters, (int[])object);
                    }
                    Object object4 = parameters.contains(Parameters.GeneralImage.\u00d4\u00d30000) ? (Object)((object3 = parameters.get(Parameters.GeneralImage.\u00d4\u00d30000)) != null ? this.evaluatePadding((String)object3) : null) : (this.\u00d600000 != null ? this.\u00d600000 : null);
                    if (object4 != null) {
                        object3 = new PaddingPositions();
                        ((PaddingPositions)object3).\u00d400000 = object4[0] < 1.0 && object4[0] > (double)0.001f ? (int)Math.round((double)pair.getItem1().intValue() * object4[0]) : (int)Math.floor(object4[0]);
                        ((PaddingPositions)object3).\u00d300000 = object4[1] < 1.0 && object4[1] > (double)0.001f ? (int)Math.round((double)pair2.getItem1().intValue() * object4[1]) : (int)Math.floor(object4[1]);
                        ((PaddingPositions)object3).new = object4[2] < 1.0 && object4[2] > (double)0.001f ? (int)Math.round((double)pair.getItem1().intValue() * object4[2]) : (int)Math.floor(object4[2]);
                        ((PaddingPositions)object3).o00000 = object4[3] < 1.0 && object4[3] > (double)0.001f ? (int)Math.round((double)pair2.getItem1().intValue() * object4[3]) : (int)Math.floor(object4[3]);
                        if (!pair.getItem2().booleanValue() && ((PaddingPositions)object3).\u00d400000 + ((PaddingPositions)object3).new >= pair.getItem1() || !pair2.getItem2().booleanValue() && ((PaddingPositions)object3).\u00d300000 + ((PaddingPositions)object3).o00000 >= pair2.getItem1()) {
                            throw new IllegalArgumentException("Invalid parameter for padding (out if range).");
                        }
                        if (((PaddingPositions)object3).\u00d400000 < 0 || ((PaddingPositions)object3).new < 0 || ((PaddingPositions)object3).\u00d300000 < 0 || ((PaddingPositions)object3).o00000 < 0) {
                            throw new IllegalArgumentException("Invalid parameter for padding (negative value).");
                        }
                    } else {
                        object3 = null;
                    }
                    try {
                        if (bl3) {
                            int[] nArray = StandardImageRenderer.getReferenceDimensions(parameters);
                            fSIImageLimited = imageBuilder.getImagePixelBased(eISReader, sourceConnectorReader, string, nArray[0], nArray[1], (int)object[0], (int)object[1], (int)object[2], (int)object[3], this.\u00f6\u00d60000, FSIInterpolation.o00000);
                        } else {
                            fSIImageLimited = imageBuilder.getImage(eISReader, sourceConnectorReader, string, pair, pair2, (double)object2[0], (double)object2[1], (double)object2[2], (double)object2[3], this.\u00f6\u00d60000, FSIInterpolation.o00000, (PaddingPositions)object3);
                        }
                        if (object3 != null) {
                            int n2;
                            double d;
                            int n3;
                            if (!pair.getItem2().booleanValue()) {
                                n3 = pair.getItem1();
                                if (n3 > fSIImageLimited.getWidth() + ((PaddingPositions)object3).\u00d400000 + ((PaddingPositions)object3).new) {
                                    d = (double)(((PaddingPositions)object3).\u00d400000 + ((PaddingPositions)object3).new) / (double)((PaddingPositions)object3).\u00d400000;
                                    ((PaddingPositions)object3).\u00d400000 = (int)Math.round((double)(n3 - fSIImageLimited.getWidth()) / d);
                                    ((PaddingPositions)object3).new = n3 - fSIImageLimited.getWidth() + ((PaddingPositions)object3).\u00d400000;
                                }
                            } else {
                                n3 = fSIImageLimited.getWidth() + ((PaddingPositions)object3).\u00d400000 + ((PaddingPositions)object3).new;
                            }
                            if (!pair2.getItem2().booleanValue()) {
                                n2 = pair2.getItem1();
                                if (n2 > fSIImageLimited.getHeight() + ((PaddingPositions)object3).\u00d300000 + ((PaddingPositions)object3).o00000) {
                                    d = (double)(((PaddingPositions)object3).\u00d300000 + ((PaddingPositions)object3).o00000) / (double)((PaddingPositions)object3).\u00d300000;
                                    ((PaddingPositions)object3).\u00d300000 = (int)Math.round((double)(n2 - fSIImageLimited.getHeight()) / d);
                                    ((PaddingPositions)object3).o00000 = n2 - fSIImageLimited.getHeight() + ((PaddingPositions)object3).\u00d300000;
                                }
                            } else {
                                n2 = fSIImageLimited.getHeight() + ((PaddingPositions)object3).\u00d300000 + ((PaddingPositions)object3).o00000;
                            }
                            if (!fSIImageLimited.hasAlpha()) {
                                fSIImageLimited.addAlpha();
                            }
                            fSIImageLimited = (FSIImageLimited)Padding.transform(fSIImageLimited, n3, n2, (PaddingPositions)object3, true);
                        }
                    }
                    catch (FlatImageException flatImageException) {
                        this.createFallbackResponse(string, parameters, (short)5, rendererImageResponse);
                        if (eISReader != null) {
                            if (throwable != null) {
                                try {
                                    eISReader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                eISReader.close();
                            }
                        }
                        return;
                    }
                    catch (Exception exception) {
                        block61: {
                            block62: {
                                exception.printStackTrace();
                                this.createFallbackResponse(string, parameters, (short)3, rendererImageResponse);
                                if (eISReader == null) break block61;
                                if (throwable == null) break block62;
                                try {
                                    eISReader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block61;
                            }
                            eISReader.close();
                        }
                        return;
                    }
                }
                if (fSIImageLimited != null) {
                    object2 = parameters.get(Parameters.General.\u00f5\u00d40000);
                    if (object2 != null && ((String)object2).equals("_private")) {
                        object = new ParallelColorOperation(this.\u00d200000);
                        try {
                            fSIImageLimited = (FSIImageLimited)((ParallelColorOperation)object).transform(fSIImageLimited, new MatteTransparent(0xFFFFFF, false), false);
                        }
                        catch (ProcessingException processingException) {
                            StandardImageRenderer.disposeImages(fSIImageLimited);
                            throw processingException;
                        }
                    }
                    rendererImageResponse.setResponseImage(fSIImageLimited);
                    rendererImageResponse.setSelectionsRaw(imageMetaData.getSelections());
                    rendererImageResponse.setStatus(200);
                    break block60;
                }
                if (bl2) {
                    rendererImageResponse.setStatus(304);
                } else {
                    rendererImageResponse.setStatus(500);
                }
                break block60;
                {
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
            }
        }
    }

    private double[] evaluatePadding(String string) throws IllegalArgumentException {
        double[] dArray;
        String[] stringArray = string.split(",", 4);
        if (stringArray.length != 4) {
            throw new IllegalArgumentException("Invalid parameter count for padding.");
        }
        try {
            dArray = new double[]{Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3])};
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid parameter for padding.");
        }
        return dArray;
    }
}

