/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.imagemanipulator.area.Crop;
import com.neptunelabs.fsiserver.imagemanipulator.combine.Join;
import com.neptunelabs.fsiserver.imagemanipulator.helper.FSIInterpolation;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.utils.StitchRendererUtils;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class StitchImageRenderer
extends RendererAbstract {
    private int doObject = 0;

    public StitchImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws ProcessingException, InterruptedException {
        int n;
        String string;
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        RendererImageResponse rendererImageResponse = new RendererImageResponse();
        if (httpServletRequest.getAttribute("cacheable") != null) {
            rendererImageResponse.setCacheable((Boolean)httpServletRequest.getAttribute("cacheable"));
        }
        if ((string = parameters.get(Parameters.General.privateObject)) == null) {
            throw new IllegalArgumentException("source required");
        }
        String[] stringArray = string.split(",");
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = URL.cleanUpSourceParameter(stringArray[n]);
        }
        n = this.doObject;
        if (parameters.contains(Parameters.GeneralImage.\u00d5\u00d40000)) {
            n = ColorParser.parseColorWithDefault(parameters.get(Parameters.GeneralImage.\u00d5\u00d40000), n);
        }
        Pair<Integer, Boolean> pair = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
        Pair<Integer, Boolean> pair2 = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
        if (pair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(pair.getItem1()));
        }
        if (pair2.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(pair2.getItem1()));
        }
        double[] dArray = Arrays.copyOf(oO0000, 4);
        if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) || parameters.contains(Parameters.GeneralImage.thisObject) || parameters.contains(Parameters.GeneralImage.returnnew) || parameters.contains(Parameters.GeneralImage.nullObject) || parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000)) {
            StitchImageRenderer.getRelativeRangeFromParameters(parameters, dArray);
        }
        ArrayList<ImageMetaData> arrayList = new ArrayList<ImageMetaData>();
        FSIImage fSIImage = null;
        FSIImageLimited fSIImageLimited = null;
        try {
            for (String string2 : stringArray) {
                SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string2);
                MetaData metaData = this.Object.getImageBuilder().getImageMetaData(sourceConnectorReader, string2, 0, true, httpServletRequest.getSession(false));
                if (metaData == null || !(metaData instanceof ImageMetaData)) continue;
                metaData.setAssetURLPath(string2);
                arrayList.add((ImageMetaData)metaData);
            }
            Pair<Integer, Integer> pair3 = StitchRendererUtils.getTotalDimensions(arrayList, parameters);
            int n2 = (Integer)pair3.getItem1();
            int n3 = (Integer)pair3.getItem2();
            double d = (double)n2 * dArray[2];
            double d2 = (double)n3 * dArray[3];
            int n4 = pair.getItem1();
            int n5 = pair2.getItem1();
            if (pair.getItem2().booleanValue()) {
                n4 = (int)(d * (double)n5 / d2);
            } else if (pair2.getItem2().booleanValue()) {
                n5 = (int)((double)n4 * d2 / d);
            }
            StitchRendererUtils.Position position = StitchRendererUtils.getPosition(parameters);
            Crop.CropPadPosition cropPadPosition = StitchRendererUtils.getAlignment(parameters);
            int n6 = 0;
            int n7 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                double[] dArray2;
                double[] dArray3;
                double d3;
                double d4;
                double d5 = (double)n6 / (double)n2;
                ImageMetaData imageMetaData = (ImageMetaData)iterator.next();
                double d6 = (double)(n6 + imageMetaData.getWidth()) / (double)n2;
                dArray3 = new double[]{(dArray[0] - d5) / (d6 - d5), (dArray[1] - (d4 = (double)n7 / (double)n3)) / ((d3 = (double)(n7 + imageMetaData.getHeight()) / (double)n3) - d4), (dArray[0] + dArray[2] - d5) / (d6 - d5) - dArray3[0], (dArray[1] + dArray[3] - d4) / (d3 - d4) - dArray3[1]};
                if (dArray3[0] < 0.0) {
                    dArray3[2] = dArray3[2] + dArray3[0];
                    dArray3[0] = 0.0;
                }
                if (dArray3[1] < 0.0) {
                    dArray3[3] = dArray3[3] + dArray3[1];
                    dArray3[1] = 0.0;
                }
                if (dArray3[0] + dArray3[2] > 1.0) {
                    dArray3[2] = 1.0 - dArray3[0];
                }
                if (dArray3[1] + dArray3[3] > 1.0) {
                    dArray3[3] = 1.0 - dArray3[1];
                }
                dArray2 = new double[]{dArray3[0] * (d6 - d5) + d5, dArray3[1] * (d3 - d4) + d4, (dArray3[2] + dArray3[0]) * (d6 - d5) - dArray2[0] + d5, (dArray3[3] + dArray3[1]) * (d3 - d4) - dArray2[1] + d4};
                int n8 = (int)Math.ceil((double)n4 * dArray2[2] / dArray[2]);
                int n9 = (int)Math.ceil((double)n5 * dArray2[3] / dArray[3]);
                if (n8 > 0 && n9 > 0) {
                    String string3 = imageMetaData.getAssetURLPath();
                    SourceConnectorReader sourceConnectorReader = this.Object.getSourceConnectorFromAssetURLPath(string3);
                    fSIImageLimited = this.Object.getImageBuilder().getImage(null, sourceConnectorReader, string3, new Pair<Integer, Boolean>(n8, false), new Pair<Integer, Boolean>(n9, false), dArray3[0], dArray3[1], dArray3[2], dArray3[3], false, FSIInterpolation.o00000, null);
                    fSIImage = fSIImage == null ? fSIImageLimited : this.joinParts(n, position, cropPadPosition, fSIImage, fSIImageLimited);
                }
                if (position == StitchRendererUtils.Position.\u00d200000) {
                    n6 += imageMetaData.getWidth();
                    continue;
                }
                if (position != StitchRendererUtils.Position.\u00d300000) continue;
                n7 += imageMetaData.getHeight();
            }
            if (fSIImage != null && (fSIImage.getWidth() > n4 || fSIImage.getHeight() > n5)) {
                fSIImage = Crop.transform(fSIImage, (fSIImage.getWidth() - n4) / 2, (fSIImage.getHeight() - n5) / 2, n4, n5, 0, null, 0.0f, 0.0f, false);
            }
            rendererImageResponse.setStatus(200);
            rendererImageResponse.setResponseImage((FSIImageLimited)fSIImage);
            rendererImageResponse.setDateHeader("Last-Modified", StitchRendererUtils.getLatestLastModified(arrayList));
        }
        catch (NoSuchFileException noSuchFileException) {
            StitchImageRenderer.disposeImages(fSIImage, fSIImageLimited);
            rendererImageResponse.setStatus(404);
        }
        catch (IOException iOException) {
            StitchImageRenderer.disposeImages(fSIImage, fSIImageLimited);
            rendererImageResponse.setStatus(500);
            rendererImageResponse.setStatusMessage(iOException.getLocalizedMessage());
        }
        catch (NotConfiguredException notConfiguredException) {
            StitchImageRenderer.disposeImages(fSIImage, fSIImageLimited);
            rendererImageResponse.setStatus(503);
            this.\u00d200000.logException(notConfiguredException, 3191, notConfiguredException.getClass().getName() + ": " + notConfiguredException.getLocalizedMessage());
        }
        catch (ProcessingException processingException) {
            StitchImageRenderer.disposeImages(fSIImage, fSIImageLimited);
            throw processingException;
        }
        return rendererImageResponse;
    }

    private FSIImage joinParts(int n, StitchRendererUtils.Position position, Crop.CropPadPosition cropPadPosition, FSIImage fSIImage, FSIImage fSIImage2) {
        if (position == StitchRendererUtils.Position.\u00d200000) {
            if (fSIImage.getHeight() < fSIImage2.getHeight()) {
                fSIImage = Crop.transform(fSIImage, 0, 0, fSIImage.getWidth(), fSIImage2.getHeight(), n, cropPadPosition, 0.0f, 0.0f, false);
            } else if (fSIImage.getHeight() > fSIImage2.getHeight()) {
                fSIImage2 = Crop.transform(fSIImage2, 0, 0, fSIImage2.getWidth(), fSIImage.getHeight(), n, cropPadPosition, 0.0f, 0.0f, false);
            }
            fSIImage = Join.transform(fSIImage, fSIImage2, Join.JoinPosition.\u00d200000);
        } else if (position == StitchRendererUtils.Position.\u00d300000) {
            if (fSIImage.getWidth() < fSIImage2.getWidth()) {
                fSIImage = Crop.transform(fSIImage, 0, 0, fSIImage2.getWidth(), fSIImage.getHeight(), n, cropPadPosition, 0.0f, 0.0f, false);
            } else if (fSIImage.getWidth() > fSIImage2.getWidth()) {
                fSIImage2 = Crop.transform(fSIImage2, 0, 0, fSIImage.getWidth(), fSIImage2.getHeight(), n, cropPadPosition, 0.0f, 0.0f, false);
            }
            fSIImage = Join.transform(fSIImage, fSIImage2, Join.JoinPosition.\u00d300000);
        }
        return fSIImage;
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        } else if (string.equalsIgnoreCase("backgroundcolor")) {
            string2 = String.valueOf(this.doObject);
        }
        return string2;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("maxwidth");
        treeSet.add("maxheight");
        treeSet.add("defaultwidth");
        treeSet.add("defaultheight");
        treeSet.add("backgroundcolor");
        return treeSet;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string.equalsIgnoreCase("backgroundColor")) {
            try {
                this.doObject = ColorParser.parseColor(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

