/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.renderers;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.imagemanipulator.combine.TestPattern;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.image.FSIImageLimited;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererImageResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererResponse;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public final class TestPatternImageRenderer
extends RendererAbstract {
    private int \u00f5O0000 = 30000;

    public TestPatternImageRenderer(RequestProcessorSettings requestProcessorSettings, String string) {
        super(requestProcessorSettings, string);
    }

    @Override
    public Set<String> getSupportedOptions() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("defaultWidth");
        treeSet.add("defaultHeight");
        treeSet.add("maxWidth");
        treeSet.add("maxHeight");
        treeSet.add("maxDepth");
        return treeSet;
    }

    @Override
    public Set<String> getRequiredMetaData() {
        return new TreeSet<String>();
    }

    @Override
    public RendererResponse processRequest(HttpServletRequest httpServletRequest, Map<String, Object> map) throws IllegalArgumentException, ProcessingException {
        Parameters parameters = (Parameters)httpServletRequest.getAttribute("parameters");
        TestPattern testPattern = new TestPattern(this.\u00d200000, this.Object.getSwapPool(), this.Object.getByteOrder());
        RendererResponse rendererResponse = parameters.getType() == Parameters.Type.if ? this.renderImage(parameters, testPattern) : (parameters.getType() == Parameters.Type.o00000 ? this.renderInfo(parameters) : null);
        return rendererResponse;
    }

    private void convertPixelRangeToRelative(Parameters parameters, int n, int n2) {
        int[] nArray = new int[4];
        this.getPixelRangeFromParameters(parameters, nArray);
        double d = (double)nArray[0] / (double)n;
        double d2 = (double)nArray[1] / (double)n2;
        double d3 = (double)nArray[2] / (double)n;
        double d4 = (double)nArray[3] / (double)n2;
        parameters.put(Parameters.GeneralImage.\u00d3\u00d20000, d + "," + d2 + "," + d3 + "," + d4);
        parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(nArray[2]));
        parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(nArray[3]));
    }

    private RendererResponse renderImage(Parameters parameters, TestPattern testPattern) throws ProcessingException {
        Object object;
        Object object2;
        RendererImageResponse rendererImageResponse = new RendererImageResponse();
        if (parameters.contains(Parameters.GeneralImage.o\u00d20000) || parameters.contains(Parameters.GeneralImage.\u00f4\u00d20000) || parameters.contains(Parameters.GeneralImage.nullObject) || parameters.contains(Parameters.GeneralImage.thisObject) || parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000)) {
            object2 = TestPatternImageRenderer.getReferenceDimensions(parameters);
            this.convertPixelRangeToRelative(parameters, object2[0], object2[1]);
        }
        object2 = this.getWidth(parameters.get(Parameters.GeneralImage.\u00f5\u00d30000));
        Pair<Integer, Boolean> pair = this.getHeight(parameters.get(Parameters.GeneralImage.\u00d8\u00d30000));
        if (((Boolean)((Pair)object2).getItem2()).booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00f5\u00d30000, String.valueOf(((Pair)object2).getItem1()));
        }
        if (pair.getItem2().booleanValue()) {
            parameters.put(Parameters.GeneralImage.\u00d8\u00d30000, String.valueOf(pair.getItem1()));
        }
        TestPattern.Modes modes = TestPattern.Modes.\u00f500000;
        if (parameters.contains(Parameters.FileImage.\u00d800000)) {
            String string = parameters.get(Parameters.FileImage.\u00d800000).toUpperCase();
            try {
                modes = TestPattern.Modes.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        testPattern.setMode(modes);
        int n = 2;
        if (parameters.contains(Parameters.FileImage.new)) {
            object = parameters.get(Parameters.FileImage.new);
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        testPattern.setDistance(n);
        if (parameters.contains(Parameters.FileImage.if)) {
            object = parameters.get(Parameters.FileImage.if);
            String[] stringArray = ((String)object).split(",", 2);
            try {
                if (stringArray.length == 1) {
                    int n2 = ColorParser.parseColor(stringArray[0]);
                    testPattern.setColor(n2);
                } else {
                    int n3 = ColorParser.parseColor(stringArray[0]);
                    int n4 = ColorParser.parseColor(stringArray[0]);
                    testPattern.setMultiColor(n3, n4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parameters.contains(Parameters.GeneralImage.\u00d5\u00d40000)) {
            object = parameters.get(Parameters.GeneralImage.\u00d5\u00d40000);
            try {
                int n5 = ColorParser.parseColor((String)object);
                testPattern.setBackgroundColor(n5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (parameters.contains(Parameters.GeneralImage.\u00d3\u00d20000) || parameters.contains(Parameters.GeneralImage.thisObject) || parameters.contains(Parameters.GeneralImage.returnnew) || parameters.contains(Parameters.GeneralImage.nullObject) || parameters.contains(Parameters.GeneralImage.\u00f5\u00d20000)) {
            object = Arrays.copyOf(oO0000, 4);
            TestPatternImageRenderer.getRelativeRangeFromParameters(parameters, (double[])object);
            testPattern.setRange((double)object[0], (double)object[1], (double)object[2], (double)object[3]);
        } else {
            testPattern.setRange(0.0, 0.0, 1.0, 1.0);
        }
        object = (FSIImageLimited)testPattern.render((Pair<Integer, Boolean>)object2, pair);
        if (object != null) {
            if (parameters.contains(Parameters.GeneralImage.StringObject)) {
                try {
                    object = (FSIImageLimited)this.applyEffects((FSIImage)object, rendererImageResponse.getSelectionsRaw(), parameters);
                }
                catch (ProcessingException processingException) {
                    TestPatternImageRenderer.disposeImages(new FSIImage[]{object});
                    throw processingException;
                }
            }
            rendererImageResponse.setResponseImage((FSIImageLimited)object);
            rendererImageResponse.setStatus(200);
        }
        return rendererImageResponse;
    }

    private RendererResponse renderInfo(Parameters parameters) {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        try {
            String string = parameters.contains(Parameters.General.\u00d8\u00d40000) ? parameters.get(Parameters.General.\u00d8\u00d40000) : "info";
            Template template = this.Object.getTemplateCache().getTemplate(TemplateType.\u00d200000, string + ".ftl");
            TemplateAttributes templateAttributes = new TemplateAttributes(this.\u00d200000, template);
            templateAttributes.setRendererResponseContentType(rendererTextResponse);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", "file");
            hashMap.put("width", this.\u00f5O0000);
            hashMap.put("height", this.\u00f5O0000);
            HashMap<String, HashMap<String, Object>> hashMap2 = new HashMap<String, HashMap<String, Object>>();
            hashMap2.put("info", hashMap);
            try (StringWriterFast stringWriterFast = new StringWriterFast();){
                Environment environment = template.createProcessingEnvironment(hashMap2, (Writer)stringWriterFast);
                environment.process();
                rendererTextResponse.setBody(stringWriterFast.toString());
                rendererTextResponse.setStatus(200);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return TestPatternImageRenderer.generateNotFoundResponse();
        }
        catch (TemplateException | IOException throwable) {
            rendererTextResponse.setStatus(500);
            this.\u00d200000.logException((Exception)throwable, 3191, throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
        }
        return rendererTextResponse;
    }

    @Override
    public void setOption(String string, String string2) {
        if (string.equalsIgnoreCase("maxWidth")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("maxHeight")) {
            try {
                int n = Integer.valueOf(string2);
                if (n > 0) {
                    this.\u00d4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f4O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00d500000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        } else if (string.equalsIgnoreCase("maxDepth")) {
            try {
                int n = Integer.parseInt(string2);
                if (n > 0) {
                    this.\u00f5O0000 = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.\u00d200000.log(3043, string2, string, this.void);
            }
        }
    }

    @Override
    public String getOption(String string) {
        String string2 = null;
        if (string.equalsIgnoreCase("maxWidth")) {
            string2 = String.valueOf(this.\u00d5O0000);
        } else if (string.equalsIgnoreCase("maxHeight")) {
            string2 = String.valueOf(this.\u00d4O0000);
        } else if (string.equalsIgnoreCase("defaultWidth")) {
            string2 = String.valueOf(this.\u00f4O0000);
        } else if (string.equalsIgnoreCase("defaultHeight")) {
            string2 = String.valueOf(this.\u00d500000);
        } else if (string.equalsIgnoreCase("maxDepth")) {
            string2 = String.valueOf(this.\u00f5O0000);
        }
        return string2;
    }

    private FSIImage applyEffects(FSIImage fSIImage, byte[] byArray, Parameters parameters) throws ProcessingException {
        String string = parameters.get(Parameters.GeneralImage.StringObject);
        try {
            fSIImage = this.getEffectsManager().applyEffects(fSIImage, byArray, string, parameters);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.\u00d200000.log(3153, null, string, "");
        }
        return fSIImage;
    }
}

