/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.settings;

import com.neptunelabs.fsiserver.framework.helpers.ColorParser;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.fsiserver.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.fsiserver.requestprocessor.MetaDataSource;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.renderers.ImageLicenceRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererAbstract;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardDirectoryImageRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardImageRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardInfoRenderer;
import com.neptunelabs.fsiserver.requestprocessor.renderers.StandardListRenderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.OutputParameters;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Renderer {
    private final String \u00d8O0000;
    private final RequestProcessorSettings for;
    private RendererAbstract \u00d500000;
    private RendererAbstract \u00f800000;
    private RendererAbstract \u00d3O0000;
    private RendererAbstract \u00f500000;
    private RendererAbstract \u00f600000;
    private boolean \u00d2O0000 = false;
    private boolean \u00d800000 = false;
    private boolean \u00d600000 = false;
    private boolean \u00d200000 = false;
    private List<MetaDataSource> \u00d300000 = new ArrayList<MetaDataSource>();
    private boolean \u00d5O0000 = false;
    private OutputFormat private;
    private OutputParameters oO0000;
    private final List<String> null = new ArrayList<String>();
    private String o00000 = null;
    private final FSILogger \u00d6O0000;
    private boolean String = true;

    Renderer(RequestProcessorSettings requestProcessorSettings, boolean bl) {
        this.for = requestProcessorSettings;
        this.\u00d6O0000 = requestProcessorSettings.getLogger();
        if (!bl) {
            this.\u00d8O0000 = "_private";
            this.private = OutputFormat.\u00d500000;
            this.\u00d500000 = new StandardImageRenderer(requestProcessorSettings, this.\u00d8O0000);
            this.\u00d500000.addAllowedGroup("public");
            this.\u00d500000.setOption("keepAspectRatio", "true");
            this.\u00f800000 = new StandardDirectoryImageRenderer(requestProcessorSettings, this.\u00d8O0000);
            this.\u00d3O0000 = new StandardInfoRenderer(requestProcessorSettings, this.\u00d8O0000);
            this.\u00d3O0000.addAllowedGroup("public");
            this.\u00f500000 = new StandardListRenderer(requestProcessorSettings, this.\u00d8O0000);
        } else {
            this.\u00d8O0000 = "_licence";
            this.private = OutputFormat.\u00d400000;
            this.\u00f600000 = new ImageLicenceRenderer(requestProcessorSettings, this.\u00d8O0000);
        }
        this.oO0000 = new OutputParameters();
        this.String = true;
    }

    Renderer(RequestProcessorSettings requestProcessorSettings, Path path) {
        this.for = requestProcessorSettings;
        this.\u00d6O0000 = requestProcessorSettings.getLogger();
        String string = path.getFileName().toString().toLowerCase();
        if (string.endsWith(".xml")) {
            string = string.substring(0, string.length() - 4);
        }
        this.\u00d8O0000 = string;
        Document document = FileOperations.getXMLFileContent(this.\u00d6O0000, path);
        if (document != null) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string2 = node.getNodeName().toLowerCase();
                if (string2.equalsIgnoreCase("enabled")) {
                    this.String = Boolean.parseBoolean(node.getTextContent());
                    continue;
                }
                if (string2.equalsIgnoreCase("renderer") || string2.equalsIgnoreCase("imagerenderer")) {
                    this.readImageRendererNode(node, hashMap);
                    this.\u00d2O0000 = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("directoryimagerenderer")) {
                    this.readImageRendererNode(node, hashMap2);
                    this.\u00d800000 = true;
                    continue;
                }
                if (string2.equalsIgnoreCase("inforenderer")) {
                    this.readInfoRendererNode(node, hashMap3);
                    continue;
                }
                if (string2.equalsIgnoreCase("listrenderer")) {
                    this.readListRendererNode(node, hashMap4);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("outputcompression") || node.getNodeName().equalsIgnoreCase("output")) {
                    this.oO0000 = this.readOutputNode(node, path);
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("outputeffects")) continue;
                this.readOutputEffectsNode(node);
            }
            this.initImageRenderer(this.\u00d8O0000, hashMap);
            this.initDirectoryImageRenderer(this.\u00d8O0000, hashMap2);
            this.initInfoRenderer(this.\u00d8O0000, hashMap3);
            this.initListRenderer(this.\u00d8O0000, hashMap4);
            if (this.private == null || this.oO0000 == null) {
                this.\u00d6O0000.log(2025, this.\u00d8O0000);
                this.\u00d5O0000 = true;
            }
        }
        if (this.\u00d5O0000) {
            this.String = false;
        }
    }

    private void readOutputEffectsNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equalsIgnoreCase("effect")) continue;
            this.null.add(node2.getTextContent());
        }
        this.o00000 = null;
    }

    private OutputParameters readOutputNode(Node node, Path path) {
        OutputParameters outputParameters = new OutputParameters();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeName().equalsIgnoreCase("compressor") || node2.getNodeName().equalsIgnoreCase("format")) {
                String string = node2.getTextContent().toUpperCase();
                if (string.equals("JPG")) {
                    string = "JPEG";
                }
                this.private = OutputFormat.valueOf(string);
                continue;
            }
            boolean bl = false;
            String string = node2.getNodeName().toLowerCase();
            String string2 = node2.getTextContent();
            if (string.equals("quality")) {
                try {
                    outputParameters.if = Integer.parseInt(string2);
                    if (outputParameters.if < 0 && outputParameters.if > 100) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            } else if (string.equals("compressionlevel")) {
                try {
                    outputParameters.oO0000 = Integer.parseInt(string2);
                    if (outputParameters.oO0000 < 0 && outputParameters.oO0000 > 9) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            } else if (string.equals("compressionfilter")) {
                if (string2.equals("none") || string2.equals("0")) {
                    outputParameters.\u00d5O0000 = 0;
                } else if (string2.equals("sub") || string2.equals("1")) {
                    outputParameters.\u00d5O0000 = 1;
                } else {
                    bl = true;
                }
            } else if (string.equals("chromasubsampling")) {
                if (string2.equals("4:2:0")) {
                    outputParameters.thissuper = JPEGPreparation.ChromaSubsampling.\u00d300000;
                } else if (string2.equals("4:2:2")) {
                    outputParameters.thissuper = JPEGPreparation.ChromaSubsampling.new;
                } else if (string2.equals("4:4:4")) {
                    outputParameters.thissuper = JPEGPreparation.ChromaSubsampling.\u00d400000;
                } else {
                    bl = true;
                }
            } else if (string.equals("optimizehuffman")) {
                outputParameters.\u00d300000 = Boolean.getBoolean(string2);
            } else if (string.equals("dpi")) {
                try {
                    outputParameters.\u00d500000 = Integer.parseInt(string2);
                    if (outputParameters.\u00d500000 < 0 && outputParameters.\u00d500000 > 25600) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            } else if (string.equals("encoding")) {
                try {
                    outputParameters.\u00d400000 = OutputParameters.Encoding.valueOf(string2.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("colorspace")) {
                try {
                    outputParameters.\u00f800000 = OutputParameters.Colorspace.valueOf(string2.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("embedicc")) {
                try {
                    outputParameters.\u00f400000 = Boolean.valueOf(string2.toLowerCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("backgroundcolor")) {
                try {
                    outputParameters.return = ColorParser.parseColor(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("maxcolors")) {
                try {
                    outputParameters.\u00d800000 = Integer.parseInt(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("serpentine")) {
                try {
                    outputParameters.new = Boolean.parseBoolean(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("ditherer")) {
                try {
                    outputParameters.o00000 = ImageEncoderUtils.DithererMode.valueOf(string2.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("quantizer")) {
                try {
                    outputParameters.OO0000 = ImageEncoderUtils.QuantizerMode.valueOf(string2.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("quantizersampledepth")) {
                try {
                    outputParameters.\u00d4O0000 = Integer.parseInt(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("loop")) {
                try {
                    outputParameters.\u00d3O0000 = Integer.parseInt(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("delay")) {
                try {
                    outputParameters.\u00f500000 = Integer.parseInt(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            } else if (string.equals("framepalette")) {
                try {
                    outputParameters.while = Boolean.parseBoolean(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.\u00d6O0000.log(3043, string2, string, path);
            break;
        }
        return outputParameters;
    }

    private void readListRendererNode(Node node, Map<String, String> map) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.\u00d200000 = true;
            Node node2 = nodeList.item(i);
            map.put(node2.getNodeName().toLowerCase(), node2.getTextContent());
        }
    }

    private void readImageRendererNode(Node node, Map<String, String> map) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            map.put(node2.getNodeName().toLowerCase(), node2.getTextContent());
        }
    }

    private void readInfoRendererNode(Node node, Map<String, String> map) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.\u00d600000 = true;
            Node node2 = nodeList.item(i);
            map.put(node2.getNodeName().toLowerCase(), node2.getTextContent());
        }
    }

    private void initImageRenderer(String string, Map<String, String> map) {
        if (this.\u00d2O0000) {
            if (map.containsKey("implementation")) {
                String string2 = "com.neptunelabs.fsiserver.requestprocessor.renderers." + map.get("implementation");
                map.remove("implementation");
                try {
                    Constructor<?> object = Class.forName(string2).getConstructor(RequestProcessorSettings.class, String.class);
                    this.\u00d500000 = (RendererAbstract)object.newInstance(this.for, this.\u00d8O0000);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    this.\u00d6O0000.log(2031, string2, string);
                    this.\u00d5O0000 = true;
                }
            } else {
                this.\u00d500000 = new StandardImageRenderer(this.for, this.\u00d8O0000);
            }
            if (!this.\u00d5O0000) {
                this.setupAllowedGroups(map, this.\u00d500000, this.\u00d8O0000);
                for (Map.Entry entry : map.entrySet()) {
                    this.\u00d500000.setOption((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private void setupAllowedGroups(Map<String, String> map, RendererAbstract rendererAbstract, String string) {
        if (map.containsKey("allowedgroups")) {
            String[] stringArray;
            String string2 = map.get("allowedgroups");
            for (String string3 : stringArray = string2.split(",")) {
                rendererAbstract.addAllowedGroup(string3.trim());
            }
            map.remove("allowedgroups");
        } else {
            this.\u00d6O0000.log(2049, string);
        }
    }

    private void initDirectoryImageRenderer(String string, Map<String, String> map) {
        if (this.\u00d800000) {
            if (map.containsKey("implementation")) {
                String string2 = "com.neptunelabs.fsiserver.requestprocessor.renderers." + map.get("implementation");
                map.remove("implementation");
                try {
                    Constructor<?> object = Class.forName(string2).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] objectArray = new Object[]{this.for, this.\u00d8O0000};
                    this.\u00f800000 = (RendererAbstract)object.newInstance(objectArray);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    this.\u00d6O0000.log(2031, string2, string);
                    this.\u00d5O0000 = true;
                }
            } else {
                this.\u00f800000 = new StandardDirectoryImageRenderer(this.for, this.\u00d8O0000);
            }
            if (!this.\u00d5O0000) {
                this.setupAllowedGroups(map, this.\u00f800000, this.\u00d8O0000);
                for (Map.Entry entry : map.entrySet()) {
                    this.\u00f800000.setOption((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private void initInfoRenderer(String string, Map<String, String> map) {
        if (this.\u00d600000) {
            if (map.containsKey("implementation")) {
                String string2 = "com.neptunelabs.fsiserver.requestprocessor.renderers." + map.get("implementation");
                map.remove("implementation");
                try {
                    Constructor<?> object = Class.forName(string2).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] objectArray = new Object[]{this.for, this.\u00d8O0000};
                    this.\u00d3O0000 = (RendererAbstract)object.newInstance(objectArray);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    this.\u00d6O0000.log(2031, string2, string);
                    this.\u00d5O0000 = true;
                }
            } else {
                this.\u00d3O0000 = new StandardInfoRenderer(this.for, this.\u00d8O0000);
            }
            if (!this.\u00d5O0000) {
                this.setupAllowedGroups(map, this.\u00d3O0000, this.\u00d8O0000);
                for (Map.Entry entry : map.entrySet()) {
                    this.\u00d3O0000.setOption((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private void initListRenderer(String string, Map<String, String> map) {
        if (this.\u00d200000) {
            if (map.containsKey("implementation")) {
                String string2 = "com.neptunelabs.fsiserver.requestprocessor.renderers." + map.get("implementation");
                map.remove("implementation");
                try {
                    Constructor<?> object = Class.forName(string2).getConstructor(RequestProcessorSettings.class, String.class);
                    Object[] objectArray = new Object[]{this.for, this.\u00d8O0000};
                    this.\u00f500000 = (RendererAbstract)object.newInstance(objectArray);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    this.\u00d6O0000.log(2031, string2, string);
                    this.\u00d5O0000 = true;
                }
            } else {
                this.\u00f500000 = new StandardListRenderer(this.for, this.\u00d8O0000);
            }
            if (!this.\u00d5O0000) {
                this.setupAllowedGroups(map, this.\u00f500000, this.\u00d8O0000);
                for (Map.Entry entry : map.entrySet()) {
                    this.\u00f500000.setOption((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    public OutputFormat getOutputFormat() {
        return this.private;
    }

    public OutputParameters getOutputParameters() {
        return this.oO0000;
    }

    public String getName() {
        return this.\u00d8O0000;
    }

    boolean hasFatalErrors() {
        return this.\u00d5O0000;
    }

    public List<MetaDataSource> getMetaDataSources() {
        return this.\u00d300000;
    }

    public void setMetaDataSources(List<MetaDataSource> list) {
        this.\u00d300000 = list;
    }

    public RendererAbstract getImageRenderer() {
        return this.\u00d500000 != null ? this.\u00d500000 : (this.\u00f600000 != null ? this.\u00f600000 : null);
    }

    public RendererAbstract getDirectoryImageRenderer() {
        return this.\u00f800000;
    }

    public RendererAbstract getLicenceRenderer() {
        return this.\u00f600000;
    }

    public RendererAbstract getInfoRenderer() {
        return this.\u00d3O0000;
    }

    public RendererAbstract getListRenderer() {
        return this.\u00f500000;
    }

    public List<String> getOutputEffects() {
        return this.null;
    }

    public String getOutputEffectsChecksum() {
        if (this.o00000 == null) {
            this.o00000 = java.lang.String.valueOf(this.null.hashCode());
        }
        return this.o00000;
    }

    public boolean isEnabled() {
        return this.String;
    }
}

