/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.requestprocessor.settings;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.neptunelabs.fsiserver.download.DownloadJobProcessor;
import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateCache;
import com.neptunelabs.fsiserver.framework.helpers.FileEventCallback;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.jmx.MBeanUtils;
import com.neptunelabs.fsiserver.framework.licensing.Licence;
import com.neptunelabs.fsiserver.framework.licensing.RawLicence;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.framework.settings.Section;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorGeneral;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorGeneralMBean;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorLicence;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorLicenceMBean;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorPerformance;
import com.neptunelabs.fsiserver.mbeans.FSIRequestProcessorPerformanceMBean;
import com.neptunelabs.fsiserver.requestprocessor.LogWatcher;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.requestprocessor.settings.Renderer;
import com.neptunelabs.fsiserver.requestprocessor.settings.ServerOnlyAccessValidation;
import com.neptunelabs.fsiserver.requestprocessor.settings.super;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.HeadersReader;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.ServletUtils;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.Version;
import com.yworks.util.annotation.Obfuscation;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;

public class RequestProcessorSettings
extends FSIServerSettings {
    private final Map<String, Renderer> fornew = new HashMap<String, Renderer>();
    private final CopyOnWriteArrayList<String> \u00d2\u00d30000 = new CopyOnWriteArrayList();
    private final Map<String, LogWatcher> \u00d3\u00d30000 = new HashMap<String, LogWatcher>();
    private HeadersReader \u00f8\u00d20000;
    private Path \u00d5\u00d30000;
    private super privatenew;
    private ServerOnlyAccessValidation o\u00d30000;
    private TemplateCache \u00f5\u00d20000;
    private boolean \u00f6\u00d20000 = false;

    public RequestProcessorSettings(ServletContext servletContext) {
        super(servletContext, false, true);
        if (servletContext != null) {
            SoftwareVersion.setSoftware(this.getLogger(), new Version());
            if (this.getConfigHome() != null) {
                this.setSettingsFile(this.getConfigHome().resolve("requestprocessor.xml"));
            }
            if (this.getLicenceLocation() != null) {
                this.setLicenceFile(this.getLicenceLocation(), 22, 3);
            }
            this.\u00f8\u00d20000 = new HeadersReader(this.getLogger());
            this.initDefaults();
            this.writeOutLMR();
        }
    }

    protected RequestProcessorSettings(FSILogger fSILogger, FileEventCursor fileEventCursor, EffectsManager effectsManager) {
        super(null, false, true);
        SoftwareVersion.setSoftware(fSILogger, new Version());
        this.\u00f8\u00d20000 = new HeadersReader(fSILogger);
    }

    private void writeOutLMR() {
        String string = this.getSystemInformation().getLMR();
        int n = 70;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = (int)Math.ceil((float)string.length() / 70.0f);
        for (int i = 0; i < n2; ++i) {
            int n3 = i * 70;
            int n4 = i + 1 < n2 ? (i + 1) * 70 : string.length();
            stringBuilder.append(string.substring(n3, n4));
            stringBuilder.append(System.getProperty("line.separator"));
        }
        String string2 = stringBuilder.toString();
        byte[] byArray = string2.getBytes(FileOperations.new);
        FileOperations.writeFile(this.getLogger(), this.getConfigHome().resolve(Defines.\u00d3O0000), byArray);
    }

    public void init() {
        this.initWorkDirectory();
        this.initLogWatcher();
    }

    private void initWorkDirectory() {
        Path path;
        Path path2;
        String string;
        FSILogger fSILogger = this.getLogger();
        Path path3 = this.getTempDirectory();
        if (Files.notExists(path3, new LinkOption[0])) {
            try {
                Files.createDirectories(path3, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                path3 = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                fSILogger.log(2010, path3);
            }
        }
        if ((string = this.getPrefsString("application", "tempdirectory")) == null || string.equals("") || string.equalsIgnoreCase("auto")) {
            string = path3.toAbsolutePath().toString();
        }
        if (Files.notExists(path2 = !(path = Paths.get(string, new String[0])).isAbsolute() ? ServletUtils.getRealPath(this.\u00d300000, path.toString()) : path, new LinkOption[0])) {
            path2 = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        }
        this.\u00d5\u00d30000 = path2.resolve("requestprocessor");
        if (Files.notExists(this.\u00d5\u00d30000, new LinkOption[0])) {
            try {
                Files.createDirectories(this.\u00d5\u00d30000, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                fSILogger.log(3199, this.\u00d5\u00d30000);
            }
        } else {
            try {
                FileOperations.deleteDir(this.\u00d5\u00d30000);
                Files.createDirectories(this.\u00d5\u00d30000, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Path getWorkDirectory() {
        return this.\u00d5\u00d30000;
    }

    public DownloadJobProcessor getJobProcessor() {
        Object object = this.\u00d300000.getAttribute("JobProcessor");
        if (object instanceof DownloadJobProcessor) {
            return (DownloadJobProcessor)object;
        }
        return null;
    }

    private void initDefaults() {
        HashMap<String, Section> hashMap = new HashMap<String, Section>();
        Section section = new Section(Section.SectionTypes.\u00d200000);
        section.enable(true);
        section.put("storage", this.getWebInfPath() + "/storage");
        section.put("storagehasher", "crc32");
        section.put("requestprocessortokens", "prod");
        section.put("sourcemanager", "");
        section.put("copyrightnotice", SoftwareVersion.getVendor());
        section.put("cachetemplates", "true");
        section.put("maxcpu", "auto");
        section.put("hasht", "true");
        section.put("maxio", Integer.toString(2));
        section.put("forcecputhreads", "");
        section.put("forceiothreads", "");
        section.put("tempdirectory", "auto");
        section.put("byteorder", "little_endian");
        section.put("jmx", "false");
        section.put("priority", "normal");
        section.put("corsAllowedOrigins", "*");
        section.put("corsAllowedMethods", "GET, PUT, DELETE, POST, HEAD, OPTIONS");
        section.put("corsAllowedHeaders", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers,Access-Control-Expose-Headers");
        section.put("corsExposedHeaders", "X-Comment,X-Software,X-Dim,X-Source-Dim,X-Source-Level");
        section.put("corsPreflightMaxage", "1800");
        section.put("corsSupportCredentials", "true");
        section.put("corsRequestDecorate", "true");
        int n = 250;
        section.put("executorPoolSize", Integer.toString(n));
        section.put("executorPoolMaximumSize", Integer.toString(n * 10));
        section.put("executorTimeOut", Integer.toString(60000));
        section.put("executorQueueCapacity", Integer.toString(n * 100));
        section.put("requestTimeout", Integer.toString(15000));
        hashMap.put("application", section);
        Section section2 = new Section(Section.SectionTypes.\u00d200000);
        section2.put("maxmemory", "auto");
        section2.put("directmemory", "false");
        section2.put("l1", "true");
        section2.put("l1size", "1000");
        section2.put("l2", "true");
        section2.put("response", "true");
        section2.put("packasync", "true");
        hashMap.put("cache", section2);
        Section section3 = new Section(Section.SectionTypes.\u00d200000);
        section3.enable(true);
        section3.put("defaultcmykprofile", "auto");
        section3.put("defaultrgbprofile", "auto");
        section3.put("defaultgrayprofile", "auto");
        section3.put("fallbackiccconversion", "true");
        hashMap.put("colormanagementsystem", section3);
        Section section4 = new Section(Section.SectionTypes.\u00d200000);
        section4.enable(true);
        section4.put("defaultrenderer", "default");
        section4.put("defaultwidth", String.valueOf(400));
        section4.put("defaultheight", String.valueOf(300));
        section4.put("maxwidth", String.valueOf(5120));
        section4.put("maxheight", String.valueOf(2880));
        section4.put("sortcollator", "auto");
        hashMap.put("limits", section4);
        Section section5 = new Section(Section.SectionTypes.\u00d200000);
        section5.enable(false);
        section5.put("type", "solr");
        section5.put("solrserveruri", "http://localhost/solr");
        section5.put("core", "fsi-server-3");
        section5.put("authentication", "false");
        section5.put("authenticationtype", "basic");
        section5.put("authenticationusername", "");
        section5.put("authenticationpassword", "");
        section5.put("proxy", "false");
        section5.put("proxyhostname", "");
        section5.put("proxyport", "80");
        section5.put("proxyssl", "false");
        section5.put("proxyauthentication", "false");
        section5.put("proxyusername", "");
        section5.put("proxypassword", "");
        section5.put("connectionpoolmax", "500");
        hashMap.put("search", section5);
        this.setDefaultSection(hashMap);
    }

    public boolean hasEnabledRenderer(String string) {
        return this.getEnabledRenderer(string) != null;
    }

    public Renderer getRenderer(String string) {
        return this.fornew.get(string);
    }

    public Renderer getEnabledRenderer(String string) {
        Renderer renderer = this.fornew.get(string);
        return renderer != null && renderer.isEnabled() ? renderer : null;
    }

    public Map<String, Renderer> getRenderers() {
        return this.fornew;
    }

    public String getImageCopyright() {
        return this.getPrefsString("application", "copyrightNotice");
    }

    private void initLogWatcher() {
        if (!this.hasLogWatcher(this.getStorageLocationPath())) {
            this.addLogWatcher(new LogWatcher(this));
        }
    }

    void cleanSourceConnector() {
        this.o\u00d20000.clear();
        this.o\u00d30000 = null;
    }

    void addSourceConnector(String string, SourceConnectorReader sourceConnectorReader) {
        this.o\u00d20000.put(string, sourceConnectorReader);
        if (this.o\u00d30000 != null) {
            // empty if block
        }
    }

    @Obfuscation
    public void readHeadersDefinition() {
        this.\u00f8\u00d20000.loadFromFile(this.getConfigHome().resolve("headers.xml"));
        this.\u00d300000.setAttribute("headers", (Object)this.\u00f8\u00d20000);
        this.getCacheManager().clearAll();
    }

    public final void initHeadersMonitor(FileEventCursor fileEventCursor) {
        if (fileEventCursor != null) {
            FileEventCallback fileEventCallback = new FileEventCallback(this, "readHeadersDefinition", null);
            ArrayList<FileEventCallback> arrayList = new ArrayList<FileEventCallback>();
            arrayList.add(fileEventCallback);
            try {
                fileEventCursor.addPathMonitor(this.getConfigHome().resolve("headers.xml"), arrayList);
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public Map<String, String> getHeaderSet(String string) {
        if (string != null) {
            return this.\u00f8\u00d20000.getHeaderSet(string);
        }
        return null;
    }

    public void readSourceConnectors() {
        if (this.privatenew != null) {
            this.privatenew.\u00d200000();
            try {
                this.privatenew.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            this.privatenew = new super(this);
            this.privatenew.start();
        }
        catch (NotConfiguredException notConfiguredException) {
            notConfiguredException.printStackTrace();
        }
    }

    public SourceConnectorReader getSourceConnector(String string) {
        if (string != null) {
            return (SourceConnectorReader)this.o\u00d20000.get(string);
        }
        return null;
    }

    public Set<String> getSourceConnectorNames() {
        return this.o\u00d20000.keySet();
    }

    public Path getRendererDirectory() {
        return this.getConfigHome().resolve("renderers");
    }

    @Obfuscation
    public void readRenderers() {
        Object object;
        block13: {
            this.fornew.clear();
            Renderer renderer = new Renderer(this, false);
            this.fornew.put(renderer.getName(), renderer);
            Renderer renderer2 = new Renderer(this, true);
            this.fornew.put(renderer2.getName(), renderer2);
            Path path = this.getRendererDirectory();
            FSILogger fSILogger = this.getLogger();
            if (Files.isDirectory(path, new LinkOption[0])) {
                try {
                    object = FileOperations.listAllFiles(path, "*.xml");
                    if (object != null && object.size() > 0) {
                        Iterator<PathCached> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            PathCached pathCached = iterator.next();
                            if (pathCached.isRegularFile()) {
                                try {
                                    String string = pathCached.getFileName();
                                    fSILogger.log(2055, string);
                                    Renderer renderer3 = new Renderer(this, pathCached.getPath());
                                    if (renderer3.hasFatalErrors()) {
                                        fSILogger.log(2027, string);
                                    } else if (!renderer3.isEnabled()) {
                                        fSILogger.log(2033, string);
                                    }
                                    if (this.fornew.containsKey(renderer3.getName())) continue;
                                    this.fornew.put(renderer3.getName(), renderer3);
                                }
                                catch (Exception exception) {
                                    fSILogger.logException(exception, 2042, pathCached, exception.getLocalizedMessage());
                                }
                                continue;
                            }
                            fSILogger.log(2026, pathCached);
                        }
                        break block13;
                    }
                    fSILogger.log(2028, path);
                }
                catch (IOException iOException) {
                    fSILogger.log(2028, path);
                }
            } else {
                fSILogger.log(2029, path);
            }
        }
        object = this.getCacheManager();
        if (object != null) {
            ((CacheManager)object).clearAll();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fornew.clear();
        for (LogWatcher logWatcher : this.\u00d3\u00d30000.values()) {
            logWatcher.halt();
            try {
                logWatcher.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.\u00d3\u00d30000.clear();
        if (this.privatenew != null) {
            this.privatenew.\u00d200000();
            try {
                this.privatenew.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public TemplateCache getTemplateCache() {
        return this.\u00f5\u00d20000;
    }

    public void setTemplateCache(TemplateCache templateCache) {
        this.\u00f5\u00d20000 = templateCache;
    }

    private boolean hasLogWatcher(String string) {
        return this.\u00d3\u00d30000.containsKey(string);
    }

    private void addLogWatcher(LogWatcher logWatcher) {
        this.\u00d3\u00d30000.put(logWatcher.getStorageLocation().toAbsolutePath().toString(), logWatcher);
        logWatcher.start();
    }

    private Path getLicenceLocation() {
        return this.getConfigHome().resolve(Defines.if);
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        this.\u00f6\u00d20000 = true;
        super.updateLicenceFromLicenceManager();
        if (this.\u00d300000 != null) {
            CacheManager cacheManager = this.getCacheManager();
            if (cacheManager != null) {
                cacheManager.clearAll();
            }
            this.\u00f6\u00d20000 = false;
        }
    }

    @Override
    protected void initMBeans() {
        FSILogger fSILogger = this.getLogger();
        if (System.getProperty("com.sun.management.jmxremote") == null) {
            fSILogger.log(2036, new Object[0]);
        } else if (System.getProperty("com.sun.management.jmxremote.port") != null) {
            fSILogger.log(2037, Integer.parseInt(System.getProperty("com.sun.management.jmxremote.port")));
        }
        this.\u00f5o0000.add(MBeanUtils.registerMBean(fSILogger, "FSI Server:Type=General", new FSIRequestProcessorGeneral(this.getSystemMonitor()), FSIRequestProcessorGeneralMBean.class));
        this.\u00f5o0000.add(MBeanUtils.registerMBean(fSILogger, "FSI Server:Type=Licence", new FSIRequestProcessorLicence(this), FSIRequestProcessorLicenceMBean.class));
        this.\u00f5o0000.add(MBeanUtils.registerMBean(fSILogger, "FSI Server:Type=Performance", new FSIRequestProcessorPerformance(this.getSystemMonitor()), FSIRequestProcessorPerformanceMBean.class));
    }

    public ObjectNode getLicenceInfoAsJSON(Licence licence, String string) {
        return this.getLicenceInfoAsJSON(licence, false, string);
    }

    public ObjectNode getLicenceInfoAsJSON(Licence licence, boolean bl, String string) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        FSIServerSettings.LicenceState licenceState = this.isLicensed(licence, bl);
        objectNode.put("licence_state", licenceState.name().toLowerCase());
        objectNode.put("hardwareid", this.getSystemInformation().getLMR());
        objectNode.put("min-version", licence.getNiceMinVersion());
        objectNode.put("max-version", licence.getNiceMaxVersion());
        objectNode.put("licensee", licence.getLicensee());
        objectNode.put("pid", licence.getPID());
        objectNode.put("edition", licence.getEdition());
        if (licence.getFlagNFR()) {
            objectNode.put("nfr", licence.getFlagNFR());
        }
        if (licence.getFlagNonProfit()) {
            objectNode.put("non-profit", licence.getFlagNonProfit());
        }
        objectNode.put("jmx", licence.isJMXEnabled());
        if (licence.isStagingLicence()) {
            objectNode.put("staging", licence.isStagingLicence());
        }
        objectNode.put("batch-processing", licence.isBatchProcessingEnabled());
        objectNode.put("mirror-licence", licence.isMirrorLicence());
        objectNode.put("trial-licence", licence.isTrialLicence());
        objectNode.put("register-date", licence.getRegisterTime());
        ObjectNode objectNode2 = objectMapper.createObjectNode();
        objectNode2.put("current", this.getSystemMonitor().getAssetCount());
        objectNode2.put("max", licence.getMaxImages());
        objectNode.set("images", (JsonNode)objectNode2);
        ObjectNode objectNode3 = objectMapper.createObjectNode();
        objectNode3.put("current", this.getSourceConnectorCount());
        objectNode3.put("max", licence.getMaxConnectors());
        objectNode.set("connectors", (JsonNode)objectNode3);
        ObjectNode objectNode4 = objectMapper.createObjectNode();
        objectNode4.put("current", this.getUserAuthenticationInterface().getGroupCount());
        objectNode4.put("max", licence.getMaxUserGroups());
        objectNode.set("groups", (JsonNode)objectNode4);
        if (licence.getExpireTime() > 0L) {
            objectNode.put("expires", licence.getExpireTime());
        }
        ObjectNode objectNode5 = objectMapper.createObjectNode();
        objectNode5.put("current", this.getSystemMonitor().getServerInstances());
        objectNode5.put("max", licence.getMaxInstances());
        objectNode.set("instances", (JsonNode)objectNode5);
        RawLicence rawLicence = this.getLicenceManager().getRawLicence(101, 6);
        objectNode.put("fsi_viewer", rawLicence != null);
        Map<String, String> map = licence.getModules();
        if (map.containsKey("PagesMobile") && Boolean.parseBoolean(map.get("PagesMobile"))) {
            objectNode.put("fsi_pages_mobile", true);
        }
        objectNode.put("_container-hash", string);
        return objectNode;
    }

    @Override
    public FSILogger getLogger() {
        if (this.\u00d300000 != null) {
            Object object = this.\u00d300000.getAttribute("logger.requestprocessor");
            if (object != null) {
                return (FSILogger)object;
            }
            return null;
        }
        return null;
    }
}

