/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.processors;

import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.framework.helpers.Escaper;
import com.neptunelabs.fsiserver.framework.io.StringWriterFast;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SearchProcessor {
    final RequestProcessorSettings super;

    SearchProcessor(RequestProcessorSettings requestProcessorSettings) {
        this.super = requestProcessorSettings;
    }

    public abstract RendererTextResponse search(SolrSearcher var1, Parameters var2, HttpSession var3);

    List<String> getValidConnectors(UserAuthenticationInterface userAuthenticationInterface, HttpSession httpSession, SourceConnectorReader sourceConnectorReader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (sourceConnectorReader == null) {
            Set<String> set = this.super.getSourceConnectorNames();
            for (String string : set) {
                SourceConnectorReader sourceConnectorReader2 = this.super.getSourceConnector(string);
                PermissionSet permissionSet = userAuthenticationInterface.getPermissions(sourceConnectorReader2, httpSession, true);
                if (!permissionSet.list.searchResults.booleanValue() || !permissionSet.list.connector.booleanValue()) continue;
                arrayList.add(string);
            }
        } else {
            PermissionSet permissionSet = userAuthenticationInterface.getPermissions(sourceConnectorReader, httpSession, true);
            if (permissionSet.list.searchResults.booleanValue()) {
                arrayList.add(sourceConnectorReader.getPrefix());
            }
        }
        return arrayList;
    }

    void renderResult(List<MetaData> list, RendererTextResponse rendererTextResponse, String string, int n, Template template) throws IOException, TemplateException {
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Map> arrayList = new ArrayList<Map>(100);
        TemplateAttributes templateAttributes = new TemplateAttributes(this.super.getLogger(), template);
        templateAttributes.setRendererResponseContentType(rendererTextResponse);
        Escaper.EscaperType escaperType = templateAttributes.getStaticEscape();
        if (list != null) {
            for (MetaData object2 : list) {
                arrayList.add(this.getSimpleHashFromMetaData(object2, escaperType, stringBuffer));
            }
        }
        hashMap.put("currentDir", this.escapeString("/", escaperType));
        HashMap hashMap2 = new HashMap();
        hashMap2.put("entryCount", n);
        hashMap2.put("imageCount", n);
        hashMap2.put("directoryCount", 0);
        hashMap2.put("completeCount", n);
        hashMap2.put("lastModified", System.currentTimeMillis());
        if (string != null) {
            hashMap2.put("message", this.escapeString(string, escaperType));
        }
        hashMap.put("summary", hashMap2);
        ArrayList<Map> arrayList2 = new ArrayList<Map>();
        for (Map map : arrayList) {
            arrayList2.add(map);
        }
        hashMap.put("ilist", arrayList2);
        this.renderTemplate(template, hashMap, rendererTextResponse);
        rendererTextResponse.setETagModifier(stringBuffer.toString());
    }

    private void renderTemplate(Template template, Map map, RendererTextResponse rendererTextResponse) throws TemplateException, IOException {
        try (StringWriterFast stringWriterFast = new StringWriterFast();){
            TemplateModel templateModel;
            Environment environment = template.createProcessingEnvironment((Object)map, (Writer)stringWriterFast);
            environment.process();
            TemplateModel templateModel2 = environment.getVariable("ContentType");
            if (templateModel2 != null) {
                rendererTextResponse.setContentType(templateModel2.toString());
            }
            if ((templateModel = environment.getVariable("CacheControl")) != null) {
                rendererTextResponse.setHeader("Cache-Control", templateModel.toString());
            }
            stringWriterFast.flush();
            stringWriterFast.close();
            rendererTextResponse.setBody(stringWriterFast.toString());
        }
    }

    private Map getSimpleHashFromMetaData(MetaData metaData, Escaper.EscaperType escaperType, StringBuffer stringBuffer) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.escapeString(metaData.getAssetURLPath(), escaperType);
        stringBuffer.append(string);
        hashMap.put("src", string);
        if (metaData instanceof ImageMetaData) {
            int n;
            ImageMetaData imageMetaData = (ImageMetaData)metaData;
            if (imageMetaData.getWidth() > 0) {
                n = imageMetaData.getWidth();
                hashMap.put("width", n);
                stringBuffer.append(n);
            }
            if (imageMetaData.getHeight() > 0) {
                n = imageMetaData.getHeight();
                hashMap.put("height", n);
                stringBuffer.append(n);
            }
            hashMap.put("alpha", Boolean.toString(imageMetaData.hasAlpha()));
            if (imageMetaData.getImportStatus() != 0) {
                hashMap.put("importstatus", imageMetaData.getImportStatus());
                stringBuffer.append(imageMetaData.getImportStatus());
            }
        }
        hashMap.put("lastmodified", metaData.getLastModified());
        stringBuffer.append(metaData.getLastModified());
        if (metaData instanceof FileMetaData) {
            hashMap.put("size", ((FileMetaData)metaData).getSourceFileSize());
        }
        if (metaData instanceof DirectoryMetaData) {
            hashMap.put("type", "directory");
        } else {
            hashMap.put("type", "file");
        }
        return hashMap;
    }

    private String escapeString(String string, Escaper.EscaperType escaperType) {
        String string2;
        if (string == null) {
            return "";
        }
        switch (escaperType) {
            case o00000: {
                string2 = Escaper.escapeForXML(string);
                break;
            }
            case \u00d400000: {
                string2 = Escaper.escapeForXMLURI(string);
                break;
            }
            case new: {
                string2 = Escaper.escapeForURIXML(string);
                break;
            }
            case \u00d500000: {
                string2 = Escaper.escapeForJSON(string);
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    public static class SearchResult {
        public List<MetaData> \u00d200000 = null;
        public int o00000 = 0;
    }
}

