/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.search.processors;

import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.TemplateAttributes;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererTextResponse;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.search.DataTypeMapping;
import com.neptunelabs.fsiserver.search.SearchException;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SimpleSearchProcessor
extends SearchProcessor {
    public SimpleSearchProcessor(RequestProcessorSettings requestProcessorSettings) {
        super(requestProcessorSettings);
    }

    @Override
    public RendererTextResponse search(SolrSearcher solrSearcher, Parameters parameters, HttpSession httpSession) {
        RendererTextResponse rendererTextResponse;
        boolean bl = false;
        UserAuthenticationInterface userAuthenticationInterface = this.super.getUserAuthenticationInterface();
        Object object = null;
        if (httpSession != null) {
            object = httpSession.getAttribute("id");
        }
        if (userAuthenticationInterface != null && httpSession != null && object != null) {
            bl = userAuthenticationInterface.validateSession((String)httpSession.getAttribute("id")) == UserAuthenticationInterface.SessionStatus.\u00d300000;
        }
        boolean bl2 = false;
        if (bl || parameters.getAssetURLPath() != null) {
            bl2 = true;
        }
        if (!bl2) {
            rendererTextResponse = new RendererTextResponse();
            rendererTextResponse.setStatus(403);
        } else {
            rendererTextResponse = this.search(solrSearcher, parameters, userAuthenticationInterface, httpSession);
        }
        return rendererTextResponse;
    }

    private Set<String> parseQuery(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    boolean bl2 = bl = !bl;
                }
                if (c == ' ' && !bl) {
                    if (stringBuilder.toString().trim().length() <= 0) continue;
                    hashSet.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue;
                }
                stringBuilder.append(c);
            }
            if (stringBuilder.toString().trim().length() > 0) {
                hashSet.add(stringBuilder.toString());
            }
        }
        return hashSet;
    }

    private RendererTextResponse search(SolrSearcher solrSearcher, Parameters parameters, UserAuthenticationInterface userAuthenticationInterface, HttpSession httpSession) {
        RendererTextResponse rendererTextResponse = new RendererTextResponse();
        Set<String> set = this.parseContext(parameters.get(Parameters.Search.forsuper));
        if (set.size() == 0) {
            rendererTextResponse.setStatus(400);
            rendererTextResponse.setStatusMessage("Unknown or missing context.");
            rendererTextResponse.setBody("Unknown or missing context.");
        } else {
            Set<String> set2 = this.parseQuery(parameters.get(Parameters.Search.\u00d8o0000));
            if (set2.size() == 0) {
                rendererTextResponse.setStatus(400);
                rendererTextResponse.setStatusMessage("Invalid or empty search query.");
                rendererTextResponse.setBody("Invalid or empty search query.");
            } else {
                try {
                    String string = parameters.contains(Parameters.General.\u00d8\u00d40000) ? parameters.get(Parameters.General.\u00d8\u00d40000) : "image_list.xml";
                    Template template = this.super.getTemplateCache().getTemplate(TemplateType.super, string + ".ftl");
                    TemplateAttributes templateAttributes = new TemplateAttributes(this.super.getLogger(), template);
                    String string2 = templateAttributes.getStaticTypeFilter();
                    if (solrSearcher != null) {
                        SearchProcessor.SearchResult searchResult;
                        List<String> list;
                        String string3;
                        Object object;
                        int n = -1;
                        int n2 = -1;
                        if (parameters.contains(Parameters.Search.\u00d4o0000) && ((String[])(object = (string3 = parameters.get(Parameters.Search.\u00d4o0000)).split(","))).length == 2) {
                            n2 = Integer.parseInt(object[0]);
                            n = Integer.parseInt(object[1]);
                        }
                        if (!(list = this.getValidConnectors(userAuthenticationInterface, httpSession, (SourceConnectorReader)(object = this.super.getSourceConnectorFromAssetURLPath(string3 = parameters.get(Parameters.General.privateObject))))).isEmpty()) {
                            SolrUpdater solrUpdater;
                            String string4 = parameters.get(Parameters.Search.\u00d8o0000);
                            if (httpSession != null && userAuthenticationInterface.validateSession((String)httpSession.getAttribute("id")) == UserAuthenticationInterface.SessionStatus.\u00d300000 && this.super.getServletContext().getAttribute("com.neptunelabs.fsiserver.SolrUpdater") != null && (solrUpdater = (SolrUpdater)this.super.getServletContext().getAttribute("com.neptunelabs.fsiserver.SolrUpdater")).isEnabled()) {
                                solrUpdater.waitForPseudoFlush();
                            }
                            searchResult = solrSearcher.search(string4, string3, list, set, string2, n2, n, parameters.get(Parameters.Sorting.\u00d3\u00d50000), parameters.get(Parameters.Sorting.O\u00d50000));
                        } else {
                            searchResult = new SearchProcessor.SearchResult();
                        }
                        this.renderResult(searchResult.\u00d200000, rendererTextResponse, null, searchResult.o00000, template);
                    } else {
                        this.renderResult(null, rendererTextResponse, this.super.getLogger().getLogMessage(3213, new Object[0]), 0, template);
                    }
                    rendererTextResponse.setStatus(200);
                }
                catch (NoSuchFileException noSuchFileException) {
                    rendererTextResponse.setStatus(404);
                    rendererTextResponse.setBody("{\"statuscode\":\"404\",\"cause\":\"" + noSuchFileException.getMessage() + "\"}");
                }
                catch (SearchException | TemplateException | IOException throwable) {
                    this.super.getLogger().logException((Exception)throwable, 3186, throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
                    rendererTextResponse.setStatus(500);
                    rendererTextResponse.setBody("{\"statuscode\":\"500\",\"cause\":\"" + throwable.getMessage() + "\"}");
                }
            }
        }
        return rendererTextResponse;
    }

    private Set<String> parseContext(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string != null) {
            String[] stringArray = string.split(",");
            Set<String> set = DataTypeMapping.getInstance().getValidContexts();
            for (String string2 : stringArray) {
                String string3 = string2.trim();
                if (!set.contains(string3)) continue;
                hashSet.add(string3);
            }
        }
        return hashSet;
    }
}

