/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.servlet;

import com.neptunelabs.fsiserver.framework.SoftwareVersion;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateCache;
import com.neptunelabs.fsiserver.framework.freemarker.TemplateType;
import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.FormatBytes;
import com.neptunelabs.fsiserver.framework.helpers.deletepool.DeletePool;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.FileEventCursor;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.MemoryManager;
import com.neptunelabs.fsiserver.framework.io.PluginLoader;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.framework.prerequisites.JavaEEServer;
import com.neptunelabs.fsiserver.framework.prerequisites.Prerequisites;
import com.neptunelabs.fsiserver.framework.systeminformation.JavaInformation;
import com.neptunelabs.fsiserver.framework.systeminformation.OperatingSystem;
import com.neptunelabs.fsiserver.framework.systeminformation.SystemInformation;
import com.neptunelabs.fsiserver.framework.systeminformation.VMVendor;
import com.neptunelabs.fsiserver.imageio.MimeTypesLoader;
import com.neptunelabs.fsiserver.imageioimpl.common.Register;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagereader.ImageFormatScanner;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.Parameters;
import com.neptunelabs.fsiserver.requestprocessor.effects.EffectsManager;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.GIFCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.JPEGCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.JPEGTurboCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.OutputFormat;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.PNGCompressor;
import com.neptunelabs.fsiserver.requestprocessor.outputcompressors.SWFCompressor;
import com.neptunelabs.fsiserver.requestprocessor.requesthandlers.StaticFileRequestHandler;
import com.neptunelabs.fsiserver.requestprocessor.settings.RequestProcessorSettings;
import com.neptunelabs.fsiserver.requestprocessor.settings.ServerOnlyAccessValidation;
import com.neptunelabs.fsiserver.search.SDBChecker;
import com.neptunelabs.fsiserver.search.processors.DefaultSearchProcessor;
import com.neptunelabs.fsiserver.search.processors.SearchProcessor;
import com.neptunelabs.fsiserver.search.processors.SimpleSearchProcessor;
import com.neptunelabs.fsiserver.search.solr.SearchDatabaseSolr;
import com.neptunelabs.fsiserver.search.solr.SolrSearcher;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.DeleteDaemon;
import com.neptunelabs.fsiserver.sourcemanager.DirectoryImportHandler;
import com.neptunelabs.fsiserver.sourcemanager.ScannerDaemon;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.LDAPAuthentication;
import com.neptunelabs.fsiserver.utils.ServletUtils;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.StorageLockHandler;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiserver.utils.XMLFileAuthentication;
import com.yworks.util.annotation.Obfuscation;
import freemarker.template.Configuration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;

@WebListener
@Obfuscation
public class AppContextListener
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger("FSIServer");

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            Path path = this.setupConfigHome(servletContext);
            FSILogger fSILogger = this.initRequestProcessorLogger(servletContext, path);
            FSILogger fSILogger2 = this.initSourceManagerLogger(servletContext, path);
            FSILogger fSILogger3 = this.initAPILogger(servletContext, path);
            SystemInformation systemInformation = this.initSystemInformation(servletContext);
            SoftwareVersion.setSoftware(fSILogger, new Version());
            this.initBaseClasses(servletContext, fSILogger);
            this.initFileLockHandler(servletContext);
            SystemMonitor systemMonitor = this.initSystemMonitor(servletContext);
            EffectsManager effectsManager = this.initEffectManager(servletContext, fSILogger);
            FileEventCursor fileEventCursor = this.initFileEventCursor(servletContext, fSILogger);
            String string = systemInformation.getJVMVersionDetailed();
            string = systemInformation.is64() ? string + " 64 Bit" : string + " 32 Bit";
            fSILogger.log(2001, SoftwareVersion.getSoftware(true), servletContext.getServerInfo(), string);
            fSILogger2.log(2001, SoftwareVersion.getSoftware(true), servletContext.getServerInfo(), string);
            fSILogger.log(2935, "Vendor", systemInformation.getJVMInformation());
            fSILogger2.log(2935, "Vendor", systemInformation.getJVMInformation());
            JavaInformation javaInformation = new JavaInformation();
            List<String> list = javaInformation.getStartOptions();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
                if (i >= list.size() - 1) continue;
                stringBuilder.append(' ');
            }
            fSILogger.log(2935, "Start Options", stringBuilder.toString());
            fSILogger2.log(2935, "Start Options", stringBuilder.toString());
            MemoryManager memoryManager = MemoryManager.getInstance();
            long l = memoryManager.getMaxYoungGen();
            if (l > 0L) {
                fSILogger.log(2935, "Max Old/Young Gen", FormatBytes.byteToString(memoryManager.getMaxOldGen(), 3, 1) + "/" + FormatBytes.byteToString(memoryManager.getMaxYoungGen(), 3, 1));
                fSILogger2.log(2935, "Max Old/Young Gen", FormatBytes.byteToString(memoryManager.getMaxOldGen(), 3, 1) + "/" + FormatBytes.byteToString(memoryManager.getMaxYoungGen(), 3, 1));
            } else {
                fSILogger.log(2935, "Max Old Gen", FormatBytes.byteToString(memoryManager.getMaxOldGen(), 3, 1));
                fSILogger2.log(2935, "Max Old Gen", FormatBytes.byteToString(memoryManager.getMaxOldGen(), 3, 1));
            }
            if (memoryManager.usesG1GC()) {
                fSILogger.log(2935, "Using G1", "true");
                fSILogger2.log(2935, "Using G1", "true");
            }
            fSILogger.log(2935, "Encoding", systemInformation.getFileEncoding() + "/" + systemInformation.getJNUEncoding());
            fSILogger2.log(2935, "Encoding", systemInformation.getFileEncoding() + "/" + systemInformation.getJNUEncoding());
            this.checkPrerequisites(servletContext, fSILogger, systemInformation);
            RequestProcessorSettings requestProcessorSettings = this.initRequestProcessorSettings(servletContext, fSILogger, fileEventCursor, effectsManager);
            requestProcessorSettings.init();
            CacheManager cacheManager = (CacheManager)servletContext.getAttribute("com.neptunelabs.fsiserver.CacheManager");
            SwapPool swapPool = this.initSwapPool(servletContext, fSILogger, requestProcessorSettings.getWorkDirectory());
            this.initImageIO(requestProcessorSettings);
            PluginLoader pluginLoader = this.initPlugins(servletContext, fSILogger, systemInformation);
            this.initExecutorPool(servletContext, fSILogger, requestProcessorSettings);
            this.initFreeMarker(servletContext, requestProcessorSettings, fSILogger, fileEventCursor, path, requestProcessorSettings.getWebInfPath());
            Map<OutputFormat, OutputCompressor> map = this.initOutputCompressors(servletContext, fSILogger, pluginLoader);
            Map<Parameters.Type, SearchProcessor> map2 = this.initSearchProcessors(servletContext, requestProcessorSettings);
            StaticFileRequestHandler staticFileRequestHandler = this.initStaticFileHandler(servletContext, requestProcessorSettings);
            requestProcessorSettings.readHeadersDefinition();
            requestProcessorSettings.initHeadersMonitor(fileEventCursor);
            requestProcessorSettings.readSourceConnectors();
            SolrSearcher solrSearcher = this.initSolrSearcher(servletContext, requestProcessorSettings, fSILogger);
            requestProcessorSettings.configureJMXSupport();
            DeletePool deletePool = this.initDeletePool(servletContext, fSILogger, requestProcessorSettings.getStorageLocation());
            SourceManagerSettings sourceManagerSettings = this.initSourceManagerSettings(servletContext, fSILogger2, fileEventCursor, deletePool, cacheManager, effectsManager, swapPool, pluginLoader);
            ImageListFileReader imageListFileReader = (ImageListFileReader)servletContext.getAttribute("com.neptunelabs.fsiserver.ImageListFileReader");
            this.initImageBuilders(servletContext, requestProcessorSettings, swapPool, pluginLoader, imageListFileReader);
            requestProcessorSettings.readRenderers();
            if (Boolean.valueOf(System.getProperty("com.neptunelabs.devmode", "false")).booleanValue()) {
                this.initCacheBrowserServlet(servletContext);
            }
        }
        catch (Error | Exception throwable) {
            servletContext.setAttribute("com.neptunelabs.fsiserver.requestprocessor.startError", (Object)throwable.getMessage());
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        FSILogger fSILogger;
        FSILogger fSILogger2;
        FSILogger fSILogger3;
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.shutdownScannerDaemon(servletContext);
        this.shutdownSDBChecker(servletContext);
        this.shutdownDirectoryImportHandler(servletContext);
        this.shutdownConverterManager(servletContext);
        this.shutdownImageListFile(servletContext);
        this.shutdownFileEventCursor(servletContext);
        this.shutdownDeleteDaemon(servletContext);
        this.shutdownDeletePool(servletContext);
        this.shutdownCacheManager(servletContext);
        this.shutdownSystemMonitor(servletContext);
        this.shutdownSolrUpdater(servletContext);
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.RequestProcessorSettings");
        if (object != null) {
            ((RequestProcessorSettings)object).dispose();
        }
        if ((fSILogger3 = (FSILogger)servletContext.getAttribute("logger.requestprocessor")) != null) {
            fSILogger3.shutdown();
        }
        if ((fSILogger2 = (FSILogger)servletContext.getAttribute("logger.sourcemanager")) != null) {
            fSILogger2.shutdown();
        }
        if ((fSILogger = (FSILogger)servletContext.getAttribute("logger.api")) != null) {
            fSILogger.shutdown();
        }
    }

    private Path setupConfigHome(ServletContext servletContext) {
        String string = System.getProperty("com.neptunelabs.fsiserver.config.home");
        Path path = string == null ? ServletUtils.getRealPath(servletContext, "CONFIG") : Paths.get(string, new String[0]);
        servletContext.setAttribute("com.neptunelabs.fsiserver.config.home", (Object)path);
        return path;
    }

    private FSILogger initRequestProcessorLogger(ServletContext servletContext, Path path) {
        FSILogger fSILogger = new FSILogger(path, "RequestProcessor", "com/neptunelabs/fsiserver/resources/log4j_codes.properties", "log4j");
        fSILogger.start();
        servletContext.setAttribute("logger.requestprocessor", (Object)fSILogger);
        return fSILogger;
    }

    private FSILogger initSourceManagerLogger(ServletContext servletContext, Path path) {
        FSILogger fSILogger = new FSILogger(path, "SourceManager", "com/neptunelabs/fsiserver/resources/log4j_codes.properties", "log4j");
        fSILogger.start();
        servletContext.setAttribute("logger.sourcemanager", (Object)fSILogger);
        return fSILogger;
    }

    private FSILogger initAPILogger(ServletContext servletContext, Path path) {
        FSILogger fSILogger = new FSILogger(path, "APILogger", "com/neptunelabs/fsiserver/resources/api_codes.properties", "log4j", false);
        fSILogger.start();
        servletContext.setAttribute("logger.api", (Object)fSILogger);
        return fSILogger;
    }

    private SystemInformation initSystemInformation(ServletContext servletContext) {
        SystemInformation systemInformation = new SystemInformation();
        servletContext.setAttribute("com.neptunelabs.fsiserver.SystemInformation", (Object)systemInformation);
        return systemInformation;
    }

    private void initBaseClasses(ServletContext servletContext, FSILogger fSILogger) {
        Register register = new Register();
        register.initPlugins();
    }

    private RequestProcessorSettings initRequestProcessorSettings(ServletContext servletContext, FSILogger fSILogger, FileEventCursor fileEventCursor, EffectsManager effectsManager) {
        RequestProcessorSettings requestProcessorSettings = new RequestProcessorSettings(servletContext);
        requestProcessorSettings.evalutateSettings();
        this.initCacheManager(servletContext, fSILogger, requestProcessorSettings);
        this.initStorageHelper(servletContext, requestProcessorSettings);
        this.initRequestProcessorTokens(servletContext, requestProcessorSettings);
        if (!requestProcessorSettings.hasSectionEnabled("application")) {
            requestProcessorSettings.getLogger().log(2006, new Object[0]);
            throw new RuntimeException("FSI Server starting disabled by settings.");
        }
        Path path = requestProcessorSettings.getStorageLocation();
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            requestProcessorSettings.getLogger().log(2043, path);
            throw new RuntimeException("FSI Server start failed due to an invalid storage location.");
        }
        if (!Files.isReadable(path)) {
            requestProcessorSettings.getLogger().log(2045, path);
            throw new RuntimeException("FSI Server start failed due to an invalid storage location.");
        }
        try {
            requestProcessorSettings.setupStorageID();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.RequestProcessorSettings", (Object)requestProcessorSettings);
        return requestProcessorSettings;
    }

    private SourceManagerSettings initSourceManagerSettings(ServletContext servletContext, FSILogger fSILogger, FileEventCursor fileEventCursor, DeletePool deletePool, CacheManager cacheManager, EffectsManager effectsManager, SwapPool swapPool, PluginLoader pluginLoader) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SourceManagerSettings sourceManagerSettings = new SourceManagerSettings(servletContext);
        if (sourceManagerSettings.evalutateSettings() && sourceManagerSettings.hasSectionEnabled("application")) {
            this.initMimeTypes(servletContext, fSILogger, sourceManagerSettings);
            sourceManagerSettings.initWorkDirectory();
            object4 = sourceManagerSettings.getStorageLocation();
            int n = 3;
            object3 = sourceManagerSettings.getPrefsString("application", "conversionthreads");
            if (!((String)object3).equalsIgnoreCase("auto")) {
                try {
                    n = Integer.valueOf((String)object3);
                }
                catch (NumberFormatException numberFormatException) {
                    sourceManagerSettings.getLogger().log(2503, "conversionthreads", object3);
                }
            }
            sourceManagerSettings.setConversionThreads(n);
            object2 = sourceManagerSettings.getPrefsString("application", "userdb");
            if ("xmlfile".equalsIgnoreCase((String)object2)) {
                object = new XMLFileAuthentication(sourceManagerSettings);
            } else if ("ldap".equalsIgnoreCase((String)object2)) {
                object = new LDAPAuthentication(sourceManagerSettings);
            } else {
                object = new ServerOnlyAccessValidation(sourceManagerSettings);
                fSILogger.log(2032, new Object[0]);
            }
            servletContext.setAttribute("com.neptunelabs.fsiserver.AuthenticationInterface", object);
            sourceManagerSettings.readSourceConnectors();
        }
        object4 = this.initStorageManager(servletContext, sourceManagerSettings, sourceManagerSettings.getStorageLocation(), cacheManager);
        this.initImageListFile(servletContext, sourceManagerSettings, (StorageManager)object4);
        ImageListFileReader imageListFileReader = (ImageListFileReader)servletContext.getAttribute("com.neptunelabs.fsiserver.ImageListFileReader");
        object3 = (ImageListFileWriter)servletContext.getAttribute("com.neptunelabs.fsiserver.ImageListFileWriter");
        object = this.initSolrUpdater(servletContext, sourceManagerSettings, fSILogger);
        object2 = this.initDeleteDaemon(servletContext, sourceManagerSettings, deletePool, imageListFileReader, (ImageListFileWriter)object3, (SolrUpdater)object);
        boolean bl = sourceManagerSettings.getPrefsBoolean("application", "import");
        Converter_V1002 converter_V1002 = this.initConverterManager(servletContext, sourceManagerSettings, swapPool, pluginLoader, (ImageListFileWriter)object3, bl);
        DirectoryImportHandler directoryImportHandler = this.initDirectoryImportHandler(servletContext, imageListFileReader, (ImageListFileWriter)object3, sourceManagerSettings, swapPool, converter_V1002, (DeleteDaemon)object2, (StorageManager)object4);
        ScannerDaemon scannerDaemon = this.initScannerDaemon(servletContext, sourceManagerSettings, converter_V1002, swapPool, imageListFileReader, (ImageListFileWriter)object3, (StorageManager)object4, directoryImportHandler, pluginLoader, (SolrUpdater)object);
        directoryImportHandler.setScannerDaemon(scannerDaemon);
        directoryImportHandler.start();
        this.initSDBChecker(servletContext, sourceManagerSettings, scannerDaemon);
        servletContext.setAttribute("settings.sourceManager", (Object)sourceManagerSettings);
        return sourceManagerSettings;
    }

    private void initCacheBrowserServlet(ServletContext servletContext) {
        ServletRegistration.Dynamic dynamic = servletContext.addServlet("CacheBrowser", "com.neptunelabs.fsiserver.utils.cache.CacheBrowser");
        if (dynamic != null) {
            dynamic.setLoadOnStartup(10);
            dynamic.addMapping(new String[]{"/cb"});
        } else {
            LOGGER.log(Level.SEVERE, "CacheBrowser not initiated");
        }
    }

    private void initFileLockHandler(ServletContext servletContext) {
        StorageLockHandler storageLockHandler = new StorageLockHandler();
        servletContext.setAttribute("com.neptunelabs.fsiserver.utils.StorageLockHandler", (Object)storageLockHandler);
    }

    private FileEventCursor initFileEventCursor(ServletContext servletContext, FSILogger fSILogger) {
        FileEventCursor fileEventCursor = new FileEventCursor(fSILogger);
        fileEventCursor.start();
        servletContext.setAttribute("com.neptunelabs.fsiserver.utils.FileEventCursor", (Object)fileEventCursor);
        return fileEventCursor;
    }

    private void shutdownFileEventCursor(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.utils.FileEventCursor");
        if (object != null) {
            ((FileEventCursor)object).halt();
            try {
                ((FileEventCursor)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void checkPrerequisites(ServletContext servletContext, FSILogger fSILogger, SystemInformation systemInformation) {
        int n;
        Prerequisites prerequisites = new Prerequisites(fSILogger, servletContext, systemInformation, true);
        if (!fSILogger.hasNeLaDebug()) {
            n = Runtime.getRuntime().availableProcessors();
            prerequisites.setDisallow32bit(Prerequisites.Type.super, true);
            prerequisites.setThreadSettings(Prerequisites.Type.\u00d300000, 4, -1);
            prerequisites.setServletAPIVersion(Prerequisites.Type.super, 3.0, 3.1);
            prerequisites.setCheckMissingAllowEncodedSlash(Prerequisites.Type.\u00d300000, true);
            prerequisites.setRequiredMinMemory(Prerequisites.Type.super, 0x10000000L);
            prerequisites.setRequiredMinMemory(Prerequisites.Type.\u00d300000, 0x40000000L);
            prerequisites.setRequiredMinMemoryPerCPU(Prerequisites.Type.super, 0x2000000L, n);
            prerequisites.setRequiredMinMemoryPerCPU(Prerequisites.Type.\u00d300000, 0x8000000L, n);
            prerequisites.setCheckLogHome(Prerequisites.Type.super, true);
            prerequisites.setAllowSecureMode(Prerequisites.Type.super, false);
            prerequisites.setAllowedFileEncoding(Prerequisites.Type.\u00d300000, FileOperations.new);
            prerequisites.addPositiveJavaServletContainer(JavaEEServer.\u00d600000, "8.0.6", "9.0.0");
            prerequisites.addErrorJavaServletContainer(JavaEEServer.\u00d2O0000);
            prerequisites.addPositiveVMVendor(VMVendor.\u00d200000, "1.8.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.\u00d600000, "1.8.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.Object, "1.8.0_0", "1.9.0_0");
            prerequisites.addPositiveVMVendor(VMVendor.o00000, "1.8.0_0", "1.9.0_0");
            prerequisites.addErrorVMVendor(VMVendor.\u00d500000, null, null);
            prerequisites.addErrorVMVendor(VMVendor.\u00f400000, null, null);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.\u00f8O0000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.\u00d800000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.\u00f4O0000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.thissuper);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.\u00f400000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.\u00d4O0000);
            prerequisites.addPositiveOperatingSystem(OperatingSystem.forsuper);
            if (systemInformation.getJVMVersion() == 1.8f) {
                prerequisites.addRequiredSystemProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider", Prerequisites.Type.super, 2079);
            }
        }
        if (!fSILogger.hasNeLaDebug()) {
            n = prerequisites.check(Prerequisites.Type.\u00d300000);
            if (n != 0) {
                fSILogger.log(2009, n);
            }
            int n2 = prerequisites.check(Prerequisites.Type.super);
            String string = "Minimum System Requirements not accomplished (" + Prerequisites.codeToString(n2) + "). Please check the server log.";
            if (n2 != 0) {
                fSILogger.log(2008, n2);
                throw new RuntimeException(string);
            }
        }
    }

    private void initRequestProcessorTokens(ServletContext servletContext, RequestProcessorSettings requestProcessorSettings) {
        String string = "";
        String string2 = requestProcessorSettings.getPrefsString("application", "requestprocessortokens");
        if (string2 != null && !string2.equals("")) {
            if ((string2 = string2.trim().toLowerCase()).equals("full")) {
                string = requestProcessorSettings.getPrefsString(null, "vendor") + " " + SoftwareVersion.getSoftware(true);
            } else if (string2.equals("prod")) {
                string = requestProcessorSettings.getPrefsString(null, "vendor") + " " + SoftwareVersion.getSoftware(false);
            } else if (string2.equals("none")) {
                string = null;
            }
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.RequestProcessorToken", (Object)string);
    }

    private SystemMonitor initSystemMonitor(ServletContext servletContext) {
        SystemMonitor systemMonitor = new SystemMonitor();
        systemMonitor.start();
        servletContext.setAttribute("com.neptunelabs.fsiserver.SystemMonitor", (Object)systemMonitor);
        return systemMonitor;
    }

    private void shutdownSystemMonitor(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.SystemMonitor");
        if (object != null) {
            ((SystemMonitor)object).halt();
            try {
                ((SystemMonitor)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private CacheManager initCacheManager(ServletContext servletContext, FSILogger fSILogger, RequestProcessorSettings requestProcessorSettings) {
        long l = System.currentTimeMillis();
        boolean bl = requestProcessorSettings.hasSectionEnabled("cache");
        long l2 = requestProcessorSettings.evaluateMaxBlockCache(requestProcessorSettings.getPrefsString("cache", "maxmemory"));
        boolean bl2 = requestProcessorSettings.getPrefsBoolean("cache", "directmemory");
        boolean bl3 = requestProcessorSettings.getPrefsBoolean("cache", "l1");
        int n = requestProcessorSettings.getPrefsInt("cache", "l1size");
        if (n <= 0) {
            n = 0;
        }
        boolean bl4 = requestProcessorSettings.getPrefsBoolean("cache", "l2");
        boolean bl5 = requestProcessorSettings.getPrefsBoolean("cache", "response");
        boolean bl6 = requestProcessorSettings.getPrefsBoolean("cache", "packasync");
        CacheManager cacheManager = new CacheManager(bl, l2, bl2, bl3, n, bl4, bl5, bl6);
        cacheManager.setDaemon(true);
        cacheManager.start();
        long l3 = cacheManager.getAllocatedCacheSize();
        long l4 = cacheManager.getMaximumCacheSize();
        String string = l3 == 0L ? "disabled" : FormatBytes.byteToString(l3, 3, 1);
        if (bl) {
            fSILogger.log(3204, "CacheManager (" + string + "/" + FormatBytes.byteToString(l4, 3, 1) + ")", System.currentTimeMillis() - l);
        } else {
            fSILogger.log(3204, "CacheManager (disabled)", System.currentTimeMillis() - l);
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.CacheManager", (Object)cacheManager);
        return cacheManager;
    }

    private void shutdownCacheManager(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.CacheManager");
        if (object != null) {
            ((CacheManager)object).dispose();
        }
    }

    private EffectsManager initEffectManager(ServletContext servletContext, FSILogger fSILogger) {
        EffectsManager effectsManager = new EffectsManager(fSILogger);
        servletContext.setAttribute("com.neptunelabs.fsiserver.EffectManager", (Object)effectsManager);
        return effectsManager;
    }

    private DeletePool initDeletePool(ServletContext servletContext, FSILogger fSILogger, Path path) {
        DeletePool deletePool = new DeletePool(fSILogger, path);
        deletePool.start();
        servletContext.setAttribute("com.neptunelabs.fsiserver.DeletePool", (Object)deletePool);
        return deletePool;
    }

    private void shutdownDeletePool(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.DeletePool");
        if (object != null) {
            ((DeletePool)object).halt();
            try {
                ((DeletePool)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void initImageIO(RequestProcessorSettings requestProcessorSettings) {
        Path path = requestProcessorSettings.getWorkDirectory();
        if (Boolean.valueOf(System.getProperty("com.neptunelabs.useImageIOCache", "false")).booleanValue()) {
            ImageIO.setUseCache(true);
            ImageIO.setCacheDirectory(path.toFile());
        } else {
            ImageIO.setUseCache(false);
        }
    }

    private void initMimeTypes(ServletContext servletContext, FSILogger fSILogger, SourceManagerSettings sourceManagerSettings) {
        MimeTypesLoader mimeTypesLoader = new MimeTypesLoader(fSILogger);
        mimeTypesLoader.loadFromFile(sourceManagerSettings.getConfigHome().resolve("mime.types"));
        Map<String, String> map = mimeTypesLoader.getMimeTypes();
        boolean bl = sourceManagerSettings.getPrefsBoolean("scanner", "useMagicBytes");
        ImageFormatScanner.getInstance(map, bl);
        servletContext.setAttribute("com.neptunelabs.fsiserver.MimeTypes", map);
    }

    private PluginLoader initPlugins(ServletContext servletContext, FSILogger fSILogger, SystemInformation systemInformation) {
        String string = System.getProperty("com.neptunelabs.fsiserver.plugin.home");
        Path path = null;
        if (string != null && !Files.isDirectory(path = Paths.get(string, new String[0]), new LinkOption[0])) {
            path = null;
        }
        if (path == null) {
            path = ServletUtils.getRealPath(servletContext, "PRIVATE").resolve("internal").resolve("plugins");
        }
        ClassLoader classLoader = servletContext.getClass().getClassLoader();
        PluginLoader pluginLoader = new PluginLoader(fSILogger, classLoader, systemInformation);
        List<String> list = PluginLoader.scanForPlugins(path);
        for (String string2 : list) {
            pluginLoader.loadPlugin(path, string2, "sourcemanager");
            pluginLoader.loadPlugin(path, string2, "requestprocessor");
        }
        ImageIO.scanForPlugins();
        servletContext.setAttribute("com.neptunelabs.fsiserver.PluginLoader", (Object)pluginLoader);
        return pluginLoader;
    }

    private void initSDBChecker(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, ScannerDaemon scannerDaemon) {
        SDBChecker sDBChecker = new SDBChecker(sourceManagerSettings, scannerDaemon);
        if (sourceManagerSettings.hasSectionEnabled("search")) {
            sDBChecker.start();
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.SDBChecker", (Object)sDBChecker);
    }

    private void shutdownSDBChecker(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.SDBChecker");
        if (object != null) {
            ((SDBChecker)object).halt();
            try {
                ((SDBChecker)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private ScannerDaemon initScannerDaemon(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, Converter_V1002 converter_V1002, SwapPool swapPool, ImageListFileReader imageListFileReader, ImageListFileWriter imageListFileWriter, StorageManager storageManager, DirectoryImportHandler directoryImportHandler, PluginLoader pluginLoader, SolrUpdater solrUpdater) {
        ScannerDaemon scannerDaemon = new ScannerDaemon(sourceManagerSettings, converter_V1002, swapPool, imageListFileReader, imageListFileWriter, storageManager, directoryImportHandler, pluginLoader, solrUpdater);
        scannerDaemon.start();
        if (sourceManagerSettings.hasSectionEnabled("scanner")) {
            sourceManagerSettings.getLogger().log(3204, "Scanner Daemon", 0L);
        } else {
            scannerDaemon.enableCountOnlyMode(true);
            sourceManagerSettings.getLogger().log(3214, new Object[0]);
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.ScannerDaemon", (Object)scannerDaemon);
        return scannerDaemon;
    }

    private void shutdownScannerDaemon(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.ScannerDaemon");
        if (object != null) {
            ((ScannerDaemon)object).halt();
            try {
                ((ScannerDaemon)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private DeleteDaemon initDeleteDaemon(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, DeletePool deletePool, ImageListFileReader imageListFileReader, ImageListFileWriter imageListFileWriter, SolrUpdater solrUpdater) {
        DeleteDaemon deleteDaemon = new DeleteDaemon(sourceManagerSettings, deletePool, imageListFileReader, imageListFileWriter, solrUpdater);
        deleteDaemon.start();
        servletContext.setAttribute("com.neptunelabs.fsiserver.DeleteDaemon", (Object)deleteDaemon);
        return deleteDaemon;
    }

    private void shutdownDeleteDaemon(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.DeleteDaemon");
        if (object != null) {
            ((DeleteDaemon)object).halt();
            try {
                ((DeleteDaemon)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private SwapPool initSwapPool(ServletContext servletContext, FSILogger fSILogger, Path path) {
        SwapPool swapPool = new SwapPool(fSILogger, path);
        servletContext.setAttribute("com.neptunelabs.fsiserver.SwapPool", (Object)swapPool);
        return swapPool;
    }

    private Map<OutputFormat, OutputCompressor> initOutputCompressors(ServletContext servletContext, FSILogger fSILogger, PluginLoader pluginLoader) {
        OutputCompressor outputCompressor;
        HashMap<OutputFormat, OutputCompressor> hashMap = new HashMap<OutputFormat, OutputCompressor>();
        if (pluginLoader.isPluginLoaded("libjpeg-turbo")) {
            outputCompressor = new JPEGTurboCompressor(fSILogger);
            fSILogger.log(2020, "jpeg-turbo");
        } else {
            outputCompressor = new JPEGCompressor(fSILogger);
            fSILogger.log(2020, "jpg");
        }
        hashMap.put(OutputFormat.\u00d500000, outputCompressor);
        fSILogger.log(2020, "png");
        PNGCompressor pNGCompressor = new PNGCompressor(fSILogger);
        hashMap.put(OutputFormat.\u00d400000, pNGCompressor);
        fSILogger.log(2020, "swf");
        SWFCompressor sWFCompressor = new SWFCompressor(fSILogger);
        hashMap.put(OutputFormat.\u00d200000, sWFCompressor);
        fSILogger.log(2020, "gif");
        GIFCompressor gIFCompressor = new GIFCompressor(fSILogger);
        hashMap.put(OutputFormat.o00000, gIFCompressor);
        servletContext.setAttribute("com.neptunelabs.fsiserver.OutputCompressors", hashMap);
        return hashMap;
    }

    private void initExecutorPool(ServletContext servletContext, FSILogger fSILogger, FSIServerSettings fSIServerSettings) {
        boolean bl = fSIServerSettings.getPrefsBoolean("application", "hasht");
        String string = fSIServerSettings.getPrefsString("application", "maxcpu");
        int n = fSIServerSettings.evaluateMaxCPU(string);
        if (bl && n > 1) {
            n = n / 2 + 1;
        } else if (n > 1) {
            --n;
        }
        String string2 = fSIServerSettings.getPrefsString("application", "maxio");
        int n2 = fSIServerSettings.evaluateMaxIO(string2);
        int n3 = n;
        int n4 = n2;
        if (!fSIServerSettings.getLicence().isStagingLicence()) {
            String string3;
            String string4 = fSIServerSettings.getPrefsString("application", "forceCPUThreads");
            if (string4 != null && !string4.isEmpty()) {
                try {
                    n3 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string3 = fSIServerSettings.getPrefsString("application", "forceIOThreads")) != null && !string3.isEmpty()) {
                try {
                    n4 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        n3 = n3 < 2 ? 2 : n3;
        ExecutorPool.getInstance(n3, n4);
        fSILogger.log(2023, ExecutorPool.getMaxCPUThreads(), ExecutorPool.getMaxIOThreads());
    }

    private boolean initFreeMarker(ServletContext servletContext, RequestProcessorSettings requestProcessorSettings, FSILogger fSILogger, FileEventCursor fileEventCursor, Path path, Path path2) {
        boolean bl = true;
        fSILogger.log(2021, new Object[0]);
        Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        configuration.setNumberFormat("0.######");
        configuration.setDefaultEncoding("UTF-8");
        configuration.setEncoding(Locale.ENGLISH, "UTF-8");
        configuration.setOutputEncoding("UTF-8");
        configuration.setLocale(Locale.ENGLISH);
        configuration.setWhitespaceStripping(false);
        TemplateCache templateCache = new TemplateCache(fSILogger, configuration, fileEventCursor);
        try {
            templateCache.registerTemplates(TemplateType.\u00d200000, path2.resolve("internal/templates").resolve("info"), fSILogger.hasNeLaDebug());
            Path path3 = path.resolve("templates").resolve("info");
            if (Files.exists(path3, new LinkOption[0])) {
                templateCache.registerTemplates(TemplateType.\u00d200000, path3, true);
            }
            templateCache.registerTemplates(TemplateType.super, path2.resolve("internal/templates").resolve("list"), fSILogger.hasNeLaDebug());
            Path path4 = path.resolve("templates").resolve("list");
            if (Files.exists(path4, new LinkOption[0])) {
                templateCache.registerTemplates(TemplateType.super, path4, true);
            }
        }
        catch (IOException iOException) {
            fSILogger.log(2022, iOException.getLocalizedMessage());
            bl = false;
        }
        requestProcessorSettings.setTemplateCache(templateCache);
        return bl;
    }

    private Map<Parameters.Type, SearchProcessor> initSearchProcessors(ServletContext servletContext, RequestProcessorSettings requestProcessorSettings) {
        HashMap<Parameters.Type, SearchProcessor> hashMap = new HashMap<Parameters.Type, SearchProcessor>();
        hashMap.put(Parameters.Type.\u00f500000, new DefaultSearchProcessor(requestProcessorSettings));
        hashMap.put(Parameters.Type.new, new SimpleSearchProcessor(requestProcessorSettings));
        servletContext.setAttribute("com.neptunelabs.fsiserver.SearchProcessors", hashMap);
        return hashMap;
    }

    private StaticFileRequestHandler initStaticFileHandler(ServletContext servletContext, RequestProcessorSettings requestProcessorSettings) {
        StaticFileRequestHandler staticFileRequestHandler = new StaticFileRequestHandler(requestProcessorSettings);
        servletContext.setAttribute("com.neptunelabs.fsiserver.StaticFileRequestHandler", (Object)staticFileRequestHandler);
        return staticFileRequestHandler;
    }

    private StorageManager initStorageManager(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, Path path, CacheManager cacheManager) {
        StorageManager storageManager = new StorageManager(sourceManagerSettings, path, cacheManager);
        servletContext.setAttribute("com.neptunelabs.fsiserver.StorageManager", (Object)storageManager);
        return storageManager;
    }

    private void initImageListFile(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, StorageManager storageManager) {
        ImageListFileReader imageListFileReader = new ImageListFileReader(sourceManagerSettings, storageManager);
        ImageListFileWriter imageListFileWriter = new ImageListFileWriter(sourceManagerSettings, imageListFileReader);
        servletContext.setAttribute("com.neptunelabs.fsiserver.ImageListFileReader", (Object)imageListFileReader);
        servletContext.setAttribute("com.neptunelabs.fsiserver.ImageListFileWriter", (Object)imageListFileWriter);
    }

    private void shutdownImageListFile(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.ImageListFileReader");
        if (object != null) {
            ((ImageListFileReader)object).shutdownListBuffer();
        }
    }

    private Converter_V1002 initConverterManager(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, SwapPool swapPool, PluginLoader pluginLoader, ImageListFileWriter imageListFileWriter, boolean bl) {
        Converter_V1002 converter_V1002 = new Converter_V1002(sourceManagerSettings, swapPool, pluginLoader, imageListFileWriter, bl);
        converter_V1002.start();
        servletContext.setAttribute("com.neptunelabs.fsiserver.ConverterManager", (Object)converter_V1002);
        return converter_V1002;
    }

    private void shutdownConverterManager(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.ConverterManager");
        if (object != null) {
            ((Converter_V1002)object).halt();
            try {
                ((Converter_V1002)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private DirectoryImportHandler initDirectoryImportHandler(ServletContext servletContext, ImageListFileReader imageListFileReader, ImageListFileWriter imageListFileWriter, SourceManagerSettings sourceManagerSettings, SwapPool swapPool, Converter_V1002 converter_V1002, DeleteDaemon deleteDaemon, StorageManager storageManager) {
        DirectoryImportHandler directoryImportHandler = new DirectoryImportHandler(imageListFileReader, imageListFileWriter, sourceManagerSettings, swapPool, converter_V1002, deleteDaemon, storageManager);
        servletContext.setAttribute("com.neptunelabs.fsiserver.DirectoryImportHandler", (Object)directoryImportHandler);
        return directoryImportHandler;
    }

    private void shutdownDirectoryImportHandler(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.DirectoryImportHandler");
        if (object != null) {
            ((DirectoryImportHandler)object).shutdown();
            try {
                ((DirectoryImportHandler)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private SolrSearcher initSolrSearcher(ServletContext servletContext, RequestProcessorSettings requestProcessorSettings, FSILogger fSILogger) {
        String string = "FSI-Solr-Updater";
        SearchDatabaseSolr searchDatabaseSolr = new SearchDatabaseSolr("FSI-Solr-Updater");
        SolrSearcher solrSearcher = new SolrSearcher(searchDatabaseSolr);
        if (requestProcessorSettings.hasSectionEnabled("search")) {
            String string2 = requestProcessorSettings.getPrefsString("search", "type");
            if (string2.equalsIgnoreCase("solr")) {
                try {
                    boolean bl;
                    String string3;
                    String string4 = requestProcessorSettings.getPrefsString("search", "solrServerURI");
                    String string5 = requestProcessorSettings.getPrefsString("search", "core");
                    int n = requestProcessorSettings.getPrefsInt("search", "connectionpoolmax");
                    searchDatabaseSolr.setConnection(RequestProcessorSettings.parse4Env(string4), string5, n);
                    boolean bl2 = requestProcessorSettings.getPrefsBoolean("search", "authentication");
                    if (bl2) {
                        String string6 = requestProcessorSettings.getPrefsString("search", "authenticationType");
                        string3 = requestProcessorSettings.getPrefsString("search", "authenticationUsername");
                        String string7 = requestProcessorSettings.getPrefsString("search", "authenticationPassword");
                        searchDatabaseSolr.setAuthentication(bl2, string6, string3, string7);
                    }
                    if (bl = requestProcessorSettings.getPrefsBoolean("search", "proxy")) {
                        string3 = requestProcessorSettings.getPrefsString("search", "proxyHostname");
                        int n2 = requestProcessorSettings.getPrefsInt("search", "proxyPort");
                        boolean bl3 = requestProcessorSettings.getPrefsBoolean("search", "proxySSL");
                        boolean bl4 = requestProcessorSettings.getPrefsBoolean("search", "proxyAuthentication");
                        String string8 = requestProcessorSettings.getPrefsString("search", "proxyUsername");
                        String string9 = requestProcessorSettings.getPrefsString("search", "proxyPassword");
                        searchDatabaseSolr.setProxy(bl, string3, n2, bl3, bl4, string8, string9);
                    }
                    searchDatabaseSolr.init();
                    fSILogger.log(3221, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    fSILogger.log(3220, illegalArgumentException.getLocalizedMessage());
                    solrSearcher = null;
                }
            } else {
                solrSearcher = null;
                fSILogger.log(3210, "SearchDatabase", string2);
            }
        } else {
            solrSearcher = null;
            fSILogger.log(2046, new Object[0]);
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.SolrSearcher", (Object)solrSearcher);
        servletContext.setAttribute("com.neptunelabs.fsiserver.Solr", (Object)searchDatabaseSolr);
        return solrSearcher;
    }

    private SolrUpdater initSolrUpdater(ServletContext servletContext, SourceManagerSettings sourceManagerSettings, FSILogger fSILogger) {
        SolrUpdater solrUpdater = null;
        SearchDatabaseSolr searchDatabaseSolr = null;
        if (sourceManagerSettings.hasSectionEnabled("search")) {
            String string = "FSI-Solr-Updater";
            searchDatabaseSolr = new SearchDatabaseSolr(string);
            String string2 = sourceManagerSettings.getPrefsString("search", "type");
            if (string2.equalsIgnoreCase("solr")) {
                try {
                    boolean bl;
                    String string3;
                    String string4 = sourceManagerSettings.getPrefsString("search", "solrServerURI");
                    String string5 = sourceManagerSettings.getPrefsString("search", "core");
                    int n = sourceManagerSettings.getPrefsInt("search", "connectionpoolmax");
                    searchDatabaseSolr.setConnection(SourceManagerSettings.parse4Env(string4), string5, n);
                    boolean bl2 = sourceManagerSettings.getPrefsBoolean("search", "authentication");
                    if (bl2) {
                        String string6 = sourceManagerSettings.getPrefsString("search", "authenticationType");
                        string3 = sourceManagerSettings.getPrefsString("search", "authenticationUsername");
                        String string7 = sourceManagerSettings.getPrefsString("search", "authenticationPassword");
                        searchDatabaseSolr.setAuthentication(bl2, string6, string3, string7);
                    }
                    if (bl = sourceManagerSettings.getPrefsBoolean("search", "proxy")) {
                        string3 = sourceManagerSettings.getPrefsString("search", "proxyHostname");
                        int n2 = sourceManagerSettings.getPrefsInt("search", "proxyPort");
                        boolean bl3 = sourceManagerSettings.getPrefsBoolean("search", "proxySSL");
                        boolean bl4 = sourceManagerSettings.getPrefsBoolean("search", "proxyAuthentication");
                        String string8 = sourceManagerSettings.getPrefsString("search", "proxyUsername");
                        String string9 = sourceManagerSettings.getPrefsString("search", "proxyPassword");
                        searchDatabaseSolr.setProxy(bl, string3, n2, bl3, bl4, string8, string9);
                    }
                    searchDatabaseSolr.init();
                    solrUpdater = new SolrUpdater(sourceManagerSettings, searchDatabaseSolr, string);
                    solrUpdater.start();
                    fSILogger.log(3221, string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    fSILogger.log(3220, illegalArgumentException.getLocalizedMessage());
                    solrUpdater = null;
                }
            } else {
                solrUpdater = null;
                fSILogger.log(3210, "SearchDatabase", string2);
            }
            if (solrUpdater != null) {
                solrUpdater.setEnabled(true);
            }
        } else {
            solrUpdater = new SolrUpdater(sourceManagerSettings, null, "FSI-Solr-Deactivated");
            solrUpdater.setEnabled(false);
        }
        servletContext.setAttribute("com.neptunelabs.fsiserver.SolrUpdater", (Object)solrUpdater);
        return solrUpdater;
    }

    private void shutdownSolrUpdater(ServletContext servletContext) {
        Object object = servletContext.getAttribute("com.neptunelabs.fsiserver.SolrUpdater");
        if (object != null) {
            ((SolrUpdater)object).halt();
            try {
                ((SolrUpdater)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private StorageHelperV1002 initStorageHelper(ServletContext servletContext, FSIServerSettings fSIServerSettings) {
        String string = fSIServerSettings.getPrefsString("application", "storagehasher");
        StorageHelperV1002.Hasher hasher = null;
        try {
            if (string != null) {
                string = string.toUpperCase();
                hasher = StorageHelperV1002.Hasher.valueOf(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            hasher = StorageHelperV1002.Hasher.\u00d500000;
        }
        Path path = fSIServerSettings.getStorageLocation();
        StorageHelperV1002 storageHelperV1002 = new StorageHelperV1002(hasher, path);
        servletContext.setAttribute("com.neptunelabs.fsiserver.StorageHelper", (Object)storageHelperV1002);
        return storageHelperV1002;
    }

    private ImageBuilder initImageBuilders(ServletContext servletContext, RequestProcessorSettings requestProcessorSettings, SwapPool swapPool, PluginLoader pluginLoader, ImageListFileReader imageListFileReader) {
        ImageBuilder imageBuilder = new ImageBuilder(requestProcessorSettings, swapPool, pluginLoader, imageListFileReader);
        servletContext.setAttribute("com.neptunelabs.fsiserver.StandardImageBuilder", (Object)imageBuilder);
        return imageBuilder;
    }
}

