/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.framework.helpers.ExecutorPool;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.MemoryManager;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.PluginLoader;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.ImageFormatScanner;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageConverter;
import com.neptunelabs.fsiserver.imagereader.converter.BufferedImageConverterThreaded;
import com.neptunelabs.fsiserver.imagereader.converter.ColorConverterCache;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.helper.ICCDefaultReader;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.sourcemanager.ConverterStatistics;
import com.neptunelabs.fsiserver.sourcemanager.OoOO;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.ConversionCompletedEvent;
import com.neptunelabs.fsiserver.sourcemanager.small.ConversionCompletedListener;
import com.neptunelabs.fsiserver.sourcemanager.small.ConverterState;
import com.neptunelabs.fsiserver.sourcemanager.small.LimitedJobList;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.super;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.URL;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Converter_V1002
extends Thread
implements ConversionCompletedListener {
    private static final int for = 150;
    private static final int returnsuper = 0;
    private static final int \u00f5o0000 = 0x20000000;
    private static final int null = 0x40000000;
    private static final int \u00d3o0000 = 0x60000000;
    private static final AtomicInteger \u00d6O0000 = new AtomicInteger(0);
    private static final AtomicInteger oO0000 = new AtomicInteger(0x20000000);
    private static final AtomicInteger \u00d200000 = new AtomicInteger(0x40000000);
    private static final AtomicInteger \u00f600000 = new AtomicInteger(0x60000000);
    private static final int newsuper = Math.round(112.5f);
    private volatile boolean \u00d5O0000 = false;
    private final long \u00d5o0000;
    private final SwapPool \u00d300000;
    private final SourceManagerSettings ifsuper;
    private final ConverterStatistics oo0000;
    private final BufferedImageConverter \u00f800000;
    private final ColorConverterCache \u00d800000;
    private final OoOO \u00d600000;
    private final SystemMonitor \u00f500000;
    private final ExecutorService \u00d2o0000;
    private final BlockingQueue<Runnable> \u00d3O0000;
    private final Map<String, CompletableFuture<Void>> \u00d500000 = Collections.synchronizedMap(new TreeMap());
    private boolean \u00d2O0000;
    private final boolean \u00f6O0000;
    private final long \u00d8O0000;
    private final LimitedJobList<FileImportJob> o00000;
    private final ImageListFileWriter whilesuper;
    private ICCProfileWrap private = null;
    private ICCProfileWrap \u00d8o0000 = null;
    private ICCProfileWrap String = null;
    private boolean \u00f5O0000 = true;
    private String \u00f8O0000;
    private final AtomicLong \u00d6o0000 = new AtomicLong(0L);

    public Converter_V1002(SourceManagerSettings sourceManagerSettings, SwapPool swapPool, PluginLoader pluginLoader, ImageListFileWriter imageListFileWriter, boolean bl) {
        float f;
        this.setName("Converter");
        this.ifsuper = sourceManagerSettings;
        this.whilesuper = imageListFileWriter;
        this.\u00d300000 = swapPool;
        this.\u00d2O0000 = bl;
        this.\u00f500000 = sourceManagerSettings.getSystemMonitor();
        int n = sourceManagerSettings.getConversionThreads();
        this.\u00d3O0000 = new LinkedBlockingQueue<Runnable>();
        this.\u00d2o0000 = ExecutorPool.createExecutorService("Converter", n, 1, this.\u00d3O0000);
        long l = MemoryManager.getFreeHeapSpace();
        int n2 = (int)Math.ceil((float)(l - 0x9600000L) / 1048592.0f);
        if (n2 < 2) {
            n2 = 2;
        } else if (n2 > 20) {
            n2 = 20;
        }
        this.\u00d800000 = new ColorConverterCache(n2);
        sourceManagerSettings.getServletContext().setAttribute("com.neptunelabs.fsiserver.ColorConverterCache", (Object)this.\u00d800000);
        this.\u00f800000 = new BufferedImageConverterThreaded(sourceManagerSettings.getLogger(), this.\u00d800000);
        this.\u00d600000 = new OoOO(sourceManagerSettings.getLogger(), this, this.\u00f800000, swapPool, pluginLoader, sourceManagerSettings.getByteOrder());
        this.o00000 = new LimitedJobList(100);
        this.oo0000 = new ConverterStatistics();
        try {
            f = Math.max(0.9f, Float.valueOf(sourceManagerSettings.getPrefsString("application", "maxscalememratio")).floatValue());
        }
        catch (NumberFormatException numberFormatException) {
            f = 0.75f;
        }
        long l2 = (long)(f * (float)Runtime.getRuntime().maxMemory());
        this.\u00d5o0000 = l2 / (long)sourceManagerSettings.getConversionThreads();
        this.\u00f6O0000 = sourceManagerSettings.getPrefsBoolean("application", "prefetch");
        this.\u00d8O0000 = sourceManagerSettings.getPrefsLong("application", "prefetchmaxsize");
        this.setupDefaultICCProfiles();
        this.\u00f8O0000 = "idle";
    }

    @Override
    public void run() {
        while (this.\u00d2O0000) {
            try {
                if (this.\u00d3O0000.isEmpty()) {
                    \u00d6O0000.set(0);
                    oO0000.set(0x20000000);
                    \u00d200000.set(0x40000000);
                    \u00f600000.set(0x60000000);
                }
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                this.\u00d2O0000 = false;
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    private void setupDefaultICCProfiles() {
        this.setupDefaultCMYKProfile();
        this.setupDefaultRGBProfile();
        this.setupDefaultGrayProfile();
        this.\u00f5O0000 = this.ifsuper.getPrefsBoolean("colormanagementsystem", "fallbackICCConversion");
    }

    private void setupDefaultGrayProfile() {
        try {
            ICC_Profile iCC_Profile;
            Path path = this.getProfileFile("DefaultGrayProfile");
            ICC_Profile iCC_Profile2 = iCC_Profile = path == null ? ICCDefaultReader.getDefaultICCProfile("gray") : ICC_Profile.getInstance(FileOperations.readFile(path));
            if (iCC_Profile != null) {
                this.String = new ICCProfileWrap(iCC_Profile.getData());
            }
        }
        catch (IOException iOException) {
            this.ifsuper.getLogger().logException(iOException, 2030, "GRAY:" + iOException.getLocalizedMessage());
        }
    }

    private void setupDefaultRGBProfile() {
        try {
            ICC_Profile iCC_Profile;
            Path path = this.getProfileFile("DefaultRGBProfile");
            ICC_Profile iCC_Profile2 = iCC_Profile = path == null ? ICCDefaultReader.getDefaultICCProfile("rgb") : ICC_Profile.getInstance(FileOperations.readFile(path));
            if (iCC_Profile != null) {
                this.\u00d8o0000 = new ICCProfileWrap(iCC_Profile.getData());
            }
        }
        catch (IOException iOException) {
            this.ifsuper.getLogger().logException(iOException, 2030, "RGB:" + iOException.getLocalizedMessage());
        }
    }

    private void setupDefaultCMYKProfile() {
        try {
            ICC_Profile iCC_Profile;
            Path path = this.getProfileFile("DefaultCMYKProfile");
            ICC_Profile iCC_Profile2 = iCC_Profile = path == null ? ICCDefaultReader.getDefaultICCProfile("cmyk") : ICC_Profile.getInstance(FileOperations.readFile(path));
            if (iCC_Profile != null) {
                this.private = new ICCProfileWrap(iCC_Profile.getData());
            }
        }
        catch (IOException iOException) {
            this.ifsuper.getLogger().logException(iOException, 2030, "CMYK:" + iOException.getLocalizedMessage());
        }
    }

    private Path getProfileFile(String string) {
        String string2 = this.ifsuper.getPrefsString("colormanagementsystem", string);
        if (string2 != null && !string2.equals("auto")) {
            Path path = Paths.get(string2, new String[0]);
            return path.isAbsolute() ? Paths.get(string2, new String[0]) : this.ifsuper.getWebInfPath().resolve(string2);
        }
        return null;
    }

    boolean enqueueJob(FileImportJob fileImportJob) {
        if (this.acceptFile(fileImportJob.getQueueType()) && !this.\u00d500000.containsKey(fileImportJob.void)) {
            this.prepareFileImportJobForConversion(fileImportJob);
            this.testForHugeImage(fileImportJob);
            long l = this.\u00d6o0000.incrementAndGet();
            super super_ = new super(l, fileImportJob, this.\u00d5o0000);
            super_.\u00d6O0000(this.ifsuper);
            super_.\u00d2o0000(this.\u00d300000);
            super_.OO0000(this.ifsuper.getScannerDaemon());
            super_.\u00d4O0000(this);
            super_.do(this.private, this.\u00d8o0000, this.String);
            super_.\u00f6O0000(this.\u00f5O0000);
            super_.\u00f4O0000(this.\u00f6O0000, this.\u00d8O0000);
            super_.\u00d300000(this.whilesuper);
            super_.\u00f400000(this.\u00d600000);
            super_.\u00d3O0000(this.oo0000);
            this.\u00d500000.put(fileImportJob.void, CompletableFuture.supplyAsync(super_, this.\u00d2o0000));
            this.ifsuper.getLogger().log(3143, l, fileImportJob.getSourceFile());
            return true;
        }
        return false;
    }

    private void testForHugeImage(FileImportJob fileImportJob) {
        long l;
        if (fileImportJob.getQueueType() == QueueType.String && ((l = (long)fileImportJob.float * (long)fileImportJob.Object * 8L) >= this.\u00d5o0000 || (float)MemoryManager.getFreeHeapSpace() * 0.75f < (float)l)) {
            fileImportJob.setQueueType(QueueType.\u00d500000);
        }
    }

    public static int evaluatePriority(QueueType queueType) {
        if (queueType == QueueType.\u00d200000) {
            return \u00d6O0000.incrementAndGet();
        }
        if (queueType == QueueType.o00000) {
            return oO0000.incrementAndGet();
        }
        if (queueType == QueueType.String) {
            return \u00d200000.incrementAndGet();
        }
        return \u00f600000.incrementAndGet();
    }

    private boolean acceptFile(QueueType queueType) {
        if (queueType != QueueType.\u00d200000 && queueType != QueueType.o00000) {
            this.\u00d5O0000 = this.\u00d3O0000.size() >= 150;
            return this.\u00d2O0000 && !this.\u00d5O0000;
        }
        return this.\u00d2O0000;
    }

    public boolean isFileBeingConverted(super super_) {
        return this.\u00d3O0000.contains(super_);
    }

    public boolean removeJob(FileImportJob fileImportJob) {
        boolean bl = false;
        if (this.\u00d3O0000.contains(fileImportJob)) {
            bl = this.\u00d3O0000.remove(fileImportJob);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobsByPrefix(String string) {
        Map<String, CompletableFuture<Void>> map = this.\u00d500000;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : this.\u00d500000.keySet()) {
                if (!string2.startsWith(string)) continue;
                arrayList.add(string2);
            }
            for (String string2 : arrayList) {
                Future future = this.\u00d500000.remove(string2);
                future.cancel(true);
            }
        }
    }

    private void prepareFileImportJobForConversion(FileImportJob fileImportJob) {
        if (!fileImportJob.\u00d4O0000.\u00d400000 || fileImportJob.getType() == ImageFormat.Type.\u00d200000) {
            fileImportJob.\u00f500000 = FileImportJob.ImportMode.super;
            fileImportJob.supersuper = FileImportJob.SkipReason.String;
        } else if (this.isFileBeingProcessed(fileImportJob)) {
            fileImportJob.\u00f500000 = FileImportJob.ImportMode.super;
            fileImportJob.supersuper = FileImportJob.SkipReason.\u00d300000;
        }
    }

    public boolean isFileBeingProcessed(FileImportJob fileImportJob) {
        return this.\u00d500000.containsKey(fileImportJob.void);
    }

    public void halt() {
        this.\u00d2O0000 = false;
        for (Map.Entry<String, CompletableFuture<Void>> entry : this.\u00d500000.entrySet()) {
            Future future = entry.getValue();
            future.cancel(true);
        }
        ExecutorPool.shutdownAndWait(this.\u00d2o0000, this.\u00d500000.values(), 120);
    }

    public void haltNow() {
        if (this.\u00f800000 != null) {
            this.\u00f800000.dispose();
        }
        if (this.\u00d800000 != null) {
            this.\u00d800000.dispose();
        }
        this.\u00f8O0000 = "stopped";
        this.ifsuper.getLogger().log(2012, "Converter");
    }

    public String getStatus() {
        return this.\u00f8O0000;
    }

    List<FileImportJob> getRecentJobs() {
        FileImportJob[] fileImportJobArray;
        ArrayList<FileImportJob> arrayList = new ArrayList<FileImportJob>();
        for (FileImportJob fileImportJob : fileImportJobArray = (FileImportJob[])this.o00000.toArray(new FileImportJob[0])) {
            if (fileImportJob == null) continue;
            arrayList.add(fileImportJob);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conversionCompleted(ConversionCompletedEvent conversionCompletedEvent) {
        FileImportJob fileImportJob = conversionCompletedEvent.getJob();
        try {
            long l = 0L;
            long l2 = 0L;
            this.\u00f500000.setProcessingImages(0L);
            this.\u00f500000.setProcessingSwapImages(0L);
            if (this.\u00d5O0000 && this.\u00d3O0000.size() < newsuper) {
                this.\u00d5O0000 = false;
            }
            if (fileImportJob != null) {
                this.o00000.add(fileImportJob);
            }
        }
        finally {
            if (fileImportJob != null) {
                this.\u00d500000.remove(fileImportJob.void);
            }
        }
    }

    public long getTotalConversions() {
        return this.\u00d6o0000.get();
    }

    public int getMaxListSize() {
        return 150;
    }

    public int getQueuedImages() {
        return this.\u00d3O0000.size();
    }

    boolean isOverloaded() {
        return this.\u00d5O0000;
    }

    public List<ConverterState> getCurrentJobStates() {
        ArrayList<ConverterState> arrayList = new ArrayList<ConverterState>();
        return arrayList;
    }

    long pingFile(String string) throws NotConfiguredException {
        long l = -1L;
        if (!this.\u00d500000.containsKey(string)) {
            Path path;
            SourceConnectorReader sourceConnectorReader = this.ifsuper.getSourceConnectorFromAssetURLPath(string);
            String string2 = string.substring(sourceConnectorReader.getPrefix().length() + 1);
            Path path2 = sourceConnectorReader.getInboxDirectory().resolve(string2);
            PathCached pathCached = new PathCached(path2);
            ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
            ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
            Path path3 = this.ifsuper.getStorageHelper().getEisFile(string);
            FileImportJob fileImportJob = new FileImportJob(QueueType.\u00d200000, sourceConnectorReader, pathCached, imageFormat, path3, string, Converter_V1002.evaluatePriority(QueueType.\u00d200000), false);
            fileImportJob.o00000 = path = this.ifsuper.getStorageHelper().getDirectoryFile(URL.getParentAssetURLPath(string));
            if (this.enqueueJob(fileImportJob)) {
                l = this.\u00d6o0000.get();
                this.ifsuper.getLogger().log(3193, string, l);
            }
        }
        return l;
    }
}

