/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager;

import com.neptunelabs.fsiserver.framework.collections.Pair;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.io.PluginLoader;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import com.neptunelabs.fsiserver.imageloader.ImageBuilder;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.ImageFormatScanner;
import com.neptunelabs.fsiserver.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.fsiserver.imagereader.metareader.FSIMetaData;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.search.solr.SolrUpdater;
import com.neptunelabs.fsiserver.sourcemanager.Converter_V1002;
import com.neptunelabs.fsiserver.sourcemanager.DirectoryImportHandler;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.QueueType;
import com.neptunelabs.fsiserver.sourcemanager.small.ScannerPauseReason;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptStorageException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.DirectoryImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.FileImportJob;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.EISImageWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.SourceReverseRepairing;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.ImageListFileWriter;
import com.neptunelabs.fsiserver.utils.LDAPAuthentication;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.StorageMetrics;
import com.neptunelabs.fsiserver.utils.URL;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.XMLFileAuthentication;
import com.neptunelabs.fsiserver.utils.comparators.FileComparator;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.MetaData;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScannerDaemon
extends Thread {
    private static final int floatsuper = 6;
    private static final long \u00d600000 = 5000L;
    private static final long \u00f800000 = 15000L;
    private static final FileComparator Oo0000 = new FileComparator();
    private final SourceManagerSettings \u00f4o0000;
    private final ImageListFileWriter \u00f6O0000;
    private final ImageListFileReader \u00d6O0000;
    private final SystemMonitor voidsuper;
    private final Set<String> \u00f6o0000 = Collections.synchronizedSet(new HashSet());
    private final Set<ScannerPauseReason> publicsuper = Collections.synchronizedSet(new HashSet());
    private final Set<ScannerPauseReason> \u00d3O0000 = Collections.synchronizedSet(new HashSet());
    private final List<IOException> \u00d4o0000 = new ArrayList<IOException>();
    private final DirectoryImportHandler do;
    private final Converter_V1002 \u00d200000;
    private final StorageManager interface;
    private final ImageBuilder \u00d4O0000;
    private final StorageHelperV1002 \u00f600000;
    private final FSILogger \u00f8o0000;
    private final SolrUpdater \u00d2O0000;
    private final DateFormat \u00f8O0000 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private long \u00d2o0000 = 0L;
    private long super = 0L;
    private StorageMetrics \u00d3o0000;
    private volatile boolean \u00d8o0000 = false;
    private volatile STATE \u00f400000;
    private volatile STATE class = this.\u00f400000 = STATE.void;
    private boolean \u00d8O0000 = false;
    private boolean int = false;
    private int \u00d300000 = 0;
    private boolean \u00d800000 = false;
    private boolean \u00d400000 = true;
    private boolean OO0000 = false;
    private boolean \u00d6o0000 = false;
    private boolean \u00f4O0000 = false;
    private DirectoryImportJob Objectsuper = null;

    public ScannerDaemon(SourceManagerSettings sourceManagerSettings, Converter_V1002 converter_V1002, SwapPool swapPool, ImageListFileReader imageListFileReader, ImageListFileWriter imageListFileWriter, StorageManager storageManager, DirectoryImportHandler directoryImportHandler, PluginLoader pluginLoader, SolrUpdater solrUpdater) {
        this.\u00f4o0000 = sourceManagerSettings;
        this.\u00d6O0000 = imageListFileReader;
        this.\u00f6O0000 = imageListFileWriter;
        this.\u00f600000 = sourceManagerSettings.getStorageHelper();
        this.\u00d200000 = converter_V1002;
        this.interface = storageManager;
        this.do = directoryImportHandler;
        this.\u00d4O0000 = new ImageBuilder(sourceManagerSettings, swapPool, pluginLoader, imageListFileReader);
        this.voidsuper = sourceManagerSettings.getSystemMonitor();
        this.\u00f8o0000 = sourceManagerSettings.getLogger();
        this.\u00d2O0000 = solrUpdater;
        this.\u00f8O0000.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.setupStorageMetrics();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setName("Scanner Thread V1002");
        this.setDaemon(true);
    }

    private static boolean isRootStorageDirectory(Path path) {
        Path path2 = path.resolve(".FSIServerStorage");
        return Files.exists(path2, new LinkOption[0]);
    }

    public void enableCountOnlyMode(boolean bl) {
        this.\u00d6o0000 = bl;
    }

    public void reportStorageCorruption(CorruptStorageException corruptStorageException) {
        this.\u00f8o0000.log(3229, corruptStorageException.getLocalizedMessage());
        this.\u00d4o0000.add(corruptStorageException);
    }

    public void reportStorageCorruption(IOException iOException) {
        this.\u00f8o0000.log(3229, iOException.getLocalizedMessage());
        this.\u00d4o0000.add(iOException);
    }

    public STATE getScannerState() {
        return this.\u00f400000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseScanner(String string, ScannerPauseReason ... scannerPauseReasonArray) {
        ScannerDaemon scannerDaemon = this;
        synchronized (scannerDaemon) {
            this.\u00f6o0000.add(string);
            if (scannerPauseReasonArray != null) {
                this.publicsuper.addAll(Arrays.asList(scannerPauseReasonArray));
            }
        }
        if (this.\u00f400000 != STATE.\u00d600000 && this.\u00f400000 != STATE.o00000 && this.\u00f400000 != STATE.\u00d500000 && this.\u00f400000 != STATE.Object) {
            if (this.\u00f400000 == STATE.\u00d400000 || this.\u00f400000 == STATE.void) {
                this.class = this.\u00f400000;
                this.\u00f400000 = STATE.\u00d600000;
            } else {
                this.\u00d8o0000 = true;
            }
            while (this.isAlive() && this.\u00f400000 != STATE.\u00d600000) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean isPaused() {
        return this.\u00f400000 == STATE.\u00d600000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScanner(String string) {
        ScannerDaemon scannerDaemon = this;
        synchronized (scannerDaemon) {
            this.\u00f6o0000.remove(string);
            if (this.\u00f6o0000.size() == 0) {
                this.\u00d3O0000.clear();
                this.\u00d3O0000.addAll(this.publicsuper);
                this.publicsuper.clear();
                this.\u00f400000 = this.class;
            }
        }
    }

    public void resetScanner() {
        this.\u00f400000 = STATE.\u00d400000;
        this.do.cancelCurrent();
        this.\u00f6o0000.clear();
    }

    private long checkForRequestPause() {
        boolean bl = false;
        if (this.\u00d8o0000) {
            this.class = this.\u00f400000;
            this.\u00f400000 = STATE.\u00d600000;
            this.\u00d8o0000 = false;
        }
        long l = System.currentTimeMillis();
        while (this.isAlive() && this.\u00f400000 == STATE.\u00d600000 && !this.isInterrupted()) {
            if (!bl) {
                bl = true;
            }
            if (this.\u00f400000 == STATE.\u00d500000) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return System.currentTimeMillis() - l;
    }

    private PoolList makeRootList(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException iOException) {
                this.\u00f8o0000.log(3200, path);
            }
        }
        ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
        long l = 0L;
        for (Map.Entry<String, SourceConnectorReader> entry : this.\u00f4o0000.getEnabledConnectors().entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            PoolDirectoryEntry poolDirectoryEntry = new PoolDirectoryEntry(entry.getValue().getPrefix(), 0L, 0L, 0L);
            l = Math.max(l, entry.getValue().getLastModfied());
            arrayList.add(poolDirectoryEntry);
        }
        return this.\u00f6O0000.updateEntries(path, "/", null, null, arrayList, l);
    }

    private void transferProfiles(Path path) {
        Comparable<PathCached> comparable;
        Object object;
        Object object2;
        Object object3;
        Path path2 = this.\u00f4o0000.getSourceConnectorPath();
        if (Files.exists(path2, new LinkOption[0])) {
            try {
                object3 = FileOperations.listFiles(path2);
                if (object3 != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (!((PathCached)object).isRegularFile() || !((PathCached)object).isReadable()) continue;
                        comparable = path.resolve(((PathCached)object).getFileName() + ".profile");
                        boolean bl = false;
                        if (Files.exists(comparable, new LinkOption[0]) && (((PathCached)object).lastModified() != FileOperations.getSafeLastModified(comparable) || ((PathCached)object).size() != Files.size(comparable))) {
                            bl = true;
                        } else if (Files.notExists(comparable, new LinkOption[0])) {
                            bl = true;
                        }
                        if (!bl) continue;
                        FileOperations.copy(this.\u00f8o0000, ((PathCached)object).getPath(), comparable);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                object3 = FileOperations.listFiles(path);
                if (object3 != null) {
                    object2 = Pattern.compile("(.+).profile");
                    object = object3.iterator();
                    while (object.hasNext()) {
                        String string;
                        Matcher matcher;
                        comparable = (PathCached)object.next();
                        if (!((PathCached)comparable).isRegularFile() || !((PathCached)comparable).isReadable() || !(matcher = ((Pattern)object2).matcher(string = ((PathCached)comparable).getFileName())).find()) continue;
                        string = matcher.group(1);
                        Path path3 = this.\u00f4o0000.getSourceConnectorPath().resolve(string);
                        if (!Files.notExists(path3, new LinkOption[0])) continue;
                        try {
                            Files.delete(((PathCached)comparable).getPath());
                        }
                        catch (IOException iOException) {
                            this.\u00f8o0000.log(3200, comparable);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((object3 = this.\u00f4o0000.getUserAuthenticationInterface()) instanceof XMLFileAuthentication) {
            Path path4;
            object2 = (XMLFileAuthentication)object3;
            object = ((XMLFileAuthentication)object2).getUsersFile();
            if (Files.exists((Path)object, new LinkOption[0])) {
                FileOperations.copy(this.\u00f8o0000, (Path)object, path.resolve("users.xml"));
            }
            if (Files.exists(comparable = ((XMLFileAuthentication)object2).getGroupsFile(), new LinkOption[0])) {
                FileOperations.copy(this.\u00f8o0000, comparable, path.resolve("groups.xml"));
            }
            if (Files.exists(path4 = ((XMLFileAuthentication)object2).getPermissionSetsDirectory(), new LinkOption[0])) {
                FileOperations.copy(this.\u00f8o0000, path4, path.resolve("permissionsets"));
            }
        } else if (object3 instanceof LDAPAuthentication) {
            object2 = (LDAPAuthentication)object3;
            ((UserAuthenticationInterface)object3).saveUsersToFile(path.resolve("users.xml"));
            ((UserAuthenticationInterface)object3).saveGroupsToFile(path.resolve("groups.xml"));
            object = ((LDAPAuthentication)object2).getPermissionSetsDirectory();
            if (Files.exists((Path)object, new LinkOption[0])) {
                FileOperations.copy(this.\u00f8o0000, (Path)object, path.resolve("permissionsets"));
            }
        }
    }

    private boolean deleteObsoleteProfileData(PoolList poolList) throws NotConfiguredException, IOException {
        boolean bl = false;
        if (poolList != null) {
            Set<String> set = poolList.getDirectoryNameSet();
            for (String string : set) {
                this.checkForRequestPause();
                if (this.\u00f4o0000.getAllConnectors().containsKey(string)) continue;
                this.\u00f6O0000.forceClearingAllBuffers();
                this.\u00f8o0000.log(3179, string);
                STATE sTATE = this.\u00f400000;
                this.\u00f400000 = STATE.Object;
                this.removeProfileFromStorageV1002(string);
                if (this.\u00d2O0000 != null) {
                    this.\u00d2O0000.deleteAssetWithPrefixAsync(string + "/");
                }
                this.\u00f400000 = sTATE;
                Path path = this.\u00f600000.getDirectoryFile("/");
                this.\u00f6O0000.removeEntry(path, "/", null, null, string, FileOperations.getSafeLastModified(path.getParent()));
                bl = true;
            }
        }
        return bl;
    }

    private void removeProfileFromStorageV1002(String string) throws IOException {
        Path path = this.\u00f600000.getProfileStorageBase(string);
        if (Files.exists(path, new LinkOption[0])) {
            FileOperations.deleteDir(path);
        }
    }

    private void checkLicenceLimits() {
        if (this.\u00f4o0000.getLicence().hasLicence()) {
            long l;
            long l2 = this.\u00f4o0000.getLicence().getMaxImages();
            if (!this.\u00d8O0000) {
                if (l2 >= 0L && this.\u00d2o0000 > l2) {
                    this.\u00f8o0000.log(7004, this.\u00d2o0000, l2);
                    this.\u00d8O0000 = true;
                }
            } else if (this.\u00d2o0000 < l2) {
                this.\u00d8O0000 = false;
            }
            if ((l = this.\u00f4o0000.getLicence().getExpireTime()) > 0L && !this.int && this.\u00f4o0000.getLicence().getExpireTime() < System.currentTimeMillis()) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                this.\u00f8o0000.log(7005, dateFormat.format(new Date(this.\u00f4o0000.getLicence().getExpireTime())));
                this.int = true;
            }
        }
    }

    void updateSearchDatabaseEntryForAsset(String string, FSIMetaData fSIMetaData, short s) {
        if (this.\u00d2O0000 != null) {
            String string2 = string.substring(string.lastIndexOf("/") + 1);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("file.name", string2);
            String[] stringArray = FileOperations.splitFilename(string2);
            if (stringArray != null) {
                hashMap.put("file.prefix", stringArray[0]);
                hashMap.put("file.suffix", stringArray[1]);
            }
            hashMap.put("file.type", "file");
            hashMap.put("file.status", String.valueOf(s));
            if (fSIMetaData != null) {
                Object object;
                ImageMetaData imageMetaData = ImageMetaData.getInstance(fSIMetaData);
                imageMetaData.setAssetURLPath(string);
                hashMap.put("file.lastmodified", this.\u00f8O0000.format(new Date(imageMetaData.getLastModified())));
                hashMap.put("file.size", String.valueOf(((FileMetaData)imageMetaData).getSourceFileSize()));
                ImageMetaData imageMetaData2 = imageMetaData;
                hashMap.put("file.width", String.valueOf(imageMetaData2.getWidth()));
                hashMap.put("file.height", String.valueOf(imageMetaData2.getHeight()));
                int n = imageMetaData2.hasAlpha() ? 1 : 0;
                hashMap.put("file.alpha", String.valueOf(n += imageMetaData2.getExtraAlphaCount()));
                hashMap.put("file.resolution", String.valueOf((long)imageMetaData2.getWidth() * (long)imageMetaData2.getHeight()));
                ICCProfileWrap iCCProfileWrap = imageMetaData2.getICC();
                if (iCCProfileWrap != null) {
                    hashMap.put("file.icc", iCCProfileWrap.getName());
                }
                try {
                    object = ((MetaData)imageMetaData).getSortedIPTCList();
                    Iterator<Object> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Pair<String, String> object2 = iterator.next();
                        hashMap.put("iptc." + object2.getItem1(), object2.getItem2());
                    }
                }
                catch (Exception exception) {
                    this.\u00f8o0000.logException(exception, 3231, string);
                }
                try {
                    object = ((MetaData)imageMetaData).getExifSortedMap(this.\u00f8o0000, string2, false);
                    for (Map.Entry entry : object.entrySet()) {
                        if (((Pair)entry.getValue()).getItem1() == null || ((Pair)entry.getValue()).getItem2() == null) continue;
                        hashMap.put("exif." + (String)((Pair)entry.getValue()).getItem1(), (String)((Pair)entry.getValue()).getItem2());
                    }
                }
                catch (Exception exception) {
                    this.\u00f8o0000.logException(exception, 3230, string);
                }
            }
            this.\u00d2O0000.setMetaDataASync(string, hashMap, false);
        }
    }

    public boolean assetExists(String string) throws NotConfiguredException {
        boolean bl = false;
        SourceConnectorReader sourceConnectorReader = this.\u00f4o0000.getSourceConnectorFromAssetURLPath(string);
        try {
            this.\u00d4O0000.getImageMetaData(sourceConnectorReader, string, 0, true, null);
            bl = true;
        }
        catch (IOException iOException) {
            try {
                this.\u00d4O0000.getDirectoryMetaData(sourceConnectorReader, string, sourceConnectorReader.getSourceFileFromAssetURLPath(string), 0);
                bl = true;
            }
            catch (IOException iOException2) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean getMetaDataAndUpdateSearchDatabase(String string, boolean bl) throws NotConfiguredException {
        boolean bl2;
        block12: {
            bl2 = false;
            SolrUpdater solrUpdater = this.\u00d2O0000;
            if (solrUpdater != null) {
                SourceConnectorReader sourceConnectorReader = this.\u00f4o0000.getSourceConnectorFromAssetURLPath(string);
                if (sourceConnectorReader == null) {
                    return false;
                }
                try {
                    MetaData metaData;
                    PathCached pathCached = null;
                    boolean bl3 = false;
                    if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000 || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
                        bl3 = this.isStorageDirectory(string);
                    } else {
                        pathCached = sourceConnectorReader.getSourceFileFromAssetURLPath(string);
                        bl3 = pathCached.isDirectory();
                    }
                    int n = 29;
                    if (bl3) {
                        if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
                            metaData = this.\u00d4O0000.getDirectoryMetaData(string);
                        } else {
                            pathCached = sourceConnectorReader.getSourceFileFromAssetURLPath(string);
                            metaData = this.\u00d4O0000.getDirectoryMetaData(sourceConnectorReader, string, pathCached, 29);
                        }
                    } else {
                        metaData = this.\u00d4O0000.getImageMetaData(sourceConnectorReader, string, 29, true, null);
                    }
                    if (metaData != null) {
                        metaData.setAssetURLPath(string);
                        Map<String, String> map = this.getMetaDataMapFromImageMetaData(metaData);
                        bl2 = solrUpdater.setMetaDataASync(string, map, bl);
                        break block12;
                    }
                    solrUpdater.deleteAssetAsync(string);
                }
                catch (IOException iOException) {}
            } else {
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean isStorageDirectory(String string) throws NotConfiguredException {
        StorageHelperV1002 storageHelperV1002 = this.\u00f4o0000.getStorageHelper();
        return storageHelperV1002.isStorageDirectory(string);
    }

    private Map<String, String> getMetaDataMapFromImageMetaData(MetaData metaData) {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = metaData.getAssetURLPath().substring(metaData.getAssetURLPath().lastIndexOf("/") + 1);
        hashMap.put("file.name", string);
        hashMap.put("file.lastmodified", this.\u00f8O0000.format(new Date(metaData.getLastModified())));
        if (metaData instanceof DirectoryMetaData) {
            hashMap.put("file.type", "directory");
        } else {
            hashMap.put("file.type", "file");
        }
        if (metaData instanceof FileMetaData) {
            object2 = (FileMetaData)metaData;
            object = FileOperations.splitFilename(string);
            if (object != null) {
                hashMap.put("file.prefix", object[0]);
                hashMap.put("file.suffix", (String)object[1]);
            }
            hashMap.put("file.size", String.valueOf(((FileMetaData)object2).getSourceFileSize()));
        }
        if (metaData instanceof ImageMetaData) {
            Map<Pair<String, String>, String> map;
            object2 = (ImageMetaData)metaData;
            hashMap.put("file.width", String.valueOf(((ImageMetaData)object2).getWidth()));
            hashMap.put("file.height", String.valueOf(((ImageMetaData)object2).getHeight()));
            hashMap.put("file.status", String.valueOf(((ImageMetaData)object2).getImportStatus()));
            object = ((ImageMetaData)object2).getSortedIPTCList();
            if (object != null) {
                Iterator map2 = object.iterator();
                while (map2.hasNext()) {
                    Pair pair = (Pair)map2.next();
                    hashMap.put("iptc." + (String)pair.getItem1(), (String)pair.getItem2());
                }
            }
            if ((map = ((ImageMetaData)object2).getExifFullMap(this.\u00f8o0000, metaData.getAssetURLPath(), false)) != null) {
                for (Map.Entry entry : map.entrySet()) {
                    hashMap.put("exif." + (String)((Pair)entry.getKey()).getItem1(), (String)entry.getValue());
                }
            }
        }
        if ((object2 = metaData.getCustomMetaData()) != null) {
            for (Map.Entry entry : object2.entrySet()) {
                hashMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return hashMap;
    }

    private boolean checkForDeletedDirectories(PoolList poolList, Deque<PathCached> deque, String string) {
        Set<String> set = poolList.getDirectoryNameSet();
        for (PathCached pathCached : deque) {
            if (this.isInterrupted() || this.\u00f400000 == STATE.\u00d500000) break;
            if (!this.do.isRecursableDir(pathCached)) continue;
            set.remove(pathCached.getFileName().toString());
        }
        return set.size() > 0;
    }

    private List<PoolEntry> checkForNewDirectories(PoolList poolList, Deque<PathCached> deque) {
        ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
        Set<String> set = poolList.getDirectoryNameSet();
        for (PathCached pathCached : deque) {
            this.checkForRequestPause();
            if (this.isInterrupted() || this.\u00f400000 == STATE.\u00d500000) break;
            if (!this.do.isRecursableDir(pathCached) || set.contains(pathCached.getFileName())) continue;
            try {
                arrayList.add(new PoolDirectoryEntry(pathCached.getFileName(), pathCached.lastModified(), 0L, 0L));
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    private PoolList rebuildPoolList(SourceConnectorReader sourceConnectorReader, Path path, String string, boolean bl) throws NotConfiguredException {
        Path path2 = this.\u00f4o0000.getStorageHelper().getDirectoryFile(string);
        PoolList poolList = new PoolList(path2, string);
        Deque<PathCached> deque = null;
        try {
            deque = this.listAllFiles(path);
        }
        catch (IOException iOException) {
            deque = new ArrayDeque<PathCached>();
        }
        int n = sourceConnectorReader.getInboxDirectory().getAbsoluteNameLength();
        for (PathCached pathCached : deque) {
            try {
                if (pathCached.isDirectory()) {
                    if (!pathCached.isReadable() || !this.do.isRecursableDir(pathCached)) continue;
                    poolList.addDirectory(new PoolDirectoryEntry(pathCached.getFileName(), 0L, 0L, 0L));
                    continue;
                }
                if (!bl || !this.do.isValidFilename(pathCached, false)) continue;
                ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
                ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
                if (!imageFormat.\u00d400000 || imageFormat.super == ImageFormat.Type.\u00d200000) continue;
                PoolFileEntry poolFileEntry = null;
                if (poolFileEntry == null) {
                    try {
                        poolFileEntry = new PoolFileEntry(pathCached.getFileName(), pathCached.lastModified(), pathCached.size(), -1, -1, 0);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                poolList.addImage(poolFileEntry);
            }
            catch (IOException iOException) {}
        }
        return poolList;
    }

    private void setupStorageMetrics() throws IOException {
        Path path = this.\u00f600000.getMetricsDir();
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        Path path2 = path.resolve("stats");
        this.\u00d3o0000 = new StorageMetrics(this.\u00f4o0000, path2);
    }

    public boolean isAcceptedFileForStorageConnector(Path path) {
        PathCached pathCached = new PathCached(path);
        ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
        ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
        try {
            return imageFormat.\u00d400000 && imageFormat.super != ImageFormat.Type.\u00d200000 && this.do.isValidFilename(pathCached, true);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean hasStorageID() {
        String string = this.\u00f4o0000.getStorageID();
        return string != null;
    }

    private void checkReverseLookup(Map<String, SourceConnectorReader> map) throws IOException {
        Path path = this.\u00f4o0000.getStorageLocation().resolve(".rlcheck");
        if (Files.deleteIfExists(path)) {
            for (Map.Entry<String, SourceConnectorReader> entry : map.entrySet()) {
                if (this.\u00f400000 == STATE.\u00d500000 || this.\u00f400000 == STATE.\u00d400000) continue;
                SourceConnectorReader sourceConnectorReader = entry.getValue();
                PathCached pathCached = sourceConnectorReader.getInboxDirectory();
                if (sourceConnectorReader.getPrefix().equals("_downloads") || sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.\u00d300000 || !pathCached.exists()) continue;
                this.\u00f8o0000.log(3180, sourceConnectorReader.getPrefix());
                long l = System.currentTimeMillis();
                SourceReverseRepairing sourceReverseRepairing = new SourceReverseRepairing(sourceConnectorReader, this.\u00f600000, this.interface, this.do, pathCached);
                try {
                    Files.walkFileTree(sourceConnectorReader.getInboxDirectory().getPath(), sourceReverseRepairing);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                long l2 = System.currentTimeMillis() - l;
                boolean bl = sourceReverseRepairing.hasChanged();
                this.\u00f8o0000.log(3181, sourceConnectorReader.getPrefix(), Long.toString(l2), bl ? "yes" : "no");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.\u00f4O0000 = this.\u00f4o0000.getPrefsBoolean("scanner", "sorting");
        try {
            this.\u00f400000 = STATE.void;
            this.checkForRequestPause();
            if (this.hasStorageID()) {
                Map<String, SourceConnectorReader> map = this.\u00f4o0000.getEnabledConnectors();
                PoolList poolList = this.getRootDirlist();
                this.\u00f400000 = STATE.\u00f400000;
                this.\u00f8o0000.log(3194, map.size());
                long l = System.currentTimeMillis();
                poolList = this.checkConnectorEntriesInRootList(map, poolList);
                long l2 = System.currentTimeMillis();
                this.\u00f8o0000.log(3195, l2 - l);
                this.transferProfiles();
                if (this.\u00f400000 == STATE.\u00d500000) {
                    this.\u00f400000 = STATE.o00000;
                    return;
                }
                this.\u00f400000 = STATE.void;
                this.checkReverseLookup(this.\u00f4o0000.getEnabledConnectors());
                while (!this.isInterrupted() && this.\u00f400000 != STATE.\u00d500000) {
                    long l3;
                    DirectoryImportJob directoryImportJob;
                    if (this.\u00f400000 == STATE.\u00d400000) {
                        map = this.\u00f4o0000.getEnabledConnectors();
                        poolList = this.checkConnectorEntriesInRootList(map, poolList);
                        this.transferProfiles();
                    }
                    boolean bl = (directoryImportJob = this.do.getCurrentJob()) != null && this.Objectsuper != null && directoryImportJob.equals(this.Objectsuper) && directoryImportJob.getStartTime() == this.Objectsuper.getStartTime();
                    this.Objectsuper = directoryImportJob;
                    if (bl) {
                        this.\u00f8o0000.log(3182, this.Objectsuper.null, this.\u00f8O0000.format(new Date()));
                        try {
                            for (l3 = 15000L; l3 > 0L; l3 -= 100L + this.checkForRequestPause()) {
                                Thread.sleep(100L);
                            }
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                    if (this.\u00d4o0000.size() > 0) {
                        this.checkForRequestPause();
                        ArrayList<IOException> arrayList = new ArrayList<IOException>(this.\u00d4o0000);
                        this.\u00d4o0000.clear();
                        for (IOException iOException : arrayList) {
                            if (!(iOException instanceof CorruptReverseLookupException)) continue;
                            Path path = ((CorruptReverseLookupException)iOException).getReverseLookupFile();
                            FileOperations.deleteDir(path.getParent());
                        }
                        this.OO0000 = true;
                    }
                    this.checkForRequestPause();
                    if (this.\u00f400000 == STATE.\u00d400000) {
                        this.\u00f400000 = STATE.\u00f400000;
                    } else {
                        if (this.\u00f400000 == STATE.\u00d500000) {
                            this.\u00f400000 = STATE.o00000;
                            return;
                        }
                        this.\u00f400000 = STATE.\u00f400000;
                    }
                    l3 = System.currentTimeMillis();
                    poolList = this.getRootDirlist();
                    if (this.deleteObsoleteProfileData(poolList)) {
                        poolList = this.getRootDirlist();
                    }
                    boolean bl2 = false;
                    this.\u00d400000 = this.\u00d300000 % 6 == 0;
                    for (Map.Entry entry : map.entrySet()) {
                        SourceConnectorReader sourceConnectorReader;
                        if (!((SourceConnectorReader)entry.getValue()).isScanner()) continue;
                        this.checkForRequestPause();
                        if (this.\u00f400000 == STATE.\u00d500000 || this.\u00f400000 == STATE.\u00d400000 || (sourceConnectorReader = (SourceConnectorReader)entry.getValue()).getPrefix().equals("_downloads") || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) continue;
                        PathCached pathCached = sourceConnectorReader.getInboxDirectory();
                        if (pathCached.isReadable()) {
                            try {
                                long l4;
                                long l5 = this.\u00d2o0000;
                                bl2 |= this.recursiveFullScan(sourceConnectorReader, pathCached);
                                long l6 = sourceConnectorReader.getCurrentImageCount();
                                if (l6 == (l4 = this.\u00d2o0000 - l5)) continue;
                                sourceConnectorReader.setCurrentImageCount(l4);
                            }
                            catch (Exception exception) {
                                if (exception instanceof InterruptedException || exception instanceof NotConfiguredException) {
                                    throw exception;
                                }
                                System.err.println("Caught Exception scanning contents of connector " + sourceConnectorReader.getPrefix());
                                exception.printStackTrace();
                            }
                            continue;
                        }
                        sourceConnectorReader.setEnabled(false);
                    }
                    if (this.\u00d400000 && this.\u00f400000 != STATE.\u00d500000 && this.\u00f400000 != STATE.\u00d400000) {
                        if (this.\u00d800000) {
                            this.\u00d800000 = false;
                        }
                        this.\u00d3o0000.setValues(this.\u00d2o0000, this.super);
                        this.\u00d3o0000.saveToFile();
                        this.checkLicenceLimits();
                        this.voidsuper.setAssetCount(this.\u00d2o0000);
                        this.voidsuper.setAssetSize(this.super);
                    }
                    long l7 = this.\u00d2o0000;
                    this.resetCounters();
                    if (this.\u00f400000 != STATE.\u00d500000 && this.\u00f400000 != STATE.\u00d400000) {
                        ++this.\u00d300000;
                        this.sleepBetweenScans(l3, bl2, l7);
                    }
                    this.OO0000 = false;
                }
            }
        }
        catch (IOException iOException) {
            this.\u00f8o0000.logException(iOException, 3260, iOException.getLocalizedMessage());
        }
        catch (NotConfiguredException notConfiguredException) {
        }
        finally {
            try {
                this.do.join(30000L);
            }
            catch (InterruptedException interruptedException) {}
            this.\u00f400000 = STATE.o00000;
        }
    }

    public final void triggerDirectoryCheck(Path path, String string) {
        boolean bl = this.do.isDirectoryEnqueued(path, string, false);
        if (!bl) {
            SourceConnectorReader sourceConnectorReader = this.\u00f4o0000.getSourceConnectorFromAssetURLPath(string);
            this.do.submitDirectory(sourceConnectorReader, path, FileOperations.getSafeLastModified(path), string, false, false);
        }
    }

    private boolean recursiveFullScan(SourceConnectorReader sourceConnectorReader, PathCached pathCached) throws NotConfiguredException, IOException {
        Deque<Object> deque;
        boolean bl = false;
        if (ScannerDaemon.isRootStorageDirectory(pathCached.getPath())) {
            return bl;
        }
        this.checkForRequestPause();
        String string = sourceConnectorReader.getPrefix() + pathCached.getAbsoluteName().substring(sourceConnectorReader.getInboxDirectory().getAbsoluteNameLength());
        string = FileOperations.convertBackslash(string);
        Path path = this.\u00f600000.getDirectoryFile(string);
        PoolList poolList = null;
        try {
            poolList = this.\u00d6O0000.getListFileContents(path, string);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException iOException) {
            this.\u00f8o0000.logException(iOException, 3249, path, string);
        }
        if (poolList == null || poolList.\u00d4\u00d60000 != pathCached.lastModified()) {
            bl = true;
        } else {
            this.\u00d2o0000 += (long)poolList.getFileCount();
        }
        this.checkForRequestPause();
        if (this.\u00f400000 != STATE.\u00d500000) {
            try {
                deque = this.listAllFiles(pathCached.getPath());
            }
            catch (IOException iOException) {
                deque = new ArrayDeque();
            }
        } else {
            deque = new ArrayDeque();
        }
        if (this.\u00f400000 != STATE.\u00d500000 && !this.\u00d6o0000) {
            boolean bl2 = this.do.isDirectoryEnqueued(pathCached.getPath(), string, this.OO0000);
            this.checkForRequestPause();
            if (!bl2) {
                if (this.OO0000) {
                    this.do.submitDirectory(sourceConnectorReader, pathCached.getPath(), pathCached.lastModified(), string, this.\u00d800000, this.OO0000);
                } else {
                    if (!bl && this.\u00d400000) {
                        bl = this.checkFiles(poolList, deque);
                    }
                    this.checkForRequestPause();
                    if (!bl) {
                        bl = this.checkDirectories(poolList, deque);
                    }
                    this.checkForRequestPause();
                    if (!bl) {
                        bl = this.checkParentDirlistEntry(poolList, string);
                    }
                    this.checkForRequestPause();
                    if (bl && this.\u00f400000 != STATE.\u00d500000 && this.\u00f400000 != STATE.\u00d400000) {
                        this.do.submitDirectory(sourceConnectorReader, pathCached.getPath(), pathCached.lastModified(), string, this.\u00d800000, this.OO0000);
                    }
                }
            }
        }
        if (this.\u00f400000 != STATE.\u00d500000 && this.\u00f400000 != STATE.\u00d400000) {
            if (this.\u00f4O0000) {
                ArrayList<PathCached> arrayList = new ArrayList<PathCached>();
                for (PathCached pathCached2 : deque) {
                    if (!this.do.isRecursableDir(pathCached2)) continue;
                    arrayList.add(pathCached2);
                }
                for (PathCached pathCached3 : arrayList) {
                    bl |= this.recursiveFullScan(sourceConnectorReader, pathCached3);
                }
            } else {
                for (PathCached pathCached4 : deque) {
                    if (!this.do.isRecursableDir(pathCached4)) continue;
                    bl |= this.recursiveFullScan(sourceConnectorReader, pathCached4);
                }
            }
        }
        if (this.\u00f400000 == STATE.\u00d500000 || this.\u00f400000 == STATE.\u00d400000) {
            return false;
        }
        return bl;
    }

    private boolean checkParentDirlistEntry(PoolList poolList, String string) throws NotConfiguredException {
        String string2 = URL.getParentAssetURLPath(string);
        Path path = this.\u00f600000.getDirectoryFile(string2);
        try {
            PoolList poolList2 = this.\u00d6O0000.getListFileContents(path, string2);
            String string3 = string2.length() > 1 ? string.substring(string2.length() + 1) : string;
            PoolDirectoryEntry poolDirectoryEntry = poolList2.getDirectory(string3);
            if (poolDirectoryEntry.\u00f500000 != (long)poolList.getFileCount()) {
                return true;
            }
            if (poolDirectoryEntry.null != (long)poolList.getDirectoryCount()) {
                return true;
            }
            if (poolDirectoryEntry.\u00d200000 != poolList.\u00d4\u00d60000) {
                return true;
            }
        }
        catch (IOException iOException) {
            return true;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkDirectories(PoolList poolList, Deque<PathCached> deque) {
        Set<String> set = poolList.getDirectoryNameSet();
        for (PathCached pathCached : deque) {
            this.checkForRequestPause();
            if (!this.do.isRecursableDir(pathCached)) continue;
            if (set.contains(pathCached.getFileName())) {
                set.remove(pathCached.getFileName());
                continue;
            }
            return true;
        }
        return set.size() > 0;
    }

    private boolean checkFiles(PoolList poolList, Deque<PathCached> deque) throws NotConfiguredException {
        Set<String> set = poolList.getImageNameSet();
        for (PathCached pathCached : deque) {
            this.checkForRequestPause();
            try {
                if (!pathCached.isRegularFile()) continue;
                ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
                ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
                if (!set.remove(pathCached.getFileName()) && imageFormat.\u00d400000 && imageFormat.super != ImageFormat.Type.\u00d200000 && this.do.isValidFilename(pathCached, false)) {
                    return true;
                }
                PoolFileEntry poolFileEntry = poolList.getImage(pathCached.getFileName());
                if (poolFileEntry == null) continue;
                long l = pathCached.size();
                this.super += l;
                if (poolFileEntry.\u00d800000 == 2 || poolFileEntry.\u00d800000 == 4 || this.\u00d800000 && poolFileEntry.\u00d800000 != 1) {
                    return true;
                }
                if (poolFileEntry.\u00d200000 == pathCached.lastModified() && poolFileEntry.\u00d500000 == l) continue;
                return true;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        return set.size() > 0;
    }

    private void resetCounters() {
        this.\u00d2o0000 = 0L;
        this.super = 0L;
    }

    private void sleepBetweenScans(long l, boolean bl, long l2) {
        long l3 = System.currentTimeMillis() - l;
        long l4 = !bl || this.\u00d200000.isOverloaded() ? (15000L - l3 < 0L ? 5000L : 15000L - l3) : 15000L;
        if (this.\u00f400000 != STATE.\u00d500000) {
            this.voidsuper.setScannerTime(l3);
            this.\u00f8o0000.log(3183, l2, l3, l4, Boolean.toString(bl));
            this.\u00f400000 = STATE.void;
        }
        try {
            for (long i = l4; i > 0L; i -= 100L + this.checkForRequestPause()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private PoolList checkConnectorEntriesInRootList(Map<String, SourceConnectorReader> map, PoolList poolList) throws NotConfiguredException {
        for (Map.Entry<String, SourceConnectorReader> entry : map.entrySet()) {
            this.checkForRequestPause();
            SourceConnectorReader sourceConnectorReader = entry.getValue();
            if (sourceConnectorReader.getPrefix().equals("_downloads")) continue;
            if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000 && sourceConnectorReader.getInboxDirectory().exists()) {
                this.newRecursiveDirectoryScan(sourceConnectorReader, sourceConnectorReader.getInboxDirectory(), false, false);
            } else if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
                this.newAPIOnlyScan(sourceConnectorReader);
            }
            poolList = this.checkProfileEntryInRootList(poolList, sourceConnectorReader);
        }
        return poolList;
    }

    private void newAPIOnlyScan(SourceConnectorReader sourceConnectorReader) throws NotConfiguredException {
        String string = sourceConnectorReader.getPrefix();
        Path path = this.\u00f600000.getDirectoryFile(string);
        try {
            PoolList poolList = this.\u00d6O0000.getListFileContents(path, string);
        }
        catch (NoSuchFileException noSuchFileException) {
            String string2 = URL.getParentAssetURLPath(string);
            Path path2 = this.\u00f600000.getDirectoryFile(string2);
            ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
            this.\u00f6O0000.updateEntries(path, string, path2, string2, arrayList, sourceConnectorReader.getLastModfied());
        }
        catch (IOException iOException) {
            this.\u00f8o0000.logException(iOException, 3504, path, iOException.getLocalizedMessage());
        }
    }

    private void newRecursiveDirectoryScan(SourceConnectorReader sourceConnectorReader, PathCached pathCached, boolean bl, boolean bl2) throws NotConfiguredException {
        Deque<PathCached> deque;
        this.checkForRequestPause();
        if (ScannerDaemon.isRootStorageDirectory(pathCached.getPath())) {
            return;
        }
        if (this.\u00f400000 == STATE.\u00d500000 || this.\u00f400000 == STATE.\u00d400000) {
            return;
        }
        long l = 0L;
        try {
            l = pathCached.lastModified(true);
            deque = this.listDirectories(pathCached.getPath());
        }
        catch (IOException iOException) {
            deque = null;
        }
        if (deque == null) {
            return;
        }
        for (PathCached object2 : deque) {
            if (!this.do.isRecursableDir(object2)) continue;
            this.checkForRequestPause();
            this.newRecursiveDirectoryScan(sourceConnectorReader, object2, bl, bl2);
        }
        if (this.\u00f400000 == STATE.\u00d500000 || this.\u00f400000 == STATE.\u00d400000) {
            return;
        }
        int n = sourceConnectorReader.getInboxDirectory().getAbsoluteNameLength();
        String string = pathCached.getAbsoluteName().replace(File.separatorChar, '/');
        String string2 = sourceConnectorReader.getPrefix() + string.substring(n);
        Path path = this.\u00f600000.getDirectoryFile(string2);
        PoolList poolList = null;
        try {
            poolList = this.\u00d6O0000.getListFileContents(path, string2);
        }
        catch (IOException poolList2) {
            // empty catch block
        }
        if (poolList == null) {
            PoolList list = this.rebuildPoolList(sourceConnectorReader, pathCached.getPath(), string2, bl2);
            list.\u00d4\u00d60000 = l;
            this.\u00f6O0000.replaceAll(path, list);
            this.getMetaDataAndUpdateSearchDatabase(string2, false);
        } else if (bl || l != poolList.\u00d4\u00d60000) {
            this.checkForDeletedDirectories(poolList, deque, string2);
            List<PoolEntry> list = this.checkForNewDirectories(poolList, deque);
            if (list.size() > 0) {
                String string3 = URL.getParentAssetURLPath(string2);
                Path path2 = this.\u00f600000.getDirectoryFile(string3);
                this.\u00f6O0000.updateEntries(path, string2, path2, string3, list, l);
                this.getMetaDataAndUpdateSearchDatabase(string2, false);
            }
        }
    }

    private PoolList checkProfileEntryInRootList(PoolList poolList, SourceConnectorReader sourceConnectorReader) throws NotConfiguredException {
        if (!poolList.containsDirectory(sourceConnectorReader.getPrefix())) {
            ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
            PoolDirectoryEntry poolDirectoryEntry = new PoolDirectoryEntry(sourceConnectorReader.getPrefix(), sourceConnectorReader.getLastModfied(), 0L, 0L);
            long l = Math.max(poolList.\u00d4\u00d60000, sourceConnectorReader.getLastModfied());
            arrayList.add(poolDirectoryEntry);
            Path path = this.\u00f600000.getDirectoryFile("/");
            this.\u00f6O0000.updateEntries(path, "/", null, null, arrayList, l);
            poolList = this.getRootDirlist();
        }
        return poolList;
    }

    public void halt() {
        this.\u00f400000 = STATE.\u00d500000;
        this.interrupt();
        this.do.shutdown();
        try {
            this.do.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public long getScanCount() {
        return this.\u00d2o0000;
    }

    public long getEnqueuedImages() {
        return this.\u00d200000.getQueuedImages();
    }

    public void manuallySubmitDirectory(DirectoryImportJob directoryImportJob) throws NotConfiguredException, IOException {
        try {
            this.do.processJob(directoryImportJob);
        }
        catch (CorruptStorageException corruptStorageException) {
            this.reportStorageCorruption(corruptStorageException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean manuallySubmitNewJob(SourceConnectorReader sourceConnectorReader, Path path) throws NotConfiguredException, IOException {
        PathCached pathCached = new PathCached(path);
        ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
        ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
        if (!(sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.\u00d300000 && sourceConnectorReader.getMountType() != SourceConnectorReader.SourceConnectorType.\u00d400000 || imageFormat.\u00d400000 && imageFormat.super != ImageFormat.Type.\u00d200000 && this.do.isValidFilename(pathCached, false))) {
            return false;
        }
        int n = sourceConnectorReader.getInboxDirectory().getAbsoluteNameLength();
        String string = sourceConnectorReader.getPrefix() + pathCached.getAbsoluteName().substring(n);
        string = FileOperations.convertBackslash(string);
        String string2 = URL.getParentAssetURLPath(string);
        String string3 = "pk8-" + string.hashCode();
        boolean bl = false;
        try {
            this.pauseScanner(string3, new ScannerPauseReason(string2, ScannerPauseReason.ModificationType.\u00d400000));
            if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d300000 || sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.\u00d400000) {
                if (pathCached.isRegularFile()) {
                    Path path2 = this.\u00f600000.getEisFile(string);
                    FileImportJob fileImportJob = new FileImportJob(QueueType.o00000, sourceConnectorReader, pathCached, imageFormat, path2, string, Converter_V1002.evaluatePriority(QueueType.o00000), false);
                    EISImageWriter eISImageWriter = new EISImageWriter(this.\u00f4o0000, 2, -1);
                    eISImageWriter.setAssetURLPath(string);
                    FSIMetaData fSIMetaData = new FSIMetaData(null);
                    fSIMetaData.while = pathCached.size();
                    eISImageWriter.setMetaData(fSIMetaData);
                    this.interface.executeStorageDataProvider(path2, eISImageWriter);
                    fileImportJob.o00000 = this.makeDirlistEntryForManuallySubmittedJob(pathCached, string2);
                    this.\u00d200000.enqueueJob(fileImportJob);
                    bl = true;
                }
            } else if (sourceConnectorReader.getMountType() == SourceConnectorReader.SourceConnectorType.class) {
                if (imageFormat.super == ImageFormat.Type.\u00d800000 || imageFormat.super == ImageFormat.Type.\u00d600000) {
                    bl = true;
                    this.makeDirlistEntryForManuallySubmittedJob(pathCached, string2);
                }
            } else {
                if (!sourceConnectorReader.isVirtualViewerConnector()) {
                    this.makeDirlistEntryForManuallySubmittedJob(pathCached, string2);
                }
                bl = true;
            }
        }
        finally {
            this.resumeScanner(string3);
        }
        return bl;
    }

    private Path makeDirlistEntryForManuallySubmittedJob(PathCached pathCached, String string) throws NotConfiguredException, IOException {
        PoolFileEntry poolFileEntry = new PoolFileEntry(pathCached.getFileName(), pathCached.lastModified(), pathCached.size(), 0, 0, 2);
        ArrayList<PoolEntry> arrayList = new ArrayList<PoolEntry>();
        arrayList.add(poolFileEntry);
        Path path = this.\u00f600000.getDirectoryFile(string);
        String string2 = URL.getParentAssetURLPath(string);
        Path path2 = this.\u00f600000.getDirectoryFile(string2);
        this.\u00f6O0000.updateEntries(path, string, path2, string2, arrayList, FileOperations.getSafeLastModified(pathCached.getParent()));
        this.getMetaDataAndUpdateSearchDatabase(string, false);
        return path;
    }

    private PoolList getRootDirlist() throws NotConfiguredException {
        PoolList poolList = null;
        boolean bl = true;
        Path path = this.\u00f600000.getDirectoryFile("/");
        try {
            poolList = this.\u00d6O0000.getListFileContents(path, "/");
            if (poolList != null) {
                bl = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            poolList = this.makeRootList(path);
        }
        return poolList;
    }

    public int getScanCycles() {
        return this.\u00d300000;
    }

    void resetLicenceLogging() {
        this.int = false;
        this.\u00d8O0000 = false;
    }

    private void transferProfiles() throws NotConfiguredException {
        this.transferProfiles(this.\u00f600000.getMetricsDir());
    }

    private Deque<PathCached> listAllFiles(final Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        final ArrayDeque<PathCached> arrayDeque = new ArrayDeque<PathCached>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult o00000(Path path2, BasicFileAttributes basicFileAttributes) {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.\u00f400000 == STATE.\u00d500000) {
                    return FileVisitResult.TERMINATE;
                }
                if (path.equals(path2)) {
                    return FileVisitResult.CONTINUE;
                }
                arrayDeque.add(new PathCached(path2, basicFileAttributes));
                return FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult Object(Path path2, BasicFileAttributes basicFileAttributes) {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.\u00f400000 == STATE.\u00d500000) {
                    return FileVisitResult.TERMINATE;
                }
                if (basicFileAttributes.isRegularFile()) {
                    arrayDeque.add(new PathCached(path2, basicFileAttributes));
                }
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult \u00d200000(Path path2, IOException iOException) {
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return arrayDeque;
    }

    private Deque<PathCached> listDirectories(final Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        final ArrayDeque<PathCached> arrayDeque = new ArrayDeque<PathCached>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult o00000(Path path2, BasicFileAttributes basicFileAttributes) {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.\u00f400000 == STATE.\u00d500000) {
                    return FileVisitResult.TERMINATE;
                }
                if (path.equals(path2)) {
                    return FileVisitResult.CONTINUE;
                }
                arrayDeque.add(new PathCached(path2, basicFileAttributes));
                return FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult \u00d300000(Path path2, IOException iOException) {
                return FileVisitResult.SKIP_SUBTREE;
            }

            public FileVisitResult \u00d200000(Path path2, BasicFileAttributes basicFileAttributes) {
                ScannerDaemon.this.checkForRequestPause();
                if (ScannerDaemon.this.\u00f400000 == STATE.\u00d500000) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return arrayDeque;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum STATE {
        \u00f400000,
        void,
        \u00d600000,
        \u00d400000,
        \u00d500000,
        o00000,
        Object;

    }
}

