/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiserver.framework.helpers.ProcessingException;
import com.neptunelabs.fsiserver.framework.helpers.swap.SwapPool;
import com.neptunelabs.fsiserver.framework.io.ReaderAbstract;
import com.neptunelabs.fsiserver.framework.io.ReaderChannel;
import com.neptunelabs.fsiserver.imagereader.image.FSIImage;
import com.neptunelabs.fsiserver.imagereader.metrics.Histogram;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidEISFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.new;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EISReader
implements Closeable {
    private final FSIServerSettings \u00d600000;
    private final SwapPool super;
    private final boolean \u00d300000;
    private ReaderAbstract \u00d800000;
    private Path class;
    private new \u00d400000;
    private boolean \u00d200000 = false;

    public EISReader(String string, Path path, FSIServerSettings fSIServerSettings, SwapPool swapPool, boolean bl) throws IOException {
        this.class = path;
        this.\u00d600000 = fSIServerSettings;
        this.super = swapPool;
        this.\u00d300000 = bl;
        this.init(string);
    }

    private void init(String string) throws IOException {
        block9: {
            LockerReadWrite.Value<String> value = this.\u00d600000.getStorageLockHandler().readLock(this.class);
            try {
                this.\u00d800000 = new ReaderChannel(this.class, StandardOpenOption.READ);
                byte[] byArray = new byte[8];
                this.\u00d800000.read(byArray);
                if (Arrays.equals(byArray, EISEnvironment.\u00d600000)) {
                    int n = EISChainReader.findChainEntryNumber(this.\u00d800000, string);
                    this.\u00d800000.close();
                    if (n == -1) {
                        throw new NoSuchFileException("No such entry for " + string + " in chain");
                    }
                    this.class = StorageManager.getChainedDestination(this.class, n);
                    this.\u00d800000 = new ReaderChannel(this.class, StandardOpenOption.READ);
                    this.\u00d800000.read(byArray);
                }
                if (Arrays.equals(byArray, EISEnvironment.\u00d400000)) {
                    this.\u00d400000 = new new(string, this.class, this.\u00d800000, this.\u00d600000, this.super, this.\u00d300000);
                    break block9;
                }
                this.\u00d800000.close();
                throw new NotAValidEISFileException(this.class);
            }
            catch (IOException iOException) {
                if (this.\u00d800000 != null) {
                    this.\u00d800000.close();
                }
                throw iOException;
            }
            finally {
                this.\u00d600000.getStorageLockHandler().unlockRead(value);
            }
        }
    }

    public ImageMetaData getImageMetaData() throws IOException {
        return this.\u00d400000.forsuper();
    }

    public byte[] getExifData() throws IOException {
        return this.\u00d400000.\u00f8o0000();
    }

    public byte[] getIPTCData() throws IOException {
        return this.\u00d400000.\u00d3O0000();
    }

    public byte[] getXMPData() throws IOException {
        return this.\u00d400000.\u00d300000();
    }

    public byte[] getSelectionsData() throws IOException {
        return this.\u00d400000.\u00f4O0000();
    }

    public String[] getAlphaNames() throws IOException {
        return this.\u00d400000.\u00f800000();
    }

    public byte[] getICCData() throws IOException {
        return this.\u00d400000.privatesuper();
    }

    public Histogram getHistogram() throws IOException {
        return this.\u00d400000.thissuper();
    }

    public FSIImage getImage(int n, int n2, int n3, int n4, int n5) throws IOException, ProcessingException {
        return this.\u00d400000.\u00d500000(n, n2, n3, n4, n5);
    }

    public FSIImage getImage(int n, double d, double d2, double d3, double d4) throws IOException, ProcessingException {
        return this.\u00d400000.\u00d4o0000(n, d, d2, d3, d4);
    }

    public FSIImage getTileImage(int n, int n2, int n3) throws IOException {
        return this.\u00d400000.\u00d3o0000(n, n2, n3);
    }

    public Level getSourceLevel() throws IOException {
        return this.\u00d400000.while();
    }

    public boolean isClosed() {
        return this.\u00d200000;
    }

    @Override
    public void close() {
        if (!this.\u00d200000) {
            this.\u00d200000 = true;
            try {
                this.\u00d800000.close();
            }
            catch (IOException iOException) {
                this.\u00d600000.getLogger().logException(iOException, 3259, this.class);
            }
        }
    }

    public Path getEISFile() {
        return this.class;
    }

    public void dumpHeader() {
        this.\u00d400000.oo0000();
    }
}

