/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class SPXOutputStream
extends OutputStream {
    private final ByteOrder \u00d200000;
    private final OutputStream o00000;

    public SPXOutputStream(ByteOrder byteOrder, OutputStream outputStream) {
        this.\u00d200000 = byteOrder;
        this.o00000 = outputStream;
    }

    public ByteOrder getOrder() {
        return this.\u00d200000;
    }

    @Override
    public void write(int n) throws IOException {
        this.o00000.write(n);
    }

    private void write(byte by) throws IOException {
        this.write(by & 0xFF);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        for (byte by : byArray) {
            this.write(by & 0xFF);
        }
    }

    private void write(float[] fArray) throws IOException {
        for (float f : fArray) {
            this.writeFloat(f);
        }
    }

    public void writeShort(short s) throws IOException {
        if (this.\u00d200000 == ByteOrder.BIG_ENDIAN) {
            this.write(s >> 8 & 0xFF);
            this.write(s & 0xFF);
        } else {
            this.write(s & 0xFF);
            this.write(s >> 8 & 0xFF);
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.\u00d200000 == ByteOrder.BIG_ENDIAN) {
            this.write(n >>> 24 & 0xFF);
            this.write(n >> 16 & 0xFF);
            this.write(n >> 8 & 0xFF);
            this.write(n & 0xFF);
        } else {
            this.write(n & 0xFF);
            this.write(n >> 8 & 0xFF);
            this.write(n >> 16 & 0xFF);
            this.write(n >>> 24 & 0xFF);
        }
    }

    private void writeLong(long l) throws IOException {
        if (this.\u00d200000 == ByteOrder.BIG_ENDIAN) {
            this.write((int)(l >>> 56) & 0xFF);
            this.write((int)(l >> 48) & 0xFF);
            this.write((int)(l >> 40) & 0xFF);
            this.write((int)(l >> 32) & 0xFF);
            this.write((int)(l >> 24) & 0xFF);
            this.write((int)(l >> 16) & 0xFF);
            this.write((int)(l >> 8) & 0xFF);
            this.write((int)l & 0xFF);
        } else {
            this.write((int)l & 0xFF);
            this.write((int)(l >> 8) & 0xFF);
            this.write((int)(l >> 16) & 0xFF);
            this.write((int)(l >> 24) & 0xFF);
            this.write((int)(l >> 32) & 0xFF);
            this.write((int)(l >> 40) & 0xFF);
            this.write((int)(l >> 48) & 0xFF);
            this.write((int)(l >>> 56) & 0xFF);
        }
    }

    private void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeTagByte(short s, byte by) throws IOException {
        this.writeTag(s, 1);
        this.write(by);
    }

    public void writeTagBytes(short s, byte[] byArray) throws IOException {
        this.writeTag(s, byArray.length);
        this.write(byArray);
    }

    public void writeTagFloat(short s, float f) throws IOException {
        this.writeTag(s, 4);
        this.writeFloat(f);
    }

    public void writeTagFloats(short s, float[] fArray) throws IOException {
        this.writeTag(s, fArray.length * 4);
        this.write(fArray);
    }

    public void writeTagShort(short s, short s2) throws IOException {
        this.writeTag(s, 2);
        this.writeShort(s2);
    }

    public void writeTagInt(short s, int n) throws IOException {
        this.writeTag(s, 4);
        this.writeInt(n);
    }

    public void writeTagLong(short s, long l) throws IOException {
        this.writeTag(s, 8);
        this.writeLong(l);
    }

    public void writeTagDouble(short s, double d) throws IOException {
        this.writeTagLong(s, Double.doubleToRawLongBits(d));
    }

    public void writeTagUTF8(short s, String string) throws IOException {
        byte[] byArray = string.getBytes(FileOperations.new);
        this.writeTag(s, byArray.length);
        this.write(byArray);
    }

    private void writeTag(short s, int n) throws IOException {
        this.writeShort(s);
        this.writeInt(n);
    }
}

