/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.imagereader.ImageFormat;
import com.neptunelabs.fsiserver.imagereader.ImageFormatScanner;
import com.neptunelabs.fsiserver.sourcemanager.DirectoryImportHandler;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SourceReverseRepairing
implements FileVisitor<Path> {
    private final SourceConnectorReader o00000;
    private final StorageManager String;
    private final DirectoryImportHandler \u00d200000;
    private final PathCached \u00d800000;
    private final StorageHelperV1002 \u00d600000;
    private boolean \u00d300000 = false;
    private volatile boolean \u00d500000 = false;

    public SourceReverseRepairing(SourceConnectorReader sourceConnectorReader, StorageHelperV1002 storageHelperV1002, StorageManager storageManager, DirectoryImportHandler directoryImportHandler, PathCached pathCached) {
        this.o00000 = sourceConnectorReader;
        this.\u00d600000 = storageHelperV1002;
        this.String = storageManager;
        this.\u00d200000 = directoryImportHandler;
        this.\u00d800000 = pathCached;
    }

    public boolean hasChanged() {
        return this.\u00d300000;
    }

    public void stop() {
        this.\u00d500000 = true;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(basicFileAttributes);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        PathCached pathCached = new PathCached(path);
        if (pathCached.isRegularFile()) {
            ImageFormatScanner imageFormatScanner = ImageFormatScanner.getInstance();
            ImageFormat imageFormat = imageFormatScanner.scanFile(pathCached);
            if (imageFormat.\u00d400000 && imageFormat.super != ImageFormat.Type.\u00d200000 && this.\u00d200000.isValidFilename(pathCached, false)) {
                int n = this.o00000.getInboxDirectory().getAbsoluteNameLength();
                String string = FileOperations.convertBackslash(this.o00000.getPrefix() + this.\u00d800000.getAbsoluteName().substring(n));
                string = string + '/';
                string = string + FileOperations.convertBackslash(pathCached.getAbsoluteName().substring(n + 1));
                try {
                    Path path2 = this.\u00d600000.getEisFile(string);
                    boolean bl = Files.exists(path2, new LinkOption[0]);
                    Path path3 = path2.resolveSibling(".reverseLookup");
                    boolean bl2 = Files.exists(path3, new LinkOption[0]);
                    Path path4 = this.String.getRealEISImageFile(string);
                    boolean bl3 = path4 != null ? Files.exists(path4, new LinkOption[0]) : false;
                    boolean bl4 = bl & bl2 & bl3;
                    if (!bl2) {
                        if (bl) {
                            if (EISChainReader.isChainFile(path2)) {
                                Map<String, Integer> map = EISChainReader.readAll(path2);
                                if (map != null) {
                                    TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
                                    for (Map.Entry<String, Integer> entry : map.entrySet()) {
                                        treeMap.put(entry.getValue(), entry.getKey());
                                    }
                                    for (Map.Entry<String, Integer> entry : treeMap.entrySet()) {
                                        this.String.addReverseLookupEntry(path2, (String)((Object)entry.getValue()), (Integer)((Object)entry.getKey()));
                                        this.\u00d300000 = true;
                                    }
                                }
                            } else {
                                this.String.addReverseLookupEntry(path2, string, 0);
                                this.\u00d300000 = true;
                            }
                        }
                    } else if (bl && !bl3) {
                        Map<Integer, String> map = StorageManager.getReverseLookupEntries(path2);
                        if (EISChainReader.isChainFile(path2)) {
                            Map<String, Integer> map2 = EISChainReader.readAll(path2);
                            if (map2 != null) {
                                TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
                                for (Map.Entry<String, Integer> entry : map2.entrySet()) {
                                    treeMap.put(entry.getValue(), entry.getKey());
                                }
                                for (Map.Entry entry : treeMap.entrySet()) {
                                    this.String.addReverseLookupEntry(path2, (String)entry.getValue(), (Integer)entry.getKey());
                                    this.\u00d300000 = true;
                                }
                            }
                        } else {
                            this.String.addReverseLookupEntry(path2, string, 0);
                            this.\u00d300000 = true;
                        }
                    }
                }
                catch (NotConfiguredException notConfiguredException) {
                    return FileVisitResult.TERMINATE;
                }
            }
        }
        if (this.\u00d500000) {
            return FileVisitResult.TERMINATE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
        Objects.requireNonNull(path);
        throw iOException;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        if (iOException == null) {
            if (this.\u00d500000) {
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
        throw iOException;
    }
}

