/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiserver.framework.cache.CacheKey;
import com.neptunelabs.fsiserver.framework.cache.CacheManager;
import com.neptunelabs.fsiserver.framework.io.FileOperations;
import com.neptunelabs.fsiserver.framework.io.PathCached;
import com.neptunelabs.fsiserver.framework.logging.FSILogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class StorageLogger
extends Thread {
    private final FSILogger \u00d3O0000;
    private final Path \u00d800000;
    private BufferedWriter \u00d400000 = null;
    private final CacheManager OO0000;
    private final int \u00f800000;
    private final ReentrantLock \u00d2O0000 = new ReentrantLock();
    public static final char super = 'A';
    public static final char int = 'D';
    public static final char \u00d200000 = '*';
    private final DateFormat do = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final String \u00d300000 = "storage";
    private final String \u00f400000 = "log";
    private final Pattern \u00f600000 = Pattern.compile("storage\\.(\\d{4}\\-\\d{2}\\-\\d{2})\\.log");
    private final DateFormat class = new SimpleDateFormat("yyyy-MM-dd");
    private boolean \u00d600000 = false;
    private volatile boolean \u00d4O0000 = false;

    public StorageLogger(FSILogger fSILogger, Path path, int n, CacheManager cacheManager) {
        this.\u00d3O0000 = fSILogger;
        this.OO0000 = cacheManager;
        this.\u00d800000 = path;
        this.\u00f800000 = n;
        this.setName("StorageLogger");
    }

    @Override
    public void run() {
        this.\u00d600000 = true;
        long l = 0L;
        this.openFile();
        while (this.\u00d600000) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            long l2 = gregorianCalendar.getTimeInMillis();
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            ((Calendar)gregorianCalendar).add(5, 1);
            if (l2 >= l) {
                this.rotateLog();
            }
            l = gregorianCalendar.getTimeInMillis();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                this.\u00d600000 = false;
            }
            if (!this.\u00d4O0000 || this.\u00d400000 == null) continue;
            try {
                this.\u00d400000.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void dispose() {
        this.\u00d600000 = false;
        this.interrupt();
        if (this.\u00d400000 != null) {
            this.\u00d2O0000.lock();
            try {
                this.closeFile();
            }
            finally {
                this.\u00d2O0000.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(char c, LogCMD logCMD, String string) {
        CacheKey cacheKey = CacheKey.getInstance(string, c);
        if (this.OO0000 != null) {
            this.OO0000.touchChangedFile(cacheKey);
        }
        this.\u00d2O0000.lock();
        try {
            String string2 = this.do.format(new Date());
            if (this.\u00d400000 != null) {
                this.\u00d400000.write(string2);
                this.\u00d400000.write(58);
                this.\u00d400000.write(logCMD.name());
                this.\u00d400000.write(58);
                this.\u00d400000.write(cacheKey.get());
                this.\u00d400000.write(10);
            }
        }
        catch (IOException iOException) {
            this.\u00d3O0000.logException(iOException, 3247, iOException.getLocalizedMessage());
        }
        finally {
            this.\u00d2O0000.unlock();
        }
        this.\u00d4O0000 = true;
    }

    private boolean openFile() {
        boolean bl = false;
        try {
            if (Files.notExists(this.\u00d800000, new LinkOption[0])) {
                Files.createDirectories(this.\u00d800000, new FileAttribute[0]);
            }
            String string = "storage." + this.class.format(new Date()) + '.' + "log";
            Path path = this.\u00d800000.resolve(string);
            this.\u00d400000 = Files.newBufferedWriter(path, FileOperations.new, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            bl = true;
        }
        catch (IOException iOException) {
            this.\u00d3O0000.logException(iOException, 2011, iOException.getLocalizedMessage());
        }
        return bl;
    }

    private boolean closeFile() {
        boolean bl = false;
        if (this.\u00d400000 != null) {
            try {
                this.\u00d400000.close();
                this.\u00d400000 = null;
                bl = true;
            }
            catch (IOException iOException) {
                this.\u00d3O0000.logException(iOException, 2011, iOException.getLocalizedMessage());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateLog() {
        this.\u00d2O0000.lock();
        try {
            block13: {
                this.closeFile();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                ((Calendar)gregorianCalendar).add(5, 1);
                ((Calendar)gregorianCalendar).add(13, -1);
                Date date = gregorianCalendar.getTime();
                ((Calendar)gregorianCalendar).add(13, 1);
                ((Calendar)gregorianCalendar).add(5, -this.\u00f800000);
                Date date2 = gregorianCalendar.getTime();
                try {
                    List<PathCached> list = FileOperations.listAllFiles(this.\u00d800000);
                    if (list == null) break block13;
                    for (PathCached pathCached : list) {
                        boolean bl = false;
                        String string = pathCached.getFileName();
                        Matcher matcher = this.\u00f600000.matcher(string);
                        if (matcher.find()) {
                            try {
                                Date date3 = this.class.parse(matcher.group(1));
                                if (date3.before(date2) || date3.after(date)) {
                                    bl = true;
                                }
                            }
                            catch (ParseException parseException) {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                        if (!bl) continue;
                        try {
                            Files.deleteIfExists(pathCached.getPath());
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.openFile();
        }
        finally {
            this.\u00d2O0000.unlock();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum LogCMD {
        super,
        \u00d300000;

    }
}

